# encoding: UTF-8

require 'spec_helper'

describe Vulnerability do

  describe '#new' do
    subject(:vulnerability) { Vulnerability.new(title, type, references, fixed_version) }
    let(:title)             { 'A vulnerability title' }
    let(:type)              { 'XSS' }
    let(:references)        { {:url => 'example.com', :metasploit => 'm', :exploitdb => 'e'} }

    context 'w/o metasploit and fixed version modules argument' do
      subject(:vulnerability) { Vulnerability.new(title, type, references) }

      its(:title)      { should be title }
      its(:references) { should be references }
      its(:type)       { should be type }
      its(:fixed_in)   { should be_empty }
    end

    context 'with fixed version argument' do
      let(:fixed_version) { '1.0' }

      its(:title)      { should be title }
      its(:references) { should be references }
      its(:type)       { should be type }
      its(:fixed_in)   { should be fixed_version }
    end

  end

  describe '::load_from_json_item' do
    subject(:vulnerability) { Vulnerability.load_from_json_item(item) }
    let(:item) {
      json(MODELS_FIXTURES + '/vulnerability/json_item.json')
    }

    expected_refs = {
      'id'         => ['3911'],
      'url'        => ['Ref 1,Ref 2'],
      'cve'        => ['2011-001'],
      'secunia'    => ['secunia'],
      'osvdb'      => ['osvdb'],
      'metasploit' => ['exploit/ex1'],
      'exploitdb'  => ['exploitdb']
    }

    its(:title)      { should == 'Vuln Title' }
    its(:type)       { should == 'CSRF' }
    its(:references) { should ==  expected_refs}
    its(:fixed_in)   { should == '1.0'}
  end

end
