/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.rules;

import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;
import org.gradle.api.internal.changedetection.rules.PropertyDiffListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SortedMapDiffUtil {
    private SortedMapDiffUtil() {
    }

    public static <K, V> void diff(SortedMap<K, V> previous, SortedMap<K, V> current, PropertyDiffListener<K, V> diffListener) {
        Iterator<Map.Entry<K, V>> currentEntries = current.entrySet().iterator();
        Iterator<Map.Entry<K, V>> previousEntries = previous.entrySet().iterator();
        Comparator<K> comparator = previous.comparator();
        if (currentEntries.hasNext() && previousEntries.hasNext()) {
            Map.Entry<K, V> currentEntry = currentEntries.next();
            Map.Entry<K, V> previousEntry = previousEntries.next();
            while (true) {
                K currentProperty;
                K previousProperty;
                int compared;
                if ((compared = comparator.compare(previousProperty = previousEntry.getKey(), currentProperty = currentEntry.getKey())) < 0) {
                    diffListener.removed(previousProperty);
                    if (previousEntries.hasNext()) {
                        previousEntry = previousEntries.next();
                        continue;
                    }
                    diffListener.added(currentProperty);
                    break;
                }
                if (compared > 0) {
                    diffListener.added(currentProperty);
                    if (currentEntries.hasNext()) {
                        currentEntry = currentEntries.next();
                        continue;
                    }
                    diffListener.removed(previousProperty);
                    break;
                }
                diffListener.updated(previousProperty, previousEntry.getValue(), currentEntry.getValue());
                if (!previousEntries.hasNext() || !currentEntries.hasNext()) break;
                previousEntry = previousEntries.next();
                currentEntry = currentEntries.next();
            }
        }
        while (currentEntries.hasNext()) {
            diffListener.added(currentEntries.next().getKey());
        }
        while (previousEntries.hasNext()) {
            diffListener.removed(previousEntries.next().getKey());
        }
    }
}

