/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.state;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.ImmutableSortedSet;
import org.gradle.api.internal.changedetection.state.ImplementationSnapshot;
import org.gradle.api.internal.changedetection.state.TaskExecution;
import org.gradle.api.internal.changedetection.state.ValueSnapshot;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTaskExecution
implements TaskExecution {
    private final ImplementationSnapshot taskImplementation;
    private final ImmutableList<ImplementationSnapshot> taskActionImplementations;
    private final ImmutableSortedMap<String, ValueSnapshot> inputProperties;
    private final ImmutableSortedSet<String> outputPropertyNamesForCacheKey;

    public AbstractTaskExecution(ImplementationSnapshot taskImplementation, ImmutableList<ImplementationSnapshot> taskActionImplementations, ImmutableSortedMap<String, ValueSnapshot> inputProperties, ImmutableSortedSet<String> outputPropertyNames) {
        this.taskImplementation = taskImplementation;
        this.taskActionImplementations = taskActionImplementations;
        this.inputProperties = inputProperties;
        this.outputPropertyNamesForCacheKey = outputPropertyNames;
    }

    @Override
    public ImmutableSortedSet<String> getOutputPropertyNamesForCacheKey() {
        return ImmutableSortedSet.copyOf(this.outputPropertyNamesForCacheKey);
    }

    @Override
    public ImplementationSnapshot getTaskImplementation() {
        return this.taskImplementation;
    }

    @Override
    public ImmutableList<ImplementationSnapshot> getTaskActionImplementations() {
        return this.taskActionImplementations;
    }

    @Override
    public ImmutableSortedMap<String, ValueSnapshot> getInputProperties() {
        return this.inputProperties;
    }
}

