/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.state;

import com.google.common.cache.Cache;
import com.google.common.cache.RemovalCause;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import org.gradle.api.logging.LogLevel;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class LoggingEvictionListener
implements RemovalListener<Object, Object> {
    private static Logger logger = Logging.getLogger(LoggingEvictionListener.class);
    private static final String EVICTION_MITIGATION_MESSAGE = "\nPerformance may suffer from in-memory cache misses. Increase max heap size of Gradle build process to reduce cache misses.";
    volatile int evictionCounter;
    private final String cacheId;
    private Cache<Object, Object> cache;
    private final int maxSize;
    private final int logInterval;

    LoggingEvictionListener(String cacheId, int maxSize) {
        this.cacheId = cacheId;
        this.maxSize = maxSize;
        this.logInterval = maxSize / 10;
    }

    public void setCache(Cache<Object, Object> cache) {
        this.cache = cache;
    }

    public void onRemoval(RemovalNotification<Object, Object> notification) {
        if (notification.getCause() == RemovalCause.SIZE) {
            if (this.evictionCounter % this.logInterval == 0) {
                logger.log(LogLevel.INFO, "Cache entries evicted. In-memory cache of {}: Size{{}} MaxSize{{}}, {} {}", new Object[]{this.cacheId, this.cache.size(), this.maxSize, this.cache.stats(), EVICTION_MITIGATION_MESSAGE});
            }
            ++this.evictionCounter;
        }
    }
}

