/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.preferences;

import java.awt.GraphicsEnvironment;
import java.io.File;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.spi.preferences.IBaseDirectories;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Utils;

public final class JosmBaseDirectories
implements IBaseDirectories {
    private File preferencesDir;
    private File cacheDir;
    private File userdataDir;

    private JosmBaseDirectories() {
    }

    public static JosmBaseDirectories getInstance() {
        return InstanceHolder.INSTANCE;
    }

    @Override
    public File getPreferencesDirectory(boolean createIfMissing) {
        if (this.preferencesDir == null) {
            String path = Utils.getSystemProperty("josm.pref");
            this.preferencesDir = path != null ? new File(path).getAbsoluteFile() : ((path = Utils.getSystemProperty("josm.home")) != null ? new File(path).getAbsoluteFile() : Main.platform.getDefaultPrefDirectory());
        }
        try {
            if (createIfMissing && !this.preferencesDir.exists() && !this.preferencesDir.mkdirs()) {
                Logging.warn(I18n.tr("Failed to create missing preferences directory: {0}", this.preferencesDir.getAbsoluteFile()));
                if (!GraphicsEnvironment.isHeadless()) {
                    JOptionPane.showMessageDialog(Main.parent, I18n.tr("<html>Failed to create missing preferences directory: {0}</html>", this.preferencesDir.getAbsoluteFile()), I18n.tr("Error", new Object[0]), 0);
                }
            }
        }
        catch (SecurityException e) {
            Logging.log(Logging.LEVEL_ERROR, "Unable to check if preferences dir must be created", e);
        }
        return this.preferencesDir;
    }

    @Override
    public File getUserDataDirectory(boolean createIfMissing) {
        if (this.userdataDir == null) {
            String path = Utils.getSystemProperty("josm.userdata");
            this.userdataDir = path != null ? new File(path).getAbsoluteFile() : ((path = Utils.getSystemProperty("josm.home")) != null ? new File(path).getAbsoluteFile() : Main.platform.getDefaultUserDataDirectory());
        }
        try {
            if (createIfMissing && !this.userdataDir.exists() && !this.userdataDir.mkdirs()) {
                Logging.warn(I18n.tr("Failed to create missing user data directory: {0}", this.userdataDir.getAbsoluteFile()));
                if (!GraphicsEnvironment.isHeadless()) {
                    JOptionPane.showMessageDialog(Main.parent, I18n.tr("<html>Failed to create missing user data directory: {0}</html>", this.userdataDir.getAbsoluteFile()), I18n.tr("Error", new Object[0]), 0);
                }
            }
        }
        catch (SecurityException e) {
            Logging.log(Logging.LEVEL_ERROR, "Unable to check if user data dir must be created", e);
        }
        return this.userdataDir;
    }

    @Override
    public File getCacheDirectory(boolean createIfMissing) {
        if (this.cacheDir == null) {
            String path = Utils.getSystemProperty("josm.cache");
            this.cacheDir = path != null ? new File(path).getAbsoluteFile() : ((path = Utils.getSystemProperty("josm.home")) != null ? new File(path, "cache") : ((path = Config.getPref().get("cache.folder", null)) != null ? new File(path).getAbsoluteFile() : Main.platform.getDefaultCacheDirectory()));
        }
        try {
            if (createIfMissing && !this.cacheDir.exists() && !this.cacheDir.mkdirs()) {
                Logging.warn(I18n.tr("Failed to create missing cache directory: {0}", this.cacheDir.getAbsoluteFile()));
                if (!GraphicsEnvironment.isHeadless()) {
                    JOptionPane.showMessageDialog(Main.parent, I18n.tr("<html>Failed to create missing cache directory: {0}</html>", this.cacheDir.getAbsoluteFile()), I18n.tr("Error", new Object[0]), 0);
                }
            }
        }
        catch (SecurityException e) {
            Logging.log(Logging.LEVEL_ERROR, "Unable to check if cache dir must be created", e);
        }
        return this.cacheDir;
    }

    private static class InstanceHolder {
        static final JosmBaseDirectories INSTANCE = new JosmBaseDirectories();

        private InstanceHolder() {
        }
    }
}

