/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io.remotecontrol;

import java.io.File;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.openstreetmap.josm.data.preferences.BooleanProperty;
import org.openstreetmap.josm.io.remotecontrol.RemoteControlHttpServer;
import org.openstreetmap.josm.io.remotecontrol.RemoteControlHttpsServer;
import org.openstreetmap.josm.io.remotecontrol.RequestProcessor;
import org.openstreetmap.josm.io.remotecontrol.handler.RequestHandler;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.Logging;

public class RemoteControl {
    public static final BooleanProperty PROP_REMOTECONTROL_ENABLED = new BooleanProperty("remotecontrol.enabled", false);
    public static final BooleanProperty PROP_REMOTECONTROL_HTTPS_ENABLED = new BooleanProperty("remotecontrol.https.enabled", false);
    static final int protocolMajorVersion = 1;
    static final int protocolMinorVersion = 7;

    public static void start() {
        RemoteControlHttpServer.restartRemoteControlHttpServer();
        if (RemoteControl.supportsHttps()) {
            RemoteControlHttpsServer.restartRemoteControlHttpsServer();
        }
    }

    public static void stop() {
        RemoteControlHttpServer.stopRemoteControlHttpServer();
        if (RemoteControl.supportsHttps()) {
            RemoteControlHttpsServer.stopRemoteControlHttpsServer();
        }
    }

    public static boolean supportsHttps() {
        try {
            return Class.forName("sun.security.x509.GeneralName") != null;
        }
        catch (ClassNotFoundException | SecurityException e) {
            Logging.trace(e);
            return false;
        }
    }

    public void addRequestHandler(String command, Class<? extends RequestHandler> handlerClass) {
        RequestProcessor.addRequestHandlerClass(command, handlerClass);
    }

    public static String getRemoteControlDir() {
        return new File(Config.getDirs().getUserDataDirectory(true), "remotecontrol").getAbsolutePath();
    }

    public static InetAddress getInet6Address() throws UnknownHostException {
        for (InetAddress a : InetAddress.getAllByName(Config.getPref().get("remote.control.host.ipv6", "::1"))) {
            if (!(a instanceof Inet6Address)) continue;
            return a;
        }
        throw new UnknownHostException();
    }

    public static InetAddress getInet4Address() throws UnknownHostException {
        for (InetAddress a : InetAddress.getAllByName(Config.getPref().get("remote.control.host.ipv4", "127.0.0.1"))) {
            if (!(a instanceof Inet4Address)) continue;
            return a;
        }
        throw new UnknownHostException();
    }
}

