/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.base.Preconditions;
import com.google.common.collect.Multisets;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.CompatibleWith;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import java.util.Spliterator;
import java.util.function.Consumer;

public interface Multiset<E>
extends Collection<E> {
    @Override
    public int size();

    public int count(@CompatibleWith(value="E") Object var1);

    @CanIgnoreReturnValue
    public int add(E var1, int var2);

    @CanIgnoreReturnValue
    public int remove(@CompatibleWith(value="E") Object var1, int var2);

    @CanIgnoreReturnValue
    public int setCount(E var1, int var2);

    @CanIgnoreReturnValue
    public boolean setCount(E var1, int var2, int var3);

    public Set<E> elementSet();

    public Set<Entry<E>> entrySet();

    public String toString();

    @Override
    public Iterator<E> iterator();

    @Override
    public boolean contains(Object var1);

    @Override
    public boolean containsAll(Collection<?> var1);

    @Override
    @CanIgnoreReturnValue
    public boolean remove(Object var1);

    @Override
    default public void forEach(Consumer<? super E> action2) {
        Preconditions.checkNotNull(action2);
        this.entrySet().forEach((? super T entry) -> {
            Object elem = entry.getElement();
            int count2 = entry.getCount();
            for (int i = 0; i < count2; ++i) {
                action2.accept((Object)elem);
            }
        });
    }

    @Override
    default public Spliterator<E> spliterator() {
        return Multisets.spliteratorImpl(this);
    }

    public static interface Entry<E> {
        public E getElement();

        public int getCount();

        public String toString();
    }
}

