/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.sweethome3d.swing;

import com.eteks.sweethome3d.model.CatalogTexture;
import com.eteks.sweethome3d.model.CollectionEvent;
import com.eteks.sweethome3d.model.CollectionListener;
import com.eteks.sweethome3d.model.HomeTexture;
import com.eteks.sweethome3d.model.TextureImage;
import com.eteks.sweethome3d.model.TexturesCatalog;
import com.eteks.sweethome3d.model.TexturesCategory;
import com.eteks.sweethome3d.model.UserPreferences;
import com.eteks.sweethome3d.swing.AutoCommitSpinner;
import com.eteks.sweethome3d.swing.CatalogItemToolTip;
import com.eteks.sweethome3d.swing.IconManager;
import com.eteks.sweethome3d.swing.NullableSpinner;
import com.eteks.sweethome3d.swing.ScaledImageComponent;
import com.eteks.sweethome3d.swing.SwingTools;
import com.eteks.sweethome3d.tools.OperatingSystem;
import com.eteks.sweethome3d.viewcontroller.TextureChoiceController;
import com.eteks.sweethome3d.viewcontroller.TextureChoiceView;
import com.eteks.sweethome3d.viewcontroller.View;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FocusTraversalPolicy;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.AbstractListModel;
import javax.swing.AbstractSpinnerModel;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.JToolTip;
import javax.swing.KeyStroke;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.TransferHandler;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class TextureChoiceComponent
extends JButton
implements TextureChoiceView {
    private final UserPreferences preferences;

    public TextureChoiceComponent(final UserPreferences userPreferences, final TextureChoiceController textureChoiceController) {
        this.preferences = userPreferences;
        JLabel jLabel = new JLabel("Text");
        Dimension dimension = jLabel.getPreferredSize();
        final int n = dimension.height;
        textureChoiceController.addPropertyChangeListener(TextureChoiceController.Property.TEXTURE, new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                TextureChoiceComponent.this.repaint();
            }
        });
        this.setIcon(new Icon(){

            public int getIconWidth() {
                return n;
            }

            public int getIconHeight() {
                return n;
            }

            public void paintIcon(Component component, Graphics graphics, int n3, int n2) {
                graphics.setColor(Color.BLACK);
                graphics.drawRect(n3 + 2, n2 + 2, n - 5, n - 5);
                HomeTexture homeTexture = textureChoiceController.getTexture();
                if (homeTexture != null) {
                    Icon icon = IconManager.getInstance().getIcon(homeTexture.getImage(), n - 6, TextureChoiceComponent.this);
                    if (icon.getIconWidth() != icon.getIconHeight()) {
                        Graphics2D graphics2D = (Graphics2D)graphics;
                        AffineTransform affineTransform = graphics2D.getTransform();
                        graphics2D.translate(n3 + 3, n2 + 3);
                        graphics2D.scale((float)icon.getIconHeight() / (float)icon.getIconWidth(), 1.0);
                        icon.paintIcon(component, graphics2D, 0, 0);
                        graphics2D.setTransform(affineTransform);
                    } else {
                        icon.paintIcon(component, graphics, n3 + 3, n2 + 3);
                    }
                }
            }
        });
        this.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TexturePanel texturePanel = new TexturePanel(userPreferences, textureChoiceController);
                texturePanel.displayView(TextureChoiceComponent.this);
            }
        });
    }

    public boolean confirmDeleteSelectedCatalogTexture() {
        String string = this.preferences.getLocalizedString(TextureChoiceComponent.class, "confirmDeleteSelectedCatalogTexture.message", new Object[0]);
        String string2 = this.preferences.getLocalizedString(TextureChoiceComponent.class, "confirmDeleteSelectedCatalogTexture.title", new Object[0]);
        String string3 = this.preferences.getLocalizedString(TextureChoiceComponent.class, "confirmDeleteSelectedCatalogTexture.delete", new Object[0]);
        String string4 = this.preferences.getLocalizedString(TextureChoiceComponent.class, "confirmDeleteSelectedCatalogTexture.cancel", new Object[0]);
        return JOptionPane.showOptionDialog(KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow(), string, string2, 2, 3, null, new Object[]{string3, string4}, string4) == 0;
    }

    private static class TexturePanel
    extends JPanel {
        private static final int PREVIEW_ICON_SIZE = Math.round(128.0f * SwingTools.getResolutionScale());
        private static String searchFilterText = "";
        private static Dimension dialogPreferredSize;
        private TextureChoiceController controller;
        private TextureImage previewTexture;
        private JLabel searchLabel;
        private JTextField searchTextField;
        private JLabel chosenTextureLabel;
        private ScaledImageComponent texturePreviewComponent;
        private JLabel availableTexturesLabel;
        private JList availableTexturesList;
        private JLabel angleLabel;
        private JSpinner angleSpinner;
        private JLabel scaleLabel;
        private JSpinner scaleSpinner;
        private JButton importTextureButton;
        private JButton modifyTextureButton;
        private JButton deleteTextureButton;
        private JPanel recentTexturesPanel;
        private CatalogItemToolTip toolTip;

        public TexturePanel(UserPreferences userPreferences, TextureChoiceController textureChoiceController) {
            super(new GridBagLayout());
            this.controller = textureChoiceController;
            this.createComponents(userPreferences, textureChoiceController);
            this.setMnemonics(userPreferences);
            this.layoutComponents();
        }

        private void createComponents(final UserPreferences userPreferences, final TextureChoiceController textureChoiceController) {
            Serializable serializable;
            Object object;
            this.availableTexturesLabel = new JLabel(SwingTools.getLocalizedLabelText(userPreferences, TextureChoiceComponent.class, "availableTexturesLabel.text", new Object[0]));
            final TexturesCatalogListModel texturesCatalogListModel = new TexturesCatalogListModel(userPreferences.getTexturesCatalog());
            this.availableTexturesList = new JList(texturesCatalogListModel){

                public JToolTip createToolTip() {
                    if (TexturePanel.this.toolTip.isTipTextComplete()) {
                        return super.createToolTip();
                    }
                    TexturePanel.this.toolTip.setComponent(this);
                    return TexturePanel.this.toolTip;
                }

                public String getToolTipText(MouseEvent mouseEvent) {
                    int n = this.locationToIndex(mouseEvent.getPoint());
                    if (n >= 0) {
                        CatalogTexture catalogTexture = (CatalogTexture)this.getModel().getElementAt(n);
                        IconManager iconManager = IconManager.getInstance();
                        if (!iconManager.isWaitIcon(iconManager.getIcon(catalogTexture.getImage(), 16, this))) {
                            TexturePanel.this.toolTip.setCatalogItem(catalogTexture);
                            return TexturePanel.this.toolTip.getTipText();
                        }
                    }
                    return null;
                }
            };
            this.toolTip = new CatalogItemToolTip(true, userPreferences);
            this.availableTexturesList.setVisibleRowCount(12);
            this.availableTexturesList.setSelectionMode(0);
            this.availableTexturesList.setCellRenderer(new TextureListCellRenderer());
            this.availableTexturesList.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    CatalogTexture catalogTexture = (CatalogTexture)TexturePanel.this.availableTexturesList.getSelectedValue();
                    if (catalogTexture != null) {
                        TexturePanel.this.setPreviewTexture(catalogTexture);
                    }
                    if (TexturePanel.this.modifyTextureButton != null) {
                        TexturePanel.this.modifyTextureButton.setEnabled(catalogTexture != null && catalogTexture.isModifiable());
                    }
                    if (TexturePanel.this.deleteTextureButton != null) {
                        TexturePanel.this.deleteTextureButton.setEnabled(catalogTexture != null && catalogTexture.isModifiable());
                    }
                }
            });
            this.searchLabel = new JLabel(SwingTools.getLocalizedLabelText(userPreferences, TextureChoiceComponent.class, "searchLabel.text", new Object[0]));
            this.searchTextField = new JTextField(5);
            this.searchTextField.getDocument().addDocumentListener(new DocumentListener(){

                public void changedUpdate(DocumentEvent documentEvent) {
                    Object e = TexturePanel.this.availableTexturesList.getSelectedValue();
                    texturesCatalogListModel.setFilterText(TexturePanel.this.searchTextField.getText());
                    if (e != null) {
                        TexturePanel.this.availableTexturesList.clearSelection();
                        TexturePanel.this.availableTexturesList.setSelectedValue(e, true);
                        if (texturesCatalogListModel.getSize() == 1) {
                            TexturePanel.this.availableTexturesList.setSelectedIndex(0);
                        }
                    }
                }

                public void insertUpdate(DocumentEvent documentEvent) {
                    this.changedUpdate(documentEvent);
                }

                public void removeUpdate(DocumentEvent documentEvent) {
                    this.changedUpdate(documentEvent);
                }
            });
            this.searchTextField.getInputMap().put(KeyStroke.getKeyStroke("ESCAPE"), "deleteContent");
            this.searchTextField.getActionMap().put("deleteContent", new AbstractAction(){

                public void actionPerformed(ActionEvent actionEvent) {
                    TexturePanel.this.searchTextField.setText("");
                }
            });
            if (OperatingSystem.isMacOSXLeopardOrSuperior()) {
                this.searchTextField.putClientProperty("JTextField.variant", "search");
            }
            this.searchTextField.getInputMap(0).remove(KeyStroke.getKeyStroke("ESCAPE"));
            this.chosenTextureLabel = new JLabel(userPreferences.getLocalizedString(TextureChoiceComponent.class, "chosenTextureLabel.text", new Object[0]));
            this.texturePreviewComponent = new ScaledImageComponent(null, true){

                protected void paintComponent(Graphics graphics) {
                    Graphics2D graphics2D = (Graphics2D)graphics;
                    Shape shape = graphics2D.getClip();
                    AffineTransform affineTransform = graphics2D.getTransform();
                    Insets insets = this.getBorder().getBorderInsets(this);
                    graphics2D.setClip(new Rectangle(insets.left, insets.top, this.getWidth() - insets.right - insets.left, this.getHeight() - insets.bottom - insets.top));
                    graphics2D.rotate(Math.toRadians(((Number)TexturePanel.this.angleSpinner.getValue()).doubleValue()), this.getWidth() / 2, this.getHeight() / 2);
                    super.paintComponent(graphics);
                    graphics2D.setTransform(affineTransform);
                    graphics2D.setClip(shape);
                }
            };
            try {
                String string = SwingTools.getLocalizedLabelText(userPreferences, TextureChoiceComponent.class, "importTextureButton.text", new Object[0]);
                this.texturePreviewComponent.setBorder(SwingTools.getDropableComponentBorder());
                this.texturePreviewComponent.setTransferHandler(new TransferHandler(){

                    public boolean canImport(JComponent jComponent, DataFlavor[] dataFlavorArray) {
                        return Arrays.asList(dataFlavorArray).contains(DataFlavor.javaFileListFlavor);
                    }

                    public boolean importData(JComponent jComponent, Transferable transferable) {
                        try {
                            List list = (List)transferable.getTransferData(DataFlavor.javaFileListFlavor);
                            final String string = ((File)list.get(0)).getAbsolutePath();
                            EventQueue.invokeLater(new Runnable(){

                                public void run() {
                                    textureChoiceController.importTexture(string);
                                }
                            });
                            return true;
                        }
                        catch (UnsupportedFlavorException unsupportedFlavorException) {
                            return false;
                        }
                        catch (IOException iOException) {
                            return false;
                        }
                    }
                });
                this.angleLabel = new JLabel(SwingTools.getLocalizedLabelText(userPreferences, TextureChoiceComponent.class, "angleLabel.text", new Object[0]));
                object = new NullableSpinner.NullableSpinnerModuloNumberModel(0.0f, 0.0f, 360.0f, 15.0f);
                this.angleSpinner = new NullableSpinner((NullableSpinner.NullableSpinnerNumberModel)object);
                ((AbstractSpinnerModel)object).addChangeListener(new ChangeListener(){

                    public void stateChanged(ChangeEvent changeEvent) {
                        TexturePanel.this.texturePreviewComponent.repaint();
                    }
                });
                this.scaleLabel = new JLabel(SwingTools.getLocalizedLabelText(userPreferences, TextureChoiceComponent.class, "scaleLabel.text", new Object[0]));
                serializable = new SpinnerNumberModel(new Float(100.0f), new Float(1.0f), new Float(10000.0f), new Float(5.0f));
                this.scaleSpinner = new AutoCommitSpinner((SpinnerModel)((Object)serializable));
                this.importTextureButton = new JButton(string);
                this.importTextureButton.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        textureChoiceController.importTexture();
                    }
                });
                this.modifyTextureButton = new JButton(SwingTools.getLocalizedLabelText(userPreferences, TextureChoiceComponent.class, "modifyTextureButton.text", new Object[0]));
                this.modifyTextureButton.setEnabled(false);
                this.modifyTextureButton.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        textureChoiceController.modifyTexture((CatalogTexture)TexturePanel.this.availableTexturesList.getSelectedValue());
                    }
                });
                this.deleteTextureButton = new JButton(SwingTools.getLocalizedLabelText(userPreferences, TextureChoiceComponent.class, "deleteTextureButton.text", new Object[0]));
                this.deleteTextureButton.setEnabled(false);
                this.deleteTextureButton.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        textureChoiceController.deleteTexture((CatalogTexture)TexturePanel.this.availableTexturesList.getSelectedValue());
                    }
                });
                userPreferences.getTexturesCatalog().addTexturesListener(new TexturesCatalogListener(this));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.texturePreviewComponent.setBorder(BorderFactory.createEtchedBorder(1));
            }
            this.recentTexturesPanel = SwingTools.createTitledPanel(userPreferences.getLocalizedString(TextureChoiceComponent.class, "recentPanel.title", new Object[0]));
            int n = OperatingSystem.isMacOSXLeopardOrSuperior() ? -8 : -2;
            this.recentTexturesPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(0, n, 0, n), this.recentTexturesPanel.getBorder()));
            userPreferences.addPropertyChangeListener(UserPreferences.Property.RECENT_TEXTURES, new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    TexturePanel.this.updateRecentTextures(userPreferences);
                }
            });
            this.updateRecentTextures(userPreferences);
            this.recentTexturesPanel.setOpaque(false);
            object = this.texturePreviewComponent.getBorder();
            serializable = textureChoiceController.getTexture();
            this.setPreviewTexture((TextureImage)serializable);
            if (serializable instanceof HomeTexture) {
                this.angleSpinner.setValue(new Float((float)Math.toDegrees(serializable.getAngle())));
                this.scaleSpinner.setValue(new Float(serializable.getScale() * 100.0f));
            }
            Insets insets = object.getBorderInsets(this.texturePreviewComponent);
            this.texturePreviewComponent.setPreferredSize(new Dimension(PREVIEW_ICON_SIZE + insets.left + insets.right, PREVIEW_ICON_SIZE + insets.top + insets.bottom));
        }

        public void updateRecentTextures(UserPreferences userPreferences) {
            this.recentTexturesPanel.removeAll();
            List<TextureImage> list = userPreferences.getRecentTextures();
            Border border = BorderFactory.createLineBorder(Color.GRAY);
            for (int i = 0; i < list.size(); ++i) {
                final TextureImage textureImage = list.get(i);
                JLabel jLabel = new JLabel();
                jLabel.setIcon(new TextureIcon(textureImage, jLabel));
                jLabel.setBorder(border);
                jLabel.setToolTipText(textureImage.getName());
                jLabel.addMouseListener(new MouseAdapter(){

                    public void mousePressed(MouseEvent mouseEvent) {
                        JRootPane jRootPane;
                        TexturePanel.this.setPreviewTexture(textureImage);
                        if (mouseEvent.getClickCount() == 2 && (jRootPane = (JRootPane)SwingUtilities.getAncestorOfClass(JRootPane.class, TexturePanel.this.recentTexturesPanel)) != null) {
                            for (JButton jButton : SwingTools.findChildren(jRootPane, JButton.class)) {
                                if (!"OK".equals(jButton.getActionCommand())) continue;
                                jButton.doClick();
                            }
                        }
                    }
                });
                this.recentTexturesPanel.add((Component)jLabel, new GridBagConstraints(i, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 2), 0, 0));
            }
            this.recentTexturesPanel.setVisible(!list.isEmpty());
        }

        private void setMnemonics(UserPreferences userPreferences) {
            if (!OperatingSystem.isMacOSX()) {
                this.availableTexturesLabel.setDisplayedMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(TextureChoiceComponent.class, "availableTexturesLabel.mnemonic", new Object[0])).getKeyCode());
                this.availableTexturesLabel.setLabelFor(this.availableTexturesList);
                this.searchLabel.setDisplayedMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(TextureChoiceComponent.class, "searchLabel.mnemonic", new Object[0])).getKeyCode());
                this.searchLabel.setLabelFor(this.searchTextField);
                this.angleLabel.setDisplayedMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(TextureChoiceComponent.class, "angleLabel.mnemonic", new Object[0])).getKeyCode());
                this.angleLabel.setLabelFor(this.angleSpinner);
                this.scaleLabel.setDisplayedMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(TextureChoiceComponent.class, "scaleLabel.mnemonic", new Object[0])).getKeyCode());
                this.scaleLabel.setLabelFor(this.scaleSpinner);
                if (this.importTextureButton != null) {
                    this.importTextureButton.setMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(TextureChoiceComponent.class, "importTextureButton.mnemonic", new Object[0])).getKeyCode());
                    this.modifyTextureButton.setMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(TextureChoiceComponent.class, "modifyTextureButton.mnemonic", new Object[0])).getKeyCode());
                    this.deleteTextureButton.setMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(TextureChoiceComponent.class, "deleteTextureButton.mnemonic", new Object[0])).getKeyCode());
                }
            }
        }

        private void layoutComponents() {
            Serializable serializable;
            int n = OperatingSystem.isMacOSX() ? 22 : 21;
            JPanel jPanel = new JPanel(new GridBagLayout());
            jPanel.add((Component)this.availableTexturesLabel, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 21, 0, new Insets(0, 0, 5, 0), 0, 0));
            JScrollPane jScrollPane = new JScrollPane(this.availableTexturesList);
            jScrollPane.getVerticalScrollBar().addAdjustmentListener(SwingTools.createAdjustmentListenerUpdatingScrollPaneViewToolTip(jScrollPane));
            jScrollPane.setPreferredSize(new Dimension(250, jScrollPane.getPreferredSize().height));
            jPanel.add((Component)jScrollPane, new GridBagConstraints(0, 1, 2, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 3, 0), 0, 0));
            SwingTools.installFocusBorder(this.availableTexturesList);
            if (OperatingSystem.isMacOSXLeopardOrSuperior()) {
                jPanel.add((Component)this.searchTextField, new GridBagConstraints(0, 5, 2, 1, 0.0, 0.0, 21, 2, new Insets(0, 0, 0, 0), 0, 0));
            } else {
                jPanel.add((Component)this.searchLabel, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, n, 0, new Insets(2, 0, 0, 3), 0, 0));
                jPanel.add((Component)this.searchTextField, new GridBagConstraints(1, 5, 1, 1, 0.0, 0.0, 21, 2, new Insets(2, 0, 0, 0), 0, 0));
            }
            JPanel jPanel2 = new JPanel(new GridBagLayout());
            jPanel2.add((Component)this.chosenTextureLabel, new GridBagConstraints(2, 0, 2, 1, 0.0, 0.0, 21, 0, new Insets(0, 0, 5, 0), 0, 0));
            jPanel2.add((Component)this.texturePreviewComponent, new GridBagConstraints(2, 1, 2, 1, 0.0, 0.0, 11, 0, new Insets(0, 0, 5, 0), 0, 0));
            if (this.controller.isRotationSupported()) {
                jPanel2.add((Component)this.angleLabel, new GridBagConstraints(2, 2, 1, 1, 0.1, 0.0, n, 0, new Insets(0, 0, 5, 5), 0, 0));
                jPanel2.add((Component)this.angleSpinner, new GridBagConstraints(3, 2, 1, 1, 0.1, 0.0, 21, 2, new Insets(0, 0, 5, 0), 0, 0));
                jPanel2.add((Component)this.scaleLabel, new GridBagConstraints(2, 3, 1, 1, 0.1, 0.0, n, 0, new Insets(0, 0, 5, 5), 0, 0));
                jPanel2.add((Component)this.scaleSpinner, new GridBagConstraints(3, 3, 1, 1, 0.1, 0.0, 21, 2, new Insets(0, 0, 5, 0), 0, 0));
                jPanel2.add((Component)new JSeparator(), new GridBagConstraints(2, 4, 2, 1, 0.0, 0.0, 21, 2, new Insets(0, 0, 5, 0), 0, 0));
            }
            if (this.importTextureButton != null) {
                serializable = new JPanel(new GridLayout(3, 1, 2, 2));
                ((Container)serializable).add(this.importTextureButton);
                ((Container)serializable).add(this.modifyTextureButton);
                ((Container)serializable).add(this.deleteTextureButton);
                jPanel2.add((Component)serializable, new GridBagConstraints(2, 5, 2, 1, 0.0, 1.0, 11, 0, new Insets(0, 0, 0, 0), 0, 0));
            }
            this.add((Component)jPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 11, 1, new Insets(0, 0, 0, 15), 0, 0));
            this.add((Component)jPanel2, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 11, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.add((Component)this.recentTexturesPanel, new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 11, 2, new Insets(5, 0, 0, 0), 0, 0));
            serializable = new ArrayList();
            serializable.add(this.availableTexturesList);
            serializable.add(this.searchTextField);
            if (this.controller.isRotationSupported()) {
                serializable.add(((JSpinner.DefaultEditor)this.angleSpinner.getEditor()).getTextField());
                serializable.add(((JSpinner.DefaultEditor)this.scaleSpinner.getEditor()).getTextField());
            }
            if (this.importTextureButton != null) {
                serializable.add(this.importTextureButton);
                serializable.add(this.modifyTextureButton);
                serializable.add(this.deleteTextureButton);
            }
            this.setFocusTraversalPolicy(new FocusTraversalPolicy((List)((Object)serializable)){
                final /* synthetic */ List val$components;
                {
                    this.val$components = list;
                }

                public Component getComponentAfter(Container container, Component component) {
                    int n = this.val$components.indexOf(component);
                    if (n == this.val$components.size() - 1) {
                        return null;
                    }
                    JComponent jComponent = (JComponent)this.val$components.get(n + 1);
                    if (jComponent.isEnabled()) {
                        return jComponent;
                    }
                    return this.getComponentAfter(container, jComponent);
                }

                public Component getComponentBefore(Container container, Component component) {
                    int n = this.val$components.indexOf(component);
                    if (n == 0) {
                        return null;
                    }
                    JComponent jComponent = (JComponent)this.val$components.get(n - 1);
                    if (jComponent.isEnabled()) {
                        return jComponent;
                    }
                    return this.getComponentBefore(container, jComponent);
                }

                public Component getFirstComponent(Container container) {
                    return (Component)this.val$components.get(0);
                }

                public Component getLastComponent(Container container) {
                    return (Component)this.val$components.get(this.val$components.size() - 1);
                }

                public Component getDefaultComponent(Container container) {
                    return this.getFirstComponent(container);
                }
            });
            this.setFocusTraversalPolicyProvider(true);
        }

        private TextureImage getPreviewTexture() {
            return this.previewTexture;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void setPreviewTexture(TextureImage textureImage) {
            this.previewTexture = textureImage;
            if (textureImage != null) {
                this.texturePreviewComponent.setToolTipText(textureImage.getName());
                InputStream inputStream = null;
                try {
                    inputStream = textureImage.getImage().openStream();
                    this.texturePreviewComponent.setImage(ImageIO.read(inputStream));
                }
                catch (IOException iOException) {
                }
                finally {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            } else {
                this.texturePreviewComponent.setToolTipText(null);
                this.texturePreviewComponent.setImage(null);
            }
            this.availableTexturesList.setSelectedValue(textureImage, true);
            if (this.availableTexturesList.getSelectedValue() != textureImage) {
                int n = this.availableTexturesList.getSelectedIndex();
                this.availableTexturesList.removeSelectionInterval(n, n);
            }
        }

        public void displayView(View view) {
            final JOptionPane jOptionPane = new JOptionPane(this, -1, 2);
            JRootPane jRootPane = SwingUtilities.getRootPane((JComponent)((Object)view));
            if (jRootPane != null) {
                jOptionPane.setComponentOrientation(jRootPane.getComponentOrientation());
            }
            final JDialog jDialog = jOptionPane.createDialog(jRootPane, this.controller.getDialogTitle());
            jDialog.applyComponentOrientation(ComponentOrientation.getOrientation(Locale.getDefault()));
            jDialog.setResizable(true);
            jDialog.pack();
            jDialog.setMinimumSize(jDialog.getPreferredSize());
            if (dialogPreferredSize != null && TexturePanel.dialogPreferredSize.width >= jDialog.getWidth() && TexturePanel.dialogPreferredSize.height >= jDialog.getHeight()) {
                jDialog.setSize(dialogPreferredSize);
            }
            this.searchTextField.setText(searchFilterText);
            jDialog.addComponentListener(new ComponentAdapter(){

                public void componentShown(ComponentEvent componentEvent) {
                    SwingTools.requestFocusInWindow(TexturePanel.this.searchTextField);
                    jDialog.removeComponentListener(this);
                }
            });
            this.availableTexturesList.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent mouseEvent) {
                    if (mouseEvent.getClickCount() == 2) {
                        jOptionPane.setValue(0);
                        TexturePanel.this.availableTexturesList.removeMouseListener(this);
                    }
                }
            });
            ToolTipManager.sharedInstance().registerComponent(this.availableTexturesList);
            jDialog.setVisible(true);
            jDialog.dispose();
            ToolTipManager.sharedInstance().unregisterComponent(this.availableTexturesList);
            dialogPreferredSize = jDialog.getSize();
            searchFilterText = this.searchTextField.getText();
            if (Integer.valueOf(0).equals(jOptionPane.getValue())) {
                HomeTexture homeTexture = this.getSelectedTexture();
                this.controller.setTexture(homeTexture);
                if (homeTexture != null) {
                    this.controller.addRecentTexture(homeTexture);
                }
            }
        }

        private HomeTexture getSelectedTexture() {
            TextureImage textureImage = this.getPreviewTexture();
            if (textureImage == null) {
                return null;
            }
            float f = (float)Math.toRadians(((Number)this.angleSpinner.getValue()).doubleValue());
            float f2 = ((Number)this.scaleSpinner.getValue()).floatValue() / 100.0f;
            return new HomeTexture(textureImage, f, f2, true);
        }

        private static class TexturesCatalogListModel
        extends AbstractListModel {
            private TexturesCatalog catalog;
            private List<CatalogTexture> textures;
            private String filterText;

            public TexturesCatalogListModel(TexturesCatalog texturesCatalog) {
                this.catalog = texturesCatalog;
                this.filterText = "";
                texturesCatalog.addTexturesListener(new TexturesCatalogListener(this));
            }

            public void setFilterText(String string) {
                this.filterText = string;
                this.resetFurnitureList();
            }

            public Object getElementAt(int n) {
                this.checkFurnitureList();
                return this.textures.get(n);
            }

            public int getSize() {
                this.checkFurnitureList();
                return this.textures.size();
            }

            private void resetFurnitureList() {
                if (this.textures != null) {
                    this.textures = null;
                    EventQueue.invokeLater(new Runnable(){

                        public void run() {
                            TexturesCatalogListModel.this.fireContentsChanged(this, -1, -1);
                        }
                    });
                }
            }

            private void checkFurnitureList() {
                if (this.textures == null) {
                    this.textures = new ArrayList<CatalogTexture>();
                    this.textures.clear();
                    for (TexturesCategory texturesCategory : this.catalog.getCategories()) {
                        for (CatalogTexture catalogTexture : texturesCategory.getTextures()) {
                            if (!catalogTexture.matchesFilter(this.filterText)) continue;
                            this.textures.add(catalogTexture);
                        }
                    }
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            private static class TexturesCatalogListener
            implements CollectionListener<CatalogTexture> {
                private WeakReference<TexturesCatalogListModel> listModel;

                public TexturesCatalogListener(TexturesCatalogListModel texturesCatalogListModel) {
                    this.listModel = new WeakReference<TexturesCatalogListModel>(texturesCatalogListModel);
                }

                @Override
                public void collectionChanged(CollectionEvent<CatalogTexture> collectionEvent) {
                    TexturesCatalogListModel texturesCatalogListModel = (TexturesCatalogListModel)this.listModel.get();
                    TexturesCatalog texturesCatalog = (TexturesCatalog)collectionEvent.getSource();
                    if (texturesCatalogListModel == null) {
                        texturesCatalog.removeTexturesListener(this);
                    } else {
                        texturesCatalogListModel.resetFurnitureList();
                    }
                }
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static class TexturesCatalogListener
        implements CollectionListener<CatalogTexture> {
            private WeakReference<TexturePanel> texturePanel;

            public TexturesCatalogListener(TexturePanel texturePanel) {
                this.texturePanel = new WeakReference<TexturePanel>(texturePanel);
            }

            @Override
            public void collectionChanged(final CollectionEvent<CatalogTexture> collectionEvent) {
                final TexturePanel texturePanel = (TexturePanel)this.texturePanel.get();
                if (texturePanel == null) {
                    ((TexturesCatalog)collectionEvent.getSource()).removeTexturesListener(this);
                } else {
                    switch (collectionEvent.getType()) {
                        case ADD: {
                            texturePanel.searchTextField.setText("");
                            if (texturePanel.availableTexturesList.isShowing()) {
                                EventQueue.invokeLater(new Runnable(){

                                    public void run() {
                                        texturePanel.availableTexturesList.setSelectedValue(collectionEvent.getItem(), true);
                                    }
                                });
                                break;
                            }
                            texturePanel.availableTexturesList.clearSelection();
                            break;
                        }
                        case DELETE: {
                            texturePanel.availableTexturesList.clearSelection();
                        }
                    }
                }
            }
        }

        private static class TextureIcon
        implements Icon {
            static final int SIZE = 16;
            private TextureImage texture;
            private JComponent component;

            public TextureIcon(TextureImage textureImage, JComponent jComponent) {
                this.texture = textureImage;
                this.component = jComponent;
            }

            public int getIconWidth() {
                return 16;
            }

            public int getIconHeight() {
                return 16;
            }

            public void paintIcon(Component component, Graphics graphics, int n, int n2) {
                Icon icon = IconManager.getInstance().getIcon(this.texture.getImage(), this.getIconHeight(), this.component);
                if (icon.getIconWidth() != icon.getIconHeight()) {
                    Graphics2D graphics2D = (Graphics2D)graphics;
                    AffineTransform affineTransform = graphics2D.getTransform();
                    graphics2D.translate(n, n2);
                    graphics2D.scale((float)icon.getIconHeight() / (float)icon.getIconWidth(), 1.0);
                    icon.paintIcon(component, graphics2D, 0, 0);
                    graphics2D.setTransform(affineTransform);
                } else {
                    icon.paintIcon(component, graphics, n, n2);
                }
            }
        }

        private static class TextureListCellRenderer
        extends DefaultListCellRenderer {
            private Font defaultFont;
            private Font modifiablePieceFont;

            private TextureListCellRenderer() {
            }

            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                if (this.defaultFont == null) {
                    this.defaultFont = this.getFont();
                    this.modifiablePieceFont = new Font(this.defaultFont.getFontName(), 2, this.defaultFont.getSize());
                }
                CatalogTexture catalogTexture = (CatalogTexture)object;
                object = catalogTexture.getName();
                object = catalogTexture.getCategory().getName() + " - " + object;
                Component component = super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
                this.setIcon(new TextureIcon(catalogTexture, jList));
                this.setFont(catalogTexture.isModifiable() ? this.modifiablePieceFont : this.defaultFont);
                return component;
            }
        }
    }
}

