// **********************************************************************
//
// Copyright (c) 2003-2017 ZeroC, Inc. All rights reserved.
//
// This copy of Ice is licensed to you under the terms described in the
// ICE_LICENSE file included in this distribution.
//
// **********************************************************************
//
// Ice version 3.7.0
//
// <auto-generated>
//
// Generated from file `Router.ice'
//
// Warning: do not edit this file.
//
// </auto-generated>
//

package com.zeroc.Ice;

/**
 * The Ice router interface. Routers can be set either globally with
 * {@link Communicator#setDefaultRouter}, or with <tt>ice_router</tt> on specific
 * proxies.
 **/
public interface Router extends com.zeroc.Ice.Object
{
    public static class GetClientProxyResult
    {
        public GetClientProxyResult()
        {
        }

        /**
         * This constructor makes shallow copies of the results for operation GetClientProxy.
         * @param returnValue The router's client proxy.
         * @param hasRoutingTable Indicates whether or not the router supports a routing
         * table. If it is supported, the Ice runtime will call addProxies to populate the
         * routing table. This out parameter is only supported starting with Ice 3.7.
         * The Ice runtime assumes the router has a routing table if the optional is not
         * set.
         **/
        public GetClientProxyResult(com.zeroc.Ice.ObjectPrx returnValue, java.util.Optional<java.lang.Boolean> hasRoutingTable)
        {
            this.returnValue = returnValue;
            this.hasRoutingTable = hasRoutingTable;
        }

        /**
         * This constructor makes shallow copies of the results for operation GetClientProxy (overload without Optional parameters).
         * @param returnValue The router's client proxy.
         * @param hasRoutingTable Indicates whether or not the router supports a routing
         * table. If it is supported, the Ice runtime will call addProxies to populate the
         * routing table. This out parameter is only supported starting with Ice 3.7.
         * The Ice runtime assumes the router has a routing table if the optional is not
         * set.
         **/
        public GetClientProxyResult(com.zeroc.Ice.ObjectPrx returnValue, boolean hasRoutingTable)
        {
            this.returnValue = returnValue;
            this.hasRoutingTable = java.util.Optional.of(hasRoutingTable);
        }

        /**
         * The router's client proxy.
         **/
        public com.zeroc.Ice.ObjectPrx returnValue;
        /**
         * Indicates whether or not the router supports a routing
         * table. If it is supported, the Ice runtime will call addProxies to populate the
         * routing table. This out parameter is only supported starting with Ice 3.7.
         * The Ice runtime assumes the router has a routing table if the optional is not
         * set.
         **/
        public java.util.Optional<java.lang.Boolean> hasRoutingTable;

        public void write(com.zeroc.Ice.OutputStream ostr)
        {
            ostr.writeProxy(returnValue);
            ostr.writeBool(1, this.hasRoutingTable);
        }

        public void read(com.zeroc.Ice.InputStream istr)
        {
            returnValue = istr.readProxy();
            this.hasRoutingTable = istr.readBool(1);
        }
    }

    /**
     * Get the router's client proxy, i.e., the proxy to use for
     * forwarding requests from the client to the router.
     *
     * If a null proxy is returned, the client will forward requests
     * to the router's endpoints.
     * @param current The Current object for the invocation.
     * @return An instance of Router.GetClientProxyResult.
     **/
    Router.GetClientProxyResult getClientProxy(com.zeroc.Ice.Current current);

    /**
     * Get the router's server proxy, i.e., the proxy to use for
     * forwarding requests from the server to the router.
     * @param current The Current object for the invocation.
     * @return The router's server proxy.
     **/
    com.zeroc.Ice.ObjectPrx getServerProxy(com.zeroc.Ice.Current current);

    /**
     * Add new proxy information to the router's routing table.
     * @param proxies The proxies to add.
     * @param current The Current object for the invocation.
     * @return Proxies discarded by the router.
     **/
    com.zeroc.Ice.ObjectPrx[] addProxies(com.zeroc.Ice.ObjectPrx[] proxies, com.zeroc.Ice.Current current);

    static final String[] _iceIds =
    {
        "::Ice::Object",
        "::Ice::Router"
    };

    @Override
    default String[] ice_ids(com.zeroc.Ice.Current current)
    {
        return _iceIds;
    }

    @Override
    default String ice_id(com.zeroc.Ice.Current current)
    {
        return ice_staticId();
    }

    static String ice_staticId()
    {
        return "::Ice::Router";
    }

    static java.util.concurrent.CompletionStage<com.zeroc.Ice.OutputStream> _iceD_getClientProxy(Router obj, final com.zeroc.IceInternal.Incoming inS, com.zeroc.Ice.Current current)
    {
        com.zeroc.Ice.Object._iceCheckMode(com.zeroc.Ice.OperationMode.Idempotent, current.mode);
        inS.readEmptyParams();
        Router.GetClientProxyResult ret = obj.getClientProxy(current);
        com.zeroc.Ice.OutputStream ostr = inS.startWriteParams();
        ret.write(ostr);
        inS.endWriteParams(ostr);
        return inS.setResult(ostr);
    }

    static java.util.concurrent.CompletionStage<com.zeroc.Ice.OutputStream> _iceD_getServerProxy(Router obj, final com.zeroc.IceInternal.Incoming inS, com.zeroc.Ice.Current current)
    {
        com.zeroc.Ice.Object._iceCheckMode(com.zeroc.Ice.OperationMode.Idempotent, current.mode);
        inS.readEmptyParams();
        com.zeroc.Ice.ObjectPrx ret = obj.getServerProxy(current);
        com.zeroc.Ice.OutputStream ostr = inS.startWriteParams();
        ostr.writeProxy(ret);
        inS.endWriteParams(ostr);
        return inS.setResult(ostr);
    }

    static java.util.concurrent.CompletionStage<com.zeroc.Ice.OutputStream> _iceD_addProxies(Router obj, final com.zeroc.IceInternal.Incoming inS, com.zeroc.Ice.Current current)
    {
        com.zeroc.Ice.Object._iceCheckMode(com.zeroc.Ice.OperationMode.Idempotent, current.mode);
        com.zeroc.Ice.InputStream istr = inS.startReadParams();
        com.zeroc.Ice.ObjectPrx[] iceP_proxies;
        iceP_proxies = ObjectProxySeqHelper.read(istr);
        inS.endReadParams();
        com.zeroc.Ice.ObjectPrx[] ret = obj.addProxies(iceP_proxies, current);
        com.zeroc.Ice.OutputStream ostr = inS.startWriteParams();
        ObjectProxySeqHelper.write(ostr, ret);
        inS.endWriteParams(ostr);
        return inS.setResult(ostr);
    }

    final static String[] _iceOps =
    {
        "addProxies",
        "getClientProxy",
        "getServerProxy",
        "ice_id",
        "ice_ids",
        "ice_isA",
        "ice_ping"
    };

    @Override
    default java.util.concurrent.CompletionStage<com.zeroc.Ice.OutputStream> _iceDispatch(com.zeroc.IceInternal.Incoming in, com.zeroc.Ice.Current current)
        throws com.zeroc.Ice.UserException
    {
        int pos = java.util.Arrays.binarySearch(_iceOps, current.operation);
        if(pos < 0)
        {
            throw new com.zeroc.Ice.OperationNotExistException(current.id, current.facet, current.operation);
        }

        switch(pos)
        {
            case 0:
            {
                return _iceD_addProxies(this, in, current);
            }
            case 1:
            {
                return _iceD_getClientProxy(this, in, current);
            }
            case 2:
            {
                return _iceD_getServerProxy(this, in, current);
            }
            case 3:
            {
                return com.zeroc.Ice.Object._iceD_ice_id(this, in, current);
            }
            case 4:
            {
                return com.zeroc.Ice.Object._iceD_ice_ids(this, in, current);
            }
            case 5:
            {
                return com.zeroc.Ice.Object._iceD_ice_isA(this, in, current);
            }
            case 6:
            {
                return com.zeroc.Ice.Object._iceD_ice_ping(this, in, current);
            }
        }

        assert(false);
        throw new com.zeroc.Ice.OperationNotExistException(current.id, current.facet, current.operation);
    }
}
