/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.event.ActionEvent;
import java.util.Collection;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.command.MoveCommand;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmUtils;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.dialogs.LatLonDialog;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.tools.I18n;

public final class MoveNodeAction
extends JosmAction {
    public MoveNodeAction() {
        super(I18n.tr("Move Node...", new Object[0]), "movenode", I18n.tr("Edit latitude and longitude of a node.", new Object[0]), null, true);
        this.putValue("help", HelpUtil.ht("/Action/MoveNode"));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Collection<Node> selNodes = this.getLayerManager().getEditDataSet().getSelectedNodes();
        if (!this.isEnabled() || selNodes.size() != 1) {
            return;
        }
        LatLonDialog dialog = new LatLonDialog(Main.parent, I18n.tr("Move Node...", new Object[0]), HelpUtil.ht("/Action/MoveNode"));
        Node n = (Node)selNodes.toArray()[0];
        dialog.setCoordinates(n.getCoor());
        dialog.showDialog();
        if (dialog.getValue() != 1) {
            return;
        }
        LatLon coordinates = dialog.getCoordinates();
        if (coordinates == null) {
            return;
        }
        MainApplication.undoRedo.add(new MoveCommand(n, coordinates));
        MainApplication.getMap().mapView.repaint();
    }

    @Override
    protected void updateEnabledState() {
        this.updateEnabledStateOnCurrentSelection();
    }

    @Override
    protected void updateEnabledState(Collection<? extends OsmPrimitive> selection) {
        this.setEnabled(OsmUtils.isOsmCollectionEditable(selection) && selection.size() == 1 && selection.toArray()[0] instanceof Node);
    }
}

