/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.layer.geoimage;

import java.text.ParseException;
import java.util.Objects;
import org.openstreetmap.josm.tools.I18n;

public final class Timezone {
    static final Timezone ZERO = new Timezone(0.0);
    private final double timezone;

    Timezone(double hours) {
        this.timezone = hours;
    }

    public double getHours() {
        return this.timezone;
    }

    String formatTimezone() {
        StringBuilder ret = new StringBuilder();
        double timezone = this.timezone;
        if (timezone < 0.0) {
            ret.append('-');
            timezone = -timezone;
        } else {
            ret.append('+');
        }
        ret.append((long)timezone).append(':');
        int minutes = (int)(timezone % 1.0 * 60.0);
        if (minutes < 10) {
            ret.append('0');
        }
        ret.append(minutes);
        return ret.toString();
    }

    static Timezone parseTimezone(String timezone) throws ParseException {
        if (timezone.isEmpty()) {
            return ZERO;
        }
        String error = I18n.tr("Error while parsing timezone.\nExpected format: {0}", "+H:MM");
        int sgnTimezone = 43;
        StringBuilder hTimezone = new StringBuilder();
        StringBuilder mTimezone = new StringBuilder();
        int state = 1;
        block12: for (int i = 0; i < timezone.length(); ++i) {
            char c = timezone.charAt(i);
            switch (c) {
                case ' ': {
                    if (state == 2 && hTimezone.length() == 0) continue block12;
                    throw new ParseException(error, i);
                }
                case '+': 
                case '-': {
                    if (state == 1) {
                        sgnTimezone = c;
                        state = 2;
                        continue block12;
                    }
                    throw new ParseException(error, i);
                }
                case '.': 
                case ':': {
                    if (state == 2) {
                        state = 3;
                        continue block12;
                    }
                    throw new ParseException(error, i);
                }
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    switch (state) {
                        case 1: 
                        case 2: {
                            state = 2;
                            hTimezone.append(c);
                            continue block12;
                        }
                        case 3: {
                            mTimezone.append(c);
                            continue block12;
                        }
                    }
                    throw new ParseException(error, i);
                }
                default: {
                    throw new ParseException(error, i);
                }
            }
        }
        int h = 0;
        int m = 0;
        try {
            h = Integer.parseInt(hTimezone.toString());
            if (mTimezone.length() > 0) {
                m = Integer.parseInt(mTimezone.toString());
            }
        }
        catch (NumberFormatException nfe) {
            throw (ParseException)new ParseException(error, 0).initCause(nfe);
        }
        if (h > 12 || m > 59) {
            throw new ParseException(error, 0);
        }
        return new Timezone(((double)h + (double)m / 60.0) * (double)(sgnTimezone == 45 ? -1 : 1));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Timezone)) {
            return false;
        }
        Timezone timezone1 = (Timezone)o;
        return Double.compare(timezone1.timezone, this.timezone) == 0;
    }

    public int hashCode() {
        return Objects.hash(this.timezone);
    }
}

