/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.widgets;

import java.awt.Component;
import java.awt.FileDialog;
import java.awt.Frame;
import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.List;
import javax.swing.filechooser.FileFilter;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.widgets.AbstractFileChooser;
import org.openstreetmap.josm.tools.Utils;

public class NativeFileChooser
extends AbstractFileChooser {
    private final FileDialog fileDialog;
    private FileFilter fileFilter;
    private final List<FileFilter> fileFilters = new ArrayList<FileFilter>();
    private int selectionMode;

    public NativeFileChooser(File file) {
        this.fileDialog = new FileDialog((Frame)Main.parent);
        if (file != null) {
            this.fileDialog.setDirectory(file.getAbsolutePath());
            if (file.isFile()) {
                this.fileDialog.setFile(file.toString());
            }
        }
    }

    @Override
    public void addChoosableFileFilter(FileFilter filter) {
        this.fileFilters.add(filter);
    }

    @Override
    public FileFilter[] getChoosableFileFilters() {
        return this.fileFilters.toArray(new FileFilter[0]);
    }

    @Override
    public File getCurrentDirectory() {
        return new File(this.fileDialog.getDirectory());
    }

    @Override
    public FileFilter getFileFilter() {
        return this.fileFilter;
    }

    @Override
    public File getSelectedFile() {
        return new File(this.fileDialog.getDirectory() + this.fileDialog.getFile());
    }

    @Override
    public File[] getSelectedFiles() {
        return this.fileDialog.getFiles();
    }

    @Override
    public boolean isMultiSelectionEnabled() {
        return this.fileDialog.isMultipleMode();
    }

    @Override
    public void setAcceptAllFileFilterUsed(boolean b) {
    }

    @Override
    public void setCurrentDirectory(File f) {
        this.fileDialog.setDirectory(f.toString());
    }

    @Override
    public void setDialogTitle(String title) {
        this.fileDialog.setTitle(title);
    }

    @Override
    public void setFileFilter(FileFilter cff) {
        FilenameFilter filter = (directory, fileName) -> cff.accept(new File(directory.getAbsolutePath() + fileName));
        this.fileDialog.setFilenameFilter(filter);
        this.fileFilter = cff;
    }

    @Override
    public void setFileSelectionMode(int selectionMode) {
        this.selectionMode = selectionMode;
    }

    @Override
    public void setMultiSelectionEnabled(boolean multiple) {
        this.fileDialog.setMultipleMode(multiple);
    }

    @Override
    public void setSelectedFile(File file) {
        if (file == null) {
            return;
        }
        this.fileDialog.setDirectory(file.getParent());
        this.fileDialog.setFile(file.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int showOpenDialog(Component parent) {
        boolean appleProperty;
        boolean bl = appleProperty = Main.isPlatformOsx() && this.selectionMode == 1;
        if (appleProperty) {
            Utils.updateSystemProperty("apple.awt.fileDialogForDirectories", "true");
        }
        try {
            this.fileDialog.setLocale(locale);
            this.fileDialog.setMode(0);
            this.fileDialog.setVisible(true);
            int n = this.fileDialog.getFile() == null ? 1 : 0;
            return n;
        }
        finally {
            if (appleProperty) {
                Utils.updateSystemProperty("apple.awt.fileDialogForDirectories", "false");
            }
        }
    }

    @Override
    public int showSaveDialog(Component parent) {
        this.fileDialog.setLocale(locale);
        this.fileDialog.setMode(1);
        this.fileDialog.setVisible(true);
        return this.fileDialog.getFile() == null ? 1 : 0;
    }

    public static boolean supportsSelectionMode(int selectionMode) {
        switch (selectionMode) {
            case 2: {
                return false;
            }
            case 1: {
                return Main.isPlatformOsx();
            }
        }
        return true;
    }
}

