/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.applet;

import java.applet.Applet;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.net.URL;
import java.util.Hashtable;
import java.util.Map;
import javajs.util.PT;
import javax.swing.UIManager;
import netscape.javascript.JSObject;
import org.jmol.applet.WrappedApplet;
import org.jmol.awt.FileDropper;
import org.jmol.c.CBK;
import org.jmol.util.GenericApplet;
import org.jmol.util.Logger;
import org.jmol.util.Parser;

public class Jmol
extends GenericApplet
implements WrappedApplet {
    private boolean isUpdating;
    private boolean showPaintTime;
    private int timeLast;
    private int timeCount;
    private int timeTotal;
    private int lastMotionEventNumber;
    private long timeBegin;
    private FileDropper dropper;
    private Applet applet;
    private Boolean allowJSEval;
    private JSObject jsoDocument = null;

    @Override
    public void setApplet(Applet a, boolean isSigned) {
        this.applet = a;
        this.appletObject = this.applet;
        this.isSigned = isSigned;
        this.init(this.appletObject);
        if (isSigned) {
            try {
                this.dropper = new FileDropper(null, this.viewer, null);
            }
            catch (Exception e) {
                System.out.println(e);
            }
        }
    }

    @Override
    public void paint(Graphics g) {
        this.update(g, "paint ");
    }

    @Override
    public void update(Graphics g) {
        this.update(g, "update");
    }

    @Override
    public void destroy() {
        super.destroy();
        if (this.dropper != null) {
            this.dropper.dispose();
            this.dropper = null;
        }
        System.out.println("Jmol applet " + this.fullName + " destroyed");
        if (this.isJNLP) {
            System.exit(0);
        }
    }

    @Override
    public Object setStereoGraphics(boolean isStereo) {
        return isStereo ? this.applet.getGraphics() : null;
    }

    @Override
    protected void initOptions() {
        String ms = this.getJmolParameter("mayscript");
        this.mayScript = ms != null && !ms.equalsIgnoreCase("false");
        URL base = this.applet.getDocumentBase();
        this.documentBase = base == null ? this.getValue("documentBase", null) : base.toString();
        base = this.applet.getCodeBase();
        String string = this.codeBase = base == null ? this.getValue("codePath", this.getValue("codeBase", null)) : base.toString();
        if (this.codeBase != null && !this.codeBase.endsWith("/")) {
            this.codeBase = this.codeBase + "/";
        }
        this.vwrOptions = new Hashtable();
        this.isSigned |= this.isJNLP || this.getBooleanValue("signed", false);
        if (this.isSigned) {
            this.addValue(this.vwrOptions, null, "signedApplet", Boolean.TRUE);
        }
        if (this.getBooleanValue("useCommandThread", this.isSigned)) {
            this.addValue(this.vwrOptions, null, "useCommandThread", Boolean.TRUE);
        }
        String options = "";
        if (this.isSigned && this.getBooleanValue("multiTouchSparshUI-simulated", false)) {
            options = options + "-multitouch-sparshui-simulated";
        } else if (this.isSigned && this.getBooleanValue("multiTouchSparshUI", false)) {
            options = options + "-multitouch-sparshui";
        }
        this.addValue(this.vwrOptions, null, "options", options);
        this.addValue(this.vwrOptions, null, "display", this.applet);
        this.addValue(this.vwrOptions, null, "fullName", this.fullName);
        this.addValue(this.vwrOptions, null, "documentBase", this.documentBase);
        this.addValue(this.vwrOptions, null, "codePath", this.codeBase);
        if (this.getBooleanValue("noScripting", false)) {
            this.addValue(this.vwrOptions, null, "noScripting", Boolean.TRUE);
        }
        if (this.isJNLP) {
            this.addValue(this.vwrOptions, null, "isJNLP", Boolean.TRUE);
        }
        this.addValue(this.vwrOptions, "MaximumSize", "maximumSize", null);
        this.addValue(this.vwrOptions, "JmolAppletProxy", "appletProxy", null);
        this.addValue(this.vwrOptions, "documentLocation", null, null);
        try {
            UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
        }
        catch (Throwable exc) {
            System.err.println("Error loading L&F: " + exc);
        }
        if (Logger.debugging) {
            Logger.debug("checking for jsoWindow mayScript=" + this.mayScript);
        }
        if (this.mayScript) {
            this.haveDocumentAccess = false;
            this.mayScript = false;
            JSObject jsoWindow = null;
            JSObject jsoDocument = null;
            try {
                jsoWindow = JSObject.getWindow((Applet)this.applet);
                if (Logger.debugging) {
                    Logger.debug("jsoWindow=" + jsoWindow);
                }
                if (jsoWindow == null) {
                    Logger.error("jsoWindow returned null ... no JavaScript callbacks :-(");
                } else {
                    this.mayScript = true;
                }
                jsoDocument = (JSObject)jsoWindow.getMember("document");
                if (jsoDocument == null) {
                    Logger.error("jsoDocument returned null ... no DOM manipulations :-(");
                } else {
                    this.haveDocumentAccess = true;
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            if (Logger.debugging) {
                Logger.debug("jsoWindow:" + jsoWindow + " jsoDocument:" + jsoDocument + " mayScript:" + this.mayScript + " haveDocumentAccess:" + this.haveDocumentAccess);
            }
        }
        Jmol.cleanRegistry();
    }

    private void addValue(Map<String, Object> info, String key, String putKey, Object value) {
        if (key != null) {
            value = this.getValue(key, null);
        }
        if (value != null) {
            info.put(putKey == null ? key : putKey, value);
        }
        boolean haveCallback = false;
        for (CBK item : CBK.values()) {
            if (this.callbacks.get((Object)item) == null) continue;
            haveCallback = true;
            break;
        }
        if ((haveCallback || this.statusForm != null || this.statusText != null) && !this.mayScript) {
            Logger.warn("MAYSCRIPT missing -- all applet JavaScript calls disabled");
        }
        this.statusForm = this.getValue("StatusForm", null);
        this.statusText = this.getValue("StatusText", null);
        this.statusTextarea = this.getValue("StatusTextarea", null);
        if (this.statusForm != null && this.statusText != null) {
            Logger.info("applet text status will be reported to document." + this.statusForm + "." + this.statusText);
        }
        if (this.statusForm != null && this.statusTextarea != null) {
            Logger.info("applet textarea status will be reported to document." + this.statusForm + "." + this.statusTextarea);
        }
    }

    private static synchronized void cleanRegistry() {
        Applet app = null;
        boolean closed = true;
        for (Map.Entry entry : htRegistry.entrySet()) {
            String theApplet = (String)entry.getKey();
            try {
                app = (Applet)entry.getValue();
                JSObject theWindow = JSObject.getWindow((Applet)app);
                closed = (Boolean)theWindow.getMember("closed");
                if (closed || theWindow.hashCode() == 0) {
                    // empty if block
                }
                if (Logger.debugging) {
                    Logger.debug("Preserving registered applet " + theApplet + " window: " + theWindow.hashCode());
                }
            }
            catch (Exception e) {
                closed = true;
            }
            if (!closed) continue;
            if (Logger.debugging) {
                Logger.debug("Dereferencing closed window applet " + theApplet);
            }
            htRegistry.remove(theApplet);
            app.destroy();
        }
    }

    @Override
    protected String getJmolParameter(String paramName) {
        return this.applet.getParameter(paramName);
    }

    @Override
    protected void doSendJsTextStatus(String message) {
        if (!this.haveDocumentAccess || this.statusForm == null || this.statusText == null) {
            return;
        }
        try {
            JSObject jsoWindow = JSObject.getWindow((Applet)this.applet);
            JSObject jsoDocument = (JSObject)jsoWindow.getMember("document");
            JSObject jsoForm = (JSObject)jsoDocument.getMember(this.statusForm);
            if (this.statusText != null) {
                JSObject jsoText = (JSObject)jsoForm.getMember(this.statusText);
                jsoText.setMember("value", message);
            }
        }
        catch (Exception e) {
            Logger.error("error indicating status at document." + this.statusForm + "." + this.statusText + ":" + e.toString());
        }
    }

    @Override
    protected void doSendJsTextareaStatus(String message) {
        if (!this.haveDocumentAccess || this.statusForm == null || this.statusTextarea == null) {
            return;
        }
        try {
            JSObject jsoWindow = JSObject.getWindow((Applet)this.applet);
            JSObject jsoDocument = (JSObject)jsoWindow.getMember("document");
            JSObject jsoForm = (JSObject)jsoDocument.getMember(this.statusForm);
            if (this.statusTextarea != null) {
                JSObject jsoTextarea = (JSObject)jsoForm.getMember(this.statusTextarea);
                if (message == null) {
                    jsoTextarea.setMember("value", "");
                } else {
                    String info = (String)jsoTextarea.getMember("value");
                    jsoTextarea.setMember("value", info + "\n" + message);
                }
            }
        }
        catch (Exception e) {
            Logger.error("error indicating status at document." + this.statusForm + "." + this.statusTextarea + ":" + e.toString());
        }
    }

    private void update(Graphics g, String source) {
        if (this.viewer == null) {
            return;
        }
        if (this.isUpdating) {
            return;
        }
        this.isUpdating = true;
        if (this.showPaintTime) {
            this.startPaintClock();
        }
        Dimension size = new Dimension();
        this.applet.getSize(size);
        this.viewer.setScreenDimension(size.width, size.height);
        if (!this.isStereoSlave) {
            this.viewer.renderScreenImageStereo(g, true, size.width, size.height);
        }
        if (this.showPaintTime) {
            this.stopPaintClock();
            this.showTimes(10, 10, g);
        }
        this.isUpdating = false;
    }

    private void startPaintClock() {
        this.timeBegin = System.currentTimeMillis();
        int motionEventNumber = this.viewer.getMotionEventNumber();
        if (this.lastMotionEventNumber != motionEventNumber) {
            this.lastMotionEventNumber = motionEventNumber;
            this.timeTotal = 0;
            this.timeCount = 0;
            this.timeLast = -1;
        }
    }

    private void stopPaintClock() {
        int time = (int)(System.currentTimeMillis() - this.timeBegin);
        if (this.timeLast != -1) {
            this.timeTotal += this.timeLast;
            ++this.timeCount;
        }
        this.timeLast = time;
    }

    private String fmt(int num) {
        if (num < 0) {
            return "---";
        }
        if (num < 10) {
            return "  " + num;
        }
        if (num < 100) {
            return " " + num;
        }
        return "" + num;
    }

    private void showTimes(int x, int y, Graphics g) {
        int timeAverage = this.timeCount == 0 ? -1 : (this.timeTotal + this.timeCount / 2) / this.timeCount;
        g.setColor(Color.green);
        g.drawString(this.fmt(this.timeLast) + "ms : " + this.fmt(timeAverage) + "ms", x, y);
    }

    @Override
    public int[] resizeInnerPanel(String data) {
        return null;
    }

    @Override
    protected String doSendCallback(String callback, Object[] data, String strInfo) {
        if (callback == null) {
            this.getJsObjectInfo(data);
            return null;
        }
        JSObject jso = JSObject.getWindow((Applet)this.applet);
        if (callback.equals("alert")) {
            jso.call(callback, strInfo);
            return "";
        }
        if (callback.length() == 0) {
            return "";
        }
        if (callback.indexOf(".") > 0) {
            String[] mods = PT.split(callback, ".");
            for (int i = 0; i < mods.length - 1; ++i) {
                jso = (JSObject)jso.getMember(mods[i]);
            }
            callback = mods[mods.length - 1];
        }
        return "" + jso.call(callback, data);
    }

    private void getJsObjectInfo(Object[] data) {
        data[0] = null;
        try {
            String method = (String)data[1];
            Object[] jsObject = (Object[])data[2];
            Object[] args = (Object[])data[3];
            JSObject DOMNode = (JSObject)jsObject[0];
            if (method == null) {
                String namespaceURI = (String)DOMNode.getMember("namespaceURI");
                String localName = (String)DOMNode.getMember("localName");
                data[0] = "namespaceURI=\"" + namespaceURI + "\" localName=\"" + localName + "\"";
            } else {
                data[0] = args == null ? DOMNode.getMember(method) : DOMNode.call(method, args);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    protected String doEval(String strEval) {
        Object jsoWindow = null;
        if (this.allowJSEval == null) {
            try {
                this.jsoDocument = (JSObject)JSObject.getWindow((Applet)this.applet).getMember("document");
                try {
                    if (((Boolean)this.jsoDocument.eval("!!Jmol._noEval")).booleanValue()) {
                        this.allowJSEval = Boolean.FALSE;
                    }
                }
                catch (Exception e) {
                    try {
                        if (((Boolean)this.jsoDocument.eval("!!_jmol.noEval")).booleanValue()) {
                            this.allowJSEval = Boolean.FALSE;
                        }
                    }
                    catch (Exception e2) {
                        this.allowJSEval = Boolean.FALSE;
                        Logger.error("# no Jmol or _jmol object in evaluating " + strEval + ":" + e.toString());
                    }
                }
            }
            catch (Exception e) {
                if (Logger.debugging) {
                    Logger.debug(" error setting jsoWindow or jsoDocument:" + jsoWindow + ", " + this.jsoDocument);
                }
                this.allowJSEval = Boolean.FALSE;
            }
        }
        if (this.allowJSEval == Boolean.FALSE) {
            this.jsoDocument = null;
            return "NO EVAL ALLOWED";
        }
        try {
            return "" + this.jsoDocument.eval(strEval);
        }
        catch (Exception e) {
            Logger.error("# error evaluating " + strEval + ":" + e.toString());
            return "";
        }
    }

    @Override
    public float[][] doFunctionXY(String functionName, int nX, int nY) {
        float[][] fxy = new float[Math.abs(nX)][Math.abs(nY)];
        if (!this.mayScript || nX == 0 || nY == 0) {
            return fxy;
        }
        try {
            JSObject jsoWindow = JSObject.getWindow((Applet)this.applet);
            if (nX > 0 && nY > 0) {
                for (int i = 0; i < nX; ++i) {
                    for (int j = 0; j < nY; ++j) {
                        fxy[i][j] = ((Double)jsoWindow.call(functionName, this.htmlName, i, j)).floatValue();
                    }
                }
            } else if (nY > 0) {
                String data = (String)jsoWindow.call(functionName, this.htmlName, nX, nY);
                nX = Math.abs(nX);
                float[] fdata = new float[nX * nY];
                Parser.parseStringInfestedFloatArray(data, null, fdata);
                int ipt = 0;
                for (int i = 0; i < nX; ++i) {
                    int j = 0;
                    while (j < nY) {
                        fxy[i][j] = fdata[ipt];
                        ++j;
                        ++ipt;
                    }
                }
            } else {
                jsoWindow.call(functionName, new Object[]{this.htmlName, nX, nY, fxy});
            }
        }
        catch (Exception e) {
            Logger.error("Exception " + e.getMessage() + " with nX, nY: " + nX + " " + nY);
        }
        return fxy;
    }

    @Override
    public float[][][] doFunctionXYZ(String functionName, int nX, int nY, int nZ) {
        float[][][] fxyz = new float[Math.abs(nX)][Math.abs(nY)][Math.abs(nZ)];
        if (!this.mayScript || nX == 0 || nY == 0 || nZ == 0) {
            return fxyz;
        }
        try {
            JSObject jsoWindow = JSObject.getWindow((Applet)this.applet);
            jsoWindow.call(functionName, new Object[]{this.htmlName, nX, nY, nZ, fxyz});
        }
        catch (Exception e) {
            Logger.error("Exception " + e.getMessage() + " for " + functionName + " with nX, nY, nZ: " + nX + " " + nY + " " + nZ);
        }
        return fxyz;
    }

    @Override
    protected void doShowDocument(URL url) {
        this.applet.getAppletContext().showDocument(url, "_blank");
    }

    @Override
    protected void doShowStatus(String message) {
        try {
            System.out.println(message);
            this.applet.showStatus(PT.rep(PT.split(message, "\n")[0], "'", "\\'"));
            this.doSendJsTextStatus(message);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

