/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.contracts.interpretation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.contracts.description.BooleanExpression;
import org.jetbrains.kotlin.contracts.description.ConditionalEffectDeclaration;
import org.jetbrains.kotlin.contracts.description.ContractDescription;
import org.jetbrains.kotlin.contracts.description.ContractProviderKey;
import org.jetbrains.kotlin.contracts.description.EffectDeclaration;
import org.jetbrains.kotlin.contracts.description.LazyContractProvider;
import org.jetbrains.kotlin.contracts.description.expressions.ConstantReference;
import org.jetbrains.kotlin.contracts.description.expressions.VariableReference;
import org.jetbrains.kotlin.contracts.interpretation.CallsEffectInterpreter;
import org.jetbrains.kotlin.contracts.interpretation.ConditionInterpreter;
import org.jetbrains.kotlin.contracts.interpretation.ConditionalEffectInterpreter;
import org.jetbrains.kotlin.contracts.interpretation.ConstantValuesInterpreter;
import org.jetbrains.kotlin.contracts.interpretation.EffectDeclarationInterpreter;
import org.jetbrains.kotlin.contracts.interpretation.ReturnsEffectInterpreter;
import org.jetbrains.kotlin.contracts.model.ConditionalEffect;
import org.jetbrains.kotlin.contracts.model.ESEffect;
import org.jetbrains.kotlin.contracts.model.ESExpression;
import org.jetbrains.kotlin.contracts.model.Functor;
import org.jetbrains.kotlin.contracts.model.functors.SubstitutingFunctor;
import org.jetbrains.kotlin.contracts.model.structure.ESConstant;
import org.jetbrains.kotlin.contracts.model.structure.ESVariable;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0017\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0000\u00a2\u0006\u0002\b\u0014J\u0017\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0000\u00a2\u0006\u0002\b\u0019J\u0017\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0000\u00a2\u0006\u0002\b\u001eJ\u0017\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010!\u001a\u00020\"H\u0000\u00a2\u0006\u0002\b#J\u0010\u0010$\u001a\u0004\u0018\u00010\r2\u0006\u0010%\u001a\u00020&R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lorg/jetbrains/kotlin/contracts/interpretation/ContractInterpretationDispatcher;", "", "()V", "conditionInterpreter", "Lorg/jetbrains/kotlin/contracts/interpretation/ConditionInterpreter;", "conditionalEffectInterpreter", "Lorg/jetbrains/kotlin/contracts/interpretation/ConditionalEffectInterpreter;", "constantsInterpreter", "Lorg/jetbrains/kotlin/contracts/interpretation/ConstantValuesInterpreter;", "effectsInterpreters", "", "Lorg/jetbrains/kotlin/contracts/interpretation/EffectDeclarationInterpreter;", "convertContractDescriptorToFunctor", "Lorg/jetbrains/kotlin/contracts/model/Functor;", "contractDescription", "Lorg/jetbrains/kotlin/contracts/description/ContractDescription;", "interpretCondition", "Lorg/jetbrains/kotlin/contracts/model/ESExpression;", "booleanExpression", "Lorg/jetbrains/kotlin/contracts/description/BooleanExpression;", "interpretCondition$resolution", "interpretConstant", "Lorg/jetbrains/kotlin/contracts/model/structure/ESConstant;", "constantReference", "Lorg/jetbrains/kotlin/contracts/description/expressions/ConstantReference;", "interpretConstant$resolution", "interpretEffect", "Lorg/jetbrains/kotlin/contracts/model/ESEffect;", "effectDeclaration", "Lorg/jetbrains/kotlin/contracts/description/EffectDeclaration;", "interpretEffect$resolution", "interpretVariable", "Lorg/jetbrains/kotlin/contracts/model/structure/ESVariable;", "variableReference", "Lorg/jetbrains/kotlin/contracts/description/expressions/VariableReference;", "interpretVariable$resolution", "resolveFunctor", "functionDescriptor", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "resolution"})
public final class ContractInterpretationDispatcher {
    private final ConstantValuesInterpreter constantsInterpreter = new ConstantValuesInterpreter();
    private final ConditionInterpreter conditionInterpreter = new ConditionInterpreter(this);
    private final ConditionalEffectInterpreter conditionalEffectInterpreter = new ConditionalEffectInterpreter(this);
    private final List<EffectDeclarationInterpreter> effectsInterpreters = CollectionsKt.listOf(new EffectDeclarationInterpreter[]{new ReturnsEffectInterpreter(this), new CallsEffectInterpreter(this)});

    @Nullable
    public final Functor resolveFunctor(@NotNull FunctionDescriptor functionDescriptor) {
        Intrinsics.checkParameterIsNotNull(functionDescriptor, "functionDescriptor");
        Object object = (LazyContractProvider)functionDescriptor.getUserData(ContractProviderKey.INSTANCE);
        if (object == null || (object = ((LazyContractProvider)object).getContractDescription()) == null) {
            return null;
        }
        Object contractDescriptor = object;
        return this.convertContractDescriptorToFunctor((ContractDescription)contractDescriptor);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final Functor convertContractDescriptorToFunctor(ContractDescription contractDescription) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Iterable iterable = $receiver$iv = (Iterable)contractDescription.getEffects();
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            ESEffect eSEffect;
            void effect;
            EffectDeclaration effectDeclaration = (EffectDeclaration)item$iv$iv;
            Collection collection = destination$iv$iv;
            if (effect instanceof ConditionalEffectDeclaration) {
                ConditionalEffect conditionalEffect = this.conditionalEffectInterpreter.interpret((ConditionalEffectDeclaration)effect);
                if (conditionalEffect == null) return null;
                eSEffect = conditionalEffect;
            } else {
                void $receiver$iv$iv2;
                Iterable $receiver$iv2;
                Iterable iterable2 = $receiver$iv2 = (Iterable)this.effectsInterpreters;
                Collection destination$iv$iv2 = new ArrayList();
                void $receiver$iv$iv$iv = $receiver$iv$iv2;
                for (Object element$iv$iv$iv : $receiver$iv$iv$iv) {
                    ESEffect eSEffect2;
                    Object element$iv$iv = element$iv$iv$iv;
                    EffectDeclarationInterpreter it = (EffectDeclarationInterpreter)element$iv$iv;
                    if (it.tryInterpret((EffectDeclaration)effect) == null) continue;
                    ESEffect it$iv$iv = eSEffect2;
                    destination$iv$iv2.add(it$iv$iv);
                }
                eSEffect = (ESEffect)CollectionsKt.singleOrNull((List)destination$iv$iv2);
                if (eSEffect == null) {
                    return null;
                }
            }
            ESEffect eSEffect3 = eSEffect;
            collection.add(eSEffect3);
        }
        List resultingClauses = (List)destination$iv$iv;
        return new SubstitutingFunctor(resultingClauses, contractDescription.getOwnerFunction());
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final ESEffect interpretEffect$resolution(@NotNull EffectDeclaration effectDeclaration) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull(effectDeclaration, "effectDeclaration");
        Iterable iterable = $receiver$iv = (Iterable)this.effectsInterpreters;
        Collection destination$iv$iv = new ArrayList();
        void $receiver$iv$iv$iv = $receiver$iv$iv;
        for (Object element$iv$iv$iv : $receiver$iv$iv$iv) {
            ESEffect eSEffect;
            Object element$iv$iv = element$iv$iv$iv;
            EffectDeclarationInterpreter it = (EffectDeclarationInterpreter)element$iv$iv;
            if (it.tryInterpret(effectDeclaration) == null) continue;
            ESEffect it$iv$iv = eSEffect;
            destination$iv$iv.add(it$iv$iv);
        }
        List convertedFunctors = (List)destination$iv$iv;
        return (ESEffect)CollectionsKt.singleOrNull(convertedFunctors);
    }

    @Nullable
    public final ESConstant interpretConstant$resolution(@NotNull ConstantReference constantReference) {
        Intrinsics.checkParameterIsNotNull(constantReference, "constantReference");
        return this.constantsInterpreter.interpretConstant(constantReference);
    }

    @Nullable
    public final ESExpression interpretCondition$resolution(@NotNull BooleanExpression booleanExpression) {
        Intrinsics.checkParameterIsNotNull(booleanExpression, "booleanExpression");
        return (ESExpression)booleanExpression.accept(this.conditionInterpreter, Unit.INSTANCE);
    }

    @Nullable
    public final ESVariable interpretVariable$resolution(@NotNull VariableReference variableReference) {
        Intrinsics.checkParameterIsNotNull(variableReference, "variableReference");
        return new ESVariable(variableReference.getDescriptor());
    }
}

