/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.cmdline.doccat;

import java.io.File;
import java.io.IOException;
import opennlp.tools.cmdline.BasicCmdLineTool;
import opennlp.tools.cmdline.CmdLineUtil;
import opennlp.tools.cmdline.PerformanceMonitor;
import opennlp.tools.cmdline.SystemInputStreamFactory;
import opennlp.tools.cmdline.doccat.DoccatModelLoader;
import opennlp.tools.doccat.DoccatModel;
import opennlp.tools.doccat.DocumentCategorizerME;
import opennlp.tools.doccat.DocumentSample;
import opennlp.tools.util.InputStreamFactory;
import opennlp.tools.util.ParagraphStream;
import opennlp.tools.util.PlainTextByLineStream;

public class DoccatTool
extends BasicCmdLineTool {
    @Override
    public String getShortDescription() {
        return "learnable document categorizer";
    }

    @Override
    public String getHelp() {
        return "Usage: opennlp " + this.getName() + " model < documents";
    }

    @Override
    public void run(String[] args) {
        if (0 == args.length) {
            System.out.println(this.getHelp());
        } else {
            DoccatModel model = (DoccatModel)new DoccatModelLoader().load(new File(args[0]));
            DocumentCategorizerME doccat = new DocumentCategorizerME(model);
            PerformanceMonitor perfMon = new PerformanceMonitor(System.err, "doc");
            perfMon.start();
            try {
                String document;
                ParagraphStream documentStream = new ParagraphStream(new PlainTextByLineStream((InputStreamFactory)new SystemInputStreamFactory(), SystemInputStreamFactory.encoding()));
                while ((document = (String)documentStream.read()) != null) {
                    String[] tokens = model.getFactory().getTokenizer().tokenize(document);
                    double[] prob = doccat.categorize(tokens);
                    String category = doccat.getBestCategory(prob);
                    DocumentSample sample = new DocumentSample(category, tokens);
                    System.out.println(sample.toString());
                    perfMon.incrementCounter();
                }
            }
            catch (IOException e) {
                CmdLineUtil.handleStdinIoError(e);
            }
            perfMon.stopAndPrintFinalResult();
        }
    }
}

