/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.smarter;

import java.util.Hashtable;
import java.util.Map;
import javajs.util.BS;
import javajs.util.Lst;
import javajs.util.M3;
import javajs.util.M4;
import javajs.util.P3;
import javajs.util.P3i;
import javajs.util.PT;
import javajs.util.SB;
import javajs.util.T3;
import javajs.util.V3;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollection;
import org.jmol.adapter.smarter.AtomSetCollectionReader;
import org.jmol.adapter.smarter.Bond;
import org.jmol.adapter.smarter.MSInterface;
import org.jmol.api.JmolModulationSet;
import org.jmol.api.SymmetryInterface;
import org.jmol.symmetry.Symmetry;
import org.jmol.symmetry.SymmetryOperation;
import org.jmol.util.BSUtil;
import org.jmol.util.SimpleUnitCell;
import org.jmol.util.Tensor;
import org.jmol.util.Vibration;

public class XtalSymmetry {
    private AtomSetCollection asc;
    private AtomSetCollectionReader acr;
    public SymmetryInterface symmetry;
    private float[] unitCellParams = new float[6];
    private float[] baseUnitCell;
    private float symmetryRange;
    private boolean doCentroidUnitCell;
    private boolean centroidPacked;
    private float packingError;
    private String filterSymop;
    private boolean applySymmetryToBonds = false;
    private int[] latticeCells;
    private Lst<float[]> trajectoryUnitCells;
    private boolean doNormalize = true;
    private boolean doPackUnitCell = false;
    private SymmetryInterface baseSymmetry;
    private SymmetryInterface sym2;
    private float rminx;
    private float rminy;
    private float rminz;
    private float rmaxx;
    private float rmaxy;
    private float rmaxz;
    private final P3 ptOffset = new P3();
    private P3i minXYZ;
    private P3i maxXYZ;
    private P3 minXYZ0;
    private P3 maxXYZ0;
    private boolean checkAll;
    private int bondCount0;
    private int dtype = 3;
    private V3[] unitCellTranslations;
    private int latticeOp;
    private boolean latticeOnly;
    private int noSymmetryCount;
    private int firstAtom;
    private static final int PARTICLE_NONE = 0;
    private static final int PARTICLE_CHAIN = 1;
    private static final int PARTICLE_SYMOP = 2;
    private P3 ptTemp;
    private M3 mTemp;
    private int nVib;

    public XtalSymmetry set(AtomSetCollectionReader reader) {
        this.acr = reader;
        this.asc = reader.asc;
        this.getSymmetry();
        return this;
    }

    SymmetryInterface getSymmetry() {
        return this.symmetry == null ? (this.symmetry = (Symmetry)this.acr.getInterface("org.jmol.symmetry.Symmetry")) : this.symmetry;
    }

    SymmetryInterface setSymmetry(SymmetryInterface symmetry) {
        this.symmetry = symmetry;
        return this.symmetry;
    }

    private void setSymmetryRange(float factor) {
        this.symmetryRange = factor;
        this.asc.setInfo("symmetryRange", Float.valueOf(factor));
    }

    private void setLatticeCells() {
        this.latticeCells = this.acr.latticeCells;
        boolean isLatticeRange = this.latticeCells[0] <= 555 && this.latticeCells[1] >= 555 && (this.latticeCells[2] == 0 || this.latticeCells[2] == 1 || this.latticeCells[2] == -1);
        this.doNormalize = this.latticeCells[0] != 0 && (!isLatticeRange || this.latticeCells[2] == 1);
        this.applySymmetryToBonds = this.acr.applySymmetryToBonds;
        this.doPackUnitCell = this.acr.doPackUnitCell;
        this.doCentroidUnitCell = this.acr.doCentroidUnitCell;
        this.centroidPacked = this.acr.centroidPacked;
        this.filterSymop = this.acr.filterSymop;
    }

    private void setUnitCell(float[] info, M3 matUnitCellOrientation, P3 unitCellOffset) {
        this.unitCellParams = new float[info.length];
        for (int i = 0; i < info.length; ++i) {
            this.unitCellParams[i] = info[i];
        }
        this.asc.haveUnitCell = true;
        this.asc.setCurrentModelInfo("unitCellParams", this.unitCellParams);
        if (this.asc.isTrajectory) {
            if (this.trajectoryUnitCells == null) {
                this.trajectoryUnitCells = new Lst();
                this.asc.setInfo("unitCells", this.trajectoryUnitCells);
            }
            this.trajectoryUnitCells.addLast(this.unitCellParams);
        }
        this.asc.setGlobalBoolean(2);
        this.getSymmetry().setUnitCell(this.unitCellParams, false);
        if (unitCellOffset != null) {
            this.symmetry.setOffsetPt(unitCellOffset);
            this.asc.setCurrentModelInfo("unitCellOffset", unitCellOffset);
        }
        if (matUnitCellOrientation != null) {
            this.symmetry.initializeOrientation(matUnitCellOrientation);
            this.asc.setCurrentModelInfo("matUnitCellOrientation", matUnitCellOrientation);
        }
    }

    int addSpaceGroupOperation(String xyz, boolean andSetLattice) {
        if (andSetLattice) {
            this.setLatticeCells();
        }
        this.symmetry.setSpaceGroup(this.doNormalize);
        return this.symmetry.addSpaceGroupOperation(xyz, 0);
    }

    public void setLatticeParameter(int latt) {
        this.symmetry.setSpaceGroup(this.doNormalize);
        this.symmetry.setLattice(latt);
    }

    SymmetryInterface applySymmetryFromReader(SymmetryInterface readerSymmetry) throws Exception {
        this.asc.setCoordinatesAreFractional(this.acr.iHaveFractionalCoordinates);
        this.setUnitCell(this.acr.unitCellParams, this.acr.matUnitCellOrientation, this.acr.unitCellOffset);
        this.setAtomSetSpaceGroupName(this.acr.sgName);
        this.setSymmetryRange(this.acr.symmetryRange);
        if (this.acr.doConvertToFractional || this.acr.fileCoordinatesAreFractional) {
            this.setLatticeCells();
            boolean doApplySymmetry = true;
            if (this.acr.ignoreFileSpaceGroupName || !this.acr.iHaveSymmetryOperators) {
                if (!this.acr.merging || readerSymmetry == null) {
                    readerSymmetry = this.acr.getNewSymmetry();
                }
                doApplySymmetry = readerSymmetry.createSpaceGroup(this.acr.desiredSpaceGroupIndex, this.acr.sgName.indexOf("!") >= 0 ? "P1" : this.acr.sgName, this.acr.unitCellParams, this.acr.modDim);
            } else {
                this.acr.doPreSymmetry();
                readerSymmetry = null;
            }
            this.packingError = this.acr.packingError;
            if (doApplySymmetry) {
                if (readerSymmetry != null) {
                    this.setSpaceGroupFrom(readerSymmetry);
                }
                this.applySymmetryLattice();
                if (readerSymmetry != null && this.filterSymop == null) {
                    this.setAtomSetSpaceGroupName(readerSymmetry.getSpaceGroupName());
                }
            }
        }
        if (this.acr.iHaveFractionalCoordinates && this.acr.merging && readerSymmetry != null) {
            Atom[] atoms = this.asc.atoms;
            int n = this.asc.ac;
            for (int i = this.asc.getLastAtomSetAtomIndex(); i < n; ++i) {
                readerSymmetry.toCartesian(atoms[i], true);
            }
            this.asc.setCoordinatesAreFractional(false);
            this.acr.addVibrations = false;
        }
        return this.symmetry;
    }

    public void setSpaceGroupFrom(SymmetryInterface readerSymmetry) {
        this.getSymmetry().setSpaceGroupFrom(readerSymmetry);
    }

    private void setAtomSetSpaceGroupName(String spaceGroupName) {
        this.symmetry.setSpaceGroupName(spaceGroupName);
        this.asc.setCurrentModelInfo("spaceGroup", spaceGroupName + "");
    }

    private void applySymmetryLattice() throws Exception {
        Atom[] atoms;
        boolean isSuper;
        if (!this.asc.coordinatesAreFractional || this.symmetry.getSpaceGroup() == null) {
            return;
        }
        this.sym2 = null;
        int maxX = this.latticeCells[0];
        int maxY = this.latticeCells[1];
        int maxZ = Math.abs(this.latticeCells[2]);
        int kcode = this.latticeCells[3];
        int dim = (int)this.symmetry.getUnitCellInfoType(6);
        this.firstAtom = this.asc.getLastAtomSetAtomIndex();
        BS bsAtoms = this.asc.bsAtoms;
        if (bsAtoms != null) {
            this.firstAtom = bsAtoms.nextSetBit(this.firstAtom);
        }
        this.rminz = Float.MAX_VALUE;
        this.rminy = Float.MAX_VALUE;
        this.rminx = Float.MAX_VALUE;
        this.rmaxz = -3.4028235E38f;
        this.rmaxy = -3.4028235E38f;
        this.rmaxx = -3.4028235E38f;
        P3 pt0 = null;
        if (this.acr.latticeType == null) {
            this.acr.latticeType = this.symmetry.getLatticeType();
        }
        if (this.acr.isPrimitive) {
            this.asc.setCurrentModelInfo("isprimitive", Boolean.TRUE);
            if (!"P".equals(this.acr.latticeType)) {
                this.asc.setCurrentModelInfo("unitcell_conventional", this.symmetry.getConventionalUnitCell(this.acr.latticeType));
            }
        }
        if (this.acr.latticeType != null) {
            this.asc.setCurrentModelInfo("latticeType", this.acr.latticeType);
        }
        if (this.acr.fillRange instanceof String && this.acr.latticeType != null) {
            String type = (String)this.acr.fillRange;
            if (type.equals("conventional")) {
                this.acr.fillRange = this.symmetry.getConventionalUnitCell(this.acr.latticeType);
            } else if (type.equals("primitive")) {
                this.acr.fillRange = this.symmetry.getUnitCellVectors();
                this.symmetry.toFromPrimitive(true, this.acr.latticeType.charAt(0), (T3[])this.acr.fillRange);
            } else {
                this.acr.fillRange = null;
            }
            if (this.acr.fillRange != null) {
                this.acr.addJmolScript("unitcell " + type);
            }
        }
        if (this.acr.fillRange != null) {
            if (bsAtoms == null) {
                this.asc.bsAtoms = bsAtoms = new BS();
            }
            this.acr.forcePacked = true;
            bsAtoms.setBits(this.firstAtom, this.asc.ac);
            this.doPackUnitCell = false;
            this.minXYZ = new P3i();
            this.maxXYZ = P3i.new3(1, 1, 1);
            T3[] oabc = new P3[4];
            for (int i = 0; i < 4; ++i) {
                oabc[i] = P3.newP(((T3[])this.acr.fillRange)[i]);
            }
            this.adjustRangeMinMax(oabc);
            if (this.sym2 == null) {
                this.sym2 = new Symmetry();
                this.sym2.getUnitCell((T3[])this.acr.fillRange, false, null);
            }
            this.applyAllSymmetry(this.acr.ms, bsAtoms);
            pt0 = new P3();
            Atom[] atoms2 = this.asc.atoms;
            int i = this.asc.ac;
            while (--i >= this.firstAtom) {
                pt0.setT(atoms2[i]);
                this.symmetry.toCartesian(pt0, false);
                this.sym2.toFractional(pt0, false);
                if (this.acr.fixJavaFloat) {
                    PT.fixPtFloats(pt0, 100000.0f);
                }
                if (this.isWithinCell(this.dtype, pt0, 0.0f, 1.0f, 0.0f, 1.0f, 0.0f, 1.0f, this.packingError)) continue;
                bsAtoms.clear(i);
            }
            return;
        }
        P3 offset = null;
        this.nVib = 0;
        P3 va = null;
        P3 vb = null;
        P3 vc = null;
        this.baseSymmetry = this.symmetry;
        String supercell = this.acr.strSupercell;
        T3[] oabc = null;
        boolean bl = isSuper = supercell != null && supercell.indexOf(",") >= 0;
        if (isSuper && (oabc = this.symmetry.getV0abc(supercell)) != null) {
            this.minXYZ = new P3i();
            this.maxXYZ = P3i.new3(maxX, maxY, maxZ);
            SimpleUnitCell.setMinMaxLatticeParameters(dim, this.minXYZ, this.maxXYZ, kcode);
            pt0 = P3.newP(oabc[0]);
            va = P3.newP(oabc[1]);
            vb = P3.newP(oabc[2]);
            vc = P3.newP(oabc[3]);
            this.adjustRangeMinMax(oabc);
        }
        int iAtomFirst = this.asc.getLastAtomSetAtomIndex();
        if (bsAtoms != null) {
            iAtomFirst = bsAtoms.nextSetBit(iAtomFirst);
        }
        if (this.rminx == Float.MAX_VALUE) {
            supercell = null;
            oabc = null;
        } else {
            int i;
            boolean doPack0;
            this.doPackUnitCell = doPack0 = this.doPackUnitCell;
            if (this.asc.bsAtoms == null) {
                this.asc.bsAtoms = BSUtil.newBitSet2(0, this.asc.ac);
            }
            bsAtoms = this.asc.bsAtoms;
            this.applyAllSymmetry(this.acr.ms, null);
            this.doPackUnitCell = doPack0;
            atoms = this.asc.atoms;
            int atomCount = this.asc.ac;
            for (i = iAtomFirst; i < atomCount; ++i) {
                this.symmetry.toCartesian(atoms[i], true);
                bsAtoms.set(i);
            }
            this.symmetry = null;
            this.symmetry = this.getSymmetry();
            this.setUnitCell(new float[]{0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, va.x, va.y, va.z, vb.x, vb.y, vb.z, vc.x, vc.y, vc.z}, null, offset);
            this.setAtomSetSpaceGroupName(oabc == null || supercell == null ? "P1" : "cell=" + supercell);
            this.symmetry.setSpaceGroup(this.doNormalize);
            this.symmetry.addSpaceGroupOperation("x,y,z", 0);
            if (pt0 != null) {
                this.symmetry.toFractional(pt0, true);
            }
            for (i = iAtomFirst; i < atomCount; ++i) {
                this.symmetry.toFractional(atoms[i], true);
                if (pt0 == null) continue;
                atoms[i].sub(pt0);
            }
            this.asc.haveAnisou = false;
            this.asc.setCurrentModelInfo("matUnitCellOrientation", null);
        }
        this.minXYZ = new P3i();
        this.maxXYZ = P3i.new3(maxX, maxY, maxZ);
        SimpleUnitCell.setMinMaxLatticeParameters(dim, this.minXYZ, this.maxXYZ, kcode);
        if (oabc == null) {
            this.applyAllSymmetry(this.acr.ms, bsAtoms);
            return;
        }
        if (this.acr.forcePacked || this.doPackUnitCell) {
            BS bs = this.asc.bsAtoms;
            atoms = this.asc.atoms;
            if (bs == null) {
                bs = this.asc.bsAtoms = BSUtil.newBitSet2(0, this.asc.ac);
            }
            int i = bs.nextSetBit(iAtomFirst);
            while (i >= 0) {
                if (!this.isWithinCell(this.dtype, atoms[i], this.minXYZ.x, this.maxXYZ.x, this.minXYZ.y, this.maxXYZ.y, this.minXYZ.z, this.maxXYZ.z, this.packingError)) {
                    bs.clear(i);
                }
                i = bs.nextSetBit(i + 1);
            }
        }
    }

    private void adjustRangeMinMax(T3[] oabc) {
        P3 pa = new P3();
        P3 pb = new P3();
        P3 pc = new P3();
        if (this.acr.forcePacked) {
            pa.setT(oabc[1]);
            pb.setT(oabc[2]);
            pc.setT(oabc[3]);
            pa.scale(this.packingError);
            pb.scale(this.packingError);
            pc.scale(this.packingError);
        }
        oabc[0].scaleAdd2(this.minXYZ.x, oabc[1], oabc[0]);
        oabc[0].scaleAdd2(this.minXYZ.y, oabc[2], oabc[0]);
        oabc[0].scaleAdd2(this.minXYZ.z, oabc[3], oabc[0]);
        oabc[0].sub(pa);
        oabc[0].sub(pb);
        oabc[0].sub(pc);
        P3 pt = P3.newP(oabc[0]);
        this.symmetry.toFractional(pt, true);
        this.setSymmetryMinMax(pt);
        oabc[1].scale(this.maxXYZ.x - this.minXYZ.x);
        oabc[2].scale(this.maxXYZ.y - this.minXYZ.y);
        oabc[3].scale(this.maxXYZ.z - this.minXYZ.z);
        oabc[1].scaleAdd2(2.0f, pa, oabc[1]);
        oabc[2].scaleAdd2(2.0f, pb, oabc[2]);
        oabc[3].scaleAdd2(2.0f, pc, oabc[3]);
        for (int i = 0; i < 3; ++i) {
            for (int j = i + 1; j < 4; ++j) {
                pt.add2(oabc[i], oabc[j]);
                if (i != 0) {
                    pt.add(oabc[0]);
                }
                this.symmetry.toFractional(pt, false);
                this.setSymmetryMinMax(pt);
            }
        }
        this.symmetry.toCartesian(pt, false);
        pt.add(oabc[1]);
        this.symmetry.toFractional(pt, false);
        this.setSymmetryMinMax(pt);
        this.minXYZ = P3i.new3((int)Math.min(0.0, Math.floor(this.rminx + 0.001f)), (int)Math.min(0.0, Math.floor(this.rminy + 0.001f)), (int)Math.min(0.0, Math.floor(this.rminz + 0.001f)));
        this.maxXYZ = P3i.new3((int)Math.max(1.0, Math.ceil(this.rmaxx - 0.001f)), (int)Math.max(1.0, Math.ceil(this.rmaxy - 0.001f)), (int)Math.max(1.0, Math.ceil(this.rmaxz - 0.001f)));
    }

    private void setSymmetryMinMax(P3 c) {
        if (this.rminx > c.x) {
            this.rminx = c.x;
        }
        if (this.rminy > c.y) {
            this.rminy = c.y;
        }
        if (this.rminz > c.z) {
            this.rminz = c.z;
        }
        if (this.rmaxx < c.x) {
            this.rmaxx = c.x;
        }
        if (this.rmaxy < c.y) {
            this.rmaxy = c.y;
        }
        if (this.rmaxz < c.z) {
            this.rmaxz = c.z;
        }
    }

    public boolean isWithinCell(int dtype, P3 pt, float minX, float maxX, float minY, float maxY, float minZ, float maxZ, float slop) {
        return pt.x > minX - slop && pt.x < maxX + slop && (dtype < 2 || pt.y > minY - slop && pt.y < maxY + slop) && (dtype < 3 || pt.z > minZ - slop && pt.z < maxZ + slop);
    }

    private void applyAllSymmetry(MSInterface ms, BS bsAtoms) throws Exception {
        int tz;
        int ty;
        int tx;
        SymmetryInterface thisSymmetry;
        boolean checkRange111;
        BS excludedOps;
        if (this.asc.ac == 0 || bsAtoms != null && bsAtoms.isEmpty()) {
            return;
        }
        this.noSymmetryCount = this.asc.baseSymmetryAtomCount > 0 ? this.asc.baseSymmetryAtomCount : (bsAtoms == null ? this.asc.getLastAtomSetAtomCount() : this.asc.ac - bsAtoms.nextSetBit(this.asc.getLastAtomSetAtomIndex()));
        int n = this.noSymmetryCount;
        this.asc.setTensors();
        this.bondCount0 = this.asc.bondCount;
        this.finalizeSymmetry(this.symmetry);
        int operationCount = this.symmetry.getSpaceGroupOperationCount();
        BS bS = excludedOps = this.acr.thisBiomolecule == null ? null : new BS();
        if (excludedOps != null) {
            this.asc.checkSpecial = true;
        }
        this.dtype = (int)this.symmetry.getUnitCellInfoType(6);
        SimpleUnitCell.setMinMaxLatticeParameters(this.dtype, this.minXYZ, this.maxXYZ, 0);
        this.latticeOp = this.symmetry.getLatticeOp();
        boolean bl = this.latticeOnly = this.asc.checkLatticeOnly && this.latticeOp >= 0;
        if (this.doCentroidUnitCell) {
            this.asc.setInfo("centroidMinMax", new int[]{this.minXYZ.x, this.minXYZ.y, this.minXYZ.z, this.maxXYZ.x, this.maxXYZ.y, this.maxXYZ.z, this.centroidPacked ? 1 : 0});
        }
        if (this.doCentroidUnitCell || this.doPackUnitCell || this.symmetryRange != 0.0f && this.maxXYZ.x - this.minXYZ.x == 1 && this.maxXYZ.y - this.minXYZ.y == 1 && this.maxXYZ.z - this.minXYZ.z == 1) {
            this.minXYZ0 = P3.new3(this.minXYZ.x, this.minXYZ.y, this.minXYZ.z);
            this.maxXYZ0 = P3.new3(this.maxXYZ.x, this.maxXYZ.y, this.maxXYZ.z);
            if (ms != null) {
                ms.setMinMax0(this.minXYZ0, this.maxXYZ0);
                this.minXYZ.set((int)this.minXYZ0.x, (int)this.minXYZ0.y, (int)this.minXYZ0.z);
                this.maxXYZ.set((int)this.maxXYZ0.x, (int)this.maxXYZ0.y, (int)this.maxXYZ0.z);
            }
            switch (this.dtype) {
                case 3: {
                    --this.minXYZ.z;
                    ++this.maxXYZ.z;
                }
                case 2: {
                    --this.minXYZ.y;
                    ++this.maxXYZ.y;
                }
                case 1: {
                    --this.minXYZ.x;
                    ++this.maxXYZ.x;
                }
            }
        }
        int nCells = (this.maxXYZ.x - this.minXYZ.x) * (this.maxXYZ.y - this.minXYZ.y) * (this.maxXYZ.z - this.minXYZ.z);
        int nsym = n * (this.latticeOnly ? 4 : operationCount);
        int cartesianCount = this.asc.checkSpecial || this.acr.thisBiomolecule != null ? nsym * nCells : (this.symmetryRange > 0.0f ? nsym : 1);
        P3[] cartesians = new P3[cartesianCount];
        P3[] atoms = this.asc.atoms;
        for (int i = 0; i < n; ++i) {
            atoms[this.firstAtom + i].bsSymmetry = BS.newN(operationCount * (nCells + 1));
        }
        int pt = 0;
        int[] unitCells = new int[nCells];
        this.unitCellTranslations = new V3[nCells];
        int iCell = 0;
        int cell555Count = 0;
        float absRange = Math.abs(this.symmetryRange);
        boolean checkCartesianRange = this.symmetryRange != 0.0f;
        boolean checkRangeNoSymmetry = this.symmetryRange < 0.0f;
        boolean bl2 = checkRange111 = this.symmetryRange > 0.0f;
        if (checkCartesianRange) {
            this.rminz = Float.MAX_VALUE;
            this.rminy = Float.MAX_VALUE;
            this.rminx = Float.MAX_VALUE;
            this.rmaxz = -3.4028235E38f;
            this.rmaxy = -3.4028235E38f;
            this.rmaxx = -3.4028235E38f;
        }
        SymmetryInterface lastSymmetry = thisSymmetry = this.symmetry;
        this.checkAll = this.latticeOnly || this.asc.atomSetCount == 1 && this.asc.checkSpecial && this.latticeOp >= 0;
        P3 pttemp = null;
        M4 op = thisSymmetry.getSpaceGroupOperation(0);
        if (this.doPackUnitCell) {
            pttemp = new P3();
            this.ptOffset.set(0.0f, 0.0f, 0.0f);
        }
        int[] atomMap = this.bondCount0 > this.asc.bondIndex0 && this.applySymmetryToBonds ? new int[n] : null;
        Lst<M4> lstNCS = this.acr.lstNCS;
        if (lstNCS != null && ((M4)lstNCS.get((int)0)).m33 == 0.0f) {
            int nn;
            int nOp = thisSymmetry.getSpaceGroupOperationCount();
            int i = nn = lstNCS.size();
            while (--i >= 0) {
                M4 m = (M4)lstNCS.get(i);
                m.m33 = 1.0f;
                thisSymmetry.toFractionalM(m);
            }
            for (i = 1; i < nOp; ++i) {
                M4 m1 = thisSymmetry.getSpaceGroupOperation(i);
                for (int j = 0; j < nn; ++j) {
                    M4 m = M4.newM4((M4)lstNCS.get(j));
                    m.mul2(m1, m);
                    if (this.doNormalize) {
                        SymmetryOperation.setOffset(m, atoms, this.firstAtom, this.noSymmetryCount);
                    }
                    lstNCS.addLast(m);
                }
            }
        }
        for (tx = this.minXYZ.x; tx < this.maxXYZ.x; ++tx) {
            for (ty = this.minXYZ.y; ty < this.maxXYZ.y; ++ty) {
                for (tz = this.minXYZ.z; tz < this.maxXYZ.z; ++tz) {
                    this.unitCellTranslations[iCell] = V3.new3(tx, ty, tz);
                    unitCells[iCell++] = 555 + tx * 100 + ty * 10 + tz;
                    if (tx != 0 || ty != 0 || tz != 0 || cartesians.length == 0) continue;
                    for (pt = 0; pt < n; ++pt) {
                        P3 atom = atoms[this.firstAtom + pt];
                        if (ms != null && (thisSymmetry = ms.getAtomSymmetry((Atom)atom, this.symmetry)) != lastSymmetry) {
                            if (thisSymmetry.getSpaceGroupOperationCount() == 0) {
                                lastSymmetry = thisSymmetry;
                                this.finalizeSymmetry(lastSymmetry);
                            }
                            op = thisSymmetry.getSpaceGroupOperation(0);
                        }
                        P3 c = P3.newP(atom);
                        op.rotTrans(c);
                        thisSymmetry.toCartesian(c, false);
                        if (this.doPackUnitCell) {
                            thisSymmetry.toUnitCell(c, this.ptOffset);
                            pttemp.setT(c);
                            thisSymmetry.toFractional(pttemp, false);
                            if (this.acr.fixJavaFloat) {
                                PT.fixPtFloats(pttemp, 100000.0f);
                            }
                            if (bsAtoms == null) {
                                atom.setT(pttemp);
                            } else if (atom.distance(pttemp) < 1.0E-4f) {
                                bsAtoms.set(((Atom)atom).index);
                            } else {
                                bsAtoms.clear(((Atom)atom).index);
                                continue;
                            }
                        }
                        if (bsAtoms != null) {
                            ((Atom)atom).bsSymmetry.clearAll();
                        }
                        ((Atom)atom).bsSymmetry.set(iCell * operationCount);
                        ((Atom)atom).bsSymmetry.set(0);
                        if (checkCartesianRange) {
                            this.setSymmetryMinMax(c);
                        }
                        if (pt >= cartesianCount) continue;
                        cartesians[pt] = c;
                    }
                    if (checkRangeNoSymmetry) {
                        this.rminx -= absRange;
                        this.rminy -= absRange;
                        this.rminz -= absRange;
                        this.rmaxx += absRange;
                        this.rmaxy += absRange;
                        this.rmaxz += absRange;
                    }
                    cell555Count = pt = this.symmetryAddAtoms(0, 0, 0, 0, pt, iCell * operationCount, cartesians, ms, excludedOps, atomMap);
                }
            }
        }
        if (checkRange111) {
            this.rminx -= absRange;
            this.rminy -= absRange;
            this.rminz -= absRange;
            this.rmaxx += absRange;
            this.rmaxy += absRange;
            this.rmaxz += absRange;
        }
        iCell = 0;
        for (tx = this.minXYZ.x; tx < this.maxXYZ.x; ++tx) {
            for (ty = this.minXYZ.y; ty < this.maxXYZ.y; ++ty) {
                for (tz = this.minXYZ.z; tz < this.maxXYZ.z; ++tz) {
                    ++iCell;
                    if (tx == 0 && ty == 0 && tz == 0) continue;
                    pt = this.symmetryAddAtoms(tx, ty, tz, cell555Count, pt, iCell * operationCount, cartesians, ms, excludedOps, atomMap);
                }
            }
        }
        if (iCell * n == this.asc.ac - this.firstAtom) {
            this.duplicateAtomProperties(iCell);
        }
        this.setSymmetryOps();
        this.asc.setCurrentModelInfo("presymmetryAtomIndex", this.firstAtom);
        this.asc.setCurrentModelInfo("presymmetryAtomCount", n);
        this.asc.setCurrentModelInfo("latticeDesignation", thisSymmetry.getLatticeDesignation());
        this.asc.setCurrentModelInfo("unitCellRange", unitCells);
        this.asc.setCurrentModelInfo("unitCellTranslations", this.unitCellTranslations);
        this.baseUnitCell = this.unitCellParams;
        this.unitCellParams = new float[6];
        this.reset();
    }

    private int symmetryAddAtoms(int transX, int transY, int transZ, int baseCount, int pt, int iCellOpPt, P3[] cartesians, MSInterface ms, BS excludedOps, int[] atomMap) throws Exception {
        boolean addBonds;
        boolean isBaseCell = baseCount == 0;
        boolean bl = addBonds = atomMap != null;
        if (this.doPackUnitCell) {
            this.ptOffset.set(transX, transY, transZ);
        }
        float range2 = this.symmetryRange * this.symmetryRange;
        boolean checkRangeNoSymmetry = this.symmetryRange < 0.0f;
        boolean checkRange111 = this.symmetryRange > 0.0f;
        boolean checkSymmetryMinMax = isBaseCell && checkRange111;
        checkRange111 &= !isBaseCell;
        int nOp = this.symmetry.getSpaceGroupOperationCount();
        Lst<M4> lstNCS = this.acr.lstNCS;
        int nNCS = lstNCS == null ? 0 : lstNCS.size();
        int nOperations = nOp + nNCS;
        nNCS /= nOp;
        boolean checkSpecial = nOperations == 1 && !this.doPackUnitCell ? false : this.asc.checkSpecial;
        boolean checkSymmetryRange = checkRangeNoSymmetry || checkRange111;
        boolean checkDistances = checkSpecial || checkSymmetryRange;
        boolean checkOps = excludedOps != null;
        boolean addCartesian = checkSpecial || checkSymmetryMinMax;
        BS bsAtoms = this.acr.isMolecular ? null : this.asc.bsAtoms;
        SymmetryInterface symmetry = this.symmetry;
        if (checkRangeNoSymmetry) {
            baseCount = this.noSymmetryCount;
        }
        int atomMax = this.firstAtom + this.noSymmetryCount;
        P3 ptAtom = new P3();
        String code = null;
        float d0 = checkOps ? 0.01f : 1.0E-4f;
        char subSystemId = '\u0000';
        int j00 = bsAtoms == null ? this.firstAtom : bsAtoms.nextSetBit(this.firstAtom);
        block0: for (int iSym = 0; iSym < nOperations; ++iSym) {
            if (isBaseCell && iSym == 0 || this.latticeOnly && iSym > 0 && iSym % this.latticeOp != 0 || excludedOps != null && excludedOps.get(iSym)) continue;
            int pt0 = this.firstAtom + (checkSpecial || excludedOps != null ? pt : (checkRange111 ? baseCount : 0));
            float spinOp = iSym >= nOp ? 0.0f : (this.asc.vibScale == 0 ? symmetry.getSpinOp(iSym) : (float)this.asc.vibScale);
            int i0 = Math.max(this.firstAtom, bsAtoms == null ? 0 : bsAtoms.nextSetBit(0));
            boolean checkDistance = checkDistances;
            int spt = iSym >= nOp ? (iSym - nOp) / nNCS : iSym;
            int cpt = spt + iCellOpPt;
            for (int i = i0; i < atomMax; ++i) {
                Lst<Object> tensors;
                Atom a = this.asc.atoms[i];
                if (a.ignoreSymmetry || bsAtoms != null && !bsAtoms.get(i)) continue;
                if (ms == null) {
                    symmetry.newSpaceGroupPoint(iSym, a, ptAtom, transX, transY, transZ, iSym >= nOp ? (M4)lstNCS.get(iSym - nOp) : null);
                } else {
                    symmetry = ms.getAtomSymmetry(a, this.symmetry);
                    symmetry.newSpaceGroupPoint(iSym, a, ptAtom, transX, transY, transZ, null);
                    code = symmetry.getSpaceGroupOperationCode(iSym);
                    if (code != null) {
                        subSystemId = code.charAt(0);
                        symmetry = ms.getSymmetryFromCode(code);
                        if (symmetry.getSpaceGroupOperationCount() == 0) {
                            this.finalizeSymmetry(symmetry);
                        }
                    }
                }
                if (this.acr.fixJavaFloat) {
                    PT.fixPtFloats(ptAtom, 100000.0f);
                }
                P3 c = P3.newP(ptAtom);
                symmetry.toCartesian(c, false);
                if (this.doPackUnitCell) {
                    symmetry.toUnitCell(c, this.ptOffset);
                    ptAtom.setT(c);
                    symmetry.toFractional(ptAtom, false);
                    if (this.acr.fixJavaFloat) {
                        PT.fixPtFloats(ptAtom, 100000.0f);
                    }
                    if (!this.isWithinCell(this.dtype, ptAtom, this.minXYZ0.x, this.maxXYZ0.x, this.minXYZ0.y, this.maxXYZ0.y, this.minXYZ0.z, this.maxXYZ0.z, this.packingError)) continue;
                }
                if (checkSymmetryMinMax) {
                    this.setSymmetryMinMax(c);
                }
                Atom special = null;
                if (checkDistance) {
                    if (checkSymmetryRange && (c.x < this.rminx || c.y < this.rminy || c.z < this.rminz || c.x > this.rmaxx || c.y > this.rmaxy || c.z > this.rmaxz)) continue;
                    float minDist2 = Float.MAX_VALUE;
                    int j0 = this.checkAll ? this.asc.ac : pt0;
                    String name = a.atomName;
                    char id = code == null ? a.altLoc : subSystemId;
                    for (int j = j00; j < j0; ++j) {
                        P3 pc;
                        if (bsAtoms != null && !bsAtoms.get(j) || (pc = cartesians[j - this.firstAtom]) == null) continue;
                        float d2 = c.distanceSquared(pc);
                        if (checkSpecial && d2 < d0) {
                            if (checkOps) {
                                excludedOps.set(iSym);
                                continue block0;
                            }
                            special = this.asc.atoms[j];
                            if ((special.atomName == null || special.atomName.equals(name)) && special.altLoc == id) break;
                            special = null;
                        }
                        if (!checkRange111 || j >= baseCount || !(d2 < minDist2)) continue;
                        minDist2 = d2;
                    }
                    if (checkRange111 && minDist2 > range2) continue;
                }
                if (checkOps) {
                    checkDistance = false;
                }
                int atomSite = a.atomSite;
                if (special != null) {
                    if (addBonds) {
                        atomMap[atomSite] = special.index;
                    }
                    special.bsSymmetry.set(cpt);
                    special.bsSymmetry.set(spt);
                    continue;
                }
                if (addBonds) {
                    atomMap[atomSite] = this.asc.ac;
                }
                Atom atom1 = this.asc.newCloneAtom(a);
                atom1.setT(ptAtom);
                if (this.asc.bsAtoms != null) {
                    this.asc.bsAtoms.set(atom1.index);
                }
                if (spinOp != 0.0f && atom1.vib != null) {
                    symmetry.getSpaceGroupOperation(iSym).rotate(atom1.vib);
                    atom1.vib.scale(spinOp);
                }
                atom1.atomSite = atomSite;
                if (code != null) {
                    atom1.altLoc = subSystemId;
                }
                atom1.bsSymmetry = BSUtil.newAndSetBit(cpt);
                atom1.bsSymmetry.set(spt);
                if (addCartesian) {
                    cartesians[pt++] = c;
                }
                if ((tensors = a.tensors) == null) continue;
                atom1.tensors = null;
                int j = tensors.size();
                while (--j >= 0) {
                    Tensor t = (Tensor)tensors.get(j);
                    if (t == null) continue;
                    if (nOp == 1) {
                        atom1.addTensor(t.copyTensor(), null, false);
                        continue;
                    }
                    this.addRotatedTensor(atom1, t, iSym, false, symmetry);
                }
            }
            if (!addBonds) continue;
            Bond[] bonds = this.asc.bonds;
            Atom[] atoms = this.asc.atoms;
            for (int bondNum = this.asc.bondIndex0; bondNum < this.bondCount0; ++bondNum) {
                Bond bond = bonds[bondNum];
                Atom atom1 = atoms[bond.atomIndex1];
                Atom atom2 = atoms[bond.atomIndex2];
                if (atom1 == null || atom2 == null) continue;
                int iAtom1 = atomMap[atom1.atomSite];
                int iAtom2 = atomMap[atom2.atomSite];
                if (iAtom1 < atomMax && iAtom2 < atomMax) continue;
                this.asc.addNewBondWithOrder(iAtom1, iAtom2, bond.order);
            }
        }
        return pt;
    }

    private void duplicateAtomProperties(int nTimes) {
        Map p = (Map)this.asc.getAtomSetAuxiliaryInfoValue(-1, "atomProperties");
        if (p != null) {
            for (Map.Entry entry : p.entrySet()) {
                int i;
                String key = (String)entry.getKey();
                Object val = entry.getValue();
                if (val instanceof String) {
                    String data = (String)val;
                    SB s = new SB();
                    i = nTimes;
                    while (--i >= 0) {
                        s.append(data);
                    }
                    p.put(key, s.toString());
                    continue;
                }
                float[] f = (float[])val;
                float[] fnew = new float[f.length * nTimes];
                i = nTimes;
                while (--i >= 0) {
                    System.arraycopy(f, 0, fnew, i * f.length, f.length);
                }
            }
        }
    }

    private void finalizeSymmetry(SymmetryInterface symmetry) {
        String name = (String)this.asc.getAtomSetAuxiliaryInfoValue(-1, "spaceGroup");
        symmetry.setFinalOperations(name, this.asc.atoms, this.firstAtom, this.noSymmetryCount, this.doNormalize, this.filterSymop);
        if (this.filterSymop != null || name == null || name.equals("unspecified!")) {
            this.setAtomSetSpaceGroupName(symmetry.getSpaceGroupName());
        }
    }

    private void setSymmetryOps() {
        int operationCount = this.symmetry.getSpaceGroupOperationCount();
        if (operationCount > 0) {
            String[] symmetryList = new String[operationCount];
            for (int i = 0; i < operationCount; ++i) {
                symmetryList[i] = "" + this.symmetry.getSpaceGroupXyz(i, this.doNormalize);
            }
            this.asc.setCurrentModelInfo("symmetryOperations", symmetryList);
            this.asc.setCurrentModelInfo("symmetryOps", this.symmetry.getSymmetryOperations());
        }
        this.asc.setCurrentModelInfo("symmetryCount", operationCount);
        this.asc.setCurrentModelInfo("latticeType", this.acr.latticeType == null ? "P" : this.acr.latticeType);
        this.asc.setCurrentModelInfo("intlTableNo", this.symmetry.getIntTableNumber());
        if (this.acr.sgName == null || this.acr.sgName.indexOf("?") >= 0 || this.acr.sgName.indexOf("!") >= 0) {
            this.acr.sgName = this.symmetry.getSpaceGroupName();
            this.setAtomSetSpaceGroupName(this.acr.sgName);
        }
    }

    public T3 getOverallSpan() {
        return this.maxXYZ0 == null ? V3.new3(this.maxXYZ.x - this.minXYZ.x, this.maxXYZ.y - this.minXYZ.y, this.maxXYZ.z - this.minXYZ.z) : V3.newVsub(this.maxXYZ0, this.minXYZ0);
    }

    public void applySymmetryBio(Map<String, Object> thisBiomolecule, boolean applySymmetryToBonds, String filter) {
        int i;
        String name;
        int[] lc;
        Lst biomts = (Lst)thisBiomolecule.get("biomts");
        if (biomts.size() < 2) {
            return;
        }
        this.acr.lstNCS = null;
        this.setLatticeCells();
        int[] nArray = lc = this.latticeCells != null && this.latticeCells[0] != 0 ? new int[3] : null;
        if (lc != null) {
            for (int i2 = 0; i2 < 3; ++i2) {
                lc[i2] = this.latticeCells[i2];
            }
        }
        this.latticeCells = null;
        int particleMode = filter.indexOf("BYCHAIN") >= 0 ? 1 : (filter.indexOf("BYSYMOP") >= 0 ? 2 : 0);
        this.doNormalize = false;
        Lst biomtchains = (Lst)thisBiomolecule.get("chains");
        if (((String)biomtchains.get(0)).equals(biomtchains.get(1))) {
            biomtchains = null;
        }
        this.symmetry = null;
        this.getSymmetry().setSpaceGroup(this.doNormalize);
        this.addSpaceGroupOperation("x,y,z", false);
        this.acr.sgName = name = (String)thisBiomolecule.get("name");
        this.setAtomSetSpaceGroupName(this.acr.sgName);
        int len = biomts.size();
        this.applySymmetryToBonds = applySymmetryToBonds;
        this.bondCount0 = this.asc.bondCount;
        this.firstAtom = this.asc.getLastAtomSetAtomIndex();
        int atomMax = this.asc.ac;
        Hashtable<Integer, BS> ht = new Hashtable<Integer, BS>();
        int nChain = 0;
        Atom[] atoms = this.asc.atoms;
        boolean addBonds = this.bondCount0 > this.asc.bondIndex0 && applySymmetryToBonds;
        switch (particleMode) {
            case 1: {
                Atom a;
                int i3 = atomMax;
                while (--i3 >= this.firstAtom) {
                    Integer id = atoms[i3].chainID;
                    BS bs = (BS)ht.get(id);
                    if (bs == null) {
                        ++nChain;
                        bs = new BS();
                        ht.put(id, bs);
                    }
                    bs.set(i3);
                }
                this.asc.bsAtoms = new BS();
                for (i3 = 0; i3 < nChain; ++i3) {
                    this.asc.bsAtoms.set(atomMax + i3);
                    a = new Atom();
                    a.set(0.0f, 0.0f, 0.0f);
                    a.radius = 16.0f;
                    this.asc.addAtom(a);
                }
                int ichain = 0;
                for (Map.Entry e : ht.entrySet()) {
                    Atom a2 = atoms[atomMax + ichain++];
                    BS bs = (BS)e.getValue();
                    int i4 = bs.nextSetBit(0);
                    while (i4 >= 0) {
                        a2.add(atoms[i4]);
                        i4 = bs.nextSetBit(i4 + 1);
                    }
                    a2.scale(1.0f / (float)bs.cardinality());
                    a2.atomName = "Pt" + ichain;
                    a2.chainID = (Integer)e.getKey();
                }
                this.firstAtom = atomMax;
                atomMax += nChain;
                addBonds = false;
                break;
            }
            case 2: {
                this.asc.bsAtoms = new BS();
                this.asc.bsAtoms.set(atomMax);
                Atom a = atoms[atomMax] = new Atom();
                a.set(0.0f, 0.0f, 0.0f);
                int i5 = atomMax;
                while (--i5 >= this.firstAtom) {
                    a.add(atoms[i5]);
                }
                a.scale(1.0f / (float)(atomMax - this.firstAtom));
                a.atomName = "Pt";
                a.radius = 16.0f;
                this.asc.addAtom(a);
                this.firstAtom = atomMax++;
                addBonds = false;
            }
        }
        Map assemblyIdAtoms = (Map)thisBiomolecule.get("asemblyIdAtoms");
        if (filter.indexOf("#<") >= 0) {
            len = Math.min(len, PT.parseInt(filter.substring(filter.indexOf("#<") + 2)) - 1);
            filter = PT.rep(filter, "#<", "_<");
        }
        for (int iAtom = this.firstAtom; iAtom < atomMax; ++iAtom) {
            atoms[iAtom].bsSymmetry = BSUtil.newAndSetBit(0);
        }
        BS bsAtoms = this.asc.bsAtoms;
        int[] atomMap = addBonds ? new int[this.asc.ac] : null;
        int n = i = biomtchains == null ? 1 : 0;
        while (i < len) {
            if (!(filter.indexOf("!#") >= 0 ? filter.indexOf("!#" + (i + 1) + ";") >= 0 : filter.indexOf("#") >= 0 && filter.indexOf("#" + (i + 1) + ";") < 0)) {
                String chains;
                M4 mat = (M4)biomts.get(i);
                String string = chains = biomtchains == null ? null : (String)biomtchains.get(i);
                if (chains != null && assemblyIdAtoms != null) {
                    bsAtoms = new BS();
                    for (Map.Entry e : assemblyIdAtoms.entrySet()) {
                        if (chains.indexOf(":" + (String)e.getKey() + ";") < 0) continue;
                        bsAtoms.or((BS)e.getValue());
                    }
                    if (this.asc.bsAtoms != null) {
                        bsAtoms.and(this.asc.bsAtoms);
                    }
                    chains = null;
                }
                for (int iAtom = this.firstAtom; iAtom < atomMax; ++iAtom) {
                    if (bsAtoms != null && !bsAtoms.get(iAtom) || chains != null && chains.indexOf(":" + this.acr.vwr.getChainIDStr(atoms[iAtom].chainID) + ";") < 0) continue;
                    try {
                        int atomSite = atoms[iAtom].atomSite;
                        if (addBonds) {
                            atomMap[atomSite] = this.asc.ac;
                        }
                        Atom atom1 = this.asc.newCloneAtom(atoms[iAtom]);
                        if (this.asc.bsAtoms != null) {
                            this.asc.bsAtoms.set(atom1.index);
                        }
                        atom1.atomSite = atomSite;
                        mat.rotTrans(atom1);
                        atom1.bsSymmetry = BSUtil.newAndSetBit(i);
                        continue;
                    }
                    catch (Exception e) {
                        this.asc.errorMessage = "appendAtomCollection error: " + e;
                    }
                }
                if (i > 0) {
                    this.symmetry.addBioMoleculeOperation(mat, false);
                    if (addBonds) {
                        for (int bondNum = this.asc.bondIndex0; bondNum < this.bondCount0; ++bondNum) {
                            Bond bond = this.asc.bonds[bondNum];
                            int iAtom1 = atomMap[atoms[bond.atomIndex1].atomSite];
                            int iAtom2 = atomMap[atoms[bond.atomIndex2].atomSite];
                            this.asc.addNewBondWithOrder(iAtom1, iAtom2, bond.order);
                        }
                    }
                }
            }
            ++i;
        }
        if (biomtchains != null) {
            if (this.asc.bsAtoms == null) {
                this.asc.bsAtoms = BSUtil.newBitSet2(0, this.asc.ac);
            }
            this.asc.bsAtoms.clearBits(this.firstAtom, atomMax);
        }
        this.noSymmetryCount = atomMax - this.firstAtom;
        this.asc.setCurrentModelInfo("presymmetryAtomIndex", this.firstAtom);
        this.asc.setCurrentModelInfo("presymmetryAtomCount", this.noSymmetryCount);
        this.asc.setCurrentModelInfo("biosymmetryCount", len);
        this.asc.setCurrentModelInfo("biosymmetry", this.symmetry);
        this.finalizeSymmetry(this.symmetry);
        this.setSymmetryOps();
        this.reset();
    }

    private void reset() {
        this.asc.coordinatesAreFractional = false;
        this.asc.setCurrentModelInfo("hasSymmetry", Boolean.TRUE);
        this.asc.setGlobalBoolean(1);
    }

    public Tensor addRotatedTensor(Atom a, Tensor t, int iSym, boolean reset, SymmetryInterface symmetry) {
        if (this.ptTemp == null) {
            this.ptTemp = new P3();
            this.mTemp = new M3();
        }
        return a.addTensor(((Tensor)this.acr.getInterface("org.jmol.util.Tensor")).setFromEigenVectors(symmetry.rotateAxes(iSym, t.eigenVectors, this.ptTemp, this.mTemp), t.eigenValues, t.isIsotropic ? "iso" : t.type, t.id, t), null, reset);
    }

    void setTensors() {
        int n = this.asc.ac;
        for (int i = this.asc.getLastAtomSetAtomIndex(); i < n; ++i) {
            Atom a = this.asc.atoms[i];
            if (a.anisoBorU == null) continue;
            a.addTensor(this.symmetry.getTensor(this.acr.vwr, a.anisoBorU), null, false);
            if (Float.isNaN(a.bfactor)) {
                a.bfactor = a.anisoBorU[7] * 100.0f;
            }
            a.anisoBorU = null;
        }
    }

    public void setTimeReversal(int op, int timeRev) {
        this.symmetry.setTimeReversal(op, timeRev);
    }

    public int setSpinVectors() {
        if (this.nVib > 0 || this.asc.iSet < 0 || !this.acr.vibsFractional) {
            return this.nVib;
        }
        int i0 = this.asc.getAtomSetAtomIndex(this.asc.iSet);
        SymmetryInterface sym = this.getBaseSymmetry();
        int i = this.asc.ac;
        while (--i >= i0) {
            Vibration v = (Vibration)this.asc.atoms[i].vib;
            if (v == null) continue;
            if (v.modDim > 0) {
                ((JmolModulationSet)((Object)v)).setMoment();
            } else {
                v = (Vibration)v.clone();
                sym.toCartesian(v, true);
                this.asc.atoms[i].vib = v;
            }
            ++this.nVib;
        }
        return this.nVib;
    }

    public void scaleFractionalVibs() {
        float[] params = this.getBaseSymmetry().getUnitCellParams();
        P3 ptScale = P3.new3(1.0f / params[0], 1.0f / params[1], 1.0f / params[2]);
        int i0 = this.asc.getAtomSetAtomIndex(this.asc.iSet);
        int i = this.asc.ac;
        while (--i >= i0) {
            Vibration v = (Vibration)this.asc.atoms[i].vib;
            if (v == null) continue;
            v.scaleT(ptScale);
        }
    }

    public SymmetryInterface getBaseSymmetry() {
        return this.baseSymmetry == null ? this.symmetry : this.baseSymmetry;
    }

    public void finalizeUnitCell(P3 ptSupercell) {
        if (ptSupercell != null && this.baseUnitCell != null) {
            this.baseUnitCell[22] = Math.max(1, (int)ptSupercell.x);
            this.baseUnitCell[23] = Math.max(1, (int)ptSupercell.y);
            this.baseUnitCell[24] = Math.max(1, (int)ptSupercell.z);
        }
    }
}

