/*
 * Decompiled with CFR 0.152.
 */
package com.drew.metadata.exif;

import com.drew.metadata.Directory;
import com.drew.metadata.MetadataException;
import com.drew.metadata.TagDescriptor;

public class PentaxMakernoteDescriptor
extends TagDescriptor {
    public PentaxMakernoteDescriptor(Directory directory) {
        super(directory);
    }

    @Override
    public String getDescription(int tagType) throws MetadataException {
        switch (tagType) {
            case 1: {
                return this.getCaptureModeDescription();
            }
            case 2: {
                return this.getQualityLevelDescription();
            }
            case 3: {
                return this.getFocusModeDescription();
            }
            case 4: {
                return this.getFlashModeDescription();
            }
            case 7: {
                return this.getWhiteBalanceDescription();
            }
            case 10: {
                return this.getDigitalZoomDescription();
            }
            case 11: {
                return this.getSharpnessDescription();
            }
            case 12: {
                return this.getContrastDescription();
            }
            case 13: {
                return this.getSaturationDescription();
            }
            case 20: {
                return this.getIsoSpeedDescription();
            }
            case 23: {
                return this.getColourDescription();
            }
        }
        return this._directory.getString(tagType);
    }

    public String getColourDescription() throws MetadataException {
        if (!this._directory.containsTag(23)) {
            return null;
        }
        int value = this._directory.getInt(23);
        switch (value) {
            case 1: {
                return "Normal";
            }
            case 2: {
                return "Black & White";
            }
            case 3: {
                return "Sepia";
            }
        }
        return "Unknown (" + value + ")";
    }

    public String getIsoSpeedDescription() throws MetadataException {
        if (!this._directory.containsTag(20)) {
            return null;
        }
        int value = this._directory.getInt(20);
        switch (value) {
            case 10: {
                return "ISO 100";
            }
            case 16: {
                return "ISO 200";
            }
            case 100: {
                return "ISO 100";
            }
            case 200: {
                return "ISO 200";
            }
        }
        return "Unknown (" + value + ")";
    }

    public String getSaturationDescription() throws MetadataException {
        if (!this._directory.containsTag(13)) {
            return null;
        }
        int value = this._directory.getInt(13);
        switch (value) {
            case 0: {
                return "Normal";
            }
            case 1: {
                return "Low";
            }
            case 2: {
                return "High";
            }
        }
        return "Unknown (" + value + ")";
    }

    public String getContrastDescription() throws MetadataException {
        if (!this._directory.containsTag(12)) {
            return null;
        }
        int value = this._directory.getInt(12);
        switch (value) {
            case 0: {
                return "Normal";
            }
            case 1: {
                return "Low";
            }
            case 2: {
                return "High";
            }
        }
        return "Unknown (" + value + ")";
    }

    public String getSharpnessDescription() throws MetadataException {
        if (!this._directory.containsTag(11)) {
            return null;
        }
        int value = this._directory.getInt(11);
        switch (value) {
            case 0: {
                return "Normal";
            }
            case 1: {
                return "Soft";
            }
            case 2: {
                return "Hard";
            }
        }
        return "Unknown (" + value + ")";
    }

    public String getDigitalZoomDescription() throws MetadataException {
        if (!this._directory.containsTag(10)) {
            return null;
        }
        float value = this._directory.getFloat(10);
        if (value == 0.0f) {
            return "Off";
        }
        return Float.toString(value);
    }

    public String getWhiteBalanceDescription() throws MetadataException {
        if (!this._directory.containsTag(7)) {
            return null;
        }
        int value = this._directory.getInt(7);
        switch (value) {
            case 0: {
                return "Auto";
            }
            case 1: {
                return "Daylight";
            }
            case 2: {
                return "Shade";
            }
            case 3: {
                return "Tungsten";
            }
            case 4: {
                return "Fluorescent";
            }
            case 5: {
                return "Manual";
            }
        }
        return "Unknown (" + value + ")";
    }

    public String getFlashModeDescription() throws MetadataException {
        if (!this._directory.containsTag(4)) {
            return null;
        }
        int value = this._directory.getInt(4);
        switch (value) {
            case 1: {
                return "Auto";
            }
            case 2: {
                return "Flash On";
            }
            case 4: {
                return "Flash Off";
            }
            case 6: {
                return "Red-eye Reduction";
            }
        }
        return "Unknown (" + value + ")";
    }

    public String getFocusModeDescription() throws MetadataException {
        if (!this._directory.containsTag(3)) {
            return null;
        }
        int value = this._directory.getInt(3);
        switch (value) {
            case 2: {
                return "Custom";
            }
            case 3: {
                return "Auto";
            }
        }
        return "Unknown (" + value + ")";
    }

    public String getQualityLevelDescription() throws MetadataException {
        if (!this._directory.containsTag(2)) {
            return null;
        }
        int value = this._directory.getInt(2);
        switch (value) {
            case 0: {
                return "Good";
            }
            case 1: {
                return "Better";
            }
            case 2: {
                return "Best";
            }
        }
        return "Unknown (" + value + ")";
    }

    public String getCaptureModeDescription() throws MetadataException {
        if (!this._directory.containsTag(1)) {
            return null;
        }
        int value = this._directory.getInt(1);
        switch (value) {
            case 1: {
                return "Auto";
            }
            case 2: {
                return "Night-scene";
            }
            case 3: {
                return "Manual";
            }
            case 4: {
                return "Multiple";
            }
        }
        return "Unknown (" + value + ")";
    }
}

