/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fonts.substitute;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.fonts.FontInfo;
import org.apache.fop.fonts.FontTriplet;
import org.apache.fop.fonts.substitute.FontQualifier;
import org.apache.fop.fonts.substitute.FontSubstitution;

public class FontSubstitutions
extends ArrayList<FontSubstitution> {
    private static final long serialVersionUID = -9173104935431899722L;
    protected static final Log log = LogFactory.getLog(FontSubstitutions.class);

    public void adjustFontInfo(FontInfo fontInfo) {
        Iterator subsIt = super.iterator();
        while (subsIt.hasNext()) {
            FontSubstitution substitution = (FontSubstitution)subsIt.next();
            FontQualifier toQualifier = substitution.getToQualifier();
            FontTriplet fontTriplet = toQualifier.bestMatch(fontInfo);
            if (fontTriplet == null) {
                log.error("Unable to match font substitution for destination qualifier " + toQualifier);
                continue;
            }
            String internalFontKey = fontInfo.getInternalFontKey(fontTriplet);
            FontQualifier fromQualifier = substitution.getFromQualifier();
            List<FontTriplet> tripletList = fromQualifier.getTriplets();
            Iterator<FontTriplet> i$ = tripletList.iterator();
            while (i$.hasNext()) {
                FontTriplet aTripletList;
                FontTriplet triplet = aTripletList = i$.next();
                fontInfo.addFontProperties(internalFontKey, triplet);
            }
        }
    }
}

