/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.instructions;

import java.util.EnumSet;
import org.jruby.RubySymbol;
import org.jruby.ir.IRFlags;
import org.jruby.ir.IRScope;
import org.jruby.ir.IRVisitor;
import org.jruby.ir.Operation;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.instructions.NoOperandInstr;
import org.jruby.ir.persistence.IRReaderDecoder;
import org.jruby.ir.persistence.IRWriterEncoder;
import org.jruby.ir.runtime.IRRuntimeHelpers;
import org.jruby.ir.transformations.inlining.CloneInfo;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.RubyEvent;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class TraceInstr
extends NoOperandInstr {
    private final RubyEvent event;
    private final RubySymbol name;
    private final String filename;
    private final int linenumber;

    public TraceInstr(RubyEvent event2, RubySymbol name2, String filename2, int linenumber) {
        super(Operation.TRACE);
        this.event = event2;
        this.name = name2;
        this.filename = filename2;
        this.linenumber = linenumber;
    }

    @Override
    public Instr clone(CloneInfo ii) {
        return new TraceInstr(this.event, this.name, this.filename, this.linenumber);
    }

    public RubyEvent getEvent() {
        return this.event;
    }

    public String getName() {
        return this.name == null ? null : this.name.idString();
    }

    public String getFilename() {
        return this.filename;
    }

    public int getLinenumber() {
        return this.linenumber;
    }

    @Override
    public String[] toStringNonOperandArgs() {
        return new String[]{"ev: " + (Object)((Object)this.event), "name: " + this.name, "file: " + this.filename, "line: " + this.linenumber};
    }

    @Override
    public void encode(IRWriterEncoder e) {
        super.encode(e);
        e.encode(this.getEvent());
        e.encode(this.getName());
        e.encode(this.getFilename());
        e.encode(this.getLinenumber());
    }

    public static TraceInstr decode(IRReaderDecoder d) {
        return new TraceInstr(d.decodeRubyEvent(), d.decodeSymbol(), d.decodeString(), d.decodeInt());
    }

    @Override
    public Object interpret(ThreadContext context, StaticScope currScope, DynamicScope currDynScope, IRubyObject self2, Object[] temp) {
        IRRuntimeHelpers.callTrace(context, this.getEvent(), this.getName(), this.getFilename(), this.getLinenumber());
        return null;
    }

    @Override
    public void visit(IRVisitor visitor) {
        visitor.TraceInstr(this);
    }

    @Override
    public boolean computeScopeFlags(IRScope scope) {
        EnumSet<IRFlags> flags2 = scope.getFlags();
        flags2.addAll(IRFlags.REQUIRE_ALL_FRAME_FIELDS);
        return true;
    }
}

