// **********************************************************************
//
// Copyright (c) 2003-2017 ZeroC, Inc. All rights reserved.
//
// This copy of Ice is licensed to you under the terms described in the
// ICE_LICENSE file included in this distribution.
//
// **********************************************************************
//
// Ice version 3.7.0
//
// <auto-generated>
//
// Generated from file `IceStorm.ice'
//
// Warning: do not edit this file.
//
// </auto-generated>
//

package IceStorm;

/**
 * Publishers publish information on a particular topic. A topic
 * logically represents a type.
 *
 * @see TopicManager
 *
 **/
public interface _TopicOperations
{
    /**
     * Get the name of this topic.
     *
     * @param current The Current object for the invocation.
     * @return The name of the topic.
     *
     * @see TopicManager#create
     *
     **/
    String getName(Ice.Current current);

    /**
     * Get a proxy to a publisher object for this topic. To publish
     * data to a topic, the publisher calls {@link Topic#getPublisher} and then
     * casts to the topic type. An unchecked cast must be used on this
     * proxy. If a replicated IceStorm deployment is used this call
     * may return a replicated proxy.
     *
     * @param current The Current object for the invocation.
     * @return A proxy to publish data on this topic.
     *
     **/
    Ice.ObjectPrx getPublisher(Ice.Current current);

    /**
     * Get a non-replicated proxy to a publisher object for this
     * topic. To publish data to a topic, the publisher calls
     * {@link Topic#getPublisher} and then casts to the topic type. An unchecked
     * cast must be used on this proxy.
     *
     * @param current The Current object for the invocation.
     * @return A proxy to publish data on this topic.
     *
     **/
    Ice.ObjectPrx getNonReplicatedPublisher(Ice.Current current);

    /**
     * Subscribe with the given <tt>qos</tt> to this topic.  A
     * per-subscriber publisher object is returned.
     *
     * @param theQoS The quality of service parameters for this
     * subscription.
     *
     * @param subscriber The subscriber's proxy.
     *
     * @param current The Current object for the invocation.
     * @return The per-subscriber publisher object.
     *
     * @throws AlreadySubscribed Raised if the subscriber object is
     * already subscribed.
     *
     * @throws InvalidSubscriber Raised if the subscriber object is null.
     *
     * @throws BadQoS Raised if the requested quality of service
     * is unavailable or invalid.
     *
     * @see #unsubscribe
     *
     **/
    Ice.ObjectPrx subscribeAndGetPublisher(java.util.Map<java.lang.String, java.lang.String> theQoS, Ice.ObjectPrx subscriber, Ice.Current current)
        throws AlreadySubscribed,
               BadQoS,
               InvalidSubscriber;

    /**
     * Unsubscribe the given <tt>subscriber</tt>.
     *
     * @param subscriber The proxy of an existing subscriber.
     *
     * @see #subscribeAndGetPublisher
     *
     * @param current The Current object for the invocation.
     **/
    void unsubscribe(Ice.ObjectPrx subscriber, Ice.Current current);

    /**
     * Create a link to the given topic. All events originating
     * on this topic will also be sent to <tt>linkTo</tt>.
     *
     * @param linkTo The topic to link to.
     *
     * @param cost The cost to the linked topic.
     *
     * @throws LinkExists Raised if a link to the same topic already
     * exists.
     *
     * @param current The Current object for the invocation.
     **/
    void link(TopicPrx linkTo, int cost, Ice.Current current)
        throws LinkExists;

    /**
     * Destroy the link from this topic to the given topic <tt>linkTo</tt>.
     *
     * @param linkTo The topic to destroy the link to.
     *
     * @throws NoSuchLink Raised if a link to the topic does not exist.
     *
     * @param current The Current object for the invocation.
     **/
    void unlink(TopicPrx linkTo, Ice.Current current)
        throws NoSuchLink;

    /**
     * Retrieve information on the current links.
     *
     * @param current The Current object for the invocation.
     * @return A sequence of LinkInfo objects.
     *
     **/
    LinkInfo[] getLinkInfoSeq(Ice.Current current);

    /**
     * Retrieve the list of subscribers for this topic.
     *
     * @param current The Current object for the invocation.
     * @return The sequence of Ice identities for the subscriber objects.
     *
     **/
    Ice.Identity[] getSubscribers(Ice.Current current);

    /**
     * Destroy the topic.
     *
     * @param current The Current object for the invocation.
     **/
    void destroy(Ice.Current current);
}
