/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.font;

import com.sun.javafx.PlatformUtil;
import com.sun.javafx.font.FontStrike;
import com.sun.javafx.font.PGFont;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.t2k.T2KFontStrike;

public class PrismFontUtils {
    private static float lcdContrast = -1.0f;

    private PrismFontUtils() {
    }

    public static float getLCDContrast() {
        if (lcdContrast == -1.0f) {
            lcdContrast = PlatformUtil.isWindows() ? (float)T2KFontStrike.getLCDContrast() / 1000.0f : 1.3f;
        }
        return lcdContrast;
    }

    static FontStrike.Metrics getFontMetrics(PGFont pGFont) {
        FontStrike fontStrike = pGFont.getStrike(BaseTransform.IDENTITY_TRANSFORM, 0);
        return fontStrike.getMetrics();
    }

    static double computeStringWidth(PGFont pGFont, String string) {
        if (string == null || string.equals("")) {
            return 0.0;
        }
        FontStrike fontStrike = pGFont.getStrike(BaseTransform.IDENTITY_TRANSFORM, 0);
        return fontStrike.getStringWidth(string);
    }
}

