#!/bin/sh
export PATH='/usr/lib/distcc/bin:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name: dbus
version: 1.0.1
id: dbus-1.0.1-AUEOVKZ2s2O1ViZqP0lVm8
key: dbus-1.0.1-AUEOVKZ2s2O1ViZqP0lVm8
license: Apache-2.0
maintainer: Andrey Sverdlichenko <blaze@ruddy.ru>
author: John Millikin <john@john-millikin.com>
stability: experimental
homepage: https://github.com/rblaze/haskell-dbus#readme
synopsis: A client library for the D-Bus IPC system.
description:
    D-Bus is a simple, message-based protocol for inter-process
    communication, which allows applications to interact with other parts of
    the machine and the user'\''s session using remote procedure calls.
    .
    D-Bus is a essential part of the modern Linux desktop, where it replaces
    earlier protocols such as CORBA and DCOP.
    .
    This library is an implementation of the D-Bus protocol in Haskell. It
    can be used to add D-Bus support to Haskell applications, without the
    awkward interfaces common to foreign bindings.
    .
    Example: connect to the session bus, and get a list of active names.
    .
    @
    &#x7b;-\# LANGUAGE OverloadedStrings \#-&#x7d;
    .
    import Data.List (sort)
    import DBus
    import DBus.Client
    .
    main = do
    &#x20;   client <- connectSession
    &#x20;   //
    &#x20;   \-- Request a list of connected clients from the bus
    &#x20;   reply <- call_ client (methodCall \"\/org\/freedesktop\/DBus\" \"org.freedesktop.DBus\" \"ListNames\")
    &#x20;       &#x7b; methodCallDestination = Just \"org.freedesktop.DBus\"
    &#x20;       &#x7d;
    &#x20;   //
    &#x20;   \-- org.freedesktop.DBus.ListNames() returns a single value, which is
    &#x20;   \-- a list of names (here represented as [String])
    &#x20;   let Just names = fromVariant (methodReturnBody reply !! 0)
    &#x20;   //
    &#x20;   \-- Print each name on a line, sorted so reserved names are below
    &#x20;   \-- temporary names.
    &#x20;   mapM_ putStrLn (sort names)
    @
    .
    >$ ghc --make list-names.hs
    >$ ./list-names
    >:1.0
    >:1.1
    >:1.10
    >:1.106
    >:1.109
    >:1.110
    >ca.desrt.dconf
    >org.freedesktop.DBus
    >org.freedesktop.Notifications
    >org.freedesktop.secrets
    >org.gnome.ScreenSaver
category: Network, Desktop
abi: 86cd55a70454de9cb9bc96278b9b0aec
exposed: True
exposed-modules:
    DBus DBus.Client DBus.Generation DBus.Internal.Address
    DBus.Internal.Message DBus.Internal.Types DBus.Internal.Wire
    DBus.Introspection DBus.Socket DBus.TH DBus.Transport
import-dirs: /usr/lib/ghc-8.4.3/site-local/dbus-1.0.1
library-dirs: /usr/lib/ghc-8.4.3/site-local/dbus-1.0.1
dynamic-library-dirs: /usr/lib
data-dir: /usr/share/arm-linux-ghc-8.4.3/dbus-1.0.1
hs-libraries: HSdbus-1.0.1-AUEOVKZ2s2O1ViZqP0lVm8
depends:
    base-4.11.1.0 bytestring-0.10.8.2
    cereal-0.5.5.0-GXs0HkZKyWNA7Krg63fmZj containers-0.5.11.0
    deepseq-1.4.3.0 filepath-1.4.2 lens-4.16.1-7wZyloShNRSJPoQvcBTN31
    libxml-sax-0.7.5-GkUm3a8rMd5IxolLzHxtC3
    network-2.7.0.1-H3G12S9UXc14r49NrCjVOb parsec-3.1.13.0
    random-1.1-9LLJAJa4iQFLJiLXBOBXBV
    split-0.2.3.3-DYHuRk05Zl3FsXrGVgC4fG template-haskell-2.13.0.0
    text-1.2.3.0 th-lift-0.7.10-88ozaMeoe8eDZSlyIjheFa
    transformers-0.5.5.0 unix-2.7.2.2
    vector-0.12.0.1-1fezwShzdEfG3Hp1Pmvjkq
    xml-types-0.3.6-FWN9dD9K4Pf2M2rvMuT5Tt
abi-depends: base-4.11.1.0=a3fb1645bafaa89172454c2eea8dfdc9
             bytestring-0.10.8.2=9faa89cf4769cbd12751f8644ca9e618
             cereal-0.5.5.0-GXs0HkZKyWNA7Krg63fmZj=2b6502a041f954555a854231cf10da34
             containers-0.5.11.0=94bb4831ae701bd40855b2dc2d65cf7c
             deepseq-1.4.3.0=34da2d42d10eacba0aad99c95b538637
             filepath-1.4.2=2408ba322304c0a06810db2d7363214a
             lens-4.16.1-7wZyloShNRSJPoQvcBTN31=487f18f85ae584985d80aa3b99974876
             libxml-sax-0.7.5-GkUm3a8rMd5IxolLzHxtC3=b17aeec7292ad48228f6d107873819ae
             network-2.7.0.1-H3G12S9UXc14r49NrCjVOb=29a1441cc5e4aeb97125018af3ab80ef
             parsec-3.1.13.0=3626e7cedd22de76a8b10339d955721a
             random-1.1-9LLJAJa4iQFLJiLXBOBXBV=2cade9e72fa19fe7a43e5ace84505d9f
             split-0.2.3.3-DYHuRk05Zl3FsXrGVgC4fG=cdf77c47c599317cfa01d2d98185c5d3
             template-haskell-2.13.0.0=ac7dfd04924d4ebfa90a119ad22a36cc
             text-1.2.3.0=9752fd647a108be49a4cb0c2a4456f2b
             th-lift-0.7.10-88ozaMeoe8eDZSlyIjheFa=60d068a969a5d731636a40e25634c1aa
             transformers-0.5.5.0=4f41484af13f560f1d83ed79e1be4572
             unix-2.7.2.2=f81aa481840dadf9c364a1cea96978c0
             vector-0.12.0.1-1fezwShzdEfG3Hp1Pmvjkq=8ec9732a4c43da9ed60d7a7b8971b540
             xml-types-0.3.6-FWN9dD9K4Pf2M2rvMuT5Tt=d60c5437db670e030567a6d42bb218af
haddock-interfaces: /usr/share/doc/haskell-dbus/html/dbus.haddock
haddock-html: /usr/share/doc/haskell-dbus/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

