#!/bin/sh
export PATH='/usr/lib/distcc/bin:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name: pandoc
version: 2.2.1
id: pandoc-2.2.1-JGtIBYdSQK7CWnOawx9MwO
key: pandoc-2.2.1-JGtIBYdSQK7CWnOawx9MwO
license: GPL-2.0-only
copyright: (c) 2006-2018 John MacFarlane
maintainer: John MacFarlane <jgm@berkeley.edu>
author: John MacFarlane <jgm@berkeley.edu>
stability: alpha
homepage: https://pandoc.org
synopsis: Conversion between markup formats
description:
    Pandoc is a Haskell library for converting from one markup
    format to another, and a command-line tool that uses
    this library. It can read several dialects of Markdown and
    (subsets of) HTML, reStructuredText, LaTeX, DocBook, JATS,
    MediaWiki markup, TWiki markup, TikiWiki markup, Creole 1.0,
    Haddock markup, OPML, Emacs Org-Mode, Emacs Muse, txt2tags,
    Vimwiki, Word Docx, ODT, EPUB, FictionBook2, and Textile,
    and it can write Markdown, reStructuredText, XHTML, HTML 5,
    LaTeX, ConTeXt, DocBook, JATS, OPML, TEI, OpenDocument,
    ODT, Word docx, RTF, MediaWiki, DokuWiki, ZimWiki, Textile,
    groff man, groff ms, plain text, Emacs Org-Mode, AsciiDoc,
    Haddock markup, EPUB (v2 and v3), FictionBook2, InDesign
    ICML, Muse, LaTeX beamer slides, PowerPoint, and several
    kinds of HTML/JavaScript slide shows (S5, Slidy, Slideous,
    DZSlides, reveal.js).
    .
    In contrast to most existing tools for converting Markdown
    to HTML, pandoc has a modular design: it consists of a set of
    readers, which parse text in a given format and produce a
    native representation of the document, and a set of writers,
    which convert this native representation into a target
    format. Thus, adding an input or output format requires
    only adding a reader or writer.
category: Text
abi: cbf4a3e746f05b1f9cbaa6292983c2e1
exposed: True
exposed-modules:
    Text.Pandoc Text.Pandoc.App Text.Pandoc.Asciify Text.Pandoc.BCP47
    Text.Pandoc.Class Text.Pandoc.Emoji Text.Pandoc.Error
    Text.Pandoc.Extensions Text.Pandoc.Highlighting
    Text.Pandoc.ImageSize Text.Pandoc.Logging Text.Pandoc.Lua
    Text.Pandoc.MIME Text.Pandoc.MediaBag Text.Pandoc.Options
    Text.Pandoc.PDF Text.Pandoc.Parsing Text.Pandoc.Pretty
    Text.Pandoc.Process Text.Pandoc.Readers
    Text.Pandoc.Readers.CommonMark Text.Pandoc.Readers.Creole
    Text.Pandoc.Readers.DocBook Text.Pandoc.Readers.Docx
    Text.Pandoc.Readers.EPUB Text.Pandoc.Readers.FB2
    Text.Pandoc.Readers.HTML Text.Pandoc.Readers.Haddock
    Text.Pandoc.Readers.JATS Text.Pandoc.Readers.LaTeX
    Text.Pandoc.Readers.LaTeX.Types Text.Pandoc.Readers.Markdown
    Text.Pandoc.Readers.MediaWiki Text.Pandoc.Readers.Muse
    Text.Pandoc.Readers.Native Text.Pandoc.Readers.OPML
    Text.Pandoc.Readers.Odt Text.Pandoc.Readers.Org
    Text.Pandoc.Readers.RST Text.Pandoc.Readers.TWiki
    Text.Pandoc.Readers.Textile Text.Pandoc.Readers.TikiWiki
    Text.Pandoc.Readers.Txt2Tags Text.Pandoc.Readers.Vimwiki
    Text.Pandoc.SelfContained Text.Pandoc.Shared Text.Pandoc.Templates
    Text.Pandoc.UTF8 Text.Pandoc.Writers Text.Pandoc.Writers.AsciiDoc
    Text.Pandoc.Writers.CommonMark Text.Pandoc.Writers.ConTeXt
    Text.Pandoc.Writers.Custom Text.Pandoc.Writers.Docbook
    Text.Pandoc.Writers.Docx Text.Pandoc.Writers.DokuWiki
    Text.Pandoc.Writers.EPUB Text.Pandoc.Writers.FB2
    Text.Pandoc.Writers.HTML Text.Pandoc.Writers.Haddock
    Text.Pandoc.Writers.ICML Text.Pandoc.Writers.JATS
    Text.Pandoc.Writers.LaTeX Text.Pandoc.Writers.Man
    Text.Pandoc.Writers.Markdown Text.Pandoc.Writers.Math
    Text.Pandoc.Writers.MediaWiki Text.Pandoc.Writers.Ms
    Text.Pandoc.Writers.Muse Text.Pandoc.Writers.Native
    Text.Pandoc.Writers.ODT Text.Pandoc.Writers.OOXML
    Text.Pandoc.Writers.OPML Text.Pandoc.Writers.OpenDocument
    Text.Pandoc.Writers.Org Text.Pandoc.Writers.Powerpoint
    Text.Pandoc.Writers.RST Text.Pandoc.Writers.RTF
    Text.Pandoc.Writers.Shared Text.Pandoc.Writers.TEI
    Text.Pandoc.Writers.Texinfo Text.Pandoc.Writers.Textile
    Text.Pandoc.Writers.ZimWiki Text.Pandoc.XML
hidden-modules: Text.Pandoc.Filter Text.Pandoc.Filter.JSON
                Text.Pandoc.Filter.Lua Text.Pandoc.Filter.Path
                Text.Pandoc.Readers.Docx.Lists Text.Pandoc.Readers.Docx.Combine
                Text.Pandoc.Readers.Docx.Parse Text.Pandoc.Readers.Docx.Util
                Text.Pandoc.Readers.Docx.StyleMap Text.Pandoc.Readers.Docx.Fields
                Text.Pandoc.Readers.Odt.Base Text.Pandoc.Readers.Odt.Namespaces
                Text.Pandoc.Readers.Odt.StyleReader
                Text.Pandoc.Readers.Odt.ContentReader
                Text.Pandoc.Readers.Odt.Generic.Fallible
                Text.Pandoc.Readers.Odt.Generic.SetMap
                Text.Pandoc.Readers.Odt.Generic.Utils
                Text.Pandoc.Readers.Odt.Generic.Namespaces
                Text.Pandoc.Readers.Odt.Generic.XMLConverter
                Text.Pandoc.Readers.Odt.Arrows.State
                Text.Pandoc.Readers.Odt.Arrows.Utils
                Text.Pandoc.Readers.Org.BlockStarts Text.Pandoc.Readers.Org.Blocks
                Text.Pandoc.Readers.Org.DocumentTree
                Text.Pandoc.Readers.Org.ExportSettings
                Text.Pandoc.Readers.Org.Inlines Text.Pandoc.Readers.Org.Meta
                Text.Pandoc.Readers.Org.ParserState Text.Pandoc.Readers.Org.Parsing
                Text.Pandoc.Readers.Org.Shared
                Text.Pandoc.Writers.Powerpoint.Presentation
                Text.Pandoc.Writers.Powerpoint.Output Text.Pandoc.Lua.Filter
                Text.Pandoc.Lua.Init Text.Pandoc.Lua.Module.MediaBag
                Text.Pandoc.Lua.Module.Pandoc Text.Pandoc.Lua.Module.Utils
                Text.Pandoc.Lua.Packages Text.Pandoc.Lua.StackInstances
                Text.Pandoc.Lua.Util Text.Pandoc.CSS Text.Pandoc.CSV
                Text.Pandoc.UUID Text.Pandoc.Translations Text.Pandoc.Slides
                Paths_pandoc
import-dirs: /usr/lib/ghc-8.4.3/site-local/pandoc-2.2.1
library-dirs: /usr/lib/ghc-8.4.3/site-local/pandoc-2.2.1
dynamic-library-dirs: /usr/lib
data-dir: /usr/share/pandoc
hs-libraries: HSpandoc-2.2.1-JGtIBYdSQK7CWnOawx9MwO
depends:
    base-4.11.1.0 syb-0.7-2jW43lwzJV5e7EQvU8PxV containers-0.5.11.0
    unordered-containers-0.2.9.0-IEc9LFcTDjK6w3ap4NqwQu parsec-3.1.13.0
    mtl-2.2.2 exceptions-0.10.0-391qhPSiPEU3NJgxhfdaPf filepath-1.4.2
    process-1.6.3.0 directory-1.3.1.5 bytestring-0.10.8.2 text-1.2.3.0
    time-1.8.0.2 safe-0.3.17-HEmZRpXGD3s2ywM3rHJ1ur
    zip-archive-0.3.3-9tQAuVw6iLUEb2xhFm7Ksp
    HTTP-4000.3.12-C3QpfbUFMo49OkU01goThe
    texmath-0.11.0.1-BkZSW0NQG5jHfbYn454Of4
    xml-1.3.14-Iiopw2ucwBuIKdlkbvc4Gm
    split-0.2.3.3-DYHuRk05Zl3FsXrGVgC4fG
    random-1.1-9LLJAJa4iQFLJiLXBOBXBV
    pandoc-types-1.17.5.1-3lIJzJyDTMr1lL3BP7yEe8
    aeson-1.3.1.1-4Y3ALHMQQEYEDTh2988ctY
    aeson-pretty-0.8.7-EYGJXM3X4qMFXbdW5aHOem
    tagsoup-0.14.6-7Kjdp42VPmpFTv5v8vSEkC
    base64-bytestring-1.0.0.1-4OCIe2BZn8jKI191JIXI37
    zlib-0.6.2-HJOgVWrPGFTFgWXcvoaUGH
    skylighting-0.7.2-D1V2XlWvaBzE1lxA6gCMtd
    data-default-0.7.1.1-6pNGRUfj5nU7unWVd8ajT0
    temporary-1.3-9EjjXLpJgR32baeNqGeYFf
    blaze-html-0.9.1.1-ImJwSrLxU02EzwI2h3NYFG
    blaze-markup-0.8.2.1-FFkiru1HsegAfMrnqJMDug
    yaml-0.8.31-7owahAs65RJ9HpY0Lv8FB7
    scientific-0.3.6.2-KcBBbCjUUZZKnRSUL2OTul
    vector-0.12.0.1-1fezwShzdEfG3Hp1Pmvjkq
    hslua-0.9.5.2-CX2X6eyDj0FC4ByTGvZ9Rr
    hslua-module-text-0.1.2.1-K4GfIrO5QnpLtE7MQ9tZwg binary-0.8.5.1
    SHA-1.6.4.4-J97i4k52krALB5u9VxmQ73
    haddock-library-1.5.0.1-6c1Is8Q7xrc5y88Tkf9tCy deepseq-1.4.3.0
    JuicyPixels-3.2.9.5-32b8Pvsx9HAXt4Yu6Ulma
    Glob-0.9.2-5yb38ydyVE42JmysXCdmSi
    cmark-gfm-0.1.3-28OjSF4mAR16RhLrmDcrH7
    doctemplates-0.2.2.1-6HICDLfS9817TUE1Thoxis
    http-client-0.5.13-3Kl4d46bfFOKlGDkbjwGGp
    http-client-tls-0.3.5.3-914vPpmkuItIyNRE5gRsD8
    http-types-0.12.1-1FEEescNY7H9pB2LVhivNI
    case-insensitive-1.2.0.11-GjimmYhRn324HWbQThQUra unix-2.7.2.2
    network-uri-2.6.1.0-AstEwZoXrlUJQq4VkxaVo9
    network-2.7.0.1-H3G12S9UXc14r49NrCjVOb
abi-depends: base-4.11.1.0=a3fb1645bafaa89172454c2eea8dfdc9
             syb-0.7-2jW43lwzJV5e7EQvU8PxV=867165047495b4e6f144c8b9b108f918
             containers-0.5.11.0=94bb4831ae701bd40855b2dc2d65cf7c
             unordered-containers-0.2.9.0-IEc9LFcTDjK6w3ap4NqwQu=5b052eced98346d45f3db03378f2841d
             parsec-3.1.13.0=3626e7cedd22de76a8b10339d955721a
             mtl-2.2.2=0b3b35c3b96c7607606ed10087c4aa4a
             exceptions-0.10.0-391qhPSiPEU3NJgxhfdaPf=7910067871295cb7f4f6699a852863a6
             filepath-1.4.2=2408ba322304c0a06810db2d7363214a
             process-1.6.3.0=b58285e21ceee9f67d7be28ddb8b2627
             directory-1.3.1.5=f5fa3aef63d61d9b32ef25d211ef137f
             bytestring-0.10.8.2=9faa89cf4769cbd12751f8644ca9e618
             text-1.2.3.0=9752fd647a108be49a4cb0c2a4456f2b
             time-1.8.0.2=042930fb6746cbaf3bc794f817f8a6b2
             safe-0.3.17-HEmZRpXGD3s2ywM3rHJ1ur=42026212d0dad8beaed25fde58365be8
             zip-archive-0.3.3-9tQAuVw6iLUEb2xhFm7Ksp=fffbfd5093e4fefad19c7747fddd9194
             HTTP-4000.3.12-C3QpfbUFMo49OkU01goThe=efa080f84205f6ae04f9345124512eb5
             texmath-0.11.0.1-BkZSW0NQG5jHfbYn454Of4=c52a9e1bbf1d6133c3d29b4480488b8d
             xml-1.3.14-Iiopw2ucwBuIKdlkbvc4Gm=447f20f46280d63791817d6b9c8e0eb8
             split-0.2.3.3-DYHuRk05Zl3FsXrGVgC4fG=cdf77c47c599317cfa01d2d98185c5d3
             random-1.1-9LLJAJa4iQFLJiLXBOBXBV=2cade9e72fa19fe7a43e5ace84505d9f
             pandoc-types-1.17.5.1-3lIJzJyDTMr1lL3BP7yEe8=af770085d1e0202b1cfec9fa2962f024
             aeson-1.3.1.1-4Y3ALHMQQEYEDTh2988ctY=4a6f3fa3d72c8a9dbe85892dfb85eb93
             aeson-pretty-0.8.7-EYGJXM3X4qMFXbdW5aHOem=e64c2b2f831962507a9ad37b9e3de613
             tagsoup-0.14.6-7Kjdp42VPmpFTv5v8vSEkC=20f59525319cbc5c261121b478cbf532
             base64-bytestring-1.0.0.1-4OCIe2BZn8jKI191JIXI37=65adc4f5f54a1c07291b4ebc49756c05
             zlib-0.6.2-HJOgVWrPGFTFgWXcvoaUGH=8fa648805d93281f19b98bbf203b4b1c
             skylighting-0.7.2-D1V2XlWvaBzE1lxA6gCMtd=82ae873e5ec1e103feec9d9753400c2c
             data-default-0.7.1.1-6pNGRUfj5nU7unWVd8ajT0=e2403b7ea90422302496191f03ca1dc3
             temporary-1.3-9EjjXLpJgR32baeNqGeYFf=5f3b0abdcad1490550c29edc4afc90dc
             blaze-html-0.9.1.1-ImJwSrLxU02EzwI2h3NYFG=c53bb3bf02513bb30eb5ce3eb528e263
             blaze-markup-0.8.2.1-FFkiru1HsegAfMrnqJMDug=71b515c6e3bfb99ff0075cc129b1fc3b
             yaml-0.8.31-7owahAs65RJ9HpY0Lv8FB7=f248e8dd185729e99287e28e1088444c
             scientific-0.3.6.2-KcBBbCjUUZZKnRSUL2OTul=67146f6b2fe2f883da537f78817eb0dd
             vector-0.12.0.1-1fezwShzdEfG3Hp1Pmvjkq=8ec9732a4c43da9ed60d7a7b8971b540
             hslua-0.9.5.2-CX2X6eyDj0FC4ByTGvZ9Rr=8ee0d1cf66270818d038f8219f4c2fdc
             hslua-module-text-0.1.2.1-K4GfIrO5QnpLtE7MQ9tZwg=e1437e2c932edf301b1926d94e684f15
             binary-0.8.5.1=0c28e4e382bf1405fd468e0d2a2b58e5
             SHA-1.6.4.4-J97i4k52krALB5u9VxmQ73=7fdfeaf1e3416ffd434c90cf824fb303
             haddock-library-1.5.0.1-6c1Is8Q7xrc5y88Tkf9tCy=648b40b0193b05a9acfda4c9641240f7
             deepseq-1.4.3.0=34da2d42d10eacba0aad99c95b538637
             JuicyPixels-3.2.9.5-32b8Pvsx9HAXt4Yu6Ulma=08f25432ab0f2edd7f9c9a6839fe5f71
             Glob-0.9.2-5yb38ydyVE42JmysXCdmSi=2e0c28767328ce383047b3d3d84ba8bf
             cmark-gfm-0.1.3-28OjSF4mAR16RhLrmDcrH7=0e690b1d304c9b4105053990835ac3da
             doctemplates-0.2.2.1-6HICDLfS9817TUE1Thoxis=920493bcf341da3dbaad3ae40293aef8
             http-client-0.5.13-3Kl4d46bfFOKlGDkbjwGGp=08ed2990fe4124043525924df120813a
             http-client-tls-0.3.5.3-914vPpmkuItIyNRE5gRsD8=783174f06afa209b1c7224a9e2ce9159
             http-types-0.12.1-1FEEescNY7H9pB2LVhivNI=b54600906e288a2a11c67e3d97adc11c
             case-insensitive-1.2.0.11-GjimmYhRn324HWbQThQUra=0a5994e39a32f328ff4f350b25844411
             unix-2.7.2.2=f81aa481840dadf9c364a1cea96978c0
             network-uri-2.6.1.0-AstEwZoXrlUJQq4VkxaVo9=4ea8f0efa7a1ade0af4e9ce0cffcff8c
             network-2.7.0.1-H3G12S9UXc14r49NrCjVOb=29a1441cc5e4aeb97125018af3ab80ef
haddock-interfaces: /usr/share/doc/pandoc/html/pandoc.haddock
haddock-html: /usr/share/doc/pandoc/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

