#ifndef EFL_OBSERVER_EO_HH
#define EFL_OBSERVER_EO_HH
#include <Eo.h>

extern "C" {
#include "efl_object.eo.h"
#include "efl_observer.eo.h"
}
#include <Eina.hh>
#include <Eo.hh>
#include "efl_object.eo.hh"
namespace efl { 
struct Observer;
} 
namespace efl { namespace eo { template<> struct is_eolian_object< ::efl::Observer> : ::std::true_type {}; } }
namespace efl { 
struct Observer;
} 
namespace efl { 
struct Object;
} 

namespace eo_cxx {
namespace efl { 
struct Observer {
   ::efl::eolian::return_traits<void>::type update( ::efl::eolian::in_traits< ::efl::Object>::type obs,  ::efl::eolian::in_traits< ::efl::eina::string_view>::type key,  ::efl::eolian::in_traits<void*>::type data) const;
   static Efl_Class const* _eo_class()
   {
      return EFL_OBSERVER_INTERFACE;
   }
   Eo* _eo_ptr() const { return *(Eo**)this; }
   operator ::efl::Observer() const;
   operator ::efl::Observer&();
   operator ::efl::Observer const&() const;
   /// @cond LOCAL
    ::efl::eolian::address_of_operator<Observer> operator&() { return {this}; }
    ::efl::eolian::address_of_operator<Observer const > operator&() const { return {this}; }
   /// @endcond
};
} 
}
namespace efl { 
struct Observer : ::efl::eo::concrete
{
   explicit Observer( ::Eo* eo)
      : ::efl::eo::concrete(eo) {}
   explicit Observer(std::nullptr_t)
      : ::efl::eo::concrete(nullptr) {}
   Observer(Observer const& other) = default;
   Observer(Observer&& other) = default;
   Observer& operator=(Observer const& other) = default;
   Observer& operator=(Observer&& other) = default;
   Observer()
   {
      ::efl::eolian::do_eo_add( ::efl::eo::concrete::_eo_raw, ::efl::eo::concrete{nullptr}, _eo_class());
   }
   Observer( ::efl::eo::concrete parent)
   {
      ::efl::eolian::do_eo_add( ::efl::eo::concrete::_eo_raw, parent, _eo_class());
   }
   template <typename F> Observer(F f, typename ::std::enable_if< ::efl::eolian::is_callable<F>::value>::type* = 0)
   {
      ::efl::eolian::do_eo_add( ::efl::eo::concrete::_eo_raw, ::efl::eo::concrete{nullptr}, _eo_class(), f);
   }
   ::efl::eolian::return_traits<void>::type update( ::efl::eolian::in_traits< ::efl::Object>::type obs,  ::efl::eolian::in_traits< ::efl::eina::string_view>::type key,  ::efl::eolian::in_traits<void*>::type data) const;
   static Efl_Class const* _eo_class()
   {
      return EFL_OBSERVER_INTERFACE;
   }
   Eo* _eo_ptr() const { return *(Eo**)this; }
   /// @cond LOCAL
    ::efl::eolian::address_of_operator<Observer> operator&() { return {this}; }
    ::efl::eolian::address_of_operator<Observer const > operator&() const { return {this}; }
   /// @endcond
};
static_assert(sizeof(Observer) == sizeof(Eo*), "");
static_assert(std::is_standard_layout<Observer>::value, "");
} 
#endif
