/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.swing.plaf.gtk;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.border.Border;

public class AdaptiveMatteBorder
implements Border {
    private Insets insets;
    private int shadowDepth;
    private boolean topLeftInsets;
    private static final float[] comps = new float[4];
    private static final float[] targs = new float[4];

    public AdaptiveMatteBorder(boolean bl, boolean bl2, boolean bl3, boolean bl4, int n, boolean bl5) {
        this.insets = new Insets(bl ? (bl5 ? n + 1 : 1) : 0, bl2 ? (bl5 ? n + 1 : 1) : 0, bl3 ? 1 + n : n, bl4 ? 1 + n : n);
        this.shadowDepth = n;
        this.topLeftInsets = bl5;
    }

    public AdaptiveMatteBorder(boolean bl, boolean bl2, boolean bl3, boolean bl4, int n) {
        this(bl, bl2, bl3, bl4, n, false);
    }

    private Insets maybeOmitInsets(Insets insets, Component component) {
        if (this.shadowDepth <= 0 || !this.topLeftInsets) {
            return insets;
        }
        Insets insets2 = new Insets(insets.top, insets.left, insets.right, insets.bottom);
        if (this.topLeftInsets) {
            Point point = component.getLocation();
            if (point.x > 10) {
                insets2.left = 1;
            }
            if (point.y > 10) {
                insets2.top = 1;
            }
        }
        return insets2;
    }

    @Override
    public Insets getBorderInsets(Component component) {
        return this.maybeOmitInsets(this.insets, component);
    }

    @Override
    public boolean isBorderOpaque() {
        return false;
    }

    @Override
    public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
        Color color = graphics.getColor();
        Insets insets = this.getBorderInsets(component);
        Point point = component.getLocation();
        graphics.setColor(UIManager.getColor("controlShadow"));
        n3 -= this.shadowDepth;
        n4 -= this.shadowDepth;
        if (this.topLeftInsets) {
            if (point.y <= 10) {
                n2 += this.shadowDepth;
                n4 -= this.shadowDepth;
            }
            if (point.x <= 10) {
                n += this.shadowDepth;
                n3 -= this.shadowDepth;
            }
        }
        if (insets.top > 0) {
            graphics.fillRect(n, n2, n3, 1);
        }
        if (insets.left > 0) {
            graphics.fillRect(n, n2, 1, n4);
        }
        if (insets.right > 0) {
            graphics.fillRect(n + n3 - 1, n2, 1, n4);
        }
        if (insets.bottom > 0) {
            graphics.fillRect(n, n2 + n4 - 1, n3, 1);
        }
        boolean bl = AdaptiveMatteBorder.isViewTab(component);
        if (this.shadowDepth > 1) {
            boolean bl2;
            Rectangle rectangle = graphics.getClipBounds();
            boolean bl3 = rectangle.x + rectangle.width >= n + n3;
            boolean bl4 = bl2 = rectangle.y + rectangle.height >= n2 + n4;
            if (bl2 || bl3) {
                Color color2 = UIManager.getColor("control");
                Color color3 = UIManager.getColor("controlShadow");
                for (int i = 1; i < this.shadowDepth; ++i) {
                    Color color4 = AdaptiveMatteBorder.colorTowards(color3, color2, this.shadowDepth, i + 1);
                    graphics.setColor(color4);
                    if (bl3 && insets.right > 0) {
                        graphics.fillRect(n + n3 - 1 + i, n2 + (bl ? 0 : i), 1, n4);
                    }
                    if (!bl2 || insets.bottom <= 0) continue;
                    graphics.fillRect(n + i, n2 + n4 - 1 + i, n3 - 1, 1);
                }
            }
        }
        graphics.setColor(color);
    }

    static boolean isViewTab(Component component) {
        JComponent jComponent;
        Object object;
        if (component.getParent() instanceof JComponent && (object = (jComponent = (JComponent)component.getParent()).getClientProperty("viewType")) != null && object instanceof Integer) {
            return (Integer)object == 0;
        }
        return false;
    }

    static final Color colorTowards(Color color, Color color2, float f, float f2) {
        color.getColorComponents(comps);
        color2.getColorComponents(targs);
        AdaptiveMatteBorder.comps[3] = 1.0f;
        float f3 = f2 / f;
        for (int i = 0; i < 3; ++i) {
            AdaptiveMatteBorder.comps[i] = AdaptiveMatteBorder.saturate(comps[i] - f3 * (comps[i] - targs[i]));
        }
        Color color3 = new Color(comps[0], comps[1], comps[2], comps[3]);
        return color3;
    }

    private static final float saturate(float f) {
        float f2 = f;
        if (f > 1.0f) {
            f = 1.0f;
        }
        if (f < 0.0f) {
            f = 0.0f;
        }
        return f;
    }
}

