/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.components;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import javax.swing.JSplitPane;
import javax.swing.plaf.basic.BasicSplitPaneUI;
import org.netbeans.lib.profiler.ui.components.JTitledPanel;

public class JExtendedSplitPane
extends JSplitPane {
    private ActionListener splitPaneActionListener = new SplitPaneActionListener();
    private ComponentListener splitPaneComponentListener = new SplitPaneComponentListener();
    private double dividerLocation;
    private int dividerSize;

    public JExtendedSplitPane() {
    }

    public JExtendedSplitPane(int n) {
        super(n);
    }

    public JExtendedSplitPane(int n, boolean bl) {
        super(n, bl);
    }

    public JExtendedSplitPane(int n, boolean bl, Component component, Component component2) {
        super(n, bl, component, component2);
        this.registerListeners(component);
        this.registerListeners(component2);
        this.updateVisibility();
        if (!component.isVisible()) {
            this.computeDividerLocationWhenInitiallyHidden(component);
        }
        if (!component2.isVisible()) {
            this.computeDividerLocationWhenInitiallyHidden(component2);
        }
    }

    public JExtendedSplitPane(int n, Component component, Component component2) {
        super(n, component, component2);
        this.registerListeners(component);
        this.registerListeners(component2);
        this.updateVisibility();
        if (!component.isVisible()) {
            this.computeDividerLocationWhenInitiallyHidden(component);
        }
        if (!component2.isVisible()) {
            this.computeDividerLocationWhenInitiallyHidden(component2);
        }
    }

    @Override
    public void setBottomComponent(Component component) {
        this.setRightComponent(component);
    }

    @Override
    public void setDividerSize(int n) {
        super.setDividerSize(n);
        this.dividerSize = n;
    }

    @Override
    public void setLeftComponent(Component component) {
        if (this.getLeftComponent() != null) {
            this.unregisterListeners(this.getLeftComponent());
        }
        super.setLeftComponent(component);
        if (this.getLeftComponent() != null) {
            this.registerListeners(this.getLeftComponent());
        }
        this.updateVisibility();
    }

    @Override
    public void setRightComponent(Component component) {
        if (this.getRightComponent() != null) {
            this.unregisterListeners(this.getRightComponent());
        }
        super.setRightComponent(component);
        if (this.getRightComponent() != null) {
            this.registerListeners(this.getRightComponent());
        }
        this.updateVisibility();
    }

    @Override
    public void setTopComponent(Component component) {
        this.setLeftComponent(component);
    }

    private Component getDivider() {
        if (this.getUI() == null) {
            return null;
        }
        return ((BasicSplitPaneUI)this.getUI()).getDivider();
    }

    private Component getFirstComponent() {
        if (this.getOrientation() == 1) {
            return this.getLeftComponent();
        }
        return this.getTopComponent();
    }

    private Component getSecondComponent() {
        if (this.getOrientation() == 1) {
            return this.getRightComponent();
        }
        return this.getBottomComponent();
    }

    private void computeDividerLocationWhenHidden(Component component) {
        if (this.getTopComponent().isVisible() || this.getBottomComponent().isVisible()) {
            this.dividerLocation = this.getOrientation() == 1 ? (component == this.getFirstComponent() ? (double)component.getSize().width / (this.getSize().getWidth() - (double)this.dividerSize) : (this.getSize().getWidth() - (double)this.dividerSize - (double)component.getSize().width) / (this.getSize().getWidth() - (double)this.dividerSize)) : (component == this.getFirstComponent() ? (double)component.getSize().height / (this.getSize().getHeight() - (double)this.dividerSize) : (this.getSize().getHeight() - (double)this.dividerSize - (double)component.getSize().height) / (this.getSize().getHeight() - (double)this.dividerSize));
        }
    }

    private void computeDividerLocationWhenInitiallyHidden(Component component) {
        if (this.getTopComponent().isVisible() || this.getBottomComponent().isVisible()) {
            this.dividerLocation = this.getOrientation() == 1 ? (component == this.getFirstComponent() ? (double)component.getPreferredSize().width / (this.getPreferredSize().getWidth() - (double)this.dividerSize) : (this.getPreferredSize().getWidth() - (double)this.dividerSize - (double)component.getPreferredSize().width) / (this.getPreferredSize().getWidth() - (double)this.dividerSize)) : (component == this.getFirstComponent() ? (double)component.getPreferredSize().height / (this.getPreferredSize().getHeight() - (double)this.dividerSize) : (this.getPreferredSize().getHeight() - (double)this.dividerSize - (double)component.getPreferredSize().height) / (this.getPreferredSize().getHeight() - (double)this.dividerSize));
        }
    }

    private void registerListeners(Component component) {
        if (this.splitPaneComponentListener != null) {
            component.addComponentListener(this.splitPaneComponentListener);
        }
        if (this.splitPaneActionListener != null && component instanceof JTitledPanel) {
            ((JTitledPanel)component).addActionListener(this.splitPaneActionListener);
        }
    }

    private void unregisterListeners(Component component) {
        if (this.splitPaneComponentListener != null) {
            component.removeComponentListener(this.splitPaneComponentListener);
        }
        if (this.splitPaneActionListener != null && component instanceof JTitledPanel) {
            ((JTitledPanel)component).removeActionListener(this.splitPaneActionListener);
        }
    }

    private void updateVisibility() {
        Component component = this.getFirstComponent();
        Component component2 = this.getSecondComponent();
        Component component3 = this.getDivider();
        if (component == null || component2 == null || component3 == null) {
            return;
        }
        if (component.isVisible() && component2.isVisible()) {
            if (!component3.isVisible()) {
                super.setDividerSize(this.dividerSize);
                component3.setVisible(true);
                this.setDividerLocation(this.dividerLocation);
            }
            if (!this.isVisible()) {
                this.setVisible(true);
            }
        } else if (!component.isVisible() && !component2.isVisible()) {
            if (this.isVisible()) {
                this.setVisible(false);
            }
        } else {
            if (component3.isVisible()) {
                super.setDividerSize(0);
                component3.setVisible(false);
                this.setDividerLocation(0);
            }
            if (!this.isVisible()) {
                this.setVisible(true);
            }
        }
    }

    private class SplitPaneComponentListener
    extends ComponentAdapter {
        private SplitPaneComponentListener() {
        }

        @Override
        public void componentHidden(ComponentEvent componentEvent) {
            JExtendedSplitPane.this.computeDividerLocationWhenHidden(componentEvent.getComponent());
            if (JExtendedSplitPane.this.dividerLocation == 0.0 || JExtendedSplitPane.this.dividerLocation == 1.0) {
                JExtendedSplitPane.this.dividerLocation = 0.5;
            }
            JExtendedSplitPane.this.updateVisibility();
        }

        @Override
        public void componentShown(ComponentEvent componentEvent) {
            JExtendedSplitPane.this.updateVisibility();
        }
    }

    private class SplitPaneActionListener
    implements ActionListener {
        private SplitPaneActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            switch (actionEvent.getID()) {
                case 1000: {
                    break;
                }
                case 1001: {
                    JExtendedSplitPane.this.setDividerLocation(JExtendedSplitPane.this.getLastDividerLocation());
                    break;
                }
                case 1002: {
                    break;
                }
                case 1003: {
                    if (actionEvent.getSource() == JExtendedSplitPane.this.getFirstComponent()) {
                        JExtendedSplitPane.this.setDividerLocation(((JExtendedSplitPane)JExtendedSplitPane.this).getFirstComponent().getPreferredSize().height);
                        break;
                    }
                    JExtendedSplitPane.this.setDividerLocation(JExtendedSplitPane.this.getSize().height - JExtendedSplitPane.this.dividerSize - ((JExtendedSplitPane)JExtendedSplitPane.this).getSecondComponent().getPreferredSize().height);
                }
            }
        }
    }
}

