/*
 * Decompiled with CFR 0.152.
 */
package com.zeroc.IceGridGUI.Application;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.zeroc.IceGrid.TemplateDescriptor;
import com.zeroc.IceGridGUI.Application.Communicator;
import com.zeroc.IceGridGUI.Application.Editor;
import com.zeroc.IceGridGUI.Application.ParametersField;
import com.zeroc.IceGridGUI.Application.Root;
import com.zeroc.IceGridGUI.Application.Templates;
import com.zeroc.IceGridGUI.Application.UpdateFailedException;
import java.awt.Component;
import java.util.LinkedList;
import java.util.Map;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextField;

class TemplateEditor
extends Editor {
    private JTextField _template = new JTextField(20);
    private ParametersField _parameters;

    TemplateEditor() {
        this._template.getDocument().addDocumentListener(this._updateListener);
        this._template.setToolTipText("Must be unique within the enclosing application");
        this._parameters = new ParametersField(this);
    }

    TemplateDescriptor getDescriptor() {
        return (TemplateDescriptor)this._target.getDescriptor();
    }

    @Override
    Object getSubDescriptor() {
        return this.getDescriptor().descriptor;
    }

    void writeDescriptor() {
        TemplateDescriptor descriptor = this.getDescriptor();
        LinkedList<String> parameters = new LinkedList<String>();
        descriptor.parameterDefaults = this._parameters.get(parameters);
        descriptor.parameters = parameters;
    }

    boolean isSimpleUpdate() {
        TemplateDescriptor descriptor = this.getDescriptor();
        LinkedList<String> parameters = new LinkedList<String>();
        Map<String, String> defaultValues = this._parameters.get(parameters);
        return descriptor.parameters.equals(parameters) && descriptor.parameterDefaults.equals(defaultValues);
    }

    @Override
    protected void appendProperties(DefaultFormBuilder builder) {
        builder.append("Template ID");
        builder.append((Component)this._template, 3);
        builder.nextLine();
        builder.append("Parameters");
        builder.nextLine();
        builder.append("");
        builder.nextLine();
        builder.append("");
        builder.nextLine();
        builder.append("");
        builder.nextRow(-6);
        JScrollPane scrollPane = new JScrollPane(this._parameters);
        CellConstraints cc = new CellConstraints();
        builder.add((Component)scrollPane, cc.xywh(builder.getColumn(), builder.getRow(), 3, 7));
        builder.nextRow(6);
        builder.nextLine();
    }

    @Override
    protected boolean validate() {
        return this.check(new String[]{"Template ID", this._template.getText().trim()});
    }

    void show() {
        TemplateDescriptor descriptor = this.getDescriptor();
        this._template.setText(this._target.getId());
        this._template.setEditable(this._target.isEphemeral());
        this._parameters.set(descriptor.parameters, descriptor.parameterDefaults);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean applyUpdate(boolean refresh) {
        Root root = this._target.getRoot();
        root.disableSelectionListener();
        try {
            if (this._target.isEphemeral()) {
                this.writeDescriptor();
                TemplateDescriptor descriptor = this.getDescriptor();
                Templates parent = (Templates)this._target.getParent();
                this._target.destroy();
                try {
                    parent.tryAdd(this._template.getText().trim(), descriptor);
                }
                catch (UpdateFailedException e) {
                    block18: {
                        try {
                            parent.insertChild(this._target, true);
                        }
                        catch (UpdateFailedException die) {
                            if ($assertionsDisabled) break block18;
                            throw new AssertionError();
                        }
                    }
                    root.setSelectedNode(this._target);
                    JOptionPane.showMessageDialog(this._target.getCoordinator().getMainFrame(), e.toString(), "Apply failed", 0);
                    boolean bl = false;
                    root.enableSelectionListener();
                    return bl;
                }
                this._target = parent.findChildWithDescriptor(descriptor);
                root.updated();
                this._template.setEditable(false);
                if (refresh) {
                    root.setSelectedNode(this._target);
                }
            } else if (this.isSimpleUpdate()) {
                this.writeDescriptor();
                ((Communicator)this._target).getEnclosingEditable().markModified();
                root.updated();
            } else {
                Object savedDescriptor = ((Communicator)this._target).saveDescriptor();
                Templates parent = (Templates)this._target.getParent();
                this.writeDescriptor();
                try {
                    parent.tryUpdate((Communicator)this._target);
                }
                catch (UpdateFailedException e) {
                    ((Communicator)this._target).restoreDescriptor(savedDescriptor);
                    JOptionPane.showMessageDialog(this._target.getCoordinator().getMainFrame(), e.toString(), "Apply failed", 0);
                    boolean bl = false;
                    root.enableSelectionListener();
                    return bl;
                }
                ((Communicator)this._target).getEnclosingEditable().markModified();
                root.updated();
                this._target = parent.findChildWithDescriptor(this.getDescriptor());
                if (refresh) {
                    root.setSelectedNode(this._target);
                }
            }
            if (refresh) {
                root.getCoordinator().getCurrentTab().showNode(this._target);
            }
            this._applyButton.setEnabled(false);
            this._discardButton.setEnabled(false);
            boolean bl = true;
            return bl;
        }
        finally {
            root.enableSelectionListener();
        }
    }
}

