/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.snaptracer.impl.swing;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JToggleButton;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public final class DropdownButton
extends JToggleButton {
    public static final String KEY_CLASS = "KEY_CLASS";
    public static final String KEY_BOOLVALUE = "KEY_BOOLVALUE";
    private final List<Action> actions = new ArrayList<Action>();

    public DropdownButton(Icon icon) {
        super(icon);
    }

    public void addAction(Action action) {
        this.actions.add(action);
    }

    public void addSeparator() {
        this.actions.add(null);
    }

    @Override
    protected void fireActionPerformed(ActionEvent actionEvent) {
        JPopupMenu jPopupMenu = new JPopupMenu();
        for (Action action : this.actions) {
            this.addAction(jPopupMenu, action);
        }
        jPopupMenu.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
                DropdownButton.this.setSelected(true);
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
                DropdownButton.this.setSelected(false);
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
            }
        });
        jPopupMenu.show(this, this.getWidth() - jPopupMenu.getPreferredSize().width, this.getHeight());
    }

    private void addAction(JPopupMenu jPopupMenu, Action action) {
        if (action == null) {
            jPopupMenu.addSeparator();
        } else {
            Class clazz = (Class)action.getValue(KEY_CLASS);
            if (Boolean.class.equals((Object)clazz)) {
                Boolean bl = (Boolean)action.getValue(KEY_BOOLVALUE);
                JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem(action);
                jCheckBoxMenuItem.setSelected(bl);
                jPopupMenu.add(jCheckBoxMenuItem);
            } else {
                jPopupMenu.add(action);
            }
        }
    }
}

