/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authc;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.elasticsearch.bootstrap.BootstrapCheck;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.set.Sets;
import org.elasticsearch.env.Environment;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.watcher.ResourceWatcherService;
import org.elasticsearch.xpack.core.security.authc.Realm;
import org.elasticsearch.xpack.core.security.authc.RealmConfig;
import org.elasticsearch.xpack.core.security.authc.RealmSettings;
import org.elasticsearch.xpack.core.ssl.SSLService;
import org.elasticsearch.xpack.security.SecurityLifecycleService;
import org.elasticsearch.xpack.security.authc.esnative.NativeRealm;
import org.elasticsearch.xpack.security.authc.esnative.NativeUsersStore;
import org.elasticsearch.xpack.security.authc.file.FileRealm;
import org.elasticsearch.xpack.security.authc.ldap.LdapRealm;
import org.elasticsearch.xpack.security.authc.pki.PkiRealm;
import org.elasticsearch.xpack.security.authc.saml.SamlRealm;
import org.elasticsearch.xpack.security.authc.support.RoleMappingFileBootstrapCheck;
import org.elasticsearch.xpack.security.authc.support.mapper.NativeRoleMappingStore;

public final class InternalRealms {
    private static final Set<String> XPACK_TYPES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("native", "file", "active_directory", "ldap", "pki", "saml")));
    private static final Set<String> STANDARD_TYPES = Collections.unmodifiableSet(Sets.difference(XPACK_TYPES, Collections.singleton("saml")));

    static boolean isXPackRealm(String type) {
        if (XPACK_TYPES.contains(type)) {
            return true;
        }
        return "reserved".equals(type);
    }

    static boolean isStandardRealm(String type) {
        return STANDARD_TYPES.contains(type);
    }

    public static Map<String, Realm.Factory> getFactories(ThreadPool threadPool, ResourceWatcherService resourceWatcherService, SSLService sslService, NativeUsersStore nativeUsersStore, NativeRoleMappingStore nativeRoleMappingStore, SecurityLifecycleService securityLifecycleService) {
        HashMap<String, Realm.Factory> map = new HashMap<String, Realm.Factory>();
        map.put("file", config -> new FileRealm(config, resourceWatcherService));
        map.put("native", config -> {
            NativeRealm nativeRealm = new NativeRealm(config, nativeUsersStore);
            securityLifecycleService.addSecurityIndexHealthChangeListener(nativeRealm::onSecurityIndexHealthChange);
            return nativeRealm;
        });
        map.put("active_directory", config -> new LdapRealm("active_directory", config, sslService, resourceWatcherService, nativeRoleMappingStore, threadPool));
        map.put("ldap", config -> new LdapRealm("ldap", config, sslService, resourceWatcherService, nativeRoleMappingStore, threadPool));
        map.put("pki", config -> new PkiRealm(config, resourceWatcherService, nativeRoleMappingStore));
        map.put("saml", config -> SamlRealm.create(config, sslService, resourceWatcherService, nativeRoleMappingStore));
        return Collections.unmodifiableMap(map);
    }

    private InternalRealms() {
    }

    public static List<BootstrapCheck> getBootstrapChecks(Settings globalSettings, Environment env) {
        ArrayList<BootstrapCheck> checks = new ArrayList<BootstrapCheck>();
        Map settingsByRealm = RealmSettings.getRealmSettings((Settings)globalSettings);
        settingsByRealm.forEach((name, settings) -> {
            RealmConfig realmConfig = new RealmConfig(name, settings, globalSettings, env, null);
            switch (realmConfig.type()) {
                case "active_directory": 
                case "ldap": 
                case "pki": {
                    BootstrapCheck check = RoleMappingFileBootstrapCheck.create(realmConfig);
                    if (check == null) break;
                    checks.add(check);
                }
            }
        });
        return checks;
    }
}

