/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authc.ldap.support;

import com.unboundid.ldap.sdk.LDAPConnectionOptions;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPURL;
import com.unboundid.ldap.sdk.ServerSet;
import com.unboundid.util.ssl.HostNameSSLSocketVerifier;
import com.unboundid.util.ssl.SSLSocketVerifier;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import javax.net.ssl.SSLSocketFactory;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.common.settings.SecureString;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xpack.core.security.authc.RealmConfig;
import org.elasticsearch.xpack.core.security.authc.RealmSettings;
import org.elasticsearch.xpack.core.security.authc.ldap.support.SessionFactorySettings;
import org.elasticsearch.xpack.core.ssl.SSLConfigurationSettings;
import org.elasticsearch.xpack.core.ssl.SSLService;
import org.elasticsearch.xpack.core.ssl.VerificationMode;
import org.elasticsearch.xpack.security.authc.ldap.support.LdapLoadBalancing;
import org.elasticsearch.xpack.security.authc.ldap.support.LdapSession;

public abstract class SessionFactory {
    private static final Pattern STARTS_WITH_LDAPS = Pattern.compile("^ldaps:.*", 2);
    private static final Pattern STARTS_WITH_LDAP = Pattern.compile("^ldap:.*", 2);
    protected final Logger logger;
    protected final RealmConfig config;
    protected final TimeValue timeout;
    protected final SSLService sslService;
    protected final ThreadPool threadPool;
    protected final ServerSet serverSet;
    protected final boolean sslUsed;
    protected final boolean ignoreReferralErrors;

    protected SessionFactory(RealmConfig config, SSLService sslService, ThreadPool threadPool) {
        this.config = config;
        this.logger = config.logger(this.getClass());
        Settings settings = config.settings();
        TimeValue searchTimeout = settings.getAsTime("timeout.ldap_search", SessionFactorySettings.TIMEOUT_DEFAULT);
        if (searchTimeout.millis() < 1000L) {
            this.logger.warn("ldap_search timeout [{}] is less than the minimum supported search timeout of 1s. using 1s", (Object)searchTimeout.millis());
            searchTimeout = TimeValue.timeValueSeconds((long)1L);
        }
        this.timeout = searchTimeout;
        this.sslService = sslService;
        this.threadPool = threadPool;
        LDAPServers ldapServers = this.ldapServers(settings);
        this.serverSet = this.serverSet(config, sslService, ldapServers);
        this.sslUsed = ldapServers.ssl;
        this.ignoreReferralErrors = (Boolean)SessionFactorySettings.IGNORE_REFERRAL_ERRORS_SETTING.get(settings);
    }

    public abstract void session(String var1, SecureString var2, ActionListener<LdapSession> var3);

    public boolean supportsUnauthenticatedSession() {
        return false;
    }

    public void unauthenticatedSession(String username, ActionListener<LdapSession> listener) {
        throw new UnsupportedOperationException("unauthenticated sessions are not supported");
    }

    protected static LDAPConnectionOptions connectionOptions(RealmConfig config, SSLService sslService, Logger logger) {
        boolean hostnameVerficationExists;
        Settings realmSettings = config.settings();
        LDAPConnectionOptions options = new LDAPConnectionOptions();
        options.setConnectTimeoutMillis(Math.toIntExact(realmSettings.getAsTime("timeout.tcp_connect", SessionFactorySettings.TIMEOUT_DEFAULT).millis()));
        options.setFollowReferrals(realmSettings.getAsBoolean("follow_referrals", Boolean.valueOf(true)).booleanValue());
        options.setResponseTimeoutMillis(realmSettings.getAsTime("timeout.tcp_read", SessionFactorySettings.TIMEOUT_DEFAULT).millis());
        options.setAllowConcurrentSocketFactoryUse(true);
        SSLConfigurationSettings sslConfigurationSettings = SSLConfigurationSettings.withoutPrefix();
        Settings realmSSLSettings = realmSettings.getByPrefix("ssl.");
        boolean verificationModeExists = sslConfigurationSettings.verificationMode.exists(realmSSLSettings);
        boolean bl = hostnameVerficationExists = realmSettings.get("hostname_verification", null) != null;
        if (verificationModeExists && hostnameVerficationExists) {
            throw new IllegalArgumentException("[hostname_verification] and [" + sslConfigurationSettings.verificationMode.getKey() + "] may not be used at the same time");
        }
        if (verificationModeExists) {
            VerificationMode verificationMode = sslService.getVerificationMode(realmSSLSettings, Settings.EMPTY);
            if (verificationMode == VerificationMode.FULL) {
                options.setSSLSocketVerifier((SSLSocketVerifier)new HostNameSSLSocketVerifier(true));
            }
        } else if (hostnameVerficationExists) {
            new DeprecationLogger(logger).deprecated("the setting [{}] has been deprecated and will be removed in a future version. use [{}] instead", new Object[]{RealmSettings.getFullSettingKey((RealmConfig)config, (String)"hostname_verification"), RealmSettings.getFullSettingKey((RealmConfig)config, (String)("ssl." + sslConfigurationSettings.verificationMode.getKey()))});
            if (realmSettings.getAsBoolean("hostname_verification", Boolean.valueOf(true)).booleanValue()) {
                options.setSSLSocketVerifier((SSLSocketVerifier)new HostNameSSLSocketVerifier(true));
            }
        } else {
            options.setSSLSocketVerifier((SSLSocketVerifier)new HostNameSSLSocketVerifier(true));
        }
        return options;
    }

    private LDAPServers ldapServers(Settings settings) {
        List ldapUrls = settings.getAsList("url", this.getDefaultLdapUrls(settings));
        if (ldapUrls == null || ldapUrls.isEmpty()) {
            throw new IllegalArgumentException("missing required LDAP setting [url]");
        }
        return new LDAPServers(ldapUrls.toArray(new String[ldapUrls.size()]));
    }

    protected List<String> getDefaultLdapUrls(Settings settings) {
        return null;
    }

    private ServerSet serverSet(RealmConfig realmConfig, SSLService clientSSLService, LDAPServers ldapServers) {
        Settings settings = realmConfig.settings();
        SSLSocketFactory socketFactory = null;
        if (ldapServers.ssl()) {
            socketFactory = clientSSLService.sslSocketFactory(settings.getByPrefix("ssl."));
            if (settings.getAsBoolean("hostname_verification", Boolean.valueOf(true)).booleanValue()) {
                this.logger.debug("using encryption for LDAP connections with hostname verification");
            } else {
                this.logger.debug("using encryption for LDAP connections without hostname verification");
            }
        }
        return LdapLoadBalancing.serverSet(ldapServers.addresses(), ldapServers.ports(), settings, socketFactory, SessionFactory.connectionOptions(realmConfig, this.sslService, this.logger));
    }

    ServerSet getServerSet() {
        return this.serverSet;
    }

    public boolean isSslUsed() {
        return this.sslUsed;
    }

    public static class LDAPServers {
        private final String[] addresses;
        private final int[] ports;
        private final boolean ssl;

        public LDAPServers(String[] urls) {
            this.ssl = this.secureUrls(urls);
            this.addresses = new String[urls.length];
            this.ports = new int[urls.length];
            for (int i = 0; i < urls.length; ++i) {
                try {
                    LDAPURL url = new LDAPURL(urls[i]);
                    this.addresses[i] = url.getHost();
                    this.ports[i] = url.getPort();
                    continue;
                }
                catch (LDAPException e) {
                    throw new IllegalArgumentException("unable to parse configured LDAP url [" + urls[i] + "]", e);
                }
            }
        }

        public String[] addresses() {
            return this.addresses;
        }

        public int[] ports() {
            return this.ports;
        }

        public boolean ssl() {
            return this.ssl;
        }

        private boolean secureUrls(String[] ldapUrls) {
            if (ldapUrls.length == 0) {
                return true;
            }
            boolean allSecure = Arrays.stream(ldapUrls).allMatch(s -> STARTS_WITH_LDAPS.matcher((CharSequence)s).find());
            boolean allClear = Arrays.stream(ldapUrls).allMatch(s -> STARTS_WITH_LDAP.matcher((CharSequence)s).find());
            if (!allSecure && !allClear) {
                throw new IllegalArgumentException("configured LDAP protocols are not all equal (ldaps://.. and ldap://..): [" + Strings.arrayToCommaDelimitedString((Object[])ldapUrls) + "]");
            }
            return allSecure;
        }
    }
}

