/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.lucene.index.IndexOptions;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.Version;
import org.elasticsearch.common.Booleans;
import org.elasticsearch.common.joda.FormatDateTimeFormatter;
import org.elasticsearch.common.joda.Joda;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.elasticsearch.index.analysis.NamedAnalyzer;
import org.elasticsearch.index.mapper.DocumentMapperParser;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.similarity.SimilarityProvider;

public class TypeParsers {
    public static final String DOC_VALUES = "doc_values";
    public static final String INDEX_OPTIONS_DOCS = "docs";
    public static final String INDEX_OPTIONS_FREQS = "freqs";
    public static final String INDEX_OPTIONS_POSITIONS = "positions";
    public static final String INDEX_OPTIONS_OFFSETS = "offsets";
    private static final DeprecationLogger DEPRECATION_LOGGER = new DeprecationLogger(Loggers.getLogger(TypeParsers.class));

    public static boolean nodeBooleanValue(String fieldName, String propertyName, Object node, Mapper.TypeParser.ParserContext parserContext) {
        if (parserContext.indexVersionCreated().onOrAfter(Version.V_6_0_0_alpha1)) {
            return XContentMapValues.nodeBooleanValue(node, fieldName + "." + propertyName);
        }
        return TypeParsers.nodeBooleanValueLenient(fieldName, propertyName, node);
    }

    public static boolean nodeBooleanValueLenient(String fieldName, String propertyName, Object node) {
        if (!Booleans.isBoolean(node.toString())) {
            DEPRECATION_LOGGER.deprecated("Expected a boolean for property [{}] for field [{}] but got [{}]", propertyName, fieldName, node);
        }
        if (node instanceof Boolean) {
            return (Boolean)node;
        }
        if (node instanceof Number) {
            return ((Number)node).intValue() != 0;
        }
        boolean value = Booleans.parseBooleanLenient(node.toString(), false);
        return value;
    }

    private static void parseAnalyzersAndTermVectors(FieldMapper.Builder builder, String name, Map<String, Object> fieldNode, Mapper.TypeParser.ParserContext parserContext) {
        NamedAnalyzer indexAnalyzer = null;
        NamedAnalyzer searchAnalyzer = null;
        NamedAnalyzer searchQuoteAnalyzer = null;
        Iterator<Map.Entry<String, Object>> iterator = fieldNode.entrySet().iterator();
        while (iterator.hasNext()) {
            NamedAnalyzer analyzer;
            Map.Entry<String, Object> entry = iterator.next();
            String propName = entry.getKey();
            Object propNode = entry.getValue();
            if (propName.equals("term_vector")) {
                TypeParsers.parseTermVector(name, propNode.toString(), builder);
                iterator.remove();
                continue;
            }
            if (propName.equals("store_term_vectors")) {
                builder.storeTermVectors(TypeParsers.nodeBooleanValue(name, "store_term_vectors", propNode, parserContext));
                iterator.remove();
                continue;
            }
            if (propName.equals("store_term_vector_offsets")) {
                builder.storeTermVectorOffsets(TypeParsers.nodeBooleanValue(name, "store_term_vector_offsets", propNode, parserContext));
                iterator.remove();
                continue;
            }
            if (propName.equals("store_term_vector_positions")) {
                builder.storeTermVectorPositions(TypeParsers.nodeBooleanValue(name, "store_term_vector_positions", propNode, parserContext));
                iterator.remove();
                continue;
            }
            if (propName.equals("store_term_vector_payloads")) {
                builder.storeTermVectorPayloads(TypeParsers.nodeBooleanValue(name, "store_term_vector_payloads", propNode, parserContext));
                iterator.remove();
                continue;
            }
            if (propName.equals("analyzer")) {
                analyzer = parserContext.getIndexAnalyzers().get(propNode.toString());
                if (analyzer == null) {
                    throw new MapperParsingException("analyzer [" + propNode.toString() + "] not found for field [" + name + "]");
                }
                indexAnalyzer = analyzer;
                iterator.remove();
                continue;
            }
            if (propName.equals("search_analyzer")) {
                analyzer = parserContext.getIndexAnalyzers().get(propNode.toString());
                if (analyzer == null) {
                    throw new MapperParsingException("analyzer [" + propNode.toString() + "] not found for field [" + name + "]");
                }
                searchAnalyzer = analyzer;
                iterator.remove();
                continue;
            }
            if (!propName.equals("search_quote_analyzer")) continue;
            analyzer = parserContext.getIndexAnalyzers().get(propNode.toString());
            if (analyzer == null) {
                throw new MapperParsingException("analyzer [" + propNode.toString() + "] not found for field [" + name + "]");
            }
            searchQuoteAnalyzer = analyzer;
            iterator.remove();
        }
        if (indexAnalyzer == null && searchAnalyzer != null) {
            throw new MapperParsingException("analyzer on field [" + name + "] must be set when search_analyzer is set");
        }
        if (searchAnalyzer == null && searchQuoteAnalyzer != null) {
            throw new MapperParsingException("analyzer and search_analyzer on field [" + name + "] must be set when search_quote_analyzer is set");
        }
        if (searchAnalyzer == null) {
            searchAnalyzer = indexAnalyzer;
        }
        if (searchQuoteAnalyzer == null) {
            searchQuoteAnalyzer = searchAnalyzer;
        }
        if (indexAnalyzer != null) {
            builder.indexAnalyzer(indexAnalyzer);
        }
        if (searchAnalyzer != null) {
            builder.searchAnalyzer(searchAnalyzer);
        }
        if (searchQuoteAnalyzer != null) {
            builder.searchQuoteAnalyzer(searchQuoteAnalyzer);
        }
    }

    public static boolean parseNorms(FieldMapper.Builder builder, String fieldName, String propName, Object propNode, Mapper.TypeParser.ParserContext parserContext) {
        if (propName.equals("norms")) {
            if (propNode instanceof Map) {
                Map<String, Object> properties = XContentMapValues.nodeMapValue(propNode, "norms");
                Iterator<Map.Entry<String, Object>> propsIterator = properties.entrySet().iterator();
                while (propsIterator.hasNext()) {
                    Map.Entry<String, Object> entry2 = propsIterator.next();
                    String propName2 = entry2.getKey();
                    Object propNode2 = entry2.getValue();
                    if (propName2.equals("enabled")) {
                        builder.omitNorms(!TypeParsers.nodeBooleanValue(fieldName, "enabled", propNode2, parserContext));
                        propsIterator.remove();
                        continue;
                    }
                    if (!propName2.equals("loading")) continue;
                    propsIterator.remove();
                }
                DocumentMapperParser.checkNoRemainingFields(propName, properties, parserContext.indexVersionCreated());
                DEPRECATION_LOGGER.deprecated("The [norms{enabled:true/false}] way of specifying norms is deprecated, please use [norms:true/false] instead", new Object[0]);
            } else {
                builder.omitNorms(!TypeParsers.nodeBooleanValue(fieldName, "norms", propNode, parserContext));
            }
            return true;
        }
        if (propName.equals("omit_norms")) {
            builder.omitNorms(TypeParsers.nodeBooleanValue(fieldName, "norms", propNode, parserContext));
            DEPRECATION_LOGGER.deprecated("[omit_norms] is deprecated, please use [norms] instead with the opposite boolean value", new Object[0]);
            return true;
        }
        return false;
    }

    public static void parseTextField(FieldMapper.Builder builder, String name, Map<String, Object> fieldNode, Mapper.TypeParser.ParserContext parserContext) {
        TypeParsers.parseField(builder, name, fieldNode, parserContext);
        TypeParsers.parseAnalyzersAndTermVectors(builder, name, fieldNode, parserContext);
        Iterator<Map.Entry<String, Object>> iterator = fieldNode.entrySet().iterator();
        while (iterator.hasNext()) {
            Object propNode;
            Map.Entry<String, Object> entry = iterator.next();
            String propName = entry.getKey();
            if (!TypeParsers.parseNorms(builder, name, propName, propNode = entry.getValue(), parserContext)) continue;
            iterator.remove();
        }
    }

    public static void parseField(FieldMapper.Builder builder, String name, Map<String, Object> fieldNode, Mapper.TypeParser.ParserContext parserContext) {
        Iterator<Map.Entry<String, Object>> iterator = fieldNode.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, Object> entry = iterator.next();
            String propName = entry.getKey();
            Object propNode = entry.getValue();
            if (!propName.equals("null_value") && propNode == null) {
                throw new MapperParsingException("[" + propName + "] must not have a [null] value");
            }
            if (propName.equals("store")) {
                builder.store(TypeParsers.nodeBooleanValue(name, "store", propNode.toString(), parserContext));
                iterator.remove();
                continue;
            }
            if (propName.equals("index")) {
                builder.index(TypeParsers.nodeBooleanValue(name, "index", propNode, parserContext));
                iterator.remove();
                continue;
            }
            if (propName.equals(DOC_VALUES)) {
                builder.docValues(TypeParsers.nodeBooleanValue(name, DOC_VALUES, propNode, parserContext));
                iterator.remove();
                continue;
            }
            if (propName.equals("boost")) {
                builder.boost(XContentMapValues.nodeFloatValue(propNode));
                iterator.remove();
                continue;
            }
            if (parserContext.indexVersionCreated().before(Version.V_5_0_0_alpha1) && TypeParsers.parseNorms(builder, name, propName, propNode, parserContext)) {
                iterator.remove();
                continue;
            }
            if (propName.equals("index_options")) {
                if (builder.allowsIndexOptions()) {
                    builder.indexOptions(TypeParsers.nodeIndexOptionValue(propNode));
                } else {
                    DEPRECATION_LOGGER.deprecated("index_options are deprecated for field [{}] of type [{}] and will be removed in the next major version.", name, builder.fieldType.typeName());
                }
                iterator.remove();
                continue;
            }
            if (propName.equals("include_in_all")) {
                if (parserContext.isWithinMultiField()) {
                    throw new MapperParsingException("include_in_all in multi fields is not allowed. Found the include_in_all in field [" + name + "] which is within a multi field.");
                }
                if (parserContext.indexVersionCreated().onOrAfter(Version.V_6_0_0_alpha1)) {
                    throw new MapperParsingException("[include_in_all] is not allowed for indices created on or after version 6.0.0 as [_all] is deprecated. As a replacement, you can use an [copy_to] on mapping fields to create your own catch all field.");
                }
                builder.includeInAll(TypeParsers.nodeBooleanValue(name, "include_in_all", propNode, parserContext));
                iterator.remove();
                continue;
            }
            if (propName.equals("similarity")) {
                SimilarityProvider similarityProvider = TypeParsers.resolveSimilarity(parserContext, name, propNode.toString());
                builder.similarity(similarityProvider);
                iterator.remove();
                continue;
            }
            if (propName.equals("fielddata") && propNode instanceof Map && parserContext.indexVersionCreated().before(Version.V_5_0_0_alpha1)) {
                iterator.remove();
                continue;
            }
            if (TypeParsers.parseMultiField(builder, name, parserContext, propName, propNode)) {
                iterator.remove();
                continue;
            }
            if (!propName.equals("copy_to")) continue;
            if (parserContext.isWithinMultiField()) {
                throw new MapperParsingException("copy_to in multi fields is not allowed. Found the copy_to in field [" + name + "] which is within a multi field.");
            }
            TypeParsers.parseCopyFields(propNode, builder);
            iterator.remove();
        }
    }

    public static boolean parseMultiField(FieldMapper.Builder builder, String name, Mapper.TypeParser.ParserContext parserContext, String propName, Object propNode) {
        parserContext = parserContext.createMultiFieldContext(parserContext);
        if (propName.equals("fields")) {
            Map multiFieldsPropNodes;
            if (propNode instanceof List && ((List)propNode).isEmpty()) {
                multiFieldsPropNodes = Collections.emptyMap();
            } else if (propNode instanceof Map) {
                multiFieldsPropNodes = (Map)propNode;
            } else {
                throw new MapperParsingException("expected map for property [fields] on field [" + propNode + "] or [" + propName + "] but got a " + propNode.getClass());
            }
            for (Map.Entry multiFieldEntry : multiFieldsPropNodes.entrySet()) {
                String multiFieldName = (String)multiFieldEntry.getKey();
                if (multiFieldName.contains(".")) {
                    throw new MapperParsingException("Field name [" + multiFieldName + "] which is a multi field of [" + name + "] cannot contain '.'");
                }
                if (!(multiFieldEntry.getValue() instanceof Map)) {
                    throw new MapperParsingException("illegal field [" + multiFieldName + "], only fields can be specified inside fields");
                }
                Map multiFieldNodes = (Map)multiFieldEntry.getValue();
                Object typeNode = multiFieldNodes.get("type");
                if (typeNode == null) {
                    throw new MapperParsingException("no type specified for property [" + multiFieldName + "]");
                }
                String type = typeNode.toString();
                if (type.equals("object") || type.equals("nested")) {
                    throw new MapperParsingException("Type [" + type + "] cannot be used in multi field");
                }
                Mapper.TypeParser typeParser = parserContext.typeParser(type);
                if (typeParser == null) {
                    throw new MapperParsingException("no handler for type [" + type + "] declared on field [" + multiFieldName + "]");
                }
                builder.addMultiField(typeParser.parse(multiFieldName, multiFieldNodes, parserContext));
                multiFieldNodes.remove("type");
                DocumentMapperParser.checkNoRemainingFields(propName, multiFieldNodes, parserContext.indexVersionCreated());
            }
            return true;
        }
        return false;
    }

    private static IndexOptions nodeIndexOptionValue(Object propNode) {
        String value = propNode.toString();
        if (INDEX_OPTIONS_OFFSETS.equalsIgnoreCase(value)) {
            return IndexOptions.DOCS_AND_FREQS_AND_POSITIONS_AND_OFFSETS;
        }
        if (INDEX_OPTIONS_POSITIONS.equalsIgnoreCase(value)) {
            return IndexOptions.DOCS_AND_FREQS_AND_POSITIONS;
        }
        if (INDEX_OPTIONS_FREQS.equalsIgnoreCase(value)) {
            return IndexOptions.DOCS_AND_FREQS;
        }
        if (INDEX_OPTIONS_DOCS.equalsIgnoreCase(value)) {
            return IndexOptions.DOCS;
        }
        throw new ElasticsearchParseException("failed to parse index option [{}]", value);
    }

    public static FormatDateTimeFormatter parseDateTimeFormatter(Object node) {
        return Joda.forPattern(node.toString());
    }

    public static void parseTermVector(String fieldName, String termVector, FieldMapper.Builder builder) throws MapperParsingException {
        if ("no".equals(termVector)) {
            builder.storeTermVectors(false);
        } else if ("yes".equals(termVector)) {
            builder.storeTermVectors(true);
        } else if ("with_offsets".equals(termVector)) {
            builder.storeTermVectorOffsets(true);
        } else if ("with_positions".equals(termVector)) {
            builder.storeTermVectorPositions(true);
        } else if ("with_positions_offsets".equals(termVector)) {
            builder.storeTermVectorPositions(true);
            builder.storeTermVectorOffsets(true);
        } else if ("with_positions_payloads".equals(termVector)) {
            builder.storeTermVectorPositions(true);
            builder.storeTermVectorPayloads(true);
        } else if ("with_positions_offsets_payloads".equals(termVector)) {
            builder.storeTermVectorPositions(true);
            builder.storeTermVectorOffsets(true);
            builder.storeTermVectorPayloads(true);
        } else {
            throw new MapperParsingException("wrong value for termVector [" + termVector + "] for field [" + fieldName + "]");
        }
    }

    public static void parseCopyFields(Object propNode, FieldMapper.Builder builder) {
        FieldMapper.CopyTo.Builder copyToBuilder = new FieldMapper.CopyTo.Builder();
        if (XContentMapValues.isArray(propNode)) {
            for (Object node : (List)propNode) {
                copyToBuilder.add(XContentMapValues.nodeStringValue(node, null));
            }
        } else {
            copyToBuilder.add(XContentMapValues.nodeStringValue(propNode, null));
        }
        builder.copyTo(copyToBuilder.build());
    }

    private static SimilarityProvider resolveSimilarity(Mapper.TypeParser.ParserContext parserContext, String name, String value) {
        SimilarityProvider similarityProvider;
        if (parserContext.indexVersionCreated().before(Version.V_5_0_0_alpha1) && "default".equals(value)) {
            value = "classic";
        }
        if ((similarityProvider = parserContext.getSimilarity(value)) == null) {
            throw new MapperParsingException("Unknown Similarity type [" + value + "] for field [" + name + "]");
        }
        return similarityProvider;
    }
}

