/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.metrics.stats.extended;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.lucene.index.LeafReaderContext;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.lease.Releasables;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.DoubleArray;
import org.elasticsearch.common.util.LongArray;
import org.elasticsearch.index.fielddata.SortedNumericDoubleValues;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.LeafBucketCollector;
import org.elasticsearch.search.aggregations.LeafBucketCollectorBase;
import org.elasticsearch.search.aggregations.metrics.NumericMetricsAggregator;
import org.elasticsearch.search.aggregations.metrics.stats.extended.InternalExtendedStats;
import org.elasticsearch.search.aggregations.pipeline.PipelineAggregator;
import org.elasticsearch.search.aggregations.support.ValuesSource;
import org.elasticsearch.search.internal.SearchContext;

public class ExtendedStatsAggregator
extends NumericMetricsAggregator.MultiValue {
    public static final ParseField SIGMA_FIELD = new ParseField("sigma", new String[0]);
    final ValuesSource.Numeric valuesSource;
    final DocValueFormat format;
    final double sigma;
    LongArray counts;
    DoubleArray sums;
    DoubleArray compensations;
    DoubleArray mins;
    DoubleArray maxes;
    DoubleArray sumOfSqrs;
    DoubleArray compensationOfSqrs;

    public ExtendedStatsAggregator(String name, ValuesSource.Numeric valuesSource, DocValueFormat formatter, SearchContext context, Aggregator parent, double sigma, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData) throws IOException {
        super(name, context, parent, pipelineAggregators, metaData);
        this.valuesSource = valuesSource;
        this.format = formatter;
        this.sigma = sigma;
        if (valuesSource != null) {
            BigArrays bigArrays = context.bigArrays();
            this.counts = bigArrays.newLongArray(1L, true);
            this.sums = bigArrays.newDoubleArray(1L, true);
            this.compensations = bigArrays.newDoubleArray(1L, true);
            this.mins = bigArrays.newDoubleArray(1L, false);
            this.mins.fill(0L, this.mins.size(), Double.POSITIVE_INFINITY);
            this.maxes = bigArrays.newDoubleArray(1L, false);
            this.maxes.fill(0L, this.maxes.size(), Double.NEGATIVE_INFINITY);
            this.sumOfSqrs = bigArrays.newDoubleArray(1L, true);
            this.compensationOfSqrs = bigArrays.newDoubleArray(1L, true);
        }
    }

    @Override
    public boolean needsScores() {
        return this.valuesSource != null && this.valuesSource.needsScores();
    }

    @Override
    public LeafBucketCollector getLeafCollector(LeafReaderContext ctx, LeafBucketCollector sub) throws IOException {
        if (this.valuesSource == null) {
            return LeafBucketCollector.NO_OP_COLLECTOR;
        }
        final BigArrays bigArrays = this.context.bigArrays();
        final SortedNumericDoubleValues values = this.valuesSource.doubleValues(ctx);
        return new LeafBucketCollectorBase(sub, values){

            @Override
            public void collect(int doc, long bucket) throws IOException {
                if (bucket >= ExtendedStatsAggregator.this.counts.size()) {
                    long from = ExtendedStatsAggregator.this.counts.size();
                    long overSize = BigArrays.overSize(bucket + 1L);
                    ExtendedStatsAggregator.this.counts = bigArrays.resize(ExtendedStatsAggregator.this.counts, overSize);
                    ExtendedStatsAggregator.this.sums = bigArrays.resize(ExtendedStatsAggregator.this.sums, overSize);
                    ExtendedStatsAggregator.this.compensations = bigArrays.resize(ExtendedStatsAggregator.this.compensations, overSize);
                    ExtendedStatsAggregator.this.mins = bigArrays.resize(ExtendedStatsAggregator.this.mins, overSize);
                    ExtendedStatsAggregator.this.maxes = bigArrays.resize(ExtendedStatsAggregator.this.maxes, overSize);
                    ExtendedStatsAggregator.this.sumOfSqrs = bigArrays.resize(ExtendedStatsAggregator.this.sumOfSqrs, overSize);
                    ExtendedStatsAggregator.this.compensationOfSqrs = bigArrays.resize(ExtendedStatsAggregator.this.compensationOfSqrs, overSize);
                    ExtendedStatsAggregator.this.mins.fill(from, overSize, Double.POSITIVE_INFINITY);
                    ExtendedStatsAggregator.this.maxes.fill(from, overSize, Double.NEGATIVE_INFINITY);
                }
                if (values.advanceExact(doc)) {
                    int valuesCount = values.docValueCount();
                    ExtendedStatsAggregator.this.counts.increment(bucket, valuesCount);
                    double min = ExtendedStatsAggregator.this.mins.get(bucket);
                    double max = ExtendedStatsAggregator.this.maxes.get(bucket);
                    double sum = ExtendedStatsAggregator.this.sums.get(bucket);
                    double compensation = ExtendedStatsAggregator.this.compensations.get(bucket);
                    double sumOfSqr = ExtendedStatsAggregator.this.sumOfSqrs.get(bucket);
                    double compensationOfSqr = ExtendedStatsAggregator.this.compensationOfSqrs.get(bucket);
                    for (int i = 0; i < valuesCount; ++i) {
                        double value = values.nextValue();
                        if (!Double.isFinite(value)) {
                            sum += value;
                            sumOfSqr += value * value;
                        } else {
                            if (Double.isFinite(sum)) {
                                double corrected = value - compensation;
                                double newSum = sum + corrected;
                                compensation = newSum - sum - corrected;
                                sum = newSum;
                            }
                            if (Double.isFinite(sumOfSqr)) {
                                double correctedOfSqr = value * value - compensationOfSqr;
                                double newSumOfSqr = sumOfSqr + correctedOfSqr;
                                compensationOfSqr = newSumOfSqr - sumOfSqr - correctedOfSqr;
                                sumOfSqr = newSumOfSqr;
                            }
                        }
                        min = Math.min(min, value);
                        max = Math.max(max, value);
                    }
                    ExtendedStatsAggregator.this.sums.set(bucket, sum);
                    ExtendedStatsAggregator.this.compensations.set(bucket, compensation);
                    ExtendedStatsAggregator.this.sumOfSqrs.set(bucket, sumOfSqr);
                    ExtendedStatsAggregator.this.compensationOfSqrs.set(bucket, compensationOfSqr);
                    ExtendedStatsAggregator.this.mins.set(bucket, min);
                    ExtendedStatsAggregator.this.maxes.set(bucket, max);
                }
            }
        };
    }

    @Override
    public boolean hasMetric(String name) {
        try {
            InternalExtendedStats.Metrics.resolve(name);
            return true;
        }
        catch (IllegalArgumentException iae) {
            return false;
        }
    }

    @Override
    public double metric(String name, long owningBucketOrd) {
        if (this.valuesSource == null || owningBucketOrd >= this.counts.size()) {
            switch (InternalExtendedStats.Metrics.resolve(name)) {
                case count: {
                    return 0.0;
                }
                case sum: {
                    return 0.0;
                }
                case min: {
                    return Double.POSITIVE_INFINITY;
                }
                case max: {
                    return Double.NEGATIVE_INFINITY;
                }
                case avg: {
                    return Double.NaN;
                }
                case sum_of_squares: {
                    return 0.0;
                }
                case variance: {
                    return Double.NaN;
                }
                case std_deviation: {
                    return Double.NaN;
                }
                case std_upper: {
                    return Double.NaN;
                }
                case std_lower: {
                    return Double.NaN;
                }
            }
            throw new IllegalArgumentException("Unknown value [" + name + "] in common stats aggregation");
        }
        switch (InternalExtendedStats.Metrics.resolve(name)) {
            case count: {
                return this.counts.get(owningBucketOrd);
            }
            case sum: {
                return this.sums.get(owningBucketOrd);
            }
            case min: {
                return this.mins.get(owningBucketOrd);
            }
            case max: {
                return this.maxes.get(owningBucketOrd);
            }
            case avg: {
                return this.sums.get(owningBucketOrd) / (double)this.counts.get(owningBucketOrd);
            }
            case sum_of_squares: {
                return this.sumOfSqrs.get(owningBucketOrd);
            }
            case variance: {
                return this.variance(owningBucketOrd);
            }
            case std_deviation: {
                return Math.sqrt(this.variance(owningBucketOrd));
            }
            case std_upper: {
                return this.sums.get(owningBucketOrd) / (double)this.counts.get(owningBucketOrd) + Math.sqrt(this.variance(owningBucketOrd)) * this.sigma;
            }
            case std_lower: {
                return this.sums.get(owningBucketOrd) / (double)this.counts.get(owningBucketOrd) - Math.sqrt(this.variance(owningBucketOrd)) * this.sigma;
            }
        }
        throw new IllegalArgumentException("Unknown value [" + name + "] in common stats aggregation");
    }

    private double variance(long owningBucketOrd) {
        double sum = this.sums.get(owningBucketOrd);
        long count = this.counts.get(owningBucketOrd);
        return (this.sumOfSqrs.get(owningBucketOrd) - sum * sum / (double)count) / (double)count;
    }

    @Override
    public InternalAggregation buildAggregation(long bucket) {
        if (this.valuesSource == null || bucket >= this.counts.size()) {
            return this.buildEmptyAggregation();
        }
        return new InternalExtendedStats(this.name, this.counts.get(bucket), this.sums.get(bucket), this.mins.get(bucket), this.maxes.get(bucket), this.sumOfSqrs.get(bucket), this.sigma, this.format, this.pipelineAggregators(), this.metaData());
    }

    @Override
    public InternalAggregation buildEmptyAggregation() {
        return new InternalExtendedStats(this.name, 0L, 0.0, Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, 0.0, this.sigma, this.format, this.pipelineAggregators(), this.metaData());
    }

    @Override
    public void doClose() {
        Releasables.close(this.counts, this.maxes, this.mins, this.sumOfSqrs, this.compensationOfSqrs, this.sums, this.compensations);
    }
}

