/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.job.results;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.ml.job.config.Job;

public class CategoryDefinition
implements ToXContentObject,
Writeable {
    public static final ParseField TYPE = new ParseField("category_definition", new String[0]);
    public static final ParseField CATEGORY_ID = new ParseField("category_id", new String[0]);
    public static final ParseField TERMS = new ParseField("terms", new String[0]);
    public static final ParseField REGEX = new ParseField("regex", new String[0]);
    public static final ParseField MAX_MATCHING_LENGTH = new ParseField("max_matching_length", new String[0]);
    public static final ParseField EXAMPLES = new ParseField("examples", new String[0]);
    public static final ParseField RESULTS_FIELD = new ParseField("categories", new String[0]);
    public static final ConstructingObjectParser<CategoryDefinition, Void> STRICT_PARSER = CategoryDefinition.createParser(false);
    public static final ConstructingObjectParser<CategoryDefinition, Void> LENIENT_PARSER = CategoryDefinition.createParser(true);
    private final String jobId;
    private long categoryId = 0L;
    private String terms = "";
    private String regex = "";
    private long maxMatchingLength = 0L;
    private final Set<String> examples;

    private static ConstructingObjectParser<CategoryDefinition, Void> createParser(boolean ignoreUnknownFields) {
        ConstructingObjectParser parser = new ConstructingObjectParser(TYPE.getPreferredName(), ignoreUnknownFields, a -> new CategoryDefinition((String)a[0]));
        parser.declareString(ConstructingObjectParser.constructorArg(), Job.ID);
        parser.declareLong(CategoryDefinition::setCategoryId, CATEGORY_ID);
        parser.declareString(CategoryDefinition::setTerms, TERMS);
        parser.declareString(CategoryDefinition::setRegex, REGEX);
        parser.declareLong(CategoryDefinition::setMaxMatchingLength, MAX_MATCHING_LENGTH);
        parser.declareStringArray(CategoryDefinition::setExamples, EXAMPLES);
        return parser;
    }

    public CategoryDefinition(String jobId) {
        this.jobId = jobId;
        this.examples = new TreeSet<String>();
    }

    public CategoryDefinition(StreamInput in) throws IOException {
        this.jobId = in.readString();
        this.categoryId = in.readLong();
        this.terms = in.readString();
        this.regex = in.readString();
        this.maxMatchingLength = in.readLong();
        this.examples = new TreeSet<String>(in.readList(StreamInput::readString));
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.jobId);
        out.writeLong(this.categoryId);
        out.writeString(this.terms);
        out.writeString(this.regex);
        out.writeLong(this.maxMatchingLength);
        out.writeStringList(new ArrayList<String>(this.examples));
    }

    public String getJobId() {
        return this.jobId;
    }

    public String getId() {
        return this.jobId + "_" + TYPE + "_" + this.categoryId;
    }

    public long getCategoryId() {
        return this.categoryId;
    }

    public void setCategoryId(long categoryId) {
        this.categoryId = categoryId;
    }

    public String getTerms() {
        return this.terms;
    }

    public void setTerms(String terms) {
        this.terms = terms;
    }

    public String getRegex() {
        return this.regex;
    }

    public void setRegex(String regex) {
        this.regex = regex;
    }

    public long getMaxMatchingLength() {
        return this.maxMatchingLength;
    }

    public void setMaxMatchingLength(long maxMatchingLength) {
        this.maxMatchingLength = maxMatchingLength;
    }

    public List<String> getExamples() {
        return new ArrayList<String>(this.examples);
    }

    public void setExamples(Collection<String> examples) {
        this.examples.clear();
        this.examples.addAll(examples);
    }

    public void addExample(String example) {
        this.examples.add(example);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(Job.ID.getPreferredName(), this.jobId);
        builder.field(CATEGORY_ID.getPreferredName(), this.categoryId);
        builder.field(TERMS.getPreferredName(), this.terms);
        builder.field(REGEX.getPreferredName(), this.regex);
        builder.field(MAX_MATCHING_LENGTH.getPreferredName(), this.maxMatchingLength);
        builder.field(EXAMPLES.getPreferredName(), this.examples);
        builder.endObject();
        return builder;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof CategoryDefinition)) {
            return false;
        }
        CategoryDefinition that = (CategoryDefinition)other;
        return Objects.equals(this.jobId, that.jobId) && Objects.equals(this.categoryId, that.categoryId) && Objects.equals(this.terms, that.terms) && Objects.equals(this.regex, that.regex) && Objects.equals(this.maxMatchingLength, that.maxMatchingLength) && Objects.equals(this.examples, that.examples);
    }

    public int hashCode() {
        return Objects.hash(this.jobId, this.categoryId, this.terms, this.regex, this.maxMatchingLength, this.examples);
    }
}

