/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action;

import java.io.IOException;
import java.util.Locale;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.index.VersionType;

public interface DocWriteRequest<T>
extends IndicesRequest {
    public String index();

    public String type();

    public String id();

    @Override
    public IndicesOptions indicesOptions();

    public T routing(String var1);

    public String routing();

    public String parent();

    public long version();

    public T version(long var1);

    public VersionType versionType();

    public T versionType(VersionType var1);

    public OpType opType();

    public static DocWriteRequest readDocumentRequest(StreamInput in) throws IOException {
        ActionRequest docWriteRequest;
        byte type = in.readByte();
        if (type == 0) {
            IndexRequest indexRequest = new IndexRequest();
            indexRequest.readFrom(in);
            docWriteRequest = indexRequest;
        } else if (type == 1) {
            DeleteRequest deleteRequest = new DeleteRequest();
            deleteRequest.readFrom(in);
            docWriteRequest = deleteRequest;
        } else if (type == 2) {
            UpdateRequest updateRequest = new UpdateRequest();
            updateRequest.readFrom(in);
            docWriteRequest = updateRequest;
        } else {
            throw new IllegalStateException("invalid request type [" + type + " ]");
        }
        return docWriteRequest;
    }

    public static void writeDocumentRequest(StreamOutput out, DocWriteRequest request) throws IOException {
        if (request instanceof IndexRequest) {
            out.writeByte((byte)0);
            ((IndexRequest)request).writeTo(out);
        } else if (request instanceof DeleteRequest) {
            out.writeByte((byte)1);
            ((DeleteRequest)request).writeTo(out);
        } else if (request instanceof UpdateRequest) {
            out.writeByte((byte)2);
            ((UpdateRequest)request).writeTo(out);
        } else {
            throw new IllegalStateException("invalid request [" + request.getClass().getSimpleName() + " ]");
        }
    }

    public static enum OpType {
        INDEX(0),
        CREATE(1),
        UPDATE(2),
        DELETE(3);

        private final byte op;
        private final String lowercase;

        private OpType(int op) {
            this.op = (byte)op;
            this.lowercase = this.toString().toLowerCase(Locale.ROOT);
        }

        public byte getId() {
            return this.op;
        }

        public String getLowercase() {
            return this.lowercase;
        }

        public static OpType fromId(byte id) {
            switch (id) {
                case 0: {
                    return INDEX;
                }
                case 1: {
                    return CREATE;
                }
                case 2: {
                    return UPDATE;
                }
                case 3: {
                    return DELETE;
                }
            }
            throw new IllegalArgumentException("Unknown opType: [" + id + "]");
        }

        public static OpType fromString(String sOpType) {
            String lowerCase = sOpType.toLowerCase(Locale.ROOT);
            for (OpType opType : OpType.values()) {
                if (!opType.getLowercase().equals(lowerCase)) continue;
                return opType;
            }
            throw new IllegalArgumentException("Unknown opType: [" + sOpType + "]");
        }
    }
}

