/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.health;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.support.ActiveShardCount;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.master.MasterNodeReadRequest;
import org.elasticsearch.cluster.health.ClusterHealthStatus;
import org.elasticsearch.common.Priority;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.unit.TimeValue;

public class ClusterHealthRequest
extends MasterNodeReadRequest<ClusterHealthRequest>
implements IndicesRequest.Replaceable {
    private String[] indices;
    private TimeValue timeout = new TimeValue(30L, TimeUnit.SECONDS);
    private ClusterHealthStatus waitForStatus;
    private boolean waitForNoRelocatingShards = false;
    private boolean waitForNoInitializingShards = false;
    private ActiveShardCount waitForActiveShards = ActiveShardCount.NONE;
    private String waitForNodes = "";
    private Priority waitForEvents = null;

    public ClusterHealthRequest() {
    }

    public ClusterHealthRequest(String ... indices) {
        this.indices = indices;
    }

    @Override
    public String[] indices() {
        return this.indices;
    }

    @Override
    public ClusterHealthRequest indices(String ... indices) {
        this.indices = indices;
        return this;
    }

    @Override
    public IndicesOptions indicesOptions() {
        return IndicesOptions.lenientExpandOpen();
    }

    public TimeValue timeout() {
        return this.timeout;
    }

    public ClusterHealthRequest timeout(TimeValue timeout) {
        this.timeout = timeout;
        if (this.masterNodeTimeout == DEFAULT_MASTER_NODE_TIMEOUT) {
            this.masterNodeTimeout = timeout;
        }
        return this;
    }

    public ClusterHealthRequest timeout(String timeout) {
        return this.timeout(TimeValue.parseTimeValue((String)timeout, null, (String)(this.getClass().getSimpleName() + ".timeout")));
    }

    public ClusterHealthStatus waitForStatus() {
        return this.waitForStatus;
    }

    public ClusterHealthRequest waitForStatus(ClusterHealthStatus waitForStatus) {
        this.waitForStatus = waitForStatus;
        return this;
    }

    public ClusterHealthRequest waitForGreenStatus() {
        return this.waitForStatus(ClusterHealthStatus.GREEN);
    }

    public ClusterHealthRequest waitForYellowStatus() {
        return this.waitForStatus(ClusterHealthStatus.YELLOW);
    }

    public boolean waitForNoRelocatingShards() {
        return this.waitForNoRelocatingShards;
    }

    public ClusterHealthRequest waitForNoRelocatingShards(boolean waitForNoRelocatingShards) {
        this.waitForNoRelocatingShards = waitForNoRelocatingShards;
        return this;
    }

    public boolean waitForNoInitializingShards() {
        return this.waitForNoInitializingShards;
    }

    public ClusterHealthRequest waitForNoInitializingShards(boolean waitForNoInitializingShards) {
        this.waitForNoInitializingShards = waitForNoInitializingShards;
        return this;
    }

    public ActiveShardCount waitForActiveShards() {
        return this.waitForActiveShards;
    }

    public ClusterHealthRequest waitForActiveShards(ActiveShardCount waitForActiveShards) {
        this.waitForActiveShards = waitForActiveShards.equals(ActiveShardCount.DEFAULT) ? ActiveShardCount.NONE : waitForActiveShards;
        return this;
    }

    public ClusterHealthRequest waitForActiveShards(int waitForActiveShards) {
        return this.waitForActiveShards(ActiveShardCount.from(waitForActiveShards));
    }

    public String waitForNodes() {
        return this.waitForNodes;
    }

    public ClusterHealthRequest waitForNodes(String waitForNodes) {
        this.waitForNodes = waitForNodes;
        return this;
    }

    public ClusterHealthRequest waitForEvents(Priority waitForEvents) {
        this.waitForEvents = waitForEvents;
        return this;
    }

    public Priority waitForEvents() {
        return this.waitForEvents;
    }

    @Override
    public ActionRequestValidationException validate() {
        return null;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        int size = in.readVInt();
        if (size == 0) {
            this.indices = Strings.EMPTY_ARRAY;
        } else {
            this.indices = new String[size];
            for (int i = 0; i < this.indices.length; ++i) {
                this.indices[i] = in.readString();
            }
        }
        this.timeout = in.readTimeValue();
        if (in.readBoolean()) {
            this.waitForStatus = ClusterHealthStatus.fromValue(in.readByte());
        }
        this.waitForNoRelocatingShards = in.readBoolean();
        this.waitForActiveShards = ActiveShardCount.readFrom(in);
        this.waitForNodes = in.readString();
        if (in.readBoolean()) {
            this.waitForEvents = Priority.readFrom(in);
        }
        if (in.getVersion().onOrAfter(Version.V_6_2_0)) {
            this.waitForNoInitializingShards = in.readBoolean();
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        if (this.indices == null) {
            out.writeVInt(0);
        } else {
            out.writeVInt(this.indices.length);
            for (String index : this.indices) {
                out.writeString(index);
            }
        }
        out.writeTimeValue(this.timeout);
        if (this.waitForStatus == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            out.writeByte(this.waitForStatus.value());
        }
        out.writeBoolean(this.waitForNoRelocatingShards);
        this.waitForActiveShards.writeTo(out);
        out.writeString(this.waitForNodes);
        if (this.waitForEvents == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            Priority.writeTo(this.waitForEvents, out);
        }
        if (out.getVersion().onOrAfter(Version.V_6_2_0)) {
            out.writeBoolean(this.waitForNoInitializingShards);
        }
    }
}

