/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.datafeed;

import java.util.List;
import java.util.Objects;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.routing.IndexRoutingTable;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.persistent.PersistentTasksCustomMetaData;
import org.elasticsearch.xpack.core.ml.MlMetadata;
import org.elasticsearch.xpack.core.ml.datafeed.DatafeedConfig;
import org.elasticsearch.xpack.core.ml.job.config.JobState;
import org.elasticsearch.xpack.core.ml.job.config.JobTaskStatus;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;

public class DatafeedNodeSelector {
    private static final Logger LOGGER = Loggers.getLogger(DatafeedNodeSelector.class);
    private final DatafeedConfig datafeed;
    private final PersistentTasksCustomMetaData.PersistentTask<?> jobTask;
    private final ClusterState clusterState;
    private final IndexNameExpressionResolver resolver;

    public DatafeedNodeSelector(ClusterState clusterState, IndexNameExpressionResolver resolver, String datafeedId) {
        MlMetadata mlMetadata = MlMetadata.getMlMetadata((ClusterState)clusterState);
        PersistentTasksCustomMetaData tasks = (PersistentTasksCustomMetaData)clusterState.getMetaData().custom("persistent_tasks");
        this.datafeed = mlMetadata.getDatafeed(datafeedId);
        this.jobTask = MlMetadata.getJobTask((String)this.datafeed.getJobId(), (PersistentTasksCustomMetaData)tasks);
        this.clusterState = Objects.requireNonNull(clusterState);
        this.resolver = Objects.requireNonNull(resolver);
    }

    public void checkDatafeedTaskCanBeCreated() {
        AssignmentFailure assignmentFailure = this.checkAssignment();
        if (assignmentFailure != null && assignmentFailure.isCriticalForTaskCreation) {
            String msg = "No node found to start datafeed [" + this.datafeed.getId() + "], allocation explanation [" + assignmentFailure.reason + "]";
            LOGGER.debug(msg);
            throw ExceptionsHelper.conflictStatusException((String)msg, (Object[])new Object[0]);
        }
    }

    public PersistentTasksCustomMetaData.Assignment selectNode() {
        AssignmentFailure assignmentFailure = this.checkAssignment();
        if (assignmentFailure == null) {
            return new PersistentTasksCustomMetaData.Assignment(this.jobTask.getExecutorNode(), "");
        }
        LOGGER.debug(assignmentFailure.reason);
        return new PersistentTasksCustomMetaData.Assignment(null, assignmentFailure.reason);
    }

    @Nullable
    private AssignmentFailure checkAssignment() {
        String reason;
        PriorityFailureCollector priorityFailureCollector = new PriorityFailureCollector();
        priorityFailureCollector.add(this.verifyIndicesActive(this.datafeed));
        JobTaskStatus taskStatus = null;
        JobState jobState = JobState.CLOSED;
        if (this.jobTask != null) {
            taskStatus = (JobTaskStatus)this.jobTask.getStatus();
            JobState jobState2 = jobState = taskStatus == null ? JobState.OPENING : taskStatus.getState();
        }
        if (!jobState.isAnyOf(new JobState[]{JobState.OPENING, JobState.OPENED})) {
            reason = "cannot start datafeed [" + this.datafeed.getId() + "], because job's [" + this.datafeed.getJobId() + "] state is [" + jobState + "] while state [" + JobState.OPENED + "] is required";
            priorityFailureCollector.add(new AssignmentFailure(reason, true));
        }
        if (taskStatus != null && taskStatus.isStatusStale(this.jobTask)) {
            reason = "cannot start datafeed [" + this.datafeed.getId() + "], job [" + this.datafeed.getJobId() + "] status is stale";
            priorityFailureCollector.add(new AssignmentFailure(reason, true));
        }
        return priorityFailureCollector.get();
    }

    @Nullable
    private AssignmentFailure verifyIndicesActive(DatafeedConfig datafeed) {
        List indices = datafeed.getIndices();
        for (String index : indices) {
            String[] concreteIndices;
            if (this.isRemoteIndex(index)) continue;
            String reason = "cannot start datafeed [" + datafeed.getId() + "] because index [" + index + "] does not exist, is closed, or is still initializing.";
            try {
                concreteIndices = this.resolver.concreteIndexNames(this.clusterState, IndicesOptions.lenientExpandOpen(), new String[]{index});
                if (concreteIndices.length == 0) {
                    return new AssignmentFailure(reason, true);
                }
            }
            catch (Exception e) {
                LOGGER.debug(reason, (Throwable)e);
                return new AssignmentFailure(reason, true);
            }
            for (String concreteIndex : concreteIndices) {
                IndexRoutingTable routingTable = this.clusterState.getRoutingTable().index(concreteIndex);
                if (routingTable != null && routingTable.allPrimaryShardsActive()) continue;
                reason = "cannot start datafeed [" + datafeed.getId() + "] because index [" + concreteIndex + "] does not have all primary shards active yet.";
                return new AssignmentFailure(reason, false);
            }
        }
        return null;
    }

    private boolean isRemoteIndex(String index) {
        return index.indexOf(58) != -1;
    }

    private static class PriorityFailureCollector {
        private AssignmentFailure failure;

        private PriorityFailureCollector() {
        }

        private void add(@Nullable AssignmentFailure newFailure) {
            if (newFailure == null) {
                return;
            }
            if (this.failure == null || !this.failure.isCriticalForTaskCreation && newFailure.isCriticalForTaskCreation) {
                this.failure = newFailure;
            }
        }

        @Nullable
        private AssignmentFailure get() {
            return this.failure;
        }
    }

    private static class AssignmentFailure {
        private final String reason;
        private final boolean isCriticalForTaskCreation;

        private AssignmentFailure(String reason, boolean isCriticalForTaskCreation) {
            this.reason = reason;
            this.isCriticalForTaskCreation = isCriticalForTaskCreation;
        }
    }
}

