/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render;

import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.apps.FOPException;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.render.AbstractRendererConfigurator;
import org.apache.fop.render.RendererContext;

public class XMLHandlerConfigurator
extends AbstractRendererConfigurator {
    protected static final Log log = LogFactory.getLog(XMLHandlerConfigurator.class);

    public XMLHandlerConfigurator(FOUserAgent userAgent) {
        super(userAgent);
    }

    private Configuration getHandlerConfig(Configuration cfg, String namespace) {
        Configuration[] children;
        if (cfg == null || namespace == null) {
            return null;
        }
        Configuration handlerConfig = null;
        for (Configuration aChildren : children = cfg.getChildren("xml-handler")) {
            try {
                if (!aChildren.getAttribute("namespace").equals(namespace)) continue;
                handlerConfig = aChildren;
                break;
            }
            catch (ConfigurationException configurationException) {
                // empty catch block
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)((handlerConfig == null ? "No" : "") + "XML handler configuration found for namespace " + namespace));
        }
        return handlerConfig;
    }

    public void configure(RendererContext context, String ns) throws FOPException {
        Configuration cfg = this.userAgent.getRendererConfiguration(context.getRenderer().getMimeType());
        if (cfg != null && (cfg = this.getHandlerConfig(cfg, ns)) != null) {
            context.setProperty("cfg", cfg);
        }
    }
}

