/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.cj.x.io;

import com.mysql.cj.api.result.Row;
import com.mysql.cj.api.x.core.ResultCtor;
import com.mysql.cj.api.x.io.ResultListener;
import com.mysql.cj.core.result.BufferedRowList;
import com.mysql.cj.core.result.Field;
import com.mysql.cj.x.core.StatementExecuteOk;
import com.mysql.cj.x.core.XDevAPIError;
import com.mysql.cj.x.io.XProtocolRow;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiFunction;

public class ResultCreatingResultListener<RES_T>
implements ResultListener {
    private ArrayList<Field> metadata;
    private List<Row> rows = new ArrayList<Row>();
    private ResultCtor<? extends RES_T> resultCtor;
    private CompletableFuture<RES_T> future;

    public ResultCreatingResultListener(ResultCtor<? extends RES_T> resultCtor, CompletableFuture<RES_T> future) {
        this.resultCtor = resultCtor;
        this.future = future;
    }

    @Override
    public void onMetadata(ArrayList<Field> metadataFields) {
        this.metadata = metadataFields;
    }

    @Override
    public void onRow(XProtocolRow r) {
        this.rows.add(r);
    }

    @Override
    public void onComplete(StatementExecuteOk ok) {
        BufferedRowList rowList = new BufferedRowList(this.rows);
        Object result = ((BiFunction)this.resultCtor.apply(this.metadata)).apply(rowList, () -> ok);
        this.future.complete(result);
    }

    @Override
    public void onError(XDevAPIError error) {
        this.future.completeExceptionally(error);
    }

    @Override
    public void onException(Throwable t) {
        this.future.completeExceptionally(t);
    }
}

