/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.function.srtm;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import javax.swing.JOptionPane;
import tim.prune.App;
import tim.prune.GenericFunction;
import tim.prune.I18nManager;
import tim.prune.config.Config;
import tim.prune.data.DoubleRange;
import tim.prune.function.srtm.SrtmTile;
import tim.prune.function.srtm.TileFinder;
import tim.prune.gui.ProgressDialog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DownloadSrtmFunction
extends GenericFunction
implements Runnable {
    private ProgressDialog _progress = null;
    private boolean _running = false;

    public DownloadSrtmFunction(App app) {
        super(app);
    }

    @Override
    public String getNameKey() {
        return "function.downloadsrtm";
    }

    @Override
    public void begin() {
        this._running = true;
        if (this._progress == null) {
            this._progress = new ProgressDialog(this._parentFrame, this.getNameKey());
        }
        this._progress.show();
        new Thread(this).start();
    }

    @Override
    public void run() {
        ArrayList<SrtmTile> arrayList = new ArrayList<SrtmTile>();
        DoubleRange doubleRange = this._app.getTrackInfo().getTrack().getLonRange();
        DoubleRange doubleRange2 = this._app.getTrackInfo().getTrack().getLatRange();
        int n = (int)Math.floor(doubleRange.getMinimum());
        int n2 = (int)Math.floor(doubleRange.getMaximum());
        int n3 = (int)Math.floor(doubleRange2.getMinimum());
        int n4 = (int)Math.floor(doubleRange2.getMaximum());
        int n5 = n;
        while (n5 <= n2) {
            int n6 = n3;
            while (n6 <= n4) {
                SrtmTile srtmTile = new SrtmTile(n6, n5);
                boolean bl = false;
                int n7 = 0;
                while (n7 < arrayList.size()) {
                    if (arrayList.get(n7).equals(srtmTile)) {
                        bl = true;
                    }
                    ++n7;
                }
                if (!bl) {
                    arrayList.add(srtmTile);
                }
                ++n6;
            }
            ++n5;
        }
        this.downloadTiles(arrayList);
        this._running = false;
    }

    private void downloadTiles(ArrayList<SrtmTile> arrayList) {
        URL[] uRLArray;
        if (this._progress != null) {
            this._progress.setMaximum(arrayList.size());
            this._progress.setValue(0);
        }
        String string = null;
        String string2 = Config.getConfigString("prune.diskcache");
        if (string2 != null) {
            uRLArray = new File(string2, "srtm");
            if (!uRLArray.exists() && !uRLArray.mkdir()) {
                string = I18nManager.getText("error.downloadsrtm.nocache");
            }
        } else {
            string = I18nManager.getText("error.downloadsrtm.nocache");
        }
        uRLArray = TileFinder.getUrls(arrayList);
        int n = 0;
        int n2 = 0;
        while (n2 < arrayList.size() && !this._progress.isCancelled()) {
            if (uRLArray[n2] != null) {
                FileOutputStream fileOutputStream = null;
                InputStream inputStream = null;
                try {
                    this._progress.setValue(n2);
                    File file = DownloadSrtmFunction.getFileToWrite(uRLArray[n2]);
                    if (file != null) {
                        int n3;
                        fileOutputStream = new FileOutputStream(file);
                        URLConnection uRLConnection = uRLArray[n2].openConnection();
                        uRLConnection.setRequestProperty("User-Agent", "GpsPrune v19");
                        inputStream = uRLConnection.getInputStream();
                        while ((n3 = inputStream.read()) != -1) {
                            fileOutputStream.write(n3);
                        }
                        ++n;
                    }
                }
                catch (IOException iOException) {
                    string = String.valueOf(iOException.getClass().getName()) + " - " + iOException.getMessage();
                }
                try {
                    inputStream.close();
                }
                catch (Exception exception) {}
                try {
                    fileOutputStream.close();
                }
                catch (Exception exception) {}
            }
            ++n2;
        }
        this._progress.dispose();
        if (this._progress.isCancelled()) {
            return;
        }
        if (string != null) {
            this._app.showErrorMessageNoLookup(this.getNameKey(), string);
        } else if (n == 1) {
            JOptionPane.showMessageDialog(this._parentFrame, I18nManager.getTextWithNumber("confirm.downloadsrtm.1", n), I18nManager.getText(this.getNameKey()), 1);
        } else if (n > 1) {
            JOptionPane.showMessageDialog(this._parentFrame, I18nManager.getTextWithNumber("confirm.downloadsrtm", n), I18nManager.getText(this.getNameKey()), 1);
        } else if (arrayList.size() > 0) {
            this._app.showErrorMessage(this.getNameKey(), "confirm.downloadsrtm.none");
        }
    }

    private static File getFileToWrite(URL uRL) {
        File file;
        File file2;
        String string = Config.getConfigString("prune.diskcache");
        if (string != null && (file2 = new File(string, "srtm")).exists() && file2.isDirectory() && file2.canRead() && (!(file = new File(file2, new File(uRL.getFile()).getName())).exists() || !file.canRead() || file.length() <= 400L)) {
            return file;
        }
        return null;
    }

    public boolean isRunning() {
        return this._running;
    }
}

