/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.options;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.gjt.sp.jedit.AbstractOptionPane;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.Mode;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.gui.PingPongList;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.syntax.ModeProvider;
import org.gjt.sp.util.StandardUtilities;

public class EditModesPane
extends AbstractOptionPane {
    private JComboBox<Mode> defaultMode;
    private PingPongList<Mode> pingPongList;
    private JTextField modeName;
    private JTextField modeFile;
    private JButton browse;
    private JTextField filenameGlob;
    private JTextField firstLineGlob;
    private JButton ok;
    private JButton deleteSelectedButton;

    public EditModesPane() {
        super("editmodes");
    }

    @Override
    protected void _init() {
        Mode[] modeArray = this.loadAllModes();
        Mode[] modeArray2 = this.loadSelectedModes();
        this.defaultMode = new JComboBox<Mode>(modeArray2);
        this.defaultMode.setSelectedItem(jEdit.getMode(jEdit.getProperty("buffer.defaultMode")));
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)new JLabel(jEdit.getProperty("options.editing.defaultMode")), "West");
        jPanel.add(this.defaultMode);
        this.addComponent(jPanel);
        this.addSeparator();
        ArrayList<Mode> arrayList = new ArrayList<Mode>();
        ArrayList<Mode> arrayList2 = new ArrayList<Mode>();
        for (Mode object2 : modeArray) {
            boolean bl;
            String string = object2.getName();
            boolean bl2 = bl = !jEdit.getBooleanProperty("mode.opt-out." + string, false);
            if (bl) {
                arrayList2.add(object2);
                continue;
            }
            arrayList.add(object2);
        }
        this.pingPongList = new PingPongList(arrayList, arrayList2);
        this.pingPongList.setLeftTitle(jEdit.getProperty("options.editing.modes.available"));
        this.pingPongList.setRightTitle(jEdit.getProperty("options.editing.modes.selected"));
        this.pingPongList.setLeftTooltip(jEdit.getProperty("options.editing.modes.available.tooltip"));
        this.pingPongList.setRightTooltip(jEdit.getProperty("options.editing.modes.selected.tooltip"));
        this.pingPongList.setRightCellRenderer(new MyCellRenderer());
        this.pingPongList.addRightListSelectionListener(new MyListSelectionListener());
        this.deleteSelectedButton = new JButton(jEdit.getProperty("options.editing.modes.deleteSelected", "Delete Selected"));
        this.deleteSelectedButton.setEnabled(false);
        this.pingPongList.addButton(this.deleteSelectedButton);
        this.deleteSelectedButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                List list = EditModesPane.this.pingPongList.getRightSelectedValues();
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(jEdit.getProperty("options.editing.modes.Delete_these_modes?", "Delete these modes?")).append('\n');
                for (Object object : list) {
                    if (!((Mode)object).isUserMode()) continue;
                    stringBuilder.append(((Mode)object).getName()).append('\n');
                }
                int n = JOptionPane.showConfirmDialog(jEdit.getActiveView(), stringBuilder.toString(), jEdit.getProperty("options.editing.deleteMode.dialog.title", "Confirm Mode Delete"), 2);
                if (n == 0) {
                    for (Mode mode : list) {
                        if (!mode.isUserMode()) continue;
                        try {
                            ModeProvider.instance.removeMode(mode.getName());
                        }
                        catch (IOException iOException) {
                            JOptionPane.showMessageDialog(jEdit.getActiveView(), jEdit.getProperty("options.editing.deleteMode.dialog.message1") + ' ' + mode.getProperty("file") + '\n' + jEdit.getProperty("options.editing.deleteMode.dialog.message2") + ' ' + mode.getName());
                        }
                    }
                    EditModesPane.this.reloadLists(null);
                }
            }
        });
        this.addComponent(this.pingPongList, 1);
        this.addSeparator();
        this.addComponent(new JLabel(jEdit.getProperty("options.editing.addMode.dialog.title", "Add Mode")));
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.setBorder(BorderFactory.createEmptyBorder(12, 12, 11, 11));
        this.addComponent(jPanel2);
        AbstractOptionPane abstractOptionPane = new AbstractOptionPane("addmode");
        abstractOptionPane.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.modeName = new JTextField(36);
        abstractOptionPane.addComponent(jEdit.getProperty("options.editing.addMode.dialog.modeName"), (Component)this.modeName);
        this.modeFile = new JTextField();
        this.browse = new JButton("...");
        this.browse.addActionListener(new ActionHandler());
        JPanel jPanel3 = new JPanel(new BorderLayout());
        jPanel3.add((Component)this.modeFile, "Center");
        jPanel3.add((Component)this.browse, "East");
        abstractOptionPane.addComponent(jEdit.getProperty("options.editing.addMode.dialog.modeFile"), (Component)jPanel3);
        this.filenameGlob = new JTextField(36);
        abstractOptionPane.addComponent(jEdit.getProperty("options.editing.addMode.dialog.filenameGlob"), (Component)this.filenameGlob);
        this.firstLineGlob = new JTextField(36);
        abstractOptionPane.addComponent(jEdit.getProperty("options.editing.addMode.dialog.firstLineGlob"), (Component)this.firstLineGlob);
        jPanel2.add(abstractOptionPane);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BoxLayout(jPanel4, 0));
        jPanel4.setBorder(BorderFactory.createEmptyBorder(17, 0, 0, 6));
        this.ok = new JButton(jEdit.getProperty("options.editing.addMode", "Add Mode"));
        this.ok.addActionListener(new ActionHandler());
        jPanel4.add(Box.createGlue());
        jPanel4.add(this.ok);
        jPanel2.add("South", jPanel4);
        this.addComponent(jPanel2);
    }

    private Mode[] loadSelectedModes() {
        Mode[] modeArray = jEdit.getModes();
        Arrays.sort(modeArray, new StandardUtilities.StringCompare(true));
        return modeArray;
    }

    private Mode[] loadAllModes() {
        Mode[] modeArray = jEdit.getAllModes();
        Arrays.sort(modeArray, new StandardUtilities.StringCompare(true));
        return modeArray;
    }

    @Override
    protected void _save() {
        Object object;
        jEdit.setProperty("buffer.defaultMode", ((Mode)this.defaultMode.getSelectedItem()).getName());
        Iterator<Mode> iterator = this.pingPongList.getLeftDataIterator();
        while (iterator.hasNext()) {
            object = iterator.next();
            jEdit.setBooleanProperty("mode.opt-out." + ((Mode)object).getName(), true);
        }
        object = this.pingPongList.getRightDataIterator();
        while (object.hasNext()) {
            Mode mode = (Mode)object.next();
            jEdit.unsetProperty("mode.opt-out." + mode.getName());
        }
    }

    public String getModeName() {
        return this.modeName.getText();
    }

    public String getModeFile() {
        return this.modeFile.getText();
    }

    public String getFilenameGlob() {
        return this.filenameGlob.getText();
    }

    public String getFirstLineGlob() {
        return this.firstLineGlob.getText();
    }

    public void ok() {
        int n;
        boolean bl;
        String string = this.getModeName();
        if (string == null || string.isEmpty()) {
            JOptionPane.showMessageDialog(jEdit.getActiveView(), jEdit.getProperty("options.editing.addMode.dialog.Mode_name_may_not_be_empty.", "Mode name may not be empty."), jEdit.getProperty("options.editing.addMode.dialog.errorTitle", "Error"), 0);
            return;
        }
        String string2 = this.getModeFile();
        if (string2 == null || string2.isEmpty()) {
            JOptionPane.showMessageDialog(jEdit.getActiveView(), jEdit.getProperty("options.editing.addMode.dialog.Mode_file_may_not_be_empty.", "Mode file may not be empty."), jEdit.getProperty("options.editing.addMode.dialog.errorTitle", "Error"), 0);
            return;
        }
        String string3 = this.getFilenameGlob();
        String string4 = this.getFirstLineGlob();
        if ((string3 == null || string3.isEmpty()) && (string4 == null || string4.isEmpty())) {
            JOptionPane.showMessageDialog(jEdit.getActiveView(), jEdit.getProperty("options.editing.addMode.dialog.Either_file_name_glob_or_first_line_glob_or_both_must_be_filled_in.", "Either file name glob or first line glob or both must be filled in."), jEdit.getProperty("options.editing.addMode.dialog.errorTitle", "Error"), 0);
            return;
        }
        boolean bl2 = bl = jEdit.getMode(string) != null;
        if (bl && 0 != (n = JOptionPane.showConfirmDialog(this, jEdit.getProperty("options.editing.addMode.dialog.warning.message"), jEdit.getProperty("options.editing.addMode.dialog.warning.title") + " " + string, 0))) {
            return;
        }
        Mode mode = new Mode(string);
        mode.setProperty("file", string2);
        mode.setProperty("filenameGlob", string3);
        mode.setProperty("firstlineGlob", string4);
        File file = new File(string2);
        Path path = FileSystems.getDefault().getPath(jEdit.getSettingsDirectory(), "modes", file.getName());
        try {
            ModeProvider.instance.addUserMode(mode, path);
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(jEdit.getActiveView(), jEdit.getProperty("options.editing.addMode.dialog.warning.message1") + " " + string2 + "\n--> " + path);
        }
        jEdit.reloadModes();
        this.reloadLists(mode);
    }

    private void reloadLists(Mode mode) {
        Mode[] modeArray;
        ArrayList<Mode> arrayList = new ArrayList<Mode>();
        ArrayList<Mode> arrayList2 = new ArrayList<Mode>();
        for (Mode mode2 : modeArray = this.loadAllModes()) {
            boolean bl;
            boolean bl2 = bl = !jEdit.getBooleanProperty("mode.opt-out." + mode2.getName(), false);
            if (bl) {
                arrayList.add(mode2);
                continue;
            }
            arrayList2.add(mode2);
        }
        this.pingPongList.setLeftData(arrayList2);
        this.pingPongList.setRightData(arrayList);
        if (mode != null) {
            this.pingPongList.setRightSelected(mode);
        }
        this.defaultMode.setModel(new DefaultComboBoxModel<Mode>(this.loadSelectedModes()));
        this.defaultMode.setSelectedItem(jEdit.getMode(jEdit.getProperty("buffer.defaultMode")));
    }

    class MyListSelectionListener
    implements ListSelectionListener {
        MyListSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            List list = EditModesPane.this.pingPongList.getRightSelectedValues();
            boolean bl = false;
            for (Mode mode : list) {
                if (!mode.isUserMode()) continue;
                bl = true;
                break;
            }
            EditModesPane.this.deleteSelectedButton.setEnabled(bl);
        }
    }

    class MyCellRenderer
    extends JLabel
    implements ListCellRenderer<Mode> {
        MyCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends Mode> jList, Mode mode, int n, boolean bl, boolean bl2) {
            String string = mode.toString();
            this.setText(string);
            this.setForeground(mode.isUserMode() ? Color.GREEN : (bl ? jList.getSelectionForeground() : jList.getForeground()));
            this.setBackground(bl ? jList.getSelectionBackground() : jList.getBackground());
            this.setOpaque(true);
            return this;
        }
    }

    private class ActionHandler
    implements ActionListener {
        private ActionHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == EditModesPane.this.browse) {
                boolean bl;
                int n;
                String string;
                View view = jEdit.getActiveView();
                String[] stringArray = GUIUtilities.showVFSFileDialog(view, string = jEdit.getSettingsDirectory(), n = 0, bl = false);
                if (stringArray != null && stringArray.length > 0) {
                    EditModesPane.this.modeFile.setText(stringArray[0]);
                } else {
                    EditModesPane.this.modeFile.setText("");
                }
            } else if (object == EditModesPane.this.ok) {
                EditModesPane.this.ok();
            }
        }
    }
}

