/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm;

import java.util.ArrayList;
import java.util.List;
import org.openstreetmap.josm.data.osm.BBox;
import org.openstreetmap.josm.data.osm.IWay;
import org.openstreetmap.josm.data.osm.NodeData;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.PrimitiveData;
import org.openstreetmap.josm.data.osm.visitor.PrimitiveVisitor;

public class WayData
extends PrimitiveData
implements IWay<NodeData> {
    private static final long serialVersionUID = 106944939313286415L;
    private List<Long> nodes = new ArrayList<Long>();

    public WayData() {
    }

    public WayData(long id) {
        super(id);
    }

    public WayData(WayData data) {
        super(data);
        this.nodes.addAll(data.getNodeIds());
    }

    @Override
    public List<NodeData> getNodes() {
        throw new UnsupportedOperationException("Use getNodeIds() instead");
    }

    @Override
    public NodeData getNode(int index) {
        throw new UnsupportedOperationException("Use getNodeId(int) instead");
    }

    @Override
    public List<Long> getNodeIds() {
        return this.nodes;
    }

    @Override
    public int getNodesCount() {
        return this.nodes.size();
    }

    @Override
    public long getNodeId(int idx) {
        return this.nodes.get(idx);
    }

    @Override
    public boolean isClosed() {
        if (this.isIncomplete()) {
            return false;
        }
        return this.nodes.get(0).equals(this.nodes.get(this.nodes.size() - 1));
    }

    public void setNodes(List<Long> nodes) {
        this.nodes = new ArrayList<Long>(nodes);
    }

    @Override
    public WayData makeCopy() {
        return new WayData(this);
    }

    @Override
    public String toString() {
        return super.toString() + " WAY" + this.nodes;
    }

    @Override
    public OsmPrimitiveType getType() {
        return OsmPrimitiveType.WAY;
    }

    @Override
    public void accept(PrimitiveVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public BBox getBBox() {
        throw new UnsupportedOperationException();
    }
}

