/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.validation.tests;

import java.awt.Component;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.openstreetmap.josm.command.ChangePropertyCommand;
import org.openstreetmap.josm.command.ChangePropertyKeyCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.osm.AbstractPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.OsmUtils;
import org.openstreetmap.josm.data.osm.Tag;
import org.openstreetmap.josm.data.osm.TagMap;
import org.openstreetmap.josm.data.validation.Severity;
import org.openstreetmap.josm.data.validation.Test;
import org.openstreetmap.josm.data.validation.TestError;
import org.openstreetmap.josm.data.validation.util.Entities;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.gui.tagging.presets.TaggingPreset;
import org.openstreetmap.josm.gui.tagging.presets.TaggingPresetItem;
import org.openstreetmap.josm.gui.tagging.presets.TaggingPresets;
import org.openstreetmap.josm.gui.tagging.presets.items.Check;
import org.openstreetmap.josm.gui.tagging.presets.items.CheckGroup;
import org.openstreetmap.josm.gui.tagging.presets.items.KeyedItem;
import org.openstreetmap.josm.gui.widgets.EditableList;
import org.openstreetmap.josm.io.CachedFile;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.MultiMap;
import org.openstreetmap.josm.tools.Utils;

public class TagChecker
extends Test.TagTest {
    public static final String IGNORE_FILE = "resource://data/validator/ignoretags.cfg";
    public static final String SPELL_FILE = "resource://data/validator/words.cfg";
    private static final Map<String, String> harmonizedKeys = new HashMap<String, String>();
    private static volatile MultiMap<String, String> additionalPresetsValueData;
    private static final List<CheckerData> checkerData;
    private static final List<String> ignoreDataStartsWith;
    private static final List<String> ignoreDataEquals;
    private static final List<String> ignoreDataEndsWith;
    private static final List<Tag> ignoreDataTag;
    protected static final String PREFIX;
    public static final String PREF_CHECK_VALUES;
    public static final String PREF_CHECK_KEYS;
    public static final String PREF_CHECK_COMPLEX;
    public static final String PREF_CHECK_FIXMES;
    public static final String PREF_SOURCES;
    public static final String PREF_CHECK_KEYS_BEFORE_UPLOAD;
    public static final String PREF_CHECK_VALUES_BEFORE_UPLOAD;
    public static final String PREF_CHECK_COMPLEX_BEFORE_UPLOAD;
    public static final String PREF_CHECK_FIXMES_BEFORE_UPLOAD;
    protected boolean checkKeys;
    protected boolean checkValues;
    protected boolean checkComplex;
    protected boolean checkFixmes;
    protected JCheckBox prefCheckKeys;
    protected JCheckBox prefCheckValues;
    protected JCheckBox prefCheckComplex;
    protected JCheckBox prefCheckFixmes;
    protected JCheckBox prefCheckPaint;
    protected JCheckBox prefCheckKeysBeforeUpload;
    protected JCheckBox prefCheckValuesBeforeUpload;
    protected JCheckBox prefCheckComplexBeforeUpload;
    protected JCheckBox prefCheckFixmesBeforeUpload;
    protected JCheckBox prefCheckPaintBeforeUpload;
    protected static final int EMPTY_VALUES = 1200;
    protected static final int INVALID_KEY = 1201;
    protected static final int INVALID_VALUE = 1202;
    protected static final int FIXME = 1203;
    protected static final int INVALID_SPACE = 1204;
    protected static final int INVALID_KEY_SPACE = 1205;
    protected static final int INVALID_HTML = 1206;
    protected static final int LONG_VALUE = 1208;
    protected static final int LONG_KEY = 1209;
    protected static final int LOW_CHAR_VALUE = 1210;
    protected static final int LOW_CHAR_KEY = 1211;
    protected static final int MISSPELLED_VALUE = 1212;
    protected static final int MISSPELLED_KEY = 1213;
    protected static final int MULTIPLE_SPACES = 1214;
    protected EditableList sourcesList;
    private static final List<String> DEFAULT_SOURCES;

    public TagChecker() {
        super(I18n.tr("Tag checker", new Object[0]), I18n.tr("This test checks for errors in tag keys and values.", new Object[0]));
    }

    @Override
    public void initialize() throws IOException {
        TagChecker.initializeData();
        TagChecker.initializePresets();
    }

    private static void initializeData() throws IOException {
        checkerData.clear();
        ignoreDataStartsWith.clear();
        ignoreDataEquals.clear();
        ignoreDataEndsWith.clear();
        ignoreDataTag.clear();
        harmonizedKeys.clear();
        StringBuilder errorSources = new StringBuilder();
        for (String source : Config.getPref().getList(PREF_SOURCES, DEFAULT_SOURCES)) {
            try (CachedFile cf = new CachedFile(source);){
                BufferedReader reader = cf.getContentReader();
                Throwable throwable = null;
                try {
                    String line;
                    String okValue = null;
                    boolean tagcheckerfile = false;
                    boolean ignorefile = false;
                    boolean isFirstLine = true;
                    while ((line = reader.readLine()) != null && (tagcheckerfile || !line.isEmpty())) {
                        if (line.startsWith("#")) {
                            if (line.startsWith("# JOSM TagChecker")) {
                                tagcheckerfile = true;
                                if (!DEFAULT_SOURCES.contains(source)) {
                                    Logging.info(I18n.tr("Adding {0} to tag checker", source));
                                }
                            } else if (line.startsWith("# JOSM IgnoreTags")) {
                                ignorefile = true;
                                if (!DEFAULT_SOURCES.contains(source)) {
                                    Logging.info(I18n.tr("Adding {0} to ignore tags", source));
                                }
                            }
                        } else if (ignorefile) {
                            if ((line = line.trim()).length() < 4) continue;
                            String key = line.substring(0, 2);
                            line = line.substring(2);
                            switch (key) {
                                case "S:": {
                                    ignoreDataStartsWith.add(line);
                                    break;
                                }
                                case "E:": {
                                    ignoreDataEquals.add(line);
                                    break;
                                }
                                case "F:": {
                                    ignoreDataEndsWith.add(line);
                                    break;
                                }
                                case "K:": {
                                    ignoreDataTag.add(Tag.ofString(line));
                                    break;
                                }
                                default: {
                                    if (!key.startsWith(";")) {
                                        Logging.warn("Unsupported TagChecker key: " + key);
                                        break;
                                    } else {
                                        break;
                                    }
                                }
                            }
                        } else if (tagcheckerfile) {
                            if (!line.isEmpty()) {
                                CheckerData d = new CheckerData();
                                String err = d.getData(line);
                                if (err == null) {
                                    checkerData.add(d);
                                } else {
                                    Logging.error(I18n.tr("Invalid tagchecker line - {0}: {1}", err, line));
                                }
                            }
                        } else if (line.charAt(0) == '+') {
                            okValue = line.substring(1);
                        } else if (line.charAt(0) == '-' && okValue != null) {
                            harmonizedKeys.put(TagChecker.harmonizeKey(line.substring(1)), okValue);
                        } else {
                            Logging.error(I18n.tr("Invalid spellcheck line: {0}", line));
                        }
                        if (!isFirstLine) continue;
                        isFirstLine = false;
                        if (tagcheckerfile || ignorefile || DEFAULT_SOURCES.contains(source)) continue;
                        Logging.info(I18n.tr("Adding {0} to spellchecker", source));
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (reader == null) continue;
                    TagChecker.$closeResource(throwable, reader);
                }
            }
            catch (IOException e) {
                Logging.error(e);
                errorSources.append(source).append('\n');
            }
        }
        if (errorSources.length() > 0) {
            throw new IOException(I18n.tr("Could not access data file(s):\n{0}", errorSources));
        }
    }

    public static void initializePresets() {
        if (!Config.getPref().getBoolean(PREF_CHECK_VALUES, true)) {
            return;
        }
        Collection<TaggingPreset> presets = TaggingPresets.getTaggingPresets();
        if (!presets.isEmpty()) {
            additionalPresetsValueData = new MultiMap();
            for (String a : AbstractPrimitive.getUninterestingKeys()) {
                additionalPresetsValueData.putVoid(a);
            }
            for (String a : Config.getPref().getList("validator.knownkeys", Arrays.asList("is_in", "int_ref", "fixme", "population"))) {
                additionalPresetsValueData.putVoid(a);
            }
            for (TaggingPreset p : presets) {
                for (TaggingPresetItem i : p.data) {
                    if (i instanceof KeyedItem) {
                        TagChecker.addPresetValue((KeyedItem)i);
                        continue;
                    }
                    if (!(i instanceof CheckGroup)) continue;
                    for (Check c : ((CheckGroup)i).checks) {
                        TagChecker.addPresetValue(c);
                    }
                }
            }
        }
    }

    private static void addPresetValue(KeyedItem ky) {
        Collection<String> values = ky.getValues();
        if (ky.key != null && values != null) {
            harmonizedKeys.put(TagChecker.harmonizeKey(ky.key), ky.key);
        }
    }

    private static boolean containsLow(String s) {
        if (s == null) {
            return false;
        }
        for (int i = 0; i < s.length(); ++i) {
            if (s.charAt(i) >= ' ') continue;
            return true;
        }
        return false;
    }

    private static Set<String> getPresetValues(String key) {
        Set<String> res = TaggingPresets.getPresetValues(key);
        if (res != null) {
            return res;
        }
        return additionalPresetsValueData.get(key);
    }

    public static boolean isKeyInPresets(String key) {
        return TagChecker.getPresetValues(key) != null;
    }

    public static boolean isTagInPresets(String key, String value) {
        Set<String> values = TagChecker.getPresetValues(key);
        return values != null && (values.isEmpty() || values.contains(value));
    }

    public static List<Tag> getIgnoredTags() {
        return new ArrayList<Tag>(ignoreDataTag);
    }

    public static boolean isTagIgnored(String key, String value) {
        boolean tagInPresets = TagChecker.isTagInPresets(key, value);
        boolean ignore = false;
        for (String string : ignoreDataStartsWith) {
            if (!key.startsWith(string)) continue;
            ignore = true;
        }
        for (String string : ignoreDataEquals) {
            if (!key.equals(string)) continue;
            ignore = true;
        }
        for (String string : ignoreDataEndsWith) {
            if (!key.endsWith(string)) continue;
            ignore = true;
        }
        if (!tagInPresets) {
            for (Tag tag : ignoreDataTag) {
                if (!key.equals(tag.getKey()) || !value.equals(tag.getValue())) continue;
                ignore = true;
            }
        }
        return ignore;
    }

    @Override
    public void check(OsmPrimitive p) {
        MultiMap<OsmPrimitive, String> withErrors = new MultiMap<OsmPrimitive, String>();
        if (this.checkComplex) {
            TagMap keys = p.getKeys();
            for (CheckerData d : checkerData) {
                if (!d.match(p, keys)) continue;
                this.errors.add(TestError.builder(this, d.getSeverity(), d.getCode()).message(I18n.tr("Suspicious tag/value combinations", new Object[0]), d.getDescription(), new Object[0]).primitives(p).build());
                withErrors.put(p, "TC");
            }
        }
        for (Map.Entry<String, String> prop : p.getKeys().entrySet()) {
            String s = I18n.marktr("Tag ''{0}'' invalid.");
            String key = prop.getKey();
            String value = prop.getValue();
            if (this.checkValues && TagChecker.containsLow(value) && !withErrors.contains(p, "ICV")) {
                this.errors.add(TestError.builder(this, Severity.WARNING, 1210).message(I18n.tr("Tag value contains character with code less than 0x20", new Object[0]), s, key).primitives(p).build());
                withErrors.put(p, "ICV");
            }
            if (this.checkKeys && TagChecker.containsLow(key) && !withErrors.contains(p, "ICK")) {
                this.errors.add(TestError.builder(this, Severity.WARNING, 1211).message(I18n.tr("Tag key contains character with code less than 0x20", new Object[0]), s, key).primitives(p).build());
                withErrors.put(p, "ICK");
            }
            if (this.checkValues && value != null && value.length() > 255 && !withErrors.contains(p, "LV")) {
                this.errors.add(TestError.builder(this, Severity.ERROR, 1208).message(I18n.tr("Tag value longer than {0} characters ({1} characters)", 255, value.length()), s, key).primitives(p).build());
                withErrors.put(p, "LV");
            }
            if (this.checkKeys && key != null && key.length() > 255 && !withErrors.contains(p, "LK")) {
                this.errors.add(TestError.builder(this, Severity.ERROR, 1209).message(I18n.tr("Tag key longer than {0} characters ({1} characters)", 255, key.length()), s, key).primitives(p).build());
                withErrors.put(p, "LK");
            }
            if (this.checkValues && (value == null || value.trim().isEmpty()) && !withErrors.contains(p, "EV")) {
                this.errors.add(TestError.builder(this, Severity.WARNING, 1200).message(I18n.tr("Tags with empty values", new Object[0]), s, key).primitives(p).build());
                withErrors.put(p, "EV");
            }
            if (this.checkKeys && key != null && key.indexOf(32) >= 0 && !withErrors.contains(p, "IPK")) {
                this.errors.add(TestError.builder(this, Severity.WARNING, 1205).message(I18n.tr("Invalid white space in property key", new Object[0]), s, key).primitives(p).build());
                withErrors.put(p, "IPK");
            }
            if (this.checkValues && value != null && (value.startsWith(" ") || value.endsWith(" ")) && !withErrors.contains(p, "SPACE")) {
                this.errors.add(TestError.builder(this, Severity.WARNING, 1204).message(I18n.tr("Property values start or end with white space", new Object[0]), s, key).primitives(p).build());
                withErrors.put(p, "SPACE");
            }
            if (this.checkValues && value != null && value.contains("  ") && !withErrors.contains(p, "SPACE")) {
                this.errors.add(TestError.builder(this, Severity.WARNING, 1214).message(I18n.tr("Property values contain multiple white spaces", new Object[0]), s, key).primitives(p).build());
                withErrors.put(p, "SPACE");
            }
            if (this.checkValues && value != null && !value.equals(Entities.unescape(value)) && !withErrors.contains(p, "HTML")) {
                this.errors.add(TestError.builder(this, Severity.OTHER, 1206).message(I18n.tr("Property values contain HTML entity", new Object[0]), s, key).primitives(p).build());
                withErrors.put(p, "HTML");
            }
            if (this.checkValues && key != null && value != null && !value.isEmpty() && additionalPresetsValueData != null && !TagChecker.isTagIgnored(key, value)) {
                if (!TagChecker.isKeyInPresets(key)) {
                    String prettifiedKey = TagChecker.harmonizeKey(key);
                    String fixedKey = harmonizedKeys.get(prettifiedKey);
                    if (fixedKey != null && !"".equals(fixedKey) && !fixedKey.equals(key)) {
                        TestError.Builder error = TestError.builder(this, Severity.WARNING, 1213).message(I18n.tr("Misspelled property key", new Object[0]), I18n.marktr("Key ''{0}'' looks like ''{1}''."), key, fixedKey).primitives(p);
                        if (p.hasKey(fixedKey)) {
                            this.errors.add(error.build());
                        } else {
                            this.errors.add(error.fix(() -> new ChangePropertyKeyCommand(p, key, fixedKey)).build());
                        }
                        withErrors.put(p, "WPK");
                    } else {
                        this.errors.add(TestError.builder(this, Severity.OTHER, 1202).message(I18n.tr("Presets do not contain property key", new Object[0]), I18n.marktr("Key ''{0}'' not in presets."), key).primitives(p).build());
                        withErrors.put(p, "UPK");
                    }
                } else if (!TagChecker.isTagInPresets(key, value)) {
                    String fixedValue = TagChecker.harmonizeValue(prop.getValue());
                    Map<String, String> possibleValues = TagChecker.getPossibleValues(TagChecker.getPresetValues(key));
                    if (possibleValues.containsKey(fixedValue)) {
                        String newKey = possibleValues.get(fixedValue);
                        this.errors.add(TestError.builder(this, Severity.WARNING, 1212).message(I18n.tr("Misspelled property value", new Object[0]), I18n.marktr("Value ''{0}'' for key ''{1}'' looks like ''{2}''."), prop.getValue(), key, fixedValue).primitives(p).fix(() -> new ChangePropertyCommand(p, key, newKey)).build());
                        withErrors.put(p, "WPV");
                    } else {
                        this.errors.add(TestError.builder(this, Severity.OTHER, 1202).message(I18n.tr("Presets do not contain property value", new Object[0]), I18n.marktr("Value ''{0}'' for key ''{1}'' not in presets."), prop.getValue(), key).primitives(p).build());
                        withErrors.put(p, "UPV");
                    }
                }
            }
            if (!this.checkFixmes || key == null || value == null || value.isEmpty() || !TagChecker.isFixme(key, value) || withErrors.contains(p, "FIXME")) continue;
            this.errors.add(TestError.builder(this, Severity.OTHER, 1203).message(I18n.tr("FIXMES", new Object[0])).primitives(p).build());
            withErrors.put(p, "FIXME");
        }
    }

    private static boolean isFixme(String key, String value) {
        return key.toLowerCase(Locale.ENGLISH).contains("fixme") || key.contains("todo") || value.toLowerCase(Locale.ENGLISH).contains("fixme") || value.contains("check and delete");
    }

    private static Map<String, String> getPossibleValues(Set<String> values) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (values != null) {
            for (String value : values) {
                map.put(value, value);
                if (!value.contains("_")) continue;
                map.put(value.replace("_", ""), value);
            }
        }
        return map;
    }

    private static String harmonizeKey(String key) {
        return Utils.strip(key.toLowerCase(Locale.ENGLISH).replace('-', '_').replace(':', '_').replace(' ', '_'), "-_;:,");
    }

    private static String harmonizeValue(String value) {
        return Utils.strip(value.toLowerCase(Locale.ENGLISH).replace('-', '_').replace(' ', '_'), "-_;:,");
    }

    @Override
    public void startTest(ProgressMonitor monitor) {
        super.startTest(monitor);
        this.checkKeys = Config.getPref().getBoolean(PREF_CHECK_KEYS, true);
        if (this.isBeforeUpload) {
            this.checkKeys = this.checkKeys && Config.getPref().getBoolean(PREF_CHECK_KEYS_BEFORE_UPLOAD, true);
        }
        this.checkValues = Config.getPref().getBoolean(PREF_CHECK_VALUES, true);
        if (this.isBeforeUpload) {
            this.checkValues = this.checkValues && Config.getPref().getBoolean(PREF_CHECK_VALUES_BEFORE_UPLOAD, true);
        }
        this.checkComplex = Config.getPref().getBoolean(PREF_CHECK_COMPLEX, true);
        if (this.isBeforeUpload) {
            this.checkComplex = this.checkComplex && Config.getPref().getBoolean(PREF_CHECK_COMPLEX_BEFORE_UPLOAD, true);
        }
        this.checkFixmes = Config.getPref().getBoolean(PREF_CHECK_FIXMES, true);
        if (this.isBeforeUpload) {
            this.checkFixmes = this.checkFixmes && Config.getPref().getBoolean(PREF_CHECK_FIXMES_BEFORE_UPLOAD, true);
        }
    }

    @Override
    public void visit(Collection<OsmPrimitive> selection) {
        if (this.checkKeys || this.checkValues || this.checkComplex || this.checkFixmes) {
            super.visit(selection);
        }
    }

    @Override
    public void addGui(JPanel testPanel) {
        GBC a = GBC.eol();
        a.anchor = 13;
        testPanel.add((Component)new JLabel(this.name + " :"), GBC.eol().insets(3, 0, 0, 0));
        this.prefCheckKeys = new JCheckBox(I18n.tr("Check property keys.", new Object[0]), Config.getPref().getBoolean(PREF_CHECK_KEYS, true));
        this.prefCheckKeys.setToolTipText(I18n.tr("Validate that property keys are valid checking against list of words.", new Object[0]));
        testPanel.add((Component)this.prefCheckKeys, GBC.std().insets(20, 0, 0, 0));
        this.prefCheckKeysBeforeUpload = new JCheckBox();
        this.prefCheckKeysBeforeUpload.setSelected(Config.getPref().getBoolean(PREF_CHECK_KEYS_BEFORE_UPLOAD, true));
        testPanel.add((Component)this.prefCheckKeysBeforeUpload, a);
        this.prefCheckComplex = new JCheckBox(I18n.tr("Use complex property checker.", new Object[0]), Config.getPref().getBoolean(PREF_CHECK_COMPLEX, true));
        this.prefCheckComplex.setToolTipText(I18n.tr("Validate property values and tags using complex rules.", new Object[0]));
        testPanel.add((Component)this.prefCheckComplex, GBC.std().insets(20, 0, 0, 0));
        this.prefCheckComplexBeforeUpload = new JCheckBox();
        this.prefCheckComplexBeforeUpload.setSelected(Config.getPref().getBoolean(PREF_CHECK_COMPLEX_BEFORE_UPLOAD, true));
        testPanel.add((Component)this.prefCheckComplexBeforeUpload, a);
        List<String> sources = Config.getPref().getList(PREF_SOURCES, DEFAULT_SOURCES);
        this.sourcesList = new EditableList(I18n.tr("TagChecker source", new Object[0]));
        this.sourcesList.setItems(sources);
        testPanel.add((Component)new JLabel(I18n.tr("Data sources ({0})", "*.cfg")), GBC.eol().insets(23, 0, 0, 0));
        testPanel.add((Component)this.sourcesList, GBC.eol().fill(2).insets(23, 0, 0, 0));
        ActionListener disableCheckActionListener = e -> this.handlePrefEnable();
        this.prefCheckKeys.addActionListener(disableCheckActionListener);
        this.prefCheckKeysBeforeUpload.addActionListener(disableCheckActionListener);
        this.prefCheckComplex.addActionListener(disableCheckActionListener);
        this.prefCheckComplexBeforeUpload.addActionListener(disableCheckActionListener);
        this.handlePrefEnable();
        this.prefCheckValues = new JCheckBox(I18n.tr("Check property values.", new Object[0]), Config.getPref().getBoolean(PREF_CHECK_VALUES, true));
        this.prefCheckValues.setToolTipText(I18n.tr("Validate that property values are valid checking against presets.", new Object[0]));
        testPanel.add((Component)this.prefCheckValues, GBC.std().insets(20, 0, 0, 0));
        this.prefCheckValuesBeforeUpload = new JCheckBox();
        this.prefCheckValuesBeforeUpload.setSelected(Config.getPref().getBoolean(PREF_CHECK_VALUES_BEFORE_UPLOAD, true));
        testPanel.add((Component)this.prefCheckValuesBeforeUpload, a);
        this.prefCheckFixmes = new JCheckBox(I18n.tr("Check for FIXMES.", new Object[0]), Config.getPref().getBoolean(PREF_CHECK_FIXMES, true));
        this.prefCheckFixmes.setToolTipText(I18n.tr("Looks for nodes or ways with FIXME in any property value.", new Object[0]));
        testPanel.add((Component)this.prefCheckFixmes, GBC.std().insets(20, 0, 0, 0));
        this.prefCheckFixmesBeforeUpload = new JCheckBox();
        this.prefCheckFixmesBeforeUpload.setSelected(Config.getPref().getBoolean(PREF_CHECK_FIXMES_BEFORE_UPLOAD, true));
        testPanel.add((Component)this.prefCheckFixmesBeforeUpload, a);
    }

    public void handlePrefEnable() {
        boolean selected = this.prefCheckKeys.isSelected() || this.prefCheckKeysBeforeUpload.isSelected() || this.prefCheckComplex.isSelected() || this.prefCheckComplexBeforeUpload.isSelected();
        this.sourcesList.setEnabled(selected);
    }

    @Override
    public boolean ok() {
        this.enabled = this.prefCheckKeys.isSelected() || this.prefCheckValues.isSelected() || this.prefCheckComplex.isSelected() || this.prefCheckFixmes.isSelected();
        this.testBeforeUpload = this.prefCheckKeysBeforeUpload.isSelected() || this.prefCheckValuesBeforeUpload.isSelected() || this.prefCheckFixmesBeforeUpload.isSelected() || this.prefCheckComplexBeforeUpload.isSelected();
        Config.getPref().putBoolean(PREF_CHECK_VALUES, this.prefCheckValues.isSelected());
        Config.getPref().putBoolean(PREF_CHECK_COMPLEX, this.prefCheckComplex.isSelected());
        Config.getPref().putBoolean(PREF_CHECK_KEYS, this.prefCheckKeys.isSelected());
        Config.getPref().putBoolean(PREF_CHECK_FIXMES, this.prefCheckFixmes.isSelected());
        Config.getPref().putBoolean(PREF_CHECK_VALUES_BEFORE_UPLOAD, this.prefCheckValuesBeforeUpload.isSelected());
        Config.getPref().putBoolean(PREF_CHECK_COMPLEX_BEFORE_UPLOAD, this.prefCheckComplexBeforeUpload.isSelected());
        Config.getPref().putBoolean(PREF_CHECK_KEYS_BEFORE_UPLOAD, this.prefCheckKeysBeforeUpload.isSelected());
        Config.getPref().putBoolean(PREF_CHECK_FIXMES_BEFORE_UPLOAD, this.prefCheckFixmesBeforeUpload.isSelected());
        return Config.getPref().putList(PREF_SOURCES, this.sourcesList.getItems());
    }

    @Override
    public Command fixError(TestError testError) {
        ArrayList<Command> commands = new ArrayList<Command>(50);
        Collection<? extends OsmPrimitive> primitives = testError.getPrimitives();
        for (OsmPrimitive osmPrimitive : primitives) {
            TagMap tags = osmPrimitive.getKeys();
            if (tags.isEmpty()) continue;
            for (Map.Entry prop : tags.entrySet()) {
                String key = (String)prop.getKey();
                String value = (String)prop.getValue();
                if (value == null || value.trim().isEmpty()) {
                    commands.add(new ChangePropertyCommand(osmPrimitive, key, null));
                    continue;
                }
                if (value.startsWith(" ") || value.endsWith(" ") || value.contains("  ")) {
                    commands.add(new ChangePropertyCommand(osmPrimitive, key, Utils.removeWhiteSpaces(value)));
                    continue;
                }
                if (key.startsWith(" ") || key.endsWith(" ") || key.contains("  ")) {
                    commands.add(new ChangePropertyKeyCommand(osmPrimitive, key, Utils.removeWhiteSpaces(key)));
                    continue;
                }
                String evalue = Entities.unescape(value);
                if (evalue.equals(value)) continue;
                commands.add(new ChangePropertyCommand(osmPrimitive, key, evalue));
            }
        }
        if (commands.isEmpty()) {
            return null;
        }
        if (commands.size() == 1) {
            return (Command)commands.get(0);
        }
        return new SequenceCommand(I18n.tr("Fix tags", new Object[0]), commands);
    }

    @Override
    public boolean isFixable(TestError testError) {
        if (testError.getTester() instanceof TagChecker) {
            int code = testError.getCode();
            return code == 1201 || code == 1200 || code == 1204 || code == 1205 || code == 1206 || code == 1212 || code == 1214;
        }
        return false;
    }

    static {
        checkerData = new ArrayList<CheckerData>();
        ignoreDataStartsWith = new ArrayList<String>();
        ignoreDataEquals = new ArrayList<String>();
        ignoreDataEndsWith = new ArrayList<String>();
        ignoreDataTag = new ArrayList<Tag>();
        PREFIX = "validator." + TagChecker.class.getSimpleName();
        PREF_CHECK_VALUES = PREFIX + ".checkValues";
        PREF_CHECK_KEYS = PREFIX + ".checkKeys";
        PREF_CHECK_COMPLEX = PREFIX + ".checkComplex";
        PREF_CHECK_FIXMES = PREFIX + ".checkFixmes";
        PREF_SOURCES = PREFIX + ".source";
        PREF_CHECK_KEYS_BEFORE_UPLOAD = PREF_CHECK_KEYS + "BeforeUpload";
        PREF_CHECK_VALUES_BEFORE_UPLOAD = PREF_CHECK_VALUES + "BeforeUpload";
        PREF_CHECK_COMPLEX_BEFORE_UPLOAD = PREF_CHECK_COMPLEX + "BeforeUpload";
        PREF_CHECK_FIXMES_BEFORE_UPLOAD = PREF_CHECK_FIXMES + "BeforeUpload";
        DEFAULT_SOURCES = Arrays.asList(IGNORE_FILE, SPELL_FILE);
    }

    protected static class CheckerData {
        private String description;
        protected List<CheckerElement> data = new ArrayList<CheckerElement>();
        private OsmPrimitiveType type;
        private TagCheckLevel level;
        protected Severity severity;
        private static final Pattern CLEAN_STR_PATTERN = Pattern.compile(" *# *([^#]+) *$");
        private static final Pattern SPLIT_TRIMMED_PATTERN = Pattern.compile(" *: *");
        private static final Pattern SPLIT_ELEMENTS_PATTERN = Pattern.compile(" *&& *");

        protected CheckerData() {
        }

        public String getData(String str) {
            Matcher m = CLEAN_STR_PATTERN.matcher(str);
            String trimmed = m.replaceFirst("").trim();
            try {
                this.description = m.group(1);
                if (this.description != null && this.description.isEmpty()) {
                    this.description = null;
                }
            }
            catch (IllegalStateException e) {
                Logging.error(e);
                this.description = null;
            }
            String[] n = SPLIT_TRIMMED_PATTERN.split(trimmed, 3);
            switch (n[0]) {
                case "way": {
                    this.type = OsmPrimitiveType.WAY;
                    break;
                }
                case "node": {
                    this.type = OsmPrimitiveType.NODE;
                    break;
                }
                case "relation": {
                    this.type = OsmPrimitiveType.RELATION;
                    break;
                }
                case "*": {
                    this.type = null;
                    break;
                }
                default: {
                    return I18n.tr("Could not find element type", new Object[0]);
                }
            }
            if (n.length != 3) {
                return I18n.tr("Incorrect number of parameters", new Object[0]);
            }
            switch (n[1]) {
                case "W": {
                    this.severity = Severity.WARNING;
                    this.level = TagCheckLevel.TAG_CHECK_WARN;
                    break;
                }
                case "E": {
                    this.severity = Severity.ERROR;
                    this.level = TagCheckLevel.TAG_CHECK_ERROR;
                    break;
                }
                case "I": {
                    this.severity = Severity.OTHER;
                    this.level = TagCheckLevel.TAG_CHECK_INFO;
                    break;
                }
                default: {
                    return I18n.tr("Could not find warning level", new Object[0]);
                }
            }
            for (String exp : SPLIT_ELEMENTS_PATTERN.split(n[2])) {
                try {
                    this.data.add(new CheckerElement(exp));
                }
                catch (IllegalStateException e) {
                    Logging.trace(e);
                    return I18n.tr("Illegal expression ''{0}''", exp);
                }
                catch (PatternSyntaxException e) {
                    Logging.trace(e);
                    return I18n.tr("Illegal regular expression ''{0}''", exp);
                }
            }
            return null;
        }

        public boolean match(OsmPrimitive osm, Map<String, String> keys) {
            if (this.type != null && OsmPrimitiveType.from(osm) != this.type) {
                return false;
            }
            for (CheckerElement ce : this.data) {
                if (ce.match(keys)) continue;
                return false;
            }
            return true;
        }

        public String getDescription() {
            return this.description;
        }

        public Severity getSeverity() {
            return this.severity;
        }

        public int getCode() {
            if (this.type == null) {
                return this.level.code;
            }
            return this.level.code + this.type.ordinal() + 1;
        }

        protected static class CheckerElement {
            public Object tag;
            public Object value;
            public boolean noMatch;
            public boolean tagAll;
            public boolean valueAll;
            public boolean valueBool;

            private static Pattern getPattern(String str) {
                if (str.endsWith("/i")) {
                    return Pattern.compile(str.substring(1, str.length() - 2), 2);
                }
                if (str.endsWith("/")) {
                    return Pattern.compile(str.substring(1, str.length() - 1));
                }
                throw new IllegalStateException();
            }

            public CheckerElement(String exp) {
                Matcher m = Pattern.compile("(.+)([!=]=)(.+)").matcher(exp);
                m.matches();
                String n = m.group(1).trim();
                if ("*".equals(n)) {
                    this.tagAll = true;
                } else {
                    this.tag = n.startsWith("/") ? CheckerElement.getPattern(n) : n;
                    this.noMatch = "!=".equals(m.group(2));
                    n = m.group(3).trim();
                    if ("*".equals(n)) {
                        this.valueAll = true;
                    } else if ("BOOLEAN_TRUE".equals(n)) {
                        this.valueBool = true;
                        this.value = "yes";
                    } else if ("BOOLEAN_FALSE".equals(n)) {
                        this.valueBool = true;
                        this.value = "no";
                    } else {
                        this.value = n.startsWith("/") ? CheckerElement.getPattern(n) : n;
                    }
                }
            }

            public boolean match(Map<String, String> keys) {
                for (Map.Entry<String, String> prop : keys.entrySet()) {
                    String val;
                    String key = prop.getKey();
                    String string = val = this.valueBool ? OsmUtils.getNamedOsmBoolean(prop.getValue()) : prop.getValue();
                    if (!this.tagAll && !(this.tag instanceof Pattern ? ((Pattern)this.tag).matcher(key).matches() : key.equals(this.tag)) || !this.valueAll && !(this.value instanceof Pattern ? ((Pattern)this.value).matcher(val).matches() : val.equals(this.value))) continue;
                    return !this.noMatch;
                }
                return this.noMatch;
            }
        }

        private static enum TagCheckLevel {
            TAG_CHECK_ERROR(1250),
            TAG_CHECK_WARN(1260),
            TAG_CHECK_INFO(1270);

            final int code;

            private TagCheckLevel(int code) {
                this.code = code;
            }
        }
    }
}

