/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.osgi.updatesite;

import java.net.URI;
import org.apache.ivy.osgi.core.BundleInfo;
import org.apache.ivy.osgi.core.BundleRequirement;
import org.apache.ivy.osgi.updatesite.xml.EclipseFeature;
import org.apache.ivy.osgi.updatesite.xml.EclipsePlugin;
import org.apache.ivy.osgi.updatesite.xml.Require;
import org.apache.ivy.osgi.util.VersionRange;

public class PluginAdapter {
    public static BundleInfo featureAsBundle(URI uRI, EclipseFeature eclipseFeature) {
        BundleInfo bundleInfo = new BundleInfo(eclipseFeature.getId(), eclipseFeature.getVersion());
        if (eclipseFeature.getUrl() == null) {
            bundleInfo.setUri(uRI.resolve("features/" + eclipseFeature.getId() + '_' + eclipseFeature.getVersion() + ".jar"));
        } else {
            bundleInfo.setUri(uRI.resolve(eclipseFeature.getUrl()));
        }
        bundleInfo.setDescription(eclipseFeature.getDescription());
        bundleInfo.setLicense(eclipseFeature.getLicense());
        for (Object object : eclipseFeature.getPlugins()) {
            Object object2 = new BundleRequirement("bundle", ((EclipsePlugin)object).getId(), new VersionRange(((EclipsePlugin)object).getVersion()), null);
            bundleInfo.addRequirement((BundleRequirement)object2);
        }
        for (Object object2 : eclipseFeature.getRequires()) {
            String string = ((Require)object2).getPlugin() != null ? ((Require)object2).getPlugin() : ((Require)object2).getFeature();
            if (!((Require)object2).getMatch().equals("greaterOrEqual")) {
                throw new IllegalStateException("unsupported match " + ((Require)object2).getMatch());
            }
            VersionRange versionRange = new VersionRange(((Require)object2).getVersion());
            BundleRequirement bundleRequirement = new BundleRequirement("bundle", string, versionRange, null);
            bundleInfo.addRequirement(bundleRequirement);
        }
        return bundleInfo;
    }

    public static BundleInfo pluginAsBundle(URI uRI, EclipsePlugin eclipsePlugin) {
        BundleInfo bundleInfo = new BundleInfo(eclipsePlugin.getId(), eclipsePlugin.getVersion());
        bundleInfo.setUri(uRI.resolve("plugins/" + eclipsePlugin.getId() + '_' + eclipsePlugin.getVersion() + ".jar"));
        return bundleInfo;
    }
}

