/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import javax.media.j3d.Bounds;
import javax.media.j3d.PickShape;
import javax.media.j3d.Transform3D;
import javax.vecmath.Point3d;
import javax.vecmath.Point4d;
import javax.vecmath.Vector3d;

public final class PickRay
extends PickShape {
    Point3d origin;
    Vector3d direction;

    public PickRay() {
        this.origin = new Point3d();
        this.direction = new Vector3d();
    }

    public PickRay(Point3d point3d, Vector3d vector3d) {
        this.origin = new Point3d(point3d);
        this.direction = new Vector3d(vector3d);
    }

    public void set(Point3d point3d, Vector3d vector3d) {
        this.origin.x = point3d.x;
        this.origin.y = point3d.y;
        this.origin.z = point3d.z;
        this.direction.x = vector3d.x;
        this.direction.y = vector3d.y;
        this.direction.z = vector3d.z;
    }

    public void get(Point3d point3d, Vector3d vector3d) {
        point3d.x = this.origin.x;
        point3d.y = this.origin.y;
        point3d.z = this.origin.z;
        vector3d.x = this.direction.x;
        vector3d.y = this.direction.y;
        vector3d.z = this.direction.z;
    }

    final boolean intersect(Bounds bounds, Point4d point4d) {
        return bounds.intersect(this.origin, this.direction, point4d);
    }

    PickShape transform(Transform3D transform3D) {
        Point3d point3d = new Point3d();
        PickRay pickRay = new PickRay(this.origin, this.direction);
        point3d.x = this.origin.x + this.direction.x;
        point3d.y = this.origin.y + this.direction.y;
        point3d.z = this.origin.z + this.direction.z;
        transform3D.transform(pickRay.origin);
        transform3D.transform(point3d);
        pickRay.direction.x = point3d.x - pickRay.origin.x;
        pickRay.direction.y = point3d.y - pickRay.origin.y;
        pickRay.direction.z = point3d.z - pickRay.origin.z;
        pickRay.direction.normalize();
        return pickRay;
    }

    Point3d getStartPoint() {
        return this.origin;
    }

    int getPickType() {
        return 1;
    }
}

