/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.Context;
import javax.media.j3d.J3dI18N;
import javax.media.j3d.J3dNotification;
import javax.media.j3d.NodeComponentRetained;
import javax.media.j3d.Shader;
import javax.media.j3d.ShaderAttrLoc;
import javax.media.j3d.ShaderAttribute;
import javax.media.j3d.ShaderAttributeArrayRetained;
import javax.media.j3d.ShaderAttributeBindingRetained;
import javax.media.j3d.ShaderAttributeObjectRetained;
import javax.media.j3d.ShaderAttributeRetained;
import javax.media.j3d.ShaderAttributeSet;
import javax.media.j3d.ShaderAttributeSetRetained;
import javax.media.j3d.ShaderAttributeValueRetained;
import javax.media.j3d.ShaderError;
import javax.media.j3d.ShaderId;
import javax.media.j3d.ShaderProgram;
import javax.media.j3d.ShaderProgramId;
import javax.media.j3d.ShaderRetained;
import javax.media.j3d.SourceCodeShaderRetained;
import javax.media.j3d.VirtualUniverse;

abstract class ShaderProgramRetained
extends NodeComponentRetained {
    protected ShaderProgramData[] shaderProgramData;
    private boolean unsupportedErrorReported = false;
    private boolean linkErrorOccurred = false;
    protected ShaderRetained[] shaders;
    protected String[] vertexAttrNames;
    protected String[] shaderAttrNames;
    private HashSet<ShaderAttribute> shaderAttrErrorSet = null;
    Object resourceLock = new Object();

    ShaderProgramRetained() {
    }

    void setVertexAttrNames(String[] stringArray) {
        this.vertexAttrNames = stringArray == null ? null : (String[])stringArray.clone();
    }

    String[] getVertexAttrNames() {
        if (this.vertexAttrNames == null) {
            return null;
        }
        return (String[])this.vertexAttrNames.clone();
    }

    void setShaderAttrNames(String[] stringArray) {
        this.shaderAttrNames = stringArray == null ? null : (String[])stringArray.clone();
    }

    String[] getShaderAttrNames() {
        if (this.shaderAttrNames == null) {
            return null;
        }
        return (String[])this.shaderAttrNames.clone();
    }

    void setShaders(Shader[] shaderArray) {
        if (shaderArray == null) {
            this.shaders = null;
            return;
        }
        this.shaders = new ShaderRetained[shaderArray.length];
        for (int i = 0; i < shaderArray.length; ++i) {
            this.shaders[i] = (ShaderRetained)shaderArray[i].retained;
        }
    }

    Shader[] getShaders() {
        if (this.shaders == null) {
            return null;
        }
        Shader[] shaderArray = new Shader[this.shaders.length];
        for (int i = 0; i < this.shaders.length; ++i) {
            shaderArray[i] = this.shaders[i] != null ? (Shader)this.shaders[i].source : null;
        }
        return shaderArray;
    }

    abstract ShaderError createShader(Context var1, ShaderRetained var2, ShaderId[] var3);

    abstract ShaderError destroyShader(Context var1, ShaderId var2);

    abstract ShaderError compileShader(Context var1, ShaderId var2, String var3);

    abstract ShaderError createShaderProgram(Context var1, ShaderProgramId[] var2);

    abstract ShaderError destroyShaderProgram(Context var1, ShaderProgramId var2);

    abstract ShaderError linkShaderProgram(Context var1, ShaderProgramId var2, ShaderId[] var3);

    abstract ShaderError bindVertexAttrName(Context var1, ShaderProgramId var2, String var3, int var4);

    abstract void lookupShaderAttrNames(Context var1, ShaderProgramId var2, String[] var3, AttrNameInfo[] var4);

    abstract void lookupVertexAttrNames(Context var1, ShaderProgramId var2, String[] var3, boolean[] var4);

    abstract ShaderError enableShaderProgram(Context var1, ShaderProgramId var2);

    abstract ShaderError disableShaderProgram(Context var1);

    abstract ShaderError setUniform1i(Context var1, ShaderProgramId var2, ShaderAttrLoc var3, int var4);

    abstract ShaderError setUniform1f(Context var1, ShaderProgramId var2, ShaderAttrLoc var3, float var4);

    abstract ShaderError setUniform2i(Context var1, ShaderProgramId var2, ShaderAttrLoc var3, int[] var4);

    abstract ShaderError setUniform2f(Context var1, ShaderProgramId var2, ShaderAttrLoc var3, float[] var4);

    abstract ShaderError setUniform3i(Context var1, ShaderProgramId var2, ShaderAttrLoc var3, int[] var4);

    abstract ShaderError setUniform3f(Context var1, ShaderProgramId var2, ShaderAttrLoc var3, float[] var4);

    abstract ShaderError setUniform4i(Context var1, ShaderProgramId var2, ShaderAttrLoc var3, int[] var4);

    abstract ShaderError setUniform4f(Context var1, ShaderProgramId var2, ShaderAttrLoc var3, float[] var4);

    abstract ShaderError setUniformMatrix3f(Context var1, ShaderProgramId var2, ShaderAttrLoc var3, float[] var4);

    abstract ShaderError setUniformMatrix4f(Context var1, ShaderProgramId var2, ShaderAttrLoc var3, float[] var4);

    abstract ShaderError setUniform1iArray(Context var1, ShaderProgramId var2, ShaderAttrLoc var3, int var4, int[] var5);

    abstract ShaderError setUniform1fArray(Context var1, ShaderProgramId var2, ShaderAttrLoc var3, int var4, float[] var5);

    abstract ShaderError setUniform2iArray(Context var1, ShaderProgramId var2, ShaderAttrLoc var3, int var4, int[] var5);

    abstract ShaderError setUniform2fArray(Context var1, ShaderProgramId var2, ShaderAttrLoc var3, int var4, float[] var5);

    abstract ShaderError setUniform3iArray(Context var1, ShaderProgramId var2, ShaderAttrLoc var3, int var4, int[] var5);

    abstract ShaderError setUniform3fArray(Context var1, ShaderProgramId var2, ShaderAttrLoc var3, int var4, float[] var5);

    abstract ShaderError setUniform4iArray(Context var1, ShaderProgramId var2, ShaderAttrLoc var3, int var4, int[] var5);

    abstract ShaderError setUniform4fArray(Context var1, ShaderProgramId var2, ShaderAttrLoc var3, int var4, float[] var5);

    abstract ShaderError setUniformMatrix3fArray(Context var1, ShaderProgramId var2, ShaderAttrLoc var3, int var4, float[] var5);

    abstract ShaderError setUniformMatrix4fArray(Context var1, ShaderProgramId var2, ShaderAttrLoc var3, int var4, float[] var5);

    abstract boolean isSupported(Canvas3D var1);

    void setLive(boolean bl, int n) {
        if (this.shaders != null) {
            for (int i = 0; i < this.shaders.length; ++i) {
                this.shaders[i].setLive(bl, n);
            }
        }
        super.doSetLive(bl, n);
        super.markAsLive();
    }

    void clearLive(int n) {
        super.clearLive(n);
        if (this.shaders != null) {
            for (int i = 0; i < this.shaders.length; ++i) {
                this.shaders[i].clearLive(n);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ShaderError enableShaderProgram(Canvas3D canvas3D, int n) {
        assert (n >= 0);
        Object object = this.resourceLock;
        synchronized (object) {
            return this.enableShaderProgram(canvas3D.ctx, this.shaderProgramData[n].getShaderProgramId());
        }
    }

    private ShaderError disableShaderProgram(Canvas3D canvas3D) {
        return this.disableShaderProgram(canvas3D.ctx);
    }

    synchronized void initMirrorObject() {
        if (this.shaders == null) {
            ((ShaderProgramRetained)this.mirror).shaders = null;
        } else {
            ((ShaderProgramRetained)this.mirror).shaders = new ShaderRetained[this.shaders.length];
            for (int i = 0; i < this.shaders.length; ++i) {
                ((ShaderProgramRetained)this.mirror).shaders[i] = (ShaderRetained)this.shaders[i].mirror;
            }
        }
        ((ShaderProgramRetained)this.mirror).shaderProgramData = null;
        ((ShaderProgramRetained)this.mirror).vertexAttrNames = this.vertexAttrNames == null ? null : (String[])this.vertexAttrNames.clone();
        ((ShaderProgramRetained)this.mirror).shaderAttrNames = this.shaderAttrNames == null ? null : (String[])this.shaderAttrNames.clone();
        ((ShaderProgramRetained)this.mirror).shaderAttrErrorSet = null;
    }

    synchronized void updateMirrorObject(int n, Object object) {
        assert (false);
        System.err.println("ShaderProgramRetained : updateMirrorObject NOT IMPLEMENTED YET");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createShaderProgramData(int n, long l) {
        Object object = this.resourceLock;
        synchronized (object) {
            if (this.shaderProgramData == null) {
                this.shaderProgramData = new ShaderProgramData[n + 1];
            } else if (this.shaderProgramData.length <= n) {
                ShaderProgramData[] shaderProgramDataArray = new ShaderProgramData[n + 1];
                System.arraycopy(this.shaderProgramData, 0, shaderProgramDataArray, 0, this.shaderProgramData.length);
                this.shaderProgramData = shaderProgramDataArray;
            }
            if (this.shaderProgramData[n] == null) {
                this.shaderProgramData[n] = new ShaderProgramData();
            } else if (this.shaderProgramData[n].getCtxTimeStamp() != l) {
                this.shaderProgramData[n].reset();
            }
            this.shaderProgramData[n].setCtxTimeStamp(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ShaderError createShaderProgram(Canvas3D canvas3D, int n) {
        Object object = this.resourceLock;
        synchronized (object) {
            assert (this.shaderProgramData[n].getShaderProgramId() == null);
            ShaderProgramId[] shaderProgramIdArray = new ShaderProgramId[1];
            ShaderError shaderError = this.createShaderProgram(canvas3D.ctx, shaderProgramIdArray);
            if (shaderError != null) {
                return shaderError;
            }
            this.shaderProgramData[n].setShaderProgramId(shaderProgramIdArray[0]);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ShaderError linkShaderProgram(Canvas3D canvas3D, int n, ShaderRetained[] shaderRetainedArray) {
        Object object = this.resourceLock;
        synchronized (object) {
            ShaderId[] shaderIdArray = new ShaderId[shaderRetainedArray.length];
            for (int i = 0; i < shaderRetainedArray.length; ++i) {
                ShaderRetained shaderRetained = shaderRetainedArray[i];
                synchronized (shaderRetained) {
                    shaderIdArray[i] = shaderRetainedArray[i].shaderData[n].getShaderId();
                    continue;
                }
            }
            ShaderError shaderError = this.linkShaderProgram(canvas3D.ctx, this.shaderProgramData[n].getShaderProgramId(), shaderIdArray);
            if (shaderError != null) {
                return shaderError;
            }
            this.shaderProgramData[n].setLinked(true);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ShaderError bindVertexAttrName(Canvas3D canvas3D, int n, String string, int n2) {
        assert (string != null);
        Object object = this.resourceLock;
        synchronized (object) {
            ShaderProgramId shaderProgramId = this.shaderProgramData[n].getShaderProgramId();
            ShaderError shaderError = this.bindVertexAttrName(canvas3D.ctx, shaderProgramId, string, n2);
            if (shaderError != null) {
                return shaderError;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void lookupVertexAttrNames(Canvas3D canvas3D, int n, String[] stringArray) {
        Object object = this.resourceLock;
        synchronized (object) {
            ShaderProgramId shaderProgramId = this.shaderProgramData[n].getShaderProgramId();
            boolean[] blArray = new boolean[stringArray.length];
            this.lookupVertexAttrNames(canvas3D.ctx, shaderProgramId, stringArray, blArray);
            for (int i = 0; i < stringArray.length; ++i) {
                if (!blArray[i]) continue;
                String string = "Vertex Attribute name lookup failed: " + stringArray[i];
                ShaderError shaderError = new ShaderError(3, string);
                shaderError.setShaderProgram((ShaderProgram)this.source);
                shaderError.setCanvas3D(canvas3D);
                this.notifyErrorListeners(canvas3D, shaderError);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void lookupShaderAttrNames(Canvas3D canvas3D, int n, String[] stringArray) {
        Object object = this.resourceLock;
        synchronized (object) {
            ShaderProgramId shaderProgramId = this.shaderProgramData[n].getShaderProgramId();
            AttrNameInfo[] attrNameInfoArray = new AttrNameInfo[stringArray.length];
            this.lookupShaderAttrNames(canvas3D.ctx, shaderProgramId, stringArray, attrNameInfoArray);
            for (int i = 0; i < stringArray.length; ++i) {
                this.shaderProgramData[n].setAttrNameInfo(stringArray[i], attrNameInfoArray[i]);
                if (attrNameInfoArray[i].getLocation() != null) continue;
                String string = "Attribute name lookup failed: " + stringArray[i];
                ShaderError shaderError = new ShaderError(4, string);
                shaderError.setShaderProgram((ShaderProgram)this.source);
                shaderError.setCanvas3D(canvas3D);
                this.notifyErrorListeners(canvas3D, shaderError);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ShaderProgramData getShaderProgramData(int n) {
        Object object = this.resourceLock;
        synchronized (object) {
            return this.shaderProgramData[n];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ShaderError createShader(Canvas3D canvas3D, int n, ShaderRetained shaderRetained) {
        Object object = shaderRetained.resourceLock;
        synchronized (object) {
            if (shaderRetained.shaderData[n].getShaderId() != null) {
                return null;
            }
            ShaderId[] shaderIdArray = new ShaderId[1];
            ShaderError shaderError = this.createShader(canvas3D.ctx, shaderRetained, shaderIdArray);
            if (shaderError != null) {
                return shaderError;
            }
            shaderRetained.shaderData[n].setShaderId(shaderIdArray[0]);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ShaderError compileShader(Canvas3D canvas3D, int n, ShaderRetained shaderRetained) {
        Object object = shaderRetained.resourceLock;
        synchronized (object) {
            if (shaderRetained.shaderData[n].isCompiled()) {
                return null;
            }
            String string = ((SourceCodeShaderRetained)shaderRetained).getShaderSource();
            ShaderError shaderError = this.compileShader(canvas3D.ctx, shaderRetained.shaderData[n].getShaderId(), string);
            if (shaderError != null) {
                return shaderError;
            }
            shaderRetained.shaderData[n].setCompiled(true);
        }
        return null;
    }

    void notifyErrorListeners(Canvas3D canvas3D, ShaderError shaderError) {
        J3dNotification j3dNotification = new J3dNotification();
        j3dNotification.type = 0;
        j3dNotification.universe = canvas3D.view.universe;
        j3dNotification.args[0] = shaderError;
        VirtualUniverse.mc.sendNotification(j3dNotification);
    }

    private boolean verifyShaderProgramSupported(Canvas3D canvas3D) {
        boolean bl = this.isSupported(canvas3D);
        if (!bl && !this.unsupportedErrorReported) {
            String string = J3dI18N.getString("ShaderProgramRetained0");
            ShaderError shaderError = new ShaderError(7, string);
            shaderError.setShaderProgram((ShaderProgram)this.source);
            shaderError.setCanvas3D(canvas3D);
            this.notifyErrorListeners(canvas3D, shaderError);
            this.unsupportedErrorReported = true;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void destroyShader(Canvas3D canvas3D, int n, ShaderRetained shaderRetained) {
        if (!this.verifyShaderProgramSupported(canvas3D)) {
            return;
        }
        Object object = shaderRetained.resourceLock;
        synchronized (object) {
            if (shaderRetained.shaderData == null || shaderRetained.shaderData.length <= n || shaderRetained.shaderData[n] == null) {
                return;
            }
            if (shaderRetained.shaderData[n].getShaderId() == null) {
                return;
            }
            this.destroyShader(canvas3D.ctx, shaderRetained.shaderData[n].getShaderId());
            shaderRetained.shaderData[n].reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void destroyShaderProgram(Canvas3D canvas3D, int n) {
        if (!this.verifyShaderProgramSupported(canvas3D)) {
            return;
        }
        Object object = this.resourceLock;
        synchronized (object) {
            assert (this.shaderProgramData != null && this.shaderProgramData.length > n && this.shaderProgramData[n] != null);
            ShaderProgramId shaderProgramId = this.shaderProgramData[n].getShaderProgramId();
            if (shaderProgramId == null) {
                return;
            }
            this.destroyShaderProgram(canvas3D.ctx, shaderProgramId);
            this.shaderProgramData[n].reset();
        }
    }

    void updateNative(Canvas3D canvas3D, boolean bl) {
        long l;
        int n;
        boolean bl2;
        boolean bl3 = bl2 = canvas3D.useSharedCtx && canvas3D.screen.renderer.sharedCtx != null;
        if (bl2) {
            n = canvas3D.screen.renderer.rendererId;
            l = canvas3D.screen.renderer.sharedCtxTimeStamp;
        } else {
            n = canvas3D.canvasId;
            l = canvas3D.ctxTimeStamp;
        }
        this.createShaderProgramData(n, l);
        if (!this.verifyShaderProgramSupported(canvas3D)) {
            return;
        }
        if (!bl) {
            this.disableShaderProgram(canvas3D);
            return;
        }
        if (this.shaders == null || this.shaders.length == 0 || this.linkErrorOccurred) {
            this.disableShaderProgram(canvas3D);
            return;
        }
        boolean bl4 = false;
        if (this.getShaderProgramData(n).getShaderProgramId() == null) {
            bl4 = true;
        }
        ShaderError shaderError = null;
        boolean bl5 = false;
        if (bl4) {
            int n2;
            if (bl2) {
                canvas3D.makeCtxCurrent(canvas3D.screen.renderer.sharedCtx);
            }
            for (n2 = 0; n2 < this.shaders.length; ++n2) {
                this.shaders[n2].createShaderData(n, l);
                if (this.shaders[n2].compileErrorOccurred) {
                    bl5 = true;
                    continue;
                }
                shaderError = this.createShader(canvas3D, n, this.shaders[n2]);
                if (shaderError != null) {
                    shaderError.setShaderProgram((ShaderProgram)this.source);
                    shaderError.setShader((Shader)this.shaders[n2].source);
                    shaderError.setCanvas3D(canvas3D);
                    this.notifyErrorListeners(canvas3D, shaderError);
                    bl5 = true;
                    continue;
                }
                shaderError = this.compileShader(canvas3D, n, this.shaders[n2]);
                if (shaderError == null) continue;
                shaderError.setShaderProgram((ShaderProgram)this.source);
                shaderError.setShader((Shader)this.shaders[n2].source);
                shaderError.setCanvas3D(canvas3D);
                this.notifyErrorListeners(canvas3D, shaderError);
                this.destroyShader(canvas3D, n, this.shaders[n2]);
                this.shaders[n2].compileErrorOccurred = true;
                bl5 = true;
            }
            if (!bl5 && (shaderError = this.createShaderProgram(canvas3D, n)) != null) {
                shaderError.setShaderProgram((ShaderProgram)this.source);
                shaderError.setCanvas3D(canvas3D);
                this.notifyErrorListeners(canvas3D, shaderError);
                bl5 = true;
            }
            if ((n2 = (int)(this.getShaderProgramData(n).isLinked() ? 1 : 0)) == 0) {
                if (!bl5 && this.vertexAttrNames != null) {
                    for (int i = 0; i < this.vertexAttrNames.length; ++i) {
                        shaderError = this.bindVertexAttrName(canvas3D, n, this.vertexAttrNames[i], i);
                        if (shaderError == null) continue;
                        shaderError.setShaderProgram((ShaderProgram)this.source);
                        shaderError.setCanvas3D(canvas3D);
                        this.notifyErrorListeners(canvas3D, shaderError);
                    }
                }
                if (!bl5 && (shaderError = this.linkShaderProgram(canvas3D, n, this.shaders)) != null) {
                    shaderError.setShaderProgram((ShaderProgram)this.source);
                    shaderError.setCanvas3D(canvas3D);
                    this.notifyErrorListeners(canvas3D, shaderError);
                    this.destroyShaderProgram(canvas3D, n);
                    this.linkErrorOccurred = true;
                    bl5 = true;
                }
                if (!bl5 && this.vertexAttrNames != null) {
                    this.lookupVertexAttrNames(canvas3D, n, this.vertexAttrNames);
                }
                if (!bl5 && this.shaderAttrNames != null) {
                    this.lookupShaderAttrNames(canvas3D, n, this.shaderAttrNames);
                }
            }
            if (bl2) {
                canvas3D.makeCtxCurrent(canvas3D.ctx);
            }
            if (bl5) {
                this.disableShaderProgram(canvas3D);
                return;
            }
        }
        this.enableShaderProgram(canvas3D, n);
    }

    ShaderError setUniformAttrValue(Context context, ShaderProgramId shaderProgramId, ShaderAttrLoc shaderAttrLoc, ShaderAttributeValueRetained shaderAttributeValueRetained) {
        switch (shaderAttributeValueRetained.getClassType()) {
            case 0: {
                return this.setUniform1i(context, shaderProgramId, shaderAttrLoc, ((int[])shaderAttributeValueRetained.attrWrapper.getRef())[0]);
            }
            case 1: {
                return this.setUniform1f(context, shaderProgramId, shaderAttrLoc, ((float[])shaderAttributeValueRetained.attrWrapper.getRef())[0]);
            }
            case 2: {
                return this.setUniform2i(context, shaderProgramId, shaderAttrLoc, (int[])shaderAttributeValueRetained.attrWrapper.getRef());
            }
            case 3: {
                return this.setUniform2f(context, shaderProgramId, shaderAttrLoc, (float[])shaderAttributeValueRetained.attrWrapper.getRef());
            }
            case 4: {
                return this.setUniform3i(context, shaderProgramId, shaderAttrLoc, (int[])shaderAttributeValueRetained.attrWrapper.getRef());
            }
            case 5: {
                return this.setUniform3f(context, shaderProgramId, shaderAttrLoc, (float[])shaderAttributeValueRetained.attrWrapper.getRef());
            }
            case 6: {
                return this.setUniform4i(context, shaderProgramId, shaderAttrLoc, (int[])shaderAttributeValueRetained.attrWrapper.getRef());
            }
            case 7: {
                return this.setUniform4f(context, shaderProgramId, shaderAttrLoc, (float[])shaderAttributeValueRetained.attrWrapper.getRef());
            }
            case 8: {
                return this.setUniformMatrix3f(context, shaderProgramId, shaderAttrLoc, (float[])shaderAttributeValueRetained.attrWrapper.getRef());
            }
            case 9: {
                return this.setUniformMatrix4f(context, shaderProgramId, shaderAttrLoc, (float[])shaderAttributeValueRetained.attrWrapper.getRef());
            }
        }
        assert (false) : "Unrecognized ShaderAttributeValue classType";
        return null;
    }

    ShaderError setUniformAttrArray(Context context, ShaderProgramId shaderProgramId, ShaderAttrLoc shaderAttrLoc, ShaderAttributeArrayRetained shaderAttributeArrayRetained) {
        switch (shaderAttributeArrayRetained.getClassType()) {
            case 0: {
                return this.setUniform1iArray(context, shaderProgramId, shaderAttrLoc, shaderAttributeArrayRetained.length(), (int[])shaderAttributeArrayRetained.attrWrapper.getRef());
            }
            case 1: {
                return this.setUniform1fArray(context, shaderProgramId, shaderAttrLoc, shaderAttributeArrayRetained.length(), (float[])shaderAttributeArrayRetained.attrWrapper.getRef());
            }
            case 2: {
                return this.setUniform2iArray(context, shaderProgramId, shaderAttrLoc, shaderAttributeArrayRetained.length(), (int[])shaderAttributeArrayRetained.attrWrapper.getRef());
            }
            case 3: {
                return this.setUniform2fArray(context, shaderProgramId, shaderAttrLoc, shaderAttributeArrayRetained.length(), (float[])shaderAttributeArrayRetained.attrWrapper.getRef());
            }
            case 4: {
                return this.setUniform3iArray(context, shaderProgramId, shaderAttrLoc, shaderAttributeArrayRetained.length(), (int[])shaderAttributeArrayRetained.attrWrapper.getRef());
            }
            case 5: {
                return this.setUniform3fArray(context, shaderProgramId, shaderAttrLoc, shaderAttributeArrayRetained.length(), (float[])shaderAttributeArrayRetained.attrWrapper.getRef());
            }
            case 6: {
                return this.setUniform4iArray(context, shaderProgramId, shaderAttrLoc, shaderAttributeArrayRetained.length(), (int[])shaderAttributeArrayRetained.attrWrapper.getRef());
            }
            case 7: {
                return this.setUniform4fArray(context, shaderProgramId, shaderAttrLoc, shaderAttributeArrayRetained.length(), (float[])shaderAttributeArrayRetained.attrWrapper.getRef());
            }
            case 8: {
                return this.setUniformMatrix3fArray(context, shaderProgramId, shaderAttrLoc, shaderAttributeArrayRetained.length(), (float[])shaderAttributeArrayRetained.attrWrapper.getRef());
            }
            case 9: {
                return this.setUniformMatrix4fArray(context, shaderProgramId, shaderAttrLoc, shaderAttributeArrayRetained.length(), (float[])shaderAttributeArrayRetained.attrWrapper.getRef());
            }
        }
        assert (false) : "Unrecognized ShaderAttributeArray classType";
        return null;
    }

    void setShaderAttributes(Canvas3D canvas3D, ShaderAttributeSetRetained shaderAttributeSetRetained) {
        boolean bl = canvas3D.useSharedCtx && canvas3D.screen.renderer.sharedCtx != null;
        int n = bl ? canvas3D.screen.renderer.rendererId : canvas3D.canvasId;
        ShaderProgramData shaderProgramData = this.getShaderProgramData(n);
        if (!shaderProgramData.isLinked()) {
            return;
        }
        ShaderProgramId shaderProgramId = shaderProgramData.getShaderProgramId();
        Iterator<ShaderAttributeRetained> iterator = shaderAttributeSetRetained.getAttrs().values().iterator();
        while (iterator.hasNext()) {
            Object object;
            ShaderError shaderError = null;
            ShaderAttributeRetained shaderAttributeRetained = iterator.next();
            AttrNameInfo attrNameInfo = shaderProgramData.getAttrNameInfo(shaderAttributeRetained.getAttributeName());
            if (attrNameInfo == null) {
                object = "Attribute name not set in ShaderProgram: " + shaderAttributeRetained.getAttributeName();
                shaderError = new ShaderError(5, (String)object);
            } else {
                object = attrNameInfo.getLocation();
                if (object != null) {
                    String string;
                    ShaderAttributeObjectRetained shaderAttributeObjectRetained;
                    if (shaderAttributeRetained instanceof ShaderAttributeValueRetained) {
                        shaderAttributeObjectRetained = (ShaderAttributeValueRetained)shaderAttributeRetained;
                        if (attrNameInfo.isArray() || shaderAttributeObjectRetained.getClassType() != attrNameInfo.getType()) {
                            string = "Attribute type mismatch: " + shaderAttributeObjectRetained.getAttributeName();
                            shaderError = new ShaderError(6, string);
                        } else {
                            shaderError = this.setUniformAttrValue(canvas3D.ctx, shaderProgramId, (ShaderAttrLoc)object, (ShaderAttributeValueRetained)shaderAttributeObjectRetained);
                        }
                    } else if (shaderAttributeRetained instanceof ShaderAttributeArrayRetained) {
                        shaderAttributeObjectRetained = (ShaderAttributeArrayRetained)shaderAttributeRetained;
                        if (!attrNameInfo.isArray() || shaderAttributeObjectRetained.getClassType() != attrNameInfo.getType()) {
                            string = "Attribute type mismatch: " + shaderAttributeObjectRetained.getAttributeName();
                            shaderError = new ShaderError(6, string);
                        } else {
                            shaderError = this.setUniformAttrArray(canvas3D.ctx, shaderProgramId, (ShaderAttrLoc)object, (ShaderAttributeArrayRetained)shaderAttributeObjectRetained);
                        }
                    } else {
                        if (shaderAttributeRetained instanceof ShaderAttributeBindingRetained) {
                            assert (false);
                            throw new RuntimeException("not implemented");
                        }
                        assert (false);
                    }
                }
            }
            if (shaderError == null) continue;
            if (this.shaderAttrErrorSet == null) {
                this.shaderAttrErrorSet = new HashSet();
            }
            if (!this.shaderAttrErrorSet.add((ShaderAttribute)shaderAttributeRetained.source)) continue;
            shaderError.setShaderProgram((ShaderProgram)this.source);
            shaderError.setShaderAttributeSet((ShaderAttributeSet)shaderAttributeSetRetained.source);
            shaderError.setShaderAttribute((ShaderAttribute)shaderAttributeRetained.source);
            shaderError.setCanvas3D(canvas3D);
            this.notifyErrorListeners(canvas3D, shaderError);
        }
    }

    class AttrNameInfo {
        private ShaderAttrLoc loc;
        private boolean isArray;
        private int type;

        AttrNameInfo() {
        }

        void setLocation(ShaderAttrLoc shaderAttrLoc) {
            this.loc = shaderAttrLoc;
        }

        ShaderAttrLoc getLocation() {
            return this.loc;
        }

        void setType(int n) {
            this.type = n;
        }

        int getType() {
            return this.type;
        }

        boolean isArray() {
            return this.isArray;
        }

        void setArray(boolean bl) {
            this.isArray = bl;
        }
    }

    class ShaderProgramData {
        private long ctxTimeStamp;
        private ShaderProgramId shaderProgramId = null;
        private boolean linked = false;
        private HashMap<String, AttrNameInfo> attrNameInfoMap = new HashMap();

        ShaderProgramData() {
        }

        void reset() {
            this.ctxTimeStamp = 0L;
            this.shaderProgramId = null;
            this.linked = false;
            this.attrNameInfoMap.clear();
        }

        long getCtxTimeStamp() {
            return this.ctxTimeStamp;
        }

        void setCtxTimeStamp(long l) {
            this.ctxTimeStamp = l;
        }

        void setShaderProgramId(ShaderProgramId shaderProgramId) {
            this.shaderProgramId = shaderProgramId;
        }

        ShaderProgramId getShaderProgramId() {
            return this.shaderProgramId;
        }

        void setLinked(boolean bl) {
            this.linked = bl;
        }

        boolean isLinked() {
            return this.linked;
        }

        void setAttrNameInfo(String string, AttrNameInfo attrNameInfo) {
            assert (string != null);
            this.attrNameInfoMap.put(string, attrNameInfo);
        }

        AttrNameInfo getAttrNameInfo(String string) {
            return this.attrNameInfoMap.get(string);
        }
    }
}

