/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webpane.sg.theme;

import com.sun.webpane.platform.Invoker;
import com.sun.webpane.platform.PopupMenu;
import com.sun.webpane.platform.WebPage;
import com.sun.webpane.platform.graphics.WCFont;
import com.sun.webpane.platform.graphics.WCPoint;
import com.sun.webpane.sg.WebPageClientImpl;
import com.sun.webpane.sg.theme.ContextMenuImpl;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.MenuItem;
import javafx.stage.WindowEvent;

public class PopupMenuImpl
extends PopupMenu {
    private static final Logger log = Logger.getLogger(PopupMenuImpl.class.getName());
    ContextMenu popupMenu = new ContextMenu();

    public PopupMenuImpl() {
        this.popupMenu.setOnHidden(new EventHandler<WindowEvent>(){

            @Override
            public void handle(WindowEvent windowEvent) {
                log.finer("onHidden");
                Invoker.getInvoker().postOnEventThread(new Runnable(){

                    @Override
                    public void run() {
                        log.finer("onHidden: notifying");
                        PopupMenuImpl.this.notifyPopupClosed();
                    }
                });
            }
        });
        this.popupMenu.setOnAction(new EventHandler<ActionEvent>(){

            @Override
            public void handle(ActionEvent actionEvent) {
                MenuItem menuItem = (MenuItem)actionEvent.getTarget();
                log.log(Level.FINE, "onAction: item={0}", menuItem);
                PopupMenuImpl.this.notifySelectionCommited(PopupMenuImpl.this.popupMenu.getItems().indexOf(menuItem));
            }
        });
    }

    @Override
    public void show(WebPage webPage, int n, int n2, int n3) {
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "show at [{0}, {1}], width={2}", new Object[]{n, n2, n3});
        }
        this.popupMenu.setPrefWidth(n3);
        this.popupMenu.setPrefHeight(this.popupMenu.getHeight());
        PopupMenuImpl.doShow(this.popupMenu, webPage, n, n2);
    }

    @Override
    public void hide() {
        log.fine("hiding");
        this.popupMenu.hide();
    }

    @Override
    public void appendItem(String string, boolean bl, boolean bl2, boolean bl3, int n, int n2, WCFont wCFont) {
        MenuItem menuItem;
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "itemText={0}, isLabel={1}, isSeparator={2}, isEnabled={3}, bgColor={4}, fgColor={5}, font={6}", new Object[]{string, bl, bl2, bl3, n, n2, wCFont});
        }
        if (bl2) {
            menuItem = new ContextMenuImpl.SeparatorImpl(null);
        } else {
            menuItem = new MenuItem(string);
            menuItem.setDisable(!bl3);
        }
        this.popupMenu.getItems().add(menuItem);
    }

    @Override
    public void setSelectedItem(int n) {
        log.log(Level.FINEST, "index={0}", n);
    }

    static void doShow(ContextMenu contextMenu, WebPage webPage, int n, int n2) {
        WebPageClientImpl webPageClientImpl = (WebPageClientImpl)webPage.getPageClient();
        assert (webPageClientImpl != null);
        WCPoint wCPoint = webPageClientImpl.windowToScreen(new WCPoint(n, n2));
        contextMenu.show(webPageClientImpl.getContainer().getScene().getWindow(), (double)wCPoint.getX(), (double)wCPoint.getY());
    }
}

