// **********************************************************************
//
// Copyright (c) 2003-2017 ZeroC, Inc. All rights reserved.
//
// This copy of Ice is licensed to you under the terms described in the
// ICE_LICENSE file included in this distribution.
//
// **********************************************************************
//
// Ice version 3.7.0
//
// <auto-generated>
//
// Generated from file `SSLInfo.ice'
//
// Warning: do not edit this file.
//
// </auto-generated>
//

#ifndef __Glacier2_SSLInfo_h__
#define __Glacier2_SSLInfo_h__

#include <IceUtil/PushDisableWarnings.h>
#include <Ice/ProxyF.h>
#include <Ice/ObjectF.h>
#include <Ice/ValueF.h>
#include <Ice/Exception.h>
#include <Ice/LocalObject.h>
#include <Ice/StreamHelpers.h>
#include <Ice/Comparable.h>
#include <IceUtil/ScopedArray.h>
#include <Ice/Optional.h>
#include <Ice/BuiltinSequences.h>
#include <IceUtil/UndefSysMacros.h>
#include <Glacier2/Config.h>

#ifndef ICE_IGNORE_VERSION
#   if ICE_INT_VERSION / 100 != 307
#       error Ice version mismatch!
#   endif
#   if ICE_INT_VERSION % 100 > 50
#       error Beta header file detected
#   endif
#   if ICE_INT_VERSION % 100 < 0
#       error Ice patch level mismatch!
#   endif
#endif

#ifndef GLACIER2_API
#   if defined(ICE_STATIC_LIBS)
#       define GLACIER2_API /**/
#   elif defined(GLACIER2_API_EXPORTS)
#       define GLACIER2_API ICE_DECLSPEC_EXPORT
#   else
#       define GLACIER2_API ICE_DECLSPEC_IMPORT
#   endif
#endif

#ifdef ICE_CPP11_MAPPING // C++11 mapping

namespace Glacier2
{

struct SSLInfo
{
    ::std::string remoteHost;
    int remotePort;
    ::std::string localHost;
    int localPort;
    ::std::string cipher;
    ::Ice::StringSeq certs;

    std::tuple<const ::std::string&, const int&, const ::std::string&, const int&, const ::std::string&, const ::Ice::StringSeq&> ice_tuple() const
    {
        return std::tie(remoteHost, remotePort, localHost, localPort, cipher, certs);
    }
};

using Ice::operator<;
using Ice::operator<=;
using Ice::operator>;
using Ice::operator>=;
using Ice::operator==;
using Ice::operator!=;

}

namespace Ice
{

template<>
struct StreamableTraits<::Glacier2::SSLInfo>
{
    static const StreamHelperCategory helper = StreamHelperCategoryStruct;
    static const int minWireSize = 12;
    static const bool fixedLength = false;
};

template<typename S>
struct StreamReader<::Glacier2::SSLInfo, S>
{
    static void read(S* istr, ::Glacier2::SSLInfo& v)
    {
        istr->readAll(v.remoteHost, v.remotePort, v.localHost, v.localPort, v.cipher, v.certs);
    }
};

}

#else // C++98 mapping

namespace Glacier2
{

struct SSLInfo
{
    ::std::string remoteHost;
    ::Ice::Int remotePort;
    ::std::string localHost;
    ::Ice::Int localPort;
    ::std::string cipher;
    ::Ice::StringSeq certs;
};

}

namespace Ice
{

template<>
struct StreamableTraits< ::Glacier2::SSLInfo>
{
    static const StreamHelperCategory helper = StreamHelperCategoryStruct;
    static const int minWireSize = 12;
    static const bool fixedLength = false;
};

template<typename S>
struct StreamWriter< ::Glacier2::SSLInfo, S>
{
    static void write(S* ostr, const ::Glacier2::SSLInfo& v)
    {
        ostr->write(v.remoteHost);
        ostr->write(v.remotePort);
        ostr->write(v.localHost);
        ostr->write(v.localPort);
        ostr->write(v.cipher);
        ostr->write(v.certs);
    }
};

template<typename S>
struct StreamReader< ::Glacier2::SSLInfo, S>
{
    static void read(S* istr, ::Glacier2::SSLInfo& v)
    {
        istr->read(v.remoteHost);
        istr->read(v.remotePort);
        istr->read(v.localHost);
        istr->read(v.localPort);
        istr->read(v.cipher);
        istr->read(v.certs);
    }
};

}

#endif

#include <IceUtil/PopDisableWarnings.h>
#endif
