/*
 * Decompiled with CFR 0.152.
 */
package java.awt.geom;

import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.CubicIterator;
import java.awt.geom.FlatteningPathIterator;
import java.awt.geom.Line2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.QuadCurve2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.util.Arrays;
import sun.awt.geom.Curve;

public abstract class CubicCurve2D
implements Shape,
Cloneable {
    protected CubicCurve2D() {
    }

    public abstract double getX1();

    public abstract double getY1();

    public abstract Point2D getP1();

    public abstract double getCtrlX1();

    public abstract double getCtrlY1();

    public abstract Point2D getCtrlP1();

    public abstract double getCtrlX2();

    public abstract double getCtrlY2();

    public abstract Point2D getCtrlP2();

    public abstract double getX2();

    public abstract double getY2();

    public abstract Point2D getP2();

    public abstract void setCurve(double var1, double var3, double var5, double var7, double var9, double var11, double var13, double var15);

    public void setCurve(double[] coords, int offset) {
        this.setCurve(coords[offset + 0], coords[offset + 1], coords[offset + 2], coords[offset + 3], coords[offset + 4], coords[offset + 5], coords[offset + 6], coords[offset + 7]);
    }

    public void setCurve(Point2D p1, Point2D cp1, Point2D cp2, Point2D p2) {
        this.setCurve(p1.getX(), p1.getY(), cp1.getX(), cp1.getY(), cp2.getX(), cp2.getY(), p2.getX(), p2.getY());
    }

    public void setCurve(Point2D[] pts, int offset) {
        this.setCurve(pts[offset + 0].getX(), pts[offset + 0].getY(), pts[offset + 1].getX(), pts[offset + 1].getY(), pts[offset + 2].getX(), pts[offset + 2].getY(), pts[offset + 3].getX(), pts[offset + 3].getY());
    }

    public void setCurve(CubicCurve2D c) {
        this.setCurve(c.getX1(), c.getY1(), c.getCtrlX1(), c.getCtrlY1(), c.getCtrlX2(), c.getCtrlY2(), c.getX2(), c.getY2());
    }

    public static double getFlatnessSq(double x1, double y1, double ctrlx1, double ctrly1, double ctrlx2, double ctrly2, double x2, double y2) {
        return Math.max(Line2D.ptSegDistSq(x1, y1, x2, y2, ctrlx1, ctrly1), Line2D.ptSegDistSq(x1, y1, x2, y2, ctrlx2, ctrly2));
    }

    public static double getFlatness(double x1, double y1, double ctrlx1, double ctrly1, double ctrlx2, double ctrly2, double x2, double y2) {
        return Math.sqrt(CubicCurve2D.getFlatnessSq(x1, y1, ctrlx1, ctrly1, ctrlx2, ctrly2, x2, y2));
    }

    public static double getFlatnessSq(double[] coords, int offset) {
        return CubicCurve2D.getFlatnessSq(coords[offset + 0], coords[offset + 1], coords[offset + 2], coords[offset + 3], coords[offset + 4], coords[offset + 5], coords[offset + 6], coords[offset + 7]);
    }

    public static double getFlatness(double[] coords, int offset) {
        return CubicCurve2D.getFlatness(coords[offset + 0], coords[offset + 1], coords[offset + 2], coords[offset + 3], coords[offset + 4], coords[offset + 5], coords[offset + 6], coords[offset + 7]);
    }

    public double getFlatnessSq() {
        return CubicCurve2D.getFlatnessSq(this.getX1(), this.getY1(), this.getCtrlX1(), this.getCtrlY1(), this.getCtrlX2(), this.getCtrlY2(), this.getX2(), this.getY2());
    }

    public double getFlatness() {
        return CubicCurve2D.getFlatness(this.getX1(), this.getY1(), this.getCtrlX1(), this.getCtrlY1(), this.getCtrlX2(), this.getCtrlY2(), this.getX2(), this.getY2());
    }

    public void subdivide(CubicCurve2D left, CubicCurve2D right) {
        CubicCurve2D.subdivide(this, left, right);
    }

    public static void subdivide(CubicCurve2D src, CubicCurve2D left, CubicCurve2D right) {
        double x1 = src.getX1();
        double y1 = src.getY1();
        double ctrlx1 = src.getCtrlX1();
        double ctrly1 = src.getCtrlY1();
        double ctrlx2 = src.getCtrlX2();
        double ctrly2 = src.getCtrlY2();
        double x2 = src.getX2();
        double y2 = src.getY2();
        double centerx = (ctrlx1 + ctrlx2) / 2.0;
        double centery = (ctrly1 + ctrly2) / 2.0;
        ctrlx1 = (x1 + ctrlx1) / 2.0;
        ctrly1 = (y1 + ctrly1) / 2.0;
        ctrlx2 = (x2 + ctrlx2) / 2.0;
        ctrly2 = (y2 + ctrly2) / 2.0;
        double ctrlx12 = (ctrlx1 + centerx) / 2.0;
        double ctrly12 = (ctrly1 + centery) / 2.0;
        double ctrlx21 = (ctrlx2 + centerx) / 2.0;
        double ctrly21 = (ctrly2 + centery) / 2.0;
        centerx = (ctrlx12 + ctrlx21) / 2.0;
        centery = (ctrly12 + ctrly21) / 2.0;
        if (left != null) {
            left.setCurve(x1, y1, ctrlx1, ctrly1, ctrlx12, ctrly12, centerx, centery);
        }
        if (right != null) {
            right.setCurve(centerx, centery, ctrlx21, ctrly21, ctrlx2, ctrly2, x2, y2);
        }
    }

    public static void subdivide(double[] src, int srcoff, double[] left, int leftoff, double[] right, int rightoff) {
        double x1 = src[srcoff + 0];
        double y1 = src[srcoff + 1];
        double ctrlx1 = src[srcoff + 2];
        double ctrly1 = src[srcoff + 3];
        double ctrlx2 = src[srcoff + 4];
        double ctrly2 = src[srcoff + 5];
        double x2 = src[srcoff + 6];
        double y2 = src[srcoff + 7];
        if (left != null) {
            left[leftoff + 0] = x1;
            left[leftoff + 1] = y1;
        }
        if (right != null) {
            right[rightoff + 6] = x2;
            right[rightoff + 7] = y2;
        }
        x1 = (x1 + ctrlx1) / 2.0;
        y1 = (y1 + ctrly1) / 2.0;
        x2 = (x2 + ctrlx2) / 2.0;
        y2 = (y2 + ctrly2) / 2.0;
        double centerx = (ctrlx1 + ctrlx2) / 2.0;
        double centery = (ctrly1 + ctrly2) / 2.0;
        ctrlx1 = (x1 + centerx) / 2.0;
        ctrly1 = (y1 + centery) / 2.0;
        ctrlx2 = (x2 + centerx) / 2.0;
        ctrly2 = (y2 + centery) / 2.0;
        centerx = (ctrlx1 + ctrlx2) / 2.0;
        centery = (ctrly1 + ctrly2) / 2.0;
        if (left != null) {
            left[leftoff + 2] = x1;
            left[leftoff + 3] = y1;
            left[leftoff + 4] = ctrlx1;
            left[leftoff + 5] = ctrly1;
            left[leftoff + 6] = centerx;
            left[leftoff + 7] = centery;
        }
        if (right != null) {
            right[rightoff + 0] = centerx;
            right[rightoff + 1] = centery;
            right[rightoff + 2] = ctrlx2;
            right[rightoff + 3] = ctrly2;
            right[rightoff + 4] = x2;
            right[rightoff + 5] = y2;
        }
    }

    public static int solveCubic(double[] eqn) {
        return CubicCurve2D.solveCubic(eqn, eqn);
    }

    public static int solveCubic(double[] eqn, double[] res) {
        int num;
        double d = eqn[3];
        if (d == 0.0) {
            return QuadCurve2D.solveQuadratic(eqn, res);
        }
        double A = eqn[2] / d;
        double B = eqn[1] / d;
        double C = eqn[0] / d;
        double sq_A = A * A;
        double p = 0.3333333333333333 * (-0.3333333333333333 * sq_A + B);
        double q = 0.5 * (0.07407407407407407 * A * sq_A - 0.3333333333333333 * A * B + C);
        double cb_p = p * p * p;
        double D = q * q + cb_p;
        double sub = 0.3333333333333333 * A;
        if (D < 0.0) {
            double phi = 0.3333333333333333 * Math.acos(-q / Math.sqrt(-cb_p));
            double t = 2.0 * Math.sqrt(-p);
            if (res == eqn) {
                eqn = Arrays.copyOf(eqn, 4);
            }
            res[0] = t * Math.cos(phi);
            res[1] = -t * Math.cos(phi + 1.0471975511965976);
            res[2] = -t * Math.cos(phi - 1.0471975511965976);
            num = 3;
            int i = 0;
            while (i < num) {
                int n = i++;
                res[n] = res[n] - sub;
            }
        } else {
            double sqrt_D = Math.sqrt(D);
            double u = Math.cbrt(sqrt_D - q);
            double v = -Math.cbrt(sqrt_D + q);
            double uv = u + v;
            num = 1;
            double err = 1.2E9 * Math.ulp(Math.abs(uv) + Math.abs(sub));
            if (CubicCurve2D.iszero(D, err) || CubicCurve2D.within(u, v, err)) {
                if (res == eqn) {
                    eqn = Arrays.copyOf(eqn, 4);
                }
                res[1] = -(uv / 2.0) - sub;
                num = 2;
            }
            res[0] = uv - sub;
        }
        if (num > 1) {
            num = CubicCurve2D.fixRoots(eqn, res, num);
        }
        if (num > 2 && (res[2] == res[1] || res[2] == res[0])) {
            --num;
        }
        if (num > 1 && res[1] == res[0]) {
            res[1] = res[--num];
        }
        return num;
    }

    private static int fixRoots(double[] eqn, double[] res, int num) {
        double[] intervals = new double[]{eqn[1], 2.0 * eqn[2], 3.0 * eqn[3]};
        int critCount = QuadCurve2D.solveQuadratic(intervals, intervals);
        if (critCount == 2 && intervals[0] == intervals[1]) {
            --critCount;
        }
        if (critCount == 2 && intervals[0] > intervals[1]) {
            double tmp = intervals[0];
            intervals[0] = intervals[1];
            intervals[1] = tmp;
        }
        if (num == 3) {
            double xe = CubicCurve2D.getRootUpperBound(eqn);
            double x0 = -xe;
            Arrays.sort(res, 0, num);
            if (critCount == 2) {
                res[0] = CubicCurve2D.refineRootWithHint(eqn, x0, intervals[0], res[0]);
                res[1] = CubicCurve2D.refineRootWithHint(eqn, intervals[0], intervals[1], res[1]);
                res[2] = CubicCurve2D.refineRootWithHint(eqn, intervals[1], xe, res[2]);
                return 3;
            }
            if (critCount == 1) {
                double fxe = eqn[3];
                double fx0 = -fxe;
                double x1 = intervals[0];
                double fx1 = CubicCurve2D.solveEqn(eqn, 3, x1);
                res[0] = CubicCurve2D.oppositeSigns(fx0, fx1) ? CubicCurve2D.bisectRootWithHint(eqn, x0, x1, res[0]) : (CubicCurve2D.oppositeSigns(fx1, fxe) ? CubicCurve2D.bisectRootWithHint(eqn, x1, xe, res[2]) : x1);
            } else if (critCount == 0) {
                res[0] = CubicCurve2D.bisectRootWithHint(eqn, x0, xe, res[1]);
            }
        } else if (num == 2 && critCount == 2) {
            double goodRoot = res[0];
            double badRoot = res[1];
            double x1 = intervals[0];
            double x2 = intervals[1];
            double x = Math.abs(x1 - goodRoot) > Math.abs(x2 - goodRoot) ? x1 : x2;
            double fx = CubicCurve2D.solveEqn(eqn, 3, x);
            if (CubicCurve2D.iszero(fx, 1.0E7 * Math.ulp(x))) {
                double badRootVal = CubicCurve2D.solveEqn(eqn, 3, badRoot);
                res[1] = Math.abs(badRootVal) < Math.abs(fx) ? badRoot : x;
                return 2;
            }
        }
        return 1;
    }

    private static double refineRootWithHint(double[] eqn, double min, double max, double t) {
        if (!CubicCurve2D.inInterval(t, min, max)) {
            return t;
        }
        double[] deriv = new double[]{eqn[1], 2.0 * eqn[2], 3.0 * eqn[3]};
        double origt = t;
        for (int i = 0; i < 3; ++i) {
            double slope = CubicCurve2D.solveEqn(deriv, 2, t);
            double y = CubicCurve2D.solveEqn(eqn, 3, t);
            double delta = -(y / slope);
            double newt = t + delta;
            if (slope == 0.0 || y == 0.0 || t == newt) break;
            t = newt;
        }
        if (CubicCurve2D.within(t, origt, 1000.0 * Math.ulp(origt)) && CubicCurve2D.inInterval(t, min, max)) {
            return t;
        }
        return origt;
    }

    private static double bisectRootWithHint(double[] eqn, double x0, double xe, double hint) {
        double delta1 = Math.min(Math.abs(hint - x0) / 64.0, 0.0625);
        double delta2 = Math.min(Math.abs(hint - xe) / 64.0, 0.0625);
        double x02 = hint - delta1;
        double xe2 = hint + delta2;
        double fx02 = CubicCurve2D.solveEqn(eqn, 3, x02);
        double fxe2 = CubicCurve2D.solveEqn(eqn, 3, xe2);
        while (CubicCurve2D.oppositeSigns(fx02, fxe2)) {
            if (x02 >= xe2) {
                return x02;
            }
            x0 = x02;
            xe = xe2;
            x02 = hint - (delta1 /= 64.0);
            xe2 = hint + (delta2 /= 64.0);
            fx02 = CubicCurve2D.solveEqn(eqn, 3, x02);
            fxe2 = CubicCurve2D.solveEqn(eqn, 3, xe2);
        }
        if (fx02 == 0.0) {
            return x02;
        }
        if (fxe2 == 0.0) {
            return xe2;
        }
        return CubicCurve2D.bisectRoot(eqn, x0, xe);
    }

    private static double bisectRoot(double[] eqn, double x0, double xe) {
        double fx0 = CubicCurve2D.solveEqn(eqn, 3, x0);
        double m = x0 + (xe - x0) / 2.0;
        while (m != x0 && m != xe) {
            double fm = CubicCurve2D.solveEqn(eqn, 3, m);
            if (fm == 0.0) {
                return m;
            }
            if (CubicCurve2D.oppositeSigns(fx0, fm)) {
                xe = m;
            } else {
                fx0 = fm;
                x0 = m;
            }
            m = x0 + (xe - x0) / 2.0;
        }
        return m;
    }

    private static boolean inInterval(double t, double min, double max) {
        return min <= t && t <= max;
    }

    private static boolean within(double x, double y, double err) {
        double d = y - x;
        return d <= err && d >= -err;
    }

    private static boolean iszero(double x, double err) {
        return CubicCurve2D.within(x, 0.0, err);
    }

    private static boolean oppositeSigns(double x1, double x2) {
        return x1 < 0.0 && x2 > 0.0 || x1 > 0.0 && x2 < 0.0;
    }

    private static double solveEqn(double[] eqn, int order, double t) {
        double v = eqn[order];
        while (--order >= 0) {
            v = v * t + eqn[order];
        }
        return v;
    }

    private static double getRootUpperBound(double[] eqn) {
        double d = eqn[3];
        double a = eqn[2];
        double b = eqn[1];
        double c = eqn[0];
        double M = 1.0 + Math.max(Math.max(Math.abs(a), Math.abs(b)), Math.abs(c)) / Math.abs(d);
        M += Math.ulp(M) + 1.0;
        return M;
    }

    @Override
    public boolean contains(double x, double y) {
        double y2;
        double x2;
        double y1;
        if (x * 0.0 + y * 0.0 != 0.0) {
            return false;
        }
        double x1 = this.getX1();
        int crossings = Curve.pointCrossingsForLine(x, y, x1, y1 = this.getY1(), x2 = this.getX2(), y2 = this.getY2()) + Curve.pointCrossingsForCubic(x, y, x1, y1, this.getCtrlX1(), this.getCtrlY1(), this.getCtrlX2(), this.getCtrlY2(), x2, y2, 0);
        return (crossings & 1) == 1;
    }

    @Override
    public boolean contains(Point2D p) {
        return this.contains(p.getX(), p.getY());
    }

    @Override
    public boolean intersects(double x, double y, double w, double h) {
        if (w <= 0.0 || h <= 0.0) {
            return false;
        }
        int numCrossings = this.rectCrossings(x, y, w, h);
        return numCrossings != 0;
    }

    @Override
    public boolean intersects(Rectangle2D r) {
        return this.intersects(r.getX(), r.getY(), r.getWidth(), r.getHeight());
    }

    @Override
    public boolean contains(double x, double y, double w, double h) {
        if (w <= 0.0 || h <= 0.0) {
            return false;
        }
        int numCrossings = this.rectCrossings(x, y, w, h);
        return numCrossings != 0 && numCrossings != Integer.MIN_VALUE;
    }

    private int rectCrossings(double x, double y, double w, double h) {
        int crossings = 0;
        if ((this.getX1() != this.getX2() || this.getY1() != this.getY2()) && (crossings = Curve.rectCrossingsForLine(crossings, x, y, x + w, y + h, this.getX1(), this.getY1(), this.getX2(), this.getY2())) == Integer.MIN_VALUE) {
            return crossings;
        }
        return Curve.rectCrossingsForCubic(crossings, x, y, x + w, y + h, this.getX2(), this.getY2(), this.getCtrlX2(), this.getCtrlY2(), this.getCtrlX1(), this.getCtrlY1(), this.getX1(), this.getY1(), 0);
    }

    @Override
    public boolean contains(Rectangle2D r) {
        return this.contains(r.getX(), r.getY(), r.getWidth(), r.getHeight());
    }

    @Override
    public Rectangle getBounds() {
        return this.getBounds2D().getBounds();
    }

    @Override
    public PathIterator getPathIterator(AffineTransform at) {
        return new CubicIterator(this, at);
    }

    @Override
    public PathIterator getPathIterator(AffineTransform at, double flatness) {
        return new FlatteningPathIterator(this.getPathIterator(at), flatness);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    public static class Double
    extends CubicCurve2D
    implements Serializable {
        public double x1;
        public double y1;
        public double ctrlx1;
        public double ctrly1;
        public double ctrlx2;
        public double ctrly2;
        public double x2;
        public double y2;
        private static final long serialVersionUID = -4202960122839707295L;

        public Double() {
        }

        public Double(double x1, double y1, double ctrlx1, double ctrly1, double ctrlx2, double ctrly2, double x2, double y2) {
            this.setCurve(x1, y1, ctrlx1, ctrly1, ctrlx2, ctrly2, x2, y2);
        }

        @Override
        public double getX1() {
            return this.x1;
        }

        @Override
        public double getY1() {
            return this.y1;
        }

        @Override
        public Point2D getP1() {
            return new Point2D.Double(this.x1, this.y1);
        }

        @Override
        public double getCtrlX1() {
            return this.ctrlx1;
        }

        @Override
        public double getCtrlY1() {
            return this.ctrly1;
        }

        @Override
        public Point2D getCtrlP1() {
            return new Point2D.Double(this.ctrlx1, this.ctrly1);
        }

        @Override
        public double getCtrlX2() {
            return this.ctrlx2;
        }

        @Override
        public double getCtrlY2() {
            return this.ctrly2;
        }

        @Override
        public Point2D getCtrlP2() {
            return new Point2D.Double(this.ctrlx2, this.ctrly2);
        }

        @Override
        public double getX2() {
            return this.x2;
        }

        @Override
        public double getY2() {
            return this.y2;
        }

        @Override
        public Point2D getP2() {
            return new Point2D.Double(this.x2, this.y2);
        }

        @Override
        public void setCurve(double x1, double y1, double ctrlx1, double ctrly1, double ctrlx2, double ctrly2, double x2, double y2) {
            this.x1 = x1;
            this.y1 = y1;
            this.ctrlx1 = ctrlx1;
            this.ctrly1 = ctrly1;
            this.ctrlx2 = ctrlx2;
            this.ctrly2 = ctrly2;
            this.x2 = x2;
            this.y2 = y2;
        }

        @Override
        public Rectangle2D getBounds2D() {
            double left = Math.min(Math.min(this.x1, this.x2), Math.min(this.ctrlx1, this.ctrlx2));
            double top = Math.min(Math.min(this.y1, this.y2), Math.min(this.ctrly1, this.ctrly2));
            double right = Math.max(Math.max(this.x1, this.x2), Math.max(this.ctrlx1, this.ctrlx2));
            double bottom = Math.max(Math.max(this.y1, this.y2), Math.max(this.ctrly1, this.ctrly2));
            return new Rectangle2D.Double(left, top, right - left, bottom - top);
        }
    }

    public static class Float
    extends CubicCurve2D
    implements Serializable {
        public float x1;
        public float y1;
        public float ctrlx1;
        public float ctrly1;
        public float ctrlx2;
        public float ctrly2;
        public float x2;
        public float y2;
        private static final long serialVersionUID = -1272015596714244385L;

        public Float() {
        }

        public Float(float x1, float y1, float ctrlx1, float ctrly1, float ctrlx2, float ctrly2, float x2, float y2) {
            this.setCurve(x1, y1, ctrlx1, ctrly1, ctrlx2, ctrly2, x2, y2);
        }

        @Override
        public double getX1() {
            return this.x1;
        }

        @Override
        public double getY1() {
            return this.y1;
        }

        @Override
        public Point2D getP1() {
            return new Point2D.Float(this.x1, this.y1);
        }

        @Override
        public double getCtrlX1() {
            return this.ctrlx1;
        }

        @Override
        public double getCtrlY1() {
            return this.ctrly1;
        }

        @Override
        public Point2D getCtrlP1() {
            return new Point2D.Float(this.ctrlx1, this.ctrly1);
        }

        @Override
        public double getCtrlX2() {
            return this.ctrlx2;
        }

        @Override
        public double getCtrlY2() {
            return this.ctrly2;
        }

        @Override
        public Point2D getCtrlP2() {
            return new Point2D.Float(this.ctrlx2, this.ctrly2);
        }

        @Override
        public double getX2() {
            return this.x2;
        }

        @Override
        public double getY2() {
            return this.y2;
        }

        @Override
        public Point2D getP2() {
            return new Point2D.Float(this.x2, this.y2);
        }

        @Override
        public void setCurve(double x1, double y1, double ctrlx1, double ctrly1, double ctrlx2, double ctrly2, double x2, double y2) {
            this.x1 = (float)x1;
            this.y1 = (float)y1;
            this.ctrlx1 = (float)ctrlx1;
            this.ctrly1 = (float)ctrly1;
            this.ctrlx2 = (float)ctrlx2;
            this.ctrly2 = (float)ctrly2;
            this.x2 = (float)x2;
            this.y2 = (float)y2;
        }

        public void setCurve(float x1, float y1, float ctrlx1, float ctrly1, float ctrlx2, float ctrly2, float x2, float y2) {
            this.x1 = x1;
            this.y1 = y1;
            this.ctrlx1 = ctrlx1;
            this.ctrly1 = ctrly1;
            this.ctrlx2 = ctrlx2;
            this.ctrly2 = ctrly2;
            this.x2 = x2;
            this.y2 = y2;
        }

        @Override
        public Rectangle2D getBounds2D() {
            float left = Math.min(Math.min(this.x1, this.x2), Math.min(this.ctrlx1, this.ctrlx2));
            float top = Math.min(Math.min(this.y1, this.y2), Math.min(this.ctrly1, this.ctrly2));
            float right = Math.max(Math.max(this.x1, this.x2), Math.max(this.ctrlx1, this.ctrlx2));
            float bottom = Math.max(Math.max(this.y1, this.y2), Math.max(this.ctrly1, this.ctrly2));
            return new Rectangle2D.Float(left, top, right - left, bottom - top);
        }
    }
}

