/*
 * Copyright (c) 2012, 2018, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2016 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in 
 * http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that
 * (a) this copyright and permission notice appear with all copies 
 * of the Data Files or Software,
 * (b) this copyright and permission notice appear in associated 
 * documentation, and
 * (c) there is clear notice in each modified Data File or in the Software
 * as well as in the documentation associated with the Data File(s) or
 * Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_ms extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_AL = "Albania";
        final String metaValue_AM = "Armenia";
        final String metaValue_AZ = "Azerbaijan";
        final String metaValue_BG = "Bulgaria";
        final String metaValue_BY = "Belarus";
        final String metaValue_DE = "Jerman";
        final String metaValue_DK = "Denmark";
        final String metaValue_EE = "Estonia";
        final String metaValue_ES = "Sepanyol";
        final String metaValue_ET = "Ethiopia";
        final String metaValue_FI = "Finland";
        final String metaValue_FJ = "Fiji";
        final String metaValue_FR = "Perancis";
        final String metaValue_GE = "Georgia";
        final String metaValue_HR = "Croatia";
        final String metaValue_HT = "Haiti";
        final String metaValue_HU = "Hungary";
        final String metaValue_ID = "Indonesia";
        final String metaValue_IE = "Ireland";
        final String metaValue_IS = "Iceland";
        final String metaValue_IT = "Itali";
        final String metaValue_JP = "Jepun";
        final String metaValue_KZ = "Kazakhstan";
        final String metaValue_LA = "Laos";
        final String metaValue_LT = "Lithuania";
        final String metaValue_LU = "Luxembourg";
        final String metaValue_LV = "Latvia";
        final String metaValue_MK = "Macedonia";
        final String metaValue_MN = "Mongolia";
        final String metaValue_MT = "Malta";
        final String metaValue_NL = "Belanda";
        final String metaValue_NO = "Norway";
        final String metaValue_NP = "Nepal";
        final String metaValue_PH = "Filipina";
        final String metaValue_PL = "Poland";
        final String metaValue_RO = "Romania";
        final String metaValue_RS = "Serbia";
        final String metaValue_RU = "Rusia";
        final String metaValue_SE = "Sweden";
        final String metaValue_SI = "Slovenia";
        final String metaValue_TO = "Tonga";
        final String metaValue_TR = "Turki";
        final String metaValue_UA = "Ukraine";
        final String metaValue_UZ = "Uzbekistan";
        final String metaValue_VN = "Vietnam";
        final String metaValue_WS = "Samoa";
        final String metaValue_ar = "Arab";
        final String metaValue_bo = "Tibet";
        final String metaValue_el = "Greek";
        final String metaValue_he = "Ibrani";
        final String metaValue_km = "Khmer";
        final String metaValue_kn = "Kannada";
        final String metaValue_ko = "Korea";
        final String metaValue_la = "Latin";
        final String metaValue_ml = "Malayalam";
        final String metaValue_or = "Oriya";
        final String metaValue_si = "Sinhala";
        final String metaValue_ta = "Tamil";
        final String metaValue_te = "Telugu";
        final String metaValue_th = "Thai";
        final Object[][] data = new Object[][] {
            { "sbp", "Sangu" },
            { "ksh", "Colognian" },
            { "nyn", "Nyankole" },
            { "key.colStrength", "Kekuatan Pengisihan" },
            { "luo", "Luo" },
            { "Zsym", "Simbol" },
            { "fil", metaValue_PH },
            { "lus", "Mizo" },
            { "bal", "Baluchi" },
            { "luy", "Luyia" },
            { "bas", "Basaa" },
            { "bax", "Bamun" },
            { "es_ES", "Sepanyol Eropah" },
            { "teo", "Teso" },
            { "ab", "Abkhazia" },
            { "AC", "Pulau Ascension" },
            { "tet", "Tetum" },
            { "key.colCaseFirst", "Penyusunan Huruf Besar/Huruf Kecil" },
            { "AD", "Andorra" },
            { "AE", "Emiriah Arab Bersatu" },
            { "ae", "Avestan" },
            { "nl_BE", "Flemish" },
            { "AF", "Afghanistan" },
            { "af", "Afrikaans" },
            { "AG", "Antigua dan Barbuda" },
            { "type.ca.ethiopic", "Kalendar Ethiopia" },
            { "glk", "Gilaki" },
            { "AI", "Anguilla" },
            { "key.tz", "Zon Waktu" },
            { "ak", "Akan" },
            { "AL", metaValue_AL },
            { "bbj", "Ghomala" },
            { "AM", metaValue_AM },
            { "am", "Amharic" },
            { "Arab", metaValue_ar },
            { "AO", "Angola" },
            { "Jpan", metaValue_JP },
            { "AQ", "Antartika" },
            { "ar", metaValue_ar },
            { "AR", "Argentina" },
            { "AS", "Samoa Amerika" },
            { "as", "Assam" },
            { "AT", "Austria" },
            { "AU", "Australia" },
            { "av", "Avaric" },
            { "AW", "Aruba" },
            { "sdh", "Kurdish Selatan" },
            { "en_US", "Inggeris AS" },
            { "AX", "Kepulauan Aland" },
            { "key.colNormalization", "Pengisihan Ternormal" },
            { "ay", "Aymara" },
            { "mye", "Myene" },
            { "az", metaValue_AZ },
            { "AZ", metaValue_AZ },
            { "BA", "Bosnia dan Herzegovina" },
            { "ba", "Bashkir" },
            { "BB", "Barbados" },
            { "BD", "Bangladesh" },
            { "type.co.unihan", "Aturan Isih Coretan Radikal" },
            { "be", metaValue_BY },
            { "BE", "Belgium" },
            { "BF", "Burkina Faso" },
            { "bg", metaValue_BG },
            { "BG", metaValue_BG },
            { "BH", "Bahrain" },
            { "BI", "Burundi" },
            { "BJ", "Benin" },
            { "BL", "Saint Barth\u00e9lemy" },
            { "BM", "Bermuda" },
            { "bm", "Bambara" },
            { "BN", "Brunei" },
            { "bn", "Benggala" },
            { "bo", metaValue_bo },
            { "BO", "Bolivia" },
            { "BQ", "Belanda Caribbean" },
            { "BR", "Brazil" },
            { "br", "Breton" },
            { "BS", "Bahamas" },
            { "bs", "Bosnia" },
            { "xog", "Soga" },
            { "BT", "Bhutan" },
            { "see", "Seneca" },
            { "BV", "Pulau Bouvet" },
            { "BW", "Botswana" },
            { "Mymr", "Myammar" },
            { "type.nu.laoo", "Digit Lao" },
            { "BY", metaValue_BY },
            { "seh", "Sena" },
            { "BZ", "Belize" },
            { "type.ca.persian", "Kalendar Parsi" },
            { "type.nu.hebr", "Angka Ibrani" },
            { "CA", "Kanada" },
            { "ca", "Catalonia" },
            { "CC", "Kepulauan Cocos (Keeling)" },
            { "mzn", "Mazanderani" },
            { "ses", "Koyraboro Senni" },
            { "CD", "Congo - Kinshasa" },
            { "ce", "Chechen" },
            { "CF", "Republik Afrika Tengah" },
            { "CG", "Congo - Brazzaville" },
            { "CH", "Switzerland" },
            { "CI", "Cote d\u2019Ivoire" },
            { "CK", "Kepulauan Cook" },
            { "CL", "Chile" },
            { "CM", "Cameroon" },
            { "CN", "China" },
            { "CO", "Colombia" },
            { "co", "Corsica" },
            { "CP", "Pulau Clipperton" },
            { "Orya", metaValue_or },
            { "CR", "Costa Rica" },
            { "cs", "Czech" },
            { "CU", "Cuba" },
            { "cu", "Slavik Gereja" },
            { "CV", "Cape Verde" },
            { "cv", "Chuvash" },
            { "CW", "Curacao" },
            { "CX", "Pulau Krismas" },
            { "CY", "Cyprus" },
            { "cy", "Wales" },
            { "CZ", "Republik Czech" },
            { "type.nu.ethi", "Angka Ethiopia" },
            { "da", metaValue_DK },
            { "pt_PT", "Portugis Eropah" },
            { "de", metaValue_DE },
            { "DE", metaValue_DE },
            { "cgg", "Chiga" },
            { "DG", "Diego Garcia" },
            { "type.nu.deva", "Digit Devanagari" },
            { "DJ", "Djibouti" },
            { "bej", "Beja" },
            { "type.colNumeric.no", "Isih Digit Secara Berasingan" },
            { "DK", metaValue_DK },
            { "ach", "Akoli" },
            { "Brai", "Braille" },
            { "DM", "Dominica" },
            { "type.nu.armnlow", "Angka Kecil Armenia" },
            { "DO", "Republik Dominica" },
            { "bem", "Bemba" },
            { "type.nu.mong", "Digit Mongolia" },
            { "key.variableTop", "Isih Sebagai Simbol" },
            { "dv", "Divehi" },
            { "es_419", "Sepanyol Amerika Latin" },
            { "DZ", "Algeria" },
            { "dz", "Dzongkha" },
            { "bez", "Bena" },
            { "type.ca.chinese", "Kalendar Cina" },
            { "EA", "Ceuta dan Melilla" },
            { "EC", "Ecuador" },
            { "dje", "Zarma" },
            { "type.nu.grek", "Angka Greek" },
            { "EE", metaValue_EE },
            { "ee", "Ewe" },
            { "bfd", "Bafut" },
            { "type.lb.normal", "Gaya Pemisah Baris Biasa" },
            { "EG", "Mesir" },
            { "EH", "Sahara Barat" },
            { "ro_MD", "Moldavia" },
            { "type.colNormalization.yes", "Isih Unikod Ternormal" },
            { "el", metaValue_el },
            { "en", "Inggeris" },
            { "chm", "Mari" },
            { "eo", "Esperanto" },
            { "chr", "Cherokee" },
            { "ER", "Eritrea" },
            { "type.co.big5han", "Aturan Isih Cina Tradisional - Big5" },
            { "es", metaValue_ES },
            { "ES", metaValue_ES },
            { "et", metaValue_EE },
            { "ET", metaValue_ET },
            { "EU", "Kesatuan Eropah" },
            { "eu", "Basque" },
            { "Hang", "Hangul" },
            { "type.ca.gregorian", "Kalendar Gregory" },
            { "shi", "Tachelhit" },
            { "type.nu.gujr", "Digit Gujarat" },
            { "hsb", "Upper Sorbian" },
            { "Hani", "Han" },
            { "ady", "Adyghe" },
            { "fa", "Parsi" },
            { "Hans", "Ringkas" },
            { "type.nu.latn", "Digit Barat" },
            { "Hant", "Tradisional" },
            { "aeb", "Arab Tunisia" },
            { "shu", "Chadian Arab" },
            { "fi", metaValue_FI },
            { "FI", metaValue_FI },
            { "fj", metaValue_FJ },
            { "FJ", metaValue_FJ },
            { "FK", "Kepulauan Falkland" },
            { "FM", "Micronesia" },
            { "key.va", "Varian Tempat" },
            { "bgn", "Balochi Barat" },
            { "FO", "Kepulauan Faroe" },
            { "fo", "Faroe" },
            { "Taml", metaValue_ta },
            { "fr", metaValue_FR },
            { "FR", metaValue_FR },
            { "fy", "Frisian Barat" },
            { "type.ca.indian", "Kalendar Kebangsaan India" },
            { "grc", "Greek Purba" },
            { "ga", metaValue_IE },
            { "GA", "Gabon" },
            { "GB", "United Kingdom" },
            { "GD", "Grenada" },
            { "gd", "Scots Gaelic" },
            { "GE", metaValue_GE },
            { "GF", "Guiana Perancis" },
            { "GG", "Guernsey" },
            { "GH", "Ghana" },
            { "GI", "Gibraltar" },
            { "key.colCaseLevel", "Pengisihan Sensitif Atur" },
            { "GL", "Greenland" },
            { "gl", "Galicia" },
            { "GM", "Gambia" },
            { "GN", "Guinea" },
            { "gn", "Guarani" },
            { "GP", "Guadeloupe" },
            { "GQ", "Guinea Khatulistiwa" },
            { "und", "Bahasa Tidak Diketahui" },
            { "GR", "Greece" },
            { "type.ca.ethiopic-amete-alem", "Kalendar Amete Alem Ethiopia" },
            { "GS", "Kepulauan Georgia Selatan & Sandwich Selatan" },
            { "GT", "Guatemala" },
            { "GU", "Guam" },
            { "gu", "Gujerat" },
            { "gv", "Manx" },
            { "GW", "Guinea Bissau" },
            { "tlh", "Klingon" },
            { "GY", "Guyana" },
            { "ha", "Hausa" },
            { "ckb", "Kurdi Sorani" },
            { "zxx", "Tiada kandungan linguistik" },
            { "he", metaValue_he },
            { "tly", "Talysh" },
            { "hi", "Hindi" },
            { "de_AT", "Jerman Austria" },
            { "HK", "Hong Kong SAR China" },
            { "HM", "Kepulauan Heard & McDonald" },
            { "HN", "Honduras" },
            { "hr", metaValue_HR },
            { "HR", metaValue_HR },
            { "agq", "Aghem" },
            { "gsw", "Jerman Switzerland" },
            { "ht", metaValue_HT },
            { "HT", metaValue_HT },
            { "hu", metaValue_HU },
            { "HU", metaValue_HU },
            { "hy", metaValue_AM },
            { "ia", "Interlingua" },
            { "IC", "Kepulauan Canary" },
            { "id", metaValue_ID },
            { "ID", metaValue_ID },
            { "type.nu.tibt", "Digit Tibet" },
            { "IE", metaValue_IE },
            { "ie", "Interlingue" },
            { "ig", "Igbo" },
            { "naq", "Nama" },
            { "ii", "Sichuan Yi" },
            { "zza", "Zaza" },
            { "IL", "Israel" },
            { "IM", "Isle of Man" },
            { "IN", "India" },
            { "IO", "Wilayah Lautan Hindi British" },
            { "IQ", "Iraq" },
            { "IR", "Iran" },
            { "is", metaValue_IS },
            { "IS", metaValue_IS },
            { "it", metaValue_IT },
            { "IT", metaValue_IT },
            { "iu", "Inuktitut" },
            { "type.nu.thai", "Digit Thai" },
            { "type.nu.beng", "Digit Bengali" },
            { "ja", metaValue_JP },
            { "Mlym", metaValue_ml },
            { "JE", "Jersey" },
            { "type.ca.islamic", "Kalendar Islam" },
            { "doi", "Dogri" },
            { "JM", "Jamaica" },
            { "Beng", "Bengali" },
            { "JO", "Jordan" },
            { "bkm", "Kom" },
            { "JP", metaValue_JP },
            { "sma", "Sami Selatan" },
            { "jv", "Jawa" },
            { "guz", "Gusii" },
            { "type.nu.knda", "Digit Kannada" },
            { "smj", "Lule Sami" },
            { "maf", "Mafa" },
            { "de_CH", "Jerman Halus Switzerland" },
            { "smn", "Inari Sami" },
            { "type.co.phonetic", "Urutan Isih Fonetik" },
            { "ka", metaValue_GE },
            { "type.ca.buddhist", "Kalendar Buddha" },
            { "sms", "Skolt Sami" },
            { "KE", "Kenya" },
            { "419", "Amerika Latin" },
            { "KG", "Kyrgyzstan" },
            { "kg", "Kongo" },
            { "KH", "Kemboja" },
            { "KI", "Kiribati" },
            { "ki", "Kikuya" },
            { "mas", "Masai" },
            { "kk", metaValue_KZ },
            { "kl", "Kalaallisut" },
            { "km", metaValue_km },
            { "KM", "Comoros" },
            { "Knda", metaValue_kn },
            { "kn", metaValue_kn },
            { "KN", "Saint Kitts dan Nevis" },
            { "fr_CA", "Perancis Kanada" },
            { "type.colStrength.identical", "Isih Semua" },
            { "ko", metaValue_ko },
            { "KP", "Korea Utara" },
            { "KR", "Korea Selatan" },
            { "ks", "Kashmir" },
            { "ku", "Kurdish" },
            { "fr_CH", "Perancis Switzerland" },
            { "KW", "Kuwait" },
            { "kw", "Cornish" },
            { "tpi", "Tok Pisin" },
            { "KY", "Kepulauan Cayman" },
            { "ky", "Kirghiz" },
            { "KZ", metaValue_KZ },
            { "Cyrl", "Cyril" },
            { "type.colStrength.primary", "Isih Huruf Asas Sahaja" },
            { "LA", metaValue_LA },
            { "la", metaValue_la },
            { "lb", metaValue_LU },
            { "LB", "Lubnan" },
            { "LC", "Saint Lucia" },
            { "type.nu.mlym", "Digit Malayalam" },
            { "lg", "Ganda" },
            { "nds", "Jerman Rendah" },
            { "LI", "Liechtenstein" },
            { "LK", "Sri Lanka" },
            { "Tibt", metaValue_bo },
            { "ln", "Lingala" },
            { "type.colCaseLevel.no", "Isih Tidak Sensitif Atur" },
            { "lo", metaValue_LA },
            { "type.ms.uksystem", "Sistem Ukuran Imperial" },
            { "type.colStrength.tertiary", "Isih Aksen/Atur/Lebar" },
            { "cop", "Coptic" },
            { "LR", "Liberia" },
            { "LS", "Lesotho" },
            { "lt", metaValue_LT },
            { "LT", metaValue_LT },
            { "LU", metaValue_LU },
            { "lu", "Luba-Katanga" },
            { "lv", metaValue_LV },
            { "LV", metaValue_LV },
            { "Kana", "Katakana" },
            { "LY", "Libya" },
            { "vun", "Vunjo" },
            { "lah", "Lahnda" },
            { "lag", "Langi" },
            { "Thaa", "Thaana" },
            { "MA", "Maghribi" },
            { "MC", "Monaco" },
            { "MD", "Moldova" },
            { "ME", "Montenegro" },
            { "MF", "Saint Martin" },
            { "MG", "Madagaskar" },
            { "mg", "Malagasy" },
            { "Thai", metaValue_th },
            { "MH", "Kepulauan Marshall" },
            { "type.co.ducet", "Aturan Isih Unikod Lalai" },
            { "mi", "Maori" },
            { "type.nu.vaii", "Digit Vai" },
            { "mk", metaValue_MK },
            { "MK", metaValue_MK },
            { "ml", metaValue_ml },
            { "ML", "Mali" },
            { "MM", "Myanmar (Burma)" },
            { "mn", metaValue_MN },
            { "MN", metaValue_MN },
            { "MO", "Macau SAR China" },
            { "MP", "Kepulauan Mariana Utara" },
            { "MQ", "Martinique" },
            { "MR", "Mauritania" },
            { "mr", "Marathi" },
            { "MS", "Montserrat" },
            { "ms", "Bahasa Melayu" },
            { "type.colAlternate.non-ignorable", "Isih Simbol" },
            { "mt", metaValue_MT },
            { "MT", metaValue_MT },
            { "MU", "Mauritius" },
            { "alt", "Altai Selatan" },
            { "MV", "Maldives" },
            { "MW", "Malawi" },
            { "MX", "Mexico" },
            { "type.ca.japanese", "Kalendar Jepun" },
            { "MY", "Malaysia" },
            { "my", "Burma" },
            { "Armn", metaValue_AM },
            { "MZ", "Mozambique" },
            { "mde", "Maba" },
            { "dsb", "Lower Sorbian" },
            { "NA", "Namibia" },
            { "type.co.search", "Carian Tujuan Umum" },
            { "nb", "Bokm\u00e5l Norway" },
            { "type.ca.hebrew", "Kalendar Ibrani" },
            { "type.co.dictionary", "Aturan Isih Kamus" },
            { "NC", "New Caledonia" },
            { "nd", "Ndebele Utara" },
            { "ne", metaValue_NP },
            { "NE", "Niger" },
            { "NF", "Pulau Norfolk" },
            { "NG", "Nigeria" },
            { "trv", "Taroko" },
            { "NI", "Nicaragua" },
            { "nl", metaValue_NL },
            { "NL", metaValue_NL },
            { "nn", "Nynorsk Norway" },
            { "no", metaValue_NO },
            { "NO", metaValue_NO },
            { "NP", metaValue_NP },
            { "NR", "Nauru" },
            { "NU", "Niue" },
            { "rof", "Rombo" },
            { "ny", "Nyanja" },
            { "NZ", "New Zealand" },
            { "kab", "Kabyle" },
            { "type.colCaseFirst.lower", "Isih Huruf Kecil Dahulu" },
            { "oc", "Occitania" },
            { "kam", "Kamba" },
            { "crh", "Turki Krimea" },
            { "type.colAlternate.shifted", "Isih Mengabaikan Simbol" },
            { "mer", "Meru" },
            { "type.nu.armn", "Angka Armenia" },
            { "OM", "Oman" },
            { "om", "Oromo" },
            { "or", metaValue_or },
            { "os", "Ossete" },
            { "bpy", "Bishnupriya" },
            { "mfe", "Morisyen" },
            { "PA", "Panama" },
            { "pa", "Punjabi" },
            { "dua", "Duala" },
            { "type.ca.islamic-civil", "Kalendar Sivil Islam" },
            { "en_GB", "Inggeris British" },
            { "kbl", "Kanembu" },
            { "PE", "Peru" },
            { "PF", "Polinesia Perancis" },
            { "PG", "Papua New Guinea" },
            { "PH", metaValue_PH },
            { "PK", "Pakistan" },
            { "pl", metaValue_PL },
            { "PL", metaValue_PL },
            { "ewo", "Ewondo" },
            { "PM", "Saint Pierre dan Miquelon" },
            { "PN", "Kepulauan Pitcairn" },
            { "type.ca.dangi", "Kalendar Dangi" },
            { "type.colBackwards.yes", "Isih Aksen Terbalik" },
            { "PR", "Puerto Rico" },
            { "PS", "Wilayah Palestin" },
            { "ps", "Pashto" },
            { "Bali", "Bali" },
            { "PT", "Portugal" },
            { "pt", "Portugis" },
            { "key.co", "Urutan Isihan" },
            { "PW", "Palau" },
            { "type.nu.greklow", "Angka Huruf Kecil Greek" },
            { "PY", "Paraguay" },
            { "pt_BR", "Portugis Brazil" },
            { "tum", "Tumbuka" },
            { "Hebr", metaValue_he },
            { "mgh", "Makhuwa-Meetto" },
            { "QA", "Qatar" },
            { "key.ca", "Kalendar" },
            { "Laoo", "Lao" },
            { "mgo", "Meta\u2019" },
            { "type.hc.h23", "Sistem 24 Jam (0\u201323)" },
            { "type.hc.h24", "Sistem 24 Jam (1\u201324)" },
            { "ssy", "Saho" },
            { "brh", "Brahui" },
            { "type.nu.mymr", "Digit Myammar" },
            { "QO", "Oceania Terpencil" },
            { "qu", "Quechua" },
            { "brx", "Bodo" },
            { "kde", "Makonde" },
            { "Ethi", metaValue_ET },
            { "001", "Dunia" },
            { "002", "Afrika" },
            { "003", "Amerika Utara" },
            { "RE", "Reunion" },
            { "type.colNormalization.no", "Isih Tanpa Penormalan" },
            { "type.hc.h12", "Sistem 12 Jam (1\u201312)" },
            { "005", "Amerika Selatan" },
            { "type.hc.h11", "Sistem 12 Jam (0\u201311)" },
            { "009", "Oceania" },
            { "rm", "Romansh" },
            { "rn", "Rundi" },
            { "key.cu", "Mata wang" },
            { "ro", metaValue_RO },
            { "RO", metaValue_RO },
            { "RS", metaValue_RS },
            { "type.nu.orya", "Digit Oriya" },
            { "type.nu.hanidec", "Angka Perpuluhan Cina" },
            { "ru", metaValue_RU },
            { "RU", metaValue_RU },
            { "bss", "Akoose" },
            { "RW", "Rwanda" },
            { "rw", "Kinyarwanda" },
            { "kea", "Kabuverdianu" },
            { "en_AU", "Inggeris Australia" },
            { "key.colAlternate", "Abaikan Pengisihan Simbol" },
            { "SA", "Arab Saudi" },
            { "sa", "Sanskrit" },
            { "SB", "Kepulauan Solomon" },
            { "twq", "Tasawaq" },
            { "011", "Afrika Barat" },
            { "SC", "Seychelles" },
            { "SD", "Sudan" },
            { "sd", "Sindhi" },
            { "SE", metaValue_SE },
            { "013", "Amerika Tengah" },
            { "se", "Sami Utara" },
            { "014", "Afrika Timur" },
            { "015", "Afrika Utara" },
            { "SG", "Singapura" },
            { "sg", "Sango" },
            { "SH", "Saint Helena" },
            { "sh", "SerboCroatia" },
            { "type.lb.strict", "Gaya Pemisah Baris Ketat" },
            { "SI", metaValue_SI },
            { "si", metaValue_si },
            { "017", "Afrika Tengah" },
            { "018", "Selatan Afrika" },
            { "SJ", "Svalbard dan Jan Mayen" },
            { "019", "Amerika" },
            { "SK", "Slovakia" },
            { "sk", "Slovak" },
            { "Bamu", "Bamu" },
            { "sl", metaValue_SI },
            { "SL", "Sierra Leone" },
            { "sm", metaValue_WS },
            { "SM", "San Marino" },
            { "SN", "Senegal" },
            { "sn", "Shona" },
            { "SO", "Somalia" },
            { "so", "Somali" },
            { "arn", "Mapuche" },
            { "type.nu.arab", "Digit Indi-Arab" },
            { "sq", metaValue_AL },
            { "type.nu.taml", "Angka Tamil" },
            { "sr", metaValue_RS },
            { "SR", "Surinam" },
            { "SS", "Sudan Selatan" },
            { "ss", "Swati" },
            { "ST", "Sao Tome dan Principe" },
            { "st", "Sotho Selatan" },
            { "arq", "Arab Algeria" },
            { "su", "Sunda" },
            { "sv", metaValue_SE },
            { "SV", "El Salvador" },
            { "sw", "Swahili" },
            { "SX", "Sint Maarten" },
            { "SY", "Syria" },
            { "type.nu.hantfin", "Angka Kewangan Cina Tradisional" },
            { "SZ", "Swaziland" },
            { "arz", "Arab Mesir" },
            { "ibb", "Ibibio" },
            { "ary", "Arab Maghribi" },
            { "ta", metaValue_ta },
            { "TA", "Tristan da Cunha" },
            { "asa", "Asu" },
            { "type.ms.ussystem", "Sistem Ukuran AS" },
            { "021", "Utara Amerika" },
            { "142", "Asia" },
            { "TC", "Kepulauan Turks dan Caicos" },
            { "bua", "Buriat" },
            { "yav", "Yangben" },
            { "143", "Asia Tengah" },
            { "TD", "Chad" },
            { "te", metaValue_te },
            { "145", "Asia Barat" },
            { "TF", "Wilayah Selatan Perancis" },
            { "TG", "Togo" },
            { "tg", "Tajik" },
            { "th", metaValue_th },
            { "TH", "Thailand" },
            { "ti", "Tigrinya" },
            { "type.colNumeric.yes", "Isih Digit Mengikut Nombor" },
            { "TJ", "Tajikistan" },
            { "en_CA", "Inggeris Kanada" },
            { "029", "Caribbean" },
            { "TK", "Tokelau" },
            { "tk", "Turkmen" },
            { "TL", "Timor-Leste" },
            { "ybb", "Yemba" },
            { "type.co.searchjl", "Cari Mengikut Konsonan Awal Hangul" },
            { "TM", "Turkmenistan" },
            { "TN", "Tunisia" },
            { "tn", "Tswana" },
            { "to", metaValue_TO },
            { "TO", metaValue_TO },
            { "bum", "Bulu" },
            { "dyo", "Jola-Fonyi" },
            { "type.nu.jpan", "Angka Jepun" },
            { "tr", metaValue_TR },
            { "TR", metaValue_TR },
            { "ts", "Tsonga" },
            { "swb", "Comoria" },
            { "TT", "Trinidad dan Tobago" },
            { "tt", "Tatar" },
            { "TV", "Tuvalu" },
            { "TW", "Taiwan" },
            { "tw", "Twi" },
            { "ty", "Tahiti" },
            { "TZ", "Tanzania" },
            { "nmg", "Kwasio" },
            { "Zzzz", "Skrip Tidak Diketahui" },
            { "UA", metaValue_UA },
            { "150", "Eropah" },
            { "key.colHiraganaQuaternary", "Pengisihan Kana" },
            { "030", "Asia Timur" },
            { "151", "Eropah Timur" },
            { "154", "Eropah Utara" },
            { "dzg", "Dazaga" },
            { "sw_CD", "Congo Swahili" },
            { "034", "Asia Selatan" },
            { "155", "Eropah Barat" },
            { "035", "Asia Tenggara" },
            { "UG", "Uganda" },
            { "ug", "Uyghur" },
            { "type.co.pinyin", "Aturan Isih Pinyin" },
            { "Kore", metaValue_ko },
            { "Zyyy", "Biasa" },
            { "type.colHiraganaQuaternary.yes", "Isih Kana Secara Berbeza" },
            { "uk", metaValue_UA },
            { "039", "Eropah Selatan" },
            { "Sinh", metaValue_si },
            { "type.colCaseFirst.no", "Isih Urutan Atur Biasa" },
            { "UM", "Kepulauan Terpencil A.S." },
            { "type.colStrength.quaternary", "Isih Aksen/Atur/Lebar/Kana" },
            { "type.ca.coptic", "Kalendar Qibti" },
            { "ur", "Urdu" },
            { "US", "Amerika Syarikat" },
            { "haw", "Hawaii" },
            { "type.co.gb2312han", "Aturan Isih Bahasa Cina Ringkas - GB2312" },
            { "UY", "Uruguay" },
            { "uz", metaValue_UZ },
            { "UZ", metaValue_UZ },
            { "tzm", "Tamazight Atlas Tengah" },
            { "type.co.stroke", "Aturan Isih Coretan" },
            { "nnh", "Ngiemboon" },
            { "VA", "Kota Vatican" },
            { "nds_NL", "Saxon Rendah" },
            { "VC", "Saint Vincent dan Grenadines" },
            { "VE", "Venezuela" },
            { "ve", "Venda" },
            { "type.ca.roc", "Kalendar Minguo" },
            { "VG", "Kepulauan Virgin British" },
            { "vi", metaValue_VN },
            { "VI", "Kepulauan Virgin A.S." },
            { "khq", "Koyra Chiini" },
            { "key.hc", "Kitaran Jam (12 berbanding 24)" },
            { "VN", metaValue_VN },
            { "type.colBackwards.no", "Isih Aksen Secara Biasa" },
            { "key.x", "Penggunaan Peribadi" },
            { "khw", "Khowar" },
            { "quc", "K\u02bciche\u02bc" },
            { "VU", "Vanuatu" },
            { "gaa", "Ga" },
            { "rwk", "Rwa" },
            { "gag", "Gagauz" },
            { "053", "Australasia" },
            { "054", "Melanesia" },
            { "WF", "Wallis dan Futuna" },
            { "Grek", metaValue_el },
            { "type.co.traditional", "Aturan Isih Tradisional" },
            { "057", "Wilayah Mikronesia" },
            { "jgo", "Ngomba" },
            { "lkt", "Lakota" },
            { "type.nu.finance", "Angka Kewangan" },
            { "wo", "Wolof" },
            { "wae", "Walser" },
            { "zgh", "Tamazight Maghribi Standard" },
            { "ar_001", "Arab Standard Moden" },
            { "WS", metaValue_WS },
            { "Cans", "Cans" },
            { "key.colNumeric", "Pengisihan Berangka" },
            { "Mong", metaValue_MN },
            { "gba", "Gbaya" },
            { "mni", "Manipuri" },
            { "Latn", metaValue_la },
            { "061", "Polinesia" },
            { "type.nu.hans", "Angka Cina Ringkas" },
            { "type.nu.hant", "Angka Cina Tradisional" },
            { "xh", "Xhosa" },
            { "XK", "Kosovo" },
            { "type.nu.romanlow", "Angka Huruf Kecil Roman" },
            { "Gujr", "Gujarat" },
            { "Zxxx", "Tidak ditulis" },
            { "byv", "Medumba" },
            { "gbz", "Zoroastrian Dari" },
            { "wbp", "Warlpiri" },
            { "moh", "Mohawk" },
            { "kkj", "Kako" },
            { "YE", "Yaman" },
            { "nqo", "N\u2019ko" },
            { "type.co.standard", "Urutan Isihan Standard" },
            { "yi", "Yiddish" },
            { "yo", "Yoruba" },
            { "type.nu.traditional", "Angka Tradisional" },
            { "es_MX", "Sepanyol Mexico" },
            { "YT", "Mayotte" },
            { "vai", "Vai" },
            { "ZA", "Afrika Selatan" },
            { "type.lb.loose", "Gaya Pemisah Baris Bebas" },
            { "kln", "Kalenjin" },
            { "Deva", "Devanagari" },
            { "zh", "Cina" },
            { "type.nu.geor", "Angka Georgia" },
            { "Hira", "Hiragana" },
            { "ZM", "Zambia" },
            { "Bopo", "Bopomofo" },
            { "key.lb", "Gaya Pemisah Baris" },
            { "zu", "Zulu" },
            { "ZW", "Zimbabwe" },
            { "type.co.phonebook", "Aturan Isih Buku Telefon" },
            { "Geor", metaValue_GE },
            { "ZZ", "Wilayah Tidak Diketahui" },
            { "type.colCaseLevel.yes", "Isih Sensitif Atur" },
            { "type.ms.metric", "Sistem Metrik" },
            { "type.ca.iso8601", "Kalendar ISO-8601" },
            { "nso", "Sotho Utara" },
            { "type.nu.telu", "Digit Telugu" },
            { "type.nu.jpanfin", "Angka Kewangan Jepun" },
            { "loz", "Lozi" },
            { "type.co.reformed", "Aturan Isih Pembaharuan" },
            { "key.colBackwards", "Pengisihan Aksen Terbalik" },
            { "type.colHiraganaQuaternary.no", "Isih Kana Berasingan" },
            { "ebu", "Embu" },
            { "jmc", "Machame" },
            { "zh_Hans", "Cina Ringkas" },
            { "koi", "Komi-Permyak" },
            { "type.nu.hansfin", "Angka Kewangan Cina Ringkas" },
            { "type.colStrength.secondary", "Isih Aksen" },
            { "kok", "Konkani" },
            { "type.nu.arabext", "Digit Indi Arab Lanjutan" },
            { "nus", "Nuer" },
            { "type.nu.fullwide", "Digit Lebar Penuh" },
            { "dav", "Taita" },
            { "lrc", "Luri Utara" },
            { "zh_Hant", "Cina Tradisional" },
            { "type.nu.khmr", "Digit Khmer" },
            { "mua", "Mundang" },
            { "type.nu.guru", "Digit Gurmukhi" },
            { "Khmr", metaValue_km },
            { "key.ms", "Sistem Ukuran" },
            { "type.nu.roman", "Angka Roman" },
            { "cay", "Cayuga" },
            { "type.nu.tamldec", "Digit Tamil" },
            { "saq", "Samburu" },
            { "efi", "Efik" },
            { "key.nu", "Nombor" },
            { "type.nu.native", "Digit Asal" },
            { "sba", "Ngambay" },
            { "Guru", "Gurmukhi" },
            { "lua", "Luba-Lulua" },
            { "ksb", "Shambala" },
            { "type.colCaseFirst.upper", "Isih Huruf Besar Dahulu" },
            { "Telu", metaValue_te },
            { "ksf", "Bafia" },
        };
        return data;
    }
}
