/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.visualvm.core.scheduler;

import com.sun.tools.visualvm.core.scheduler.DefaultScheduledTask;
import com.sun.tools.visualvm.core.scheduler.Quantum;
import com.sun.tools.visualvm.core.scheduler.ScheduledTask;
import com.sun.tools.visualvm.core.scheduler.SchedulerTask;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Logger;

public class Scheduler {
    private static final Logger LOGGER = Logger.getLogger(Scheduler.class.getName());
    private static final Scheduler INSTANCE = new Scheduler();
    private final ExecutorService immediateTaskService = Executors.newCachedThreadPool();

    private Scheduler() {
    }

    public static final Scheduler sharedInstance() {
        return INSTANCE;
    }

    public final ScheduledTask schedule(SchedulerTask task, Quantum interval) {
        return this.schedule(task, interval, true);
    }

    public final ScheduledTask schedule(final SchedulerTask task, Quantum interval, boolean immediate) {
        boolean suspended = interval.equals(Quantum.SUSPENDED);
        if (immediate && !suspended) {
            this.immediateTaskService.submit(new Runnable(){

                public void run() {
                    task.onSchedule(System.currentTimeMillis());
                }
            });
        }
        DefaultScheduledTask scheduled = new DefaultScheduledTask(interval, task);
        return scheduled;
    }

    public final void unschedule(ScheduledTask task) {
        if (task == null) {
            return;
        }
        task.suspend();
    }
}

